describe "an instance generated by a factory that inherits from another factory" do
  before do
    define_model("User", name: :string, admin: :boolean, email: :string, upper_email: :string, login: :string)

    FactoryBot.define do
      factory :user do
        name { "John" }
        email { "#{name.downcase}@example.com" }
        login { email }

        factory :admin do
          name { "admin" }
          admin { true }
          upper_email { email.upcase }
        end
      end
    end
  end

  describe "the parent class" do
    subject { FactoryBot.create(:user) }
    it { should_not be_admin }
    its(:name) { should eq "John" }
    its(:email) { should eq "john@example.com" }
    its(:login) { should eq "john@example.com" }
  end

  describe "the child class redefining parent's attributes" do
    subject { FactoryBot.create(:admin) }
    it { should be_kind_of(User) }
    it { should be_admin }
    its(:name) { should eq "admin" }
    its(:email) { should eq "admin@example.com" }
    its(:login) { should eq "admin@example.com" }
    its(:upper_email) { should eq "ADMIN@EXAMPLE.COM" }
  end
end

describe "nested factories with different parents" do
  before do
    define_model("User", name: :string)

    FactoryBot.define do
      factory :user do
        name { "Basic User" }

        factory :male_user do
          name { "John Doe" }
        end

        factory :uppercase_male_user, parent: :male_user do
          after(:build) { |user| user.name = user.name.upcase }
        end
      end
    end
  end

  it "honors :parent over the factory block nesting" do
    expect(FactoryBot.build(:uppercase_male_user).name).to eq "JOHN DOE"
  end
end
