# Announce: Rakudo compiler, Release #172 (2024.05)

On behalf of the Rakudo development team, I’m very happy to announce the
May 2024 release of Rakudo #172. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2024.05:

+ Improvements:
    + Provide the host:port that compose the address in use [ecd2dd46]
    + Improve .IO.open.lock failure messages [774cc864]
    + Make (^Inf).reverse fail rather than infiniloop [26f1c494]
    + Provide deeper context into `run` failures [aca5e4c1]

+ Additions:
    + Add rakudo flavor [6e55b118][c888a116][f253d68b][69a33564]
    + Add worry for WhateverCode on LHS of smartmatch [d9863e9a]
    + Add Cool.nomark in 6.e [5eb1da8c]
    + Introduce Any.are(type --> Bool:D) in 6.e [23b94de6]
    + Add :invocant option to Parameter.new [f17cd58f]

+ Fixes:
    * Fix various unicode property bugs [22492982]
    + Provide conditional exit status for USAGE [a4c7d5d1]
    + Supply an Any.match method candidate for Any:D [d6dc3610][51b0ef25]
      [881c1e87]
    + Fix mysterious failures when class construction process order changes
      [2cba37f5]
    + Make sure type objects without MRO don't break .are [e227a4f2]
    + Fix memory leaking in infinity-bound ... [99bfab8c]
    + Allow the use of enum values in MAIN that shadow core types [e3ad75a6]
      [f5218834][5fbda71d][45966a8c]
    + Clarify Range.rand failure cases, fix infinite loop, and optimize
      [06e45d89][f233458e]
    + Z<> is a comment - do not render it as text. [c1cc007f]
    + Allow reduce to return containers as generated [ecd75809]
    + Make dd handle Failures better [0a0435d7]
    + Make dd be more verbose about hash/array elements [e1bd3ffd][2b2e896b]
      [184c2ec2]

+ Deprecations:

+ Internal:
    + Streamline NativeCall [40c7b77f][30410664][bf81c62f][4a64b3af][d5eb39f7]
      [0c9e990d][4de8e84a][d374dbb2][89407558][14bde025][9ef2df5b][586c7832]
      [73776552][8dd91896][3ec47540][9d297a3d][335a0b0c][46a8f324][967d1a5a]
    + Streamline NativeCall::Dispatcher [8a7ed37c][2182fee5][9b078a12]
      [ed4db102][c9a0de80]
    + Move sub map_return_type logic to NativeCall::Types [b6cc74b5]
    + Streamline NativeCall::Types [3861b8f8][89d4d42b][75fa3da4][d0cbe4ae]
      [b36cceb3][b6028f9d]
    + Streamline NativeCall::Compiler::GNU [bd426162][92da00a9]
    + Only ignore last arg in a Method if '%_' (NativeCall) [f25dcacc]
    + Streamline NativeCall::Compiler::MSVC [cb6e5080][92113fe4][7766fbbd]
      [ca4bd66c]
    + Use HLL::SysConfig to obtain path-sep [c8855956]
    + Refactor t/packages to follow idiomatic distribution file structure
      [d25af712]
    + Use NQP for open mode detection in IO::Handle.lock [cf87ccf9]
    + Micro-optimize basic iterators [2e4bc48a][72b46fe2][6846c49e]

+ RakuAST Development:
    + 43 commits, 143/152 (make test), and 1063/1356 (make spectest) [fe579a3b]
      [d890d89e][cd197264][5485db22][ee525814][fcbd5303][622f58ad][b50fb0c4]
      [1278c5bb][c0c5e9ed][4e547d17][5a1e0161][a3907c3a][80ae959a][4988fb37]
      [331f0192][1d5cd34f][24f3a168][eee426ea][66c4acad][5748ac20][aec7a49d]
      [22a7a897][ddde58be][2c3602de][39705b00][3ce05fa0][3a928a56][5a122c60]
      [22932c27][097b50cd][a26b756a][a1f98bf1][13f5a744][b08810e4][a690eecc]
      [53eebb7c][cd74aa79][de12a755][5fb665ba][042660d8][b7116755][851aa490]

The following people contributed to this release:

Elizabeth Mattijsen, Will Coleda, ab5tract, Stefan Seifert, Justin DeVuyst,
Daniel Green, Nick Logan, Daniel Sockwell, raiph, Anton Oks,
Christian Bartolomäus, Mustafa Aydın, Richard Hainsworth, Tim Nelson,
voldenet

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2024 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on Libera.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#173), is tentatively scheduled for 2024-06-27.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
