# Announce: Rakudo compiler, Release #136 (2020.06)

On behalf of the Rakudo development team, I’m very happy to announce the
June 2020 release of Rakudo #136. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2020.06:
  + SPECIAL NOTES:
    + Results of `dir` routine called with dirty base path are presented
      as cleaned up for some paths (like `///` or `a/../a`) unlike
      before. While compatibility with most of other cases is preserved
      and no ecosystem fallout was observed, be cautious of the possible
      observable changes if the code does not clean dirty paths using `cleanup` method.
    + Since this release, when you start Raku with "-" as a single positional parameter, it
      will now check if STDIN is connected to a terminal.  If it is, then
      the REPL will be started, rather than appearing to freeze waiting
      for the user to enter something and issue an EOF.  If STDIN is *not*
      connected to a terminal, then Raku will read from STDIN and process
      that as the source of a program.
    + The `run` routine, `Proc.spawn` and `Proc::Async.new` are
      extended with a new argument `:$win-verbatim-args` defaulting to
      `False`. If the argument is left off or set to False, the
      arguments are quoted according to the Microsoft convention. This
      is identical to Rakus previous behavior and thus backwards
      compatible. When passing True the passed arguments are
      concatenated with a single space. No other processing takes
      place. This allows to manually quote the arguments as necessary.
  + Changes:
    + Support verbatim argument handling for `Proc` [709941c6][9a75738f]
    + Signatures of `slurp` and `spurt` routines not accepting redundant arguments is
      now compile time error rather than run-time one [22f43444]
    + The `Distro.desc` method now states codename for MacOS [b4b2a5ec]
    + The `gist` method output for multi-dimensional arrays is truncated now [cfc3e57f][4bfe5bd5]
    + Parametrization a variable type in form `my $foo is Type[Foo, Bar]` works for all types now [de43f193]
    + The `rotate` method now returns `Seq` instead of `List` [4b501bd4]
    + Add CACHEDIR.TAG to mark cache dirs as cache [37646b86][c3bdb617][ef90599e]
    + Improve GNU C++ name mangling [4f672c27]
    + Make `Instant.raku` output simpler [c0b5fb28]
    + Improve smartmatching against `Mu`/`Any`/`Junction` types
      (`Mu.new ~~ Mu` does not die anymore, `any(Mu, Any) ~~ Mu` returns `True` now) [3b4794f4][840d3e81]
  + Fixes:
    + Fix code objects created BEGIN time EVAL getting lost in precompilation [537f8877][169f63d9]
    + The `is` routine from `Test` module now handles types that cannot be stringified and
      compares them using `raku` method now [c9e94623]
    + Fix various JVM and JS backend issues [8e5b610a][2b81f978]
      [12f8f1eb][5b86436c][1464b35e][a059373e][9fe471cf]
    + Fix BEGIN time `EVAL` accidentally running CHECK phasers of the outer comp unit [eeb4f43f][b874c68e]
    + Fix results o `"١٢٣".Numeric` and `"١٢٣".Int` [c2e8b22f]
    + Fix race in `PIO` method of `IO::Handle` [f33ce01c]
    + Fix `Date(now)` call [9dcbc5ff]
    + Fix `.comb(Str)` to ensure non-overlapping results [8d5a0f70]
    + Fix `Instant.raku` for Rational values [f506cc03]
    + Fix sorting of 2 element native arrays [becb85eb]
    + Make sure `push-all` does not push when exhausted when splitting using a regex [077300c5]
    + Improve error message for method calls placed after white space [4278e4c2]
    + Improve `X::Syntax::Variable::MissingInitializer` exception's error message [ee005d8b]
    + Improve `X::Method::NotFound` exception's error message to only suggest a submethod if correct [b02a7413]
    + Improve `malformed loop spec` related errors [d3c3e534]
    + Improve error message for case of too many directives in routine `sprintf` [c988f832]
    + Improve detection of a version control conflict marker to provide an error message [65e412f7]
  + Additions:
    + Add `IO::Handle.do-not-close-automatically` method [61046d76][999d04aa]
    + Add `IO::Path::Parts` class [4387f280][187312b8][e9ea048b][30ae200f]
    + Add support for `printf($format, Junction)` [110324d3]
    + Add `Supply.rotate` method [9f7c9278]
    + Add `Capture.EXIST-POS` method [6a4f79ec][b55ecdf0][3372352e]
    + Add `RAKU_REPL_OUTPUT_METHOD` environment variable which sets
      the method used to stringify a value of an expression in REPL, default is `gist` [285717a0]
    + Add `:chomp` named argument to `Str.lines` similar to the same named argument of `IO::Handle.new` [1bcc5d73]
  + Efficiency:
    + Make creation of regex captures faster [15961f91][272c4636]
      [ed65d733][e3fa44ab][7f47db80][0b48651c][537a6e41][f627d2c8][6f6b2dfe][219199bb]
    + Make file test methods like `.d` or `.x` faster [c821bbc5]
    + Make `Match.caps` about 35% faster [87e91def]
    + Make `Str.split(Regex)` up to 2x faster [9c74d983]
    + Make `Str.split(Regex, *%_)` up to 2x faster [a9796fe5]
    + Make `dir` routine about 15% faster [700b7432]
    + Make `Blob.join` between 4% and 11% faster [84ff64cf]
    + Make `Blob.gist` about 2x as fast [b55667ef]
    + Make `QuantHash` implementation a bit faster  [4a728f2a]
    + Make `IO::Spec::Win32.basename` about 1.7x as fast [ecd06c9f]
    + Make `IO::Spec::Win32.tmpdir` about 1.8x as fast [6d427d47]
    + Make `IO::Spec::Win32.path` about 2x as fast [1a8e07c2]
    + Make `IO::Spec::Unix.path` about 3.5x as fast [8dc58abf]
    + Make `IO::Spec::Unix.basename` and `IO::Spec::Unic.extension` about 1.7x as fast [f89fad87]
    + Make `IO::Spec::Unix.tmpdir` about 1.8x as fast [a2860ead]
    + Make `WhateverCode.ACCEPTS` about 2x as fast [853e6227]
    + Make `IO::Path.sibling` about 2x as fast [a5eb1d4a]
    + Make `IO::Path.succ` and `IO::Path.pred` about 3x as fast [26b9f388][7238b094]
    + Make `IO::Path.parent` about 2.7x as fast [71cb0c56]
    + Make `IO::Path.parent(N)` about 2x as fast [f93ce875]
    + Make `IO::Path.child` about 1.4x as fast [f5b2c240]
    + Make `IO::Path.add` about 1.25x as fast [718d305b]
    + Make `IO::Path.dir` between 1.5x and 2.2x as fast [b63976a8]
      [6b22c1eb][7691742a][9b9d9f64]
    + Make `IO::Path.is-absolute` a bit faster [fc88b9c2][bd7fcb28]
    + Make `IO::Path.spurt` up to 35% faster [7571f65a]
    + Make `IO::Path.slurp` up to 4.7x as fast [d03fa4b0][cde948ae][36d89cf6]
    + Make `slurp` routine up to 40% faster [f3baa389][fc3e1aea]
    + Make `spurt` routine a few % faster [da5825e6]
    + Make `Str.Numeric` about 4.3x as fast [a0e58412]
    + Make `.IO` method and `IO::Path.new` about 2x as fast [2a88990b]
    + Make `IO::Spec.curupdir` about 25% faster [6a0eaabd][16d93e26]
    + Make `"42".Int` about 4.3x faster [3ee1777a]
    + Reduce overhead of `Code.ACCEPTS(value)` by 20% [2eec62fe]
    + Make `so` and `not` routines faster [d8c26500][8a3c36f8][5c93ddac][cb69cfce]
    + Optimize symbol lookup [c5f5d7ee][dc6594d6][5d61b3d0]
    + Prevent `$*OUT` lookup for each eigenstate of Junction when calling `print` or `put` [4297cb05]
    + Make `printf` routine up to 5% faster [e46d4590]
    + Streamline variable `is` and `of` handling [5561669b]
    + Make `Hash.sort` a tiny bit faster [cd617248]
    + Various small optimizations [a9074977][b50fd8b5][65e17c40]
  + Internal:
    + Set up CI with Azure Pipelines [ae07d685][43213e49][55529de1]
      [78fe25b8][42c37997][4085cfdc][5b4faed3][5587574e][fce783a1][adfa192b]
    + Fix `main-version.nqp` dependencies [b71cb3ae]
    + Improve `say`, `put`, `print`, `note` methods of `IO::Handle` [7a902b5e]
      [88d98225][627b39b8][438c1d2f][483cac3a][2b38666f]
    + Simplify `Shaped1Array.reverse` [de173a18]
    + Simplify `EVAL(:check)` code [afe85110]
    + Rework part of `Match` internals [0a84aa7f]
    + Simplify `Kernel.signals` using `Signal` values [5644c709]
    + Simplify `Grammar.parse` code [f10e5bce][8be24067][1402c1d1]
    + Allow debuggers for Rakudo to be specified by environment variables [48e073e2]
    + Default to using egdb when possible in rakudo-gdb-m which covers OpenBSD developer environments [b01b0120]
    + Introduce INTERPOLATE [417a591a][777e7b65][3f9f23a9][638517da][05907227]
    + Various internal improvements to the code base [ef0c457b][e71d3cb0]
      [37533ee6][b3d933b4][4afaab73][3796405b][17bf5d5f][d9defb6c][2aac854f]
      [799d627a][a56e62de][c1decf2a][a69465a7][26d88b9e][44b27019][95f7d34e]
      [b5bf1bf4][285717a0][21c3ef82][4103a309][a616fe57][e645ff6a][ea8c04db]
      [ad9b9f4f][9942ccc0][1c94538e][9f73351b][e9f80357][a431968e][519a5726]
      [4ba70b7a][496e9166][d984e7c2][bf01f845][da9943a4][150af9a2][6f459456]
      [92d01836][98dec90d][792a0f00][902401b7][4d1ef59e][2bfaab6c]
    + Update `INSTALL.txt` for the latest changes [8bb0235b][e1db95e8][bd5e19e4]
    + Various small improvements to compiler's user-facing documentation [dac68b27]
      [302bc8ed][736ce715][10a8f6a2][627ffd42][3d6756b3][eab17e7a][18ecb604]
      [2cff6dd9][77b2f2a5][197bba98][621577b4][d09cf9d8][8a8f62ca][a79efdef]
      [797c96de][8c3f013d][11afa53b][fbb0abc1]
    + Various changes to documentation related to renaming process
      [6ead4ce1][142d03be][e0384ee0][0ccd4cfe][4d6031f6][d53a3b1a][de6ebd4e][b0032395]


The following people contributed to this release:

Elizabeth Mattijsen, Juan Julián Merelo Guervós, Patrick Böker,
Will "Coke" Coleda, Daniel Green, Stoned Elipot, Alexander Kiryuhin, Stefan Seifert,
Sizhe Zhao, Christian Bartolomäus, Tom Browder, Vadim Belman,
Jonathan Worthington, Tim Smith, Luis F. Uceta, andreoss, Suman Khanal,
Aleks-Daniel Jakimenko-Aleksejev, Nicholas Clark,
Luc St-Louis, Mike Swierczek, Timo Paulssen, Ben Davies,
Wenzel P. P. Peppmeyer, Donald Hunter, Jan-Olof Hendig, Jack Miles,
Mikhail Khorkov, 0racle, Brian Duggan, Dave Lewis, David Warring,
Jeremy Studer, Jimmy Zhuo, Juan Francisco Cantero Hurtado, Nick Logan,
Sylvain Colinet, Tim Siegel, Vittore F. Scolari, cygx, nwc10,
sztanyi, vendethiel

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2020 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#137), is tentatively scheduled for 2020-07-18.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
