# Announce: Rakudo compiler, Release #135 (2020.05)

On behalf of the Rakudo development team, I’m very happy to announce the
May 2020 release of Rakudo #135. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2020.05:

  + Fixes:
    + Decontainerize attribute default values [d71761e3]
    + Fix `Cool` catchers for some `Str` methods
      [a91d7d79][63a72659][af8788b4]
    + Update some internal documentation to use Raku name [f2cc20c6]
    + Add `Cool.contains(Regex)` candidates [c3c1e8c9]
    + Make format of all `QuantHash`'s classes `.gist` uniform [cf01f7a2]
    + `Method` objects that don't have `*%_` in their signature, `.gist` ok [ac5f353a]
    + Fix `DateTime` default stringification when the second is 0 [95de7859]
    + Make `Blob/Buf.list` non-lazy so they can be used in hypers [6d146b56][291aa580]
    + Remove unnecessary parentheses from `Pair.raku` [35a827af]
    + `IO::CatHandle.slurp` did not accept `:bin` parameter [42c4c3fc]
    + Fixed some cases where `IO::Handle.slurp` was used without `:close` [efab398e]
    + `run` routine with `out` named parameter being a `Handle` and `merge` flag
      enabled now writes both stdout and stderr to the handle [1f838791]
    + A single whenever react based on a signal is now serialized by default [8aa25bfb]
    + `&cmp-ok` subroutine of `Test` module now works with objects without support for methods [fc0f78d5]
    + Ensure meta-ops respect user-defined chain ops [ac012f18]
    + Fix exception when mixing in roles that use `is built` at runtime [4c026ab8]
    + Fix inconsistent match result when using a code block in a regex [1e0474d4]
    + Fix error message related to `nextcallee` subroutine [136087e7]
    + Fix regression in sequence operator [0a6456a4]
    + Fix reflection for . twigilled parameters [296fbcf4]
    + Fix `Parameter.raku` with `OUTER` default values [87d2ff95][2f8538ed]
    + Fix `Capture.WHICH` for subclasses of `Capture` [8808401c]
    + Fix `Capture.EXISTS-KEY` for some `Capture` values [2d18cdeb]
    + Make (1..-Inf).reverse) work as intended [3983b4f8]
    + Make (foo .. foo).reverse correctly [c588323e]
    + Properly throw an exception on attempts to add a key to an immutable `Map` [1a10b63a]
    + `INPUTRC` environment variable is now checked for a Readline config when using REPL [61a48362]
    + Add missing label support for some loop constructs [66a2250a]
    + Make `Real.sign` always return an `Int` [42a303ec]
    + Result of `reverse` called on a `List` value with holes returns a
      reverse of the list with `Nil` in place of holes instead of `Mu` now [e9468d6a][ca49c153]
    + Various small JVM backend related improvements [945a4d81][b4819e7c][f6f8ac0d][25a1929c][717b3266]
  + Additions:
    + Added `docs/IN-MEMORIAM.md` to commemorate departed contributors [9b6d89b1][f9f3b662][170add26]
    + Implement support of environment variables `RAKULIB` and `RAKUDOLIB`
      to eventually replace deprecated `PERL6LIB`
      [b3bb0d38][cc165a05][1fd660a9][00c0dec3][be9bb4b1][30a3186b][e8f7eb56][61124c35][013b47d2]
    + Implement support for environment variables `RAKU_TEST_DIE_ON_FAIL` and `RAKU_TEST_TIMES`
      to replace `PERL6_TEST_DIE_ON_FAIL` and `PERL6_TEST_TIMES` [30e7a67c][afff3b0b]
    + Show timing information when installing core modules in build process [58e61356]
    + Add multiple needles feature to `Str.index/rindex` [4cec44a3][cf02c2e9]
    + `dd` can now also handle `BOOTContext` objects [8b70bfb8]
    + `Str` now has `.Date` and `DateTime` coercers [d95d218f]
    + `Date.yyyy-mm-dd` now takes a separator parameter, defaulting to `-` [3017cfea]
    + Added `Date.dd-mm-yyyy` and `Date.mm-dd-yyyy` methods [70ac9b72]
    + `IterationBuffer` now has a `.Slip` method for easier iteration [d68fe5eb]
    + Add `is implementation-detail` trait and hide exposed internals with it
      [12a33637][09c1b05a][2ae9fdf0][20c978e6][78371bb0][1d57d17d][0c36feb0]
    + Introduce `^...` and `^...^` sequence generator operators [371590fa][bbed2255]
    + Add `Date.last-date-in-month` and `Date.first-day-in-month` methods [2fb7198f][20ce5560]
    + Add a `parents` metamethod to `Metamodel::ParametricRoleGroupHOW` [8dcfa849]
  + Removals:
    + Remove undocumented `Seq.new-consumed` [0f97a7f5]
    + Move implementation detail to internals [aed658d6][b639221d][86bc3b3d]
      [75f34c52][d3385e73][73c7ded2][9429728c][509a7f6e][439b8609][e152aa6a][ebb29499]
    + Turn `infix:<…>` and `infix:<…^>` into aliases [bd4e119d]
  + Build system:
    + Fix CircleCI configuration [efba9639][ffcc6198]
    + Be more robust when working with git reference directories that has spaces in path
      [3ec58489][e6044dfc][2f0dd45e]
    + Move prebuild archive scripts to scripts folder [e1114208]
    + Change update-submodules.pl to not use the shell at all [0ae8b4e0]
    + Fix installation of perl6 aliases [aeb418a5]
    + Move RUN_CLEAN_TARGET_FILES to a separate script [ffad1024]
    + Fix building non-moar backends on Windows [47650ebe]
    + Fix `--nqp-home` Configure.pl parameter [94fdb3d5][59fe24bc]
    + Make timing based performance tests opt in via `RAKUDO_RUN_TIMING_TESTS` environment variable [31ffc2bd]
  + Efficiency:
    + Speed up compilation of large projects [c9092582][6956c063]
    + Make `raku -n` as fast as manual iteration with `.IO.lines` [be9c139f][5cad8fee]
    + Improve behavior of default `ThreadPoolScheduler`,
      increasing efficiency of multithreaded applications [77a2201e][750abe03]
    + Make method lookup with the handles trait 13% faster in certain cases [af594925]
    + Simplify "previous setting" logic [9f4a0f1c]
    + Make creation of `Failure` objects faster [79ca396e]
    + Make default `DateTime` stringification about 12% faster [0e872356][d95141ed]
    + Make all `IO::Path` filetest methods a few percent faster [76c20d28][355b520b][bd9d7c1c]
    + Make `IO::Path.mode` about 14x as fast [a093b7fa]
    + Make `Date.yyyy-mm-dd` about 250x as fast [3017cfea][f9ecf6e8]
    + Make accessing native shaped arrays about 15x faster [80f2aebf]
    + Make `Seq.Numeric` and `Seq.Int` slightly faster [b7b9358f]
    + Make a number of traits around 2% faster [4bbe308b]
    + Make a minor optimization to a bunch of STORE methods [a4fbbfa3]
    + Make `Capture.raku` 45% faster [5baa645b][d6298edc]
    + Make `Capture.WHICH` 60% faster [688f6710]
    + Make `Capture.AT-KEY` 2% faster [22c0a53d]
    + Make `push(@a, foo)` about 20x as fast [385ab4cf]
    + Make `append(@a, foo)` about 20x as fast [b98d2e00][1e4c7361]
    + Make `unshift(@a, foo)` about 20x as fast [6541775c]
    + Make `prepend(@a, foo)` about 20x as fast [9b735b76]
    + Make `Num.Rat` faster [f987cdb0][2d1ba433]
    + Make `Date.succ` faster for days 28-31 [285da3b8]
    + Make `Str.tc` about 10% faster [5610416c]
    + Make `Supply.grab` a few percent faster [e0336d52]
    + `...` (SEQUENCE) optimizations [fc8c8281][935ee309][08545a33][d2ed7faa][fbf54e17][0fba27d7]
      [8fe30b9c][58fa99b2][cf6177ef][75c6ac34][500dc662][9286def3][13559242][99cb2fa2]
    + CompUnit::* optimizations [1dbb227c][0249f23e][28bd4247][b4cdccc1][cb7be78c][638c8955]
      [c9d9a096][83fed554][2cc509c0][f1cdfb18][9d1b3f63][db6d2306][7c9951cc][83ddbaba]
      [196db682][551c157f][07643d37][e56eddd8][20d3713c][b4d32c97][8ac2eecc][4e3e937b]
      [6c7ffbdb][17c45d89][89503809][747a35ba][dedb7444][cbd75f72][81ac37f8][f54ad732]
      [fae4d45d][d55146bd][e33fe878][b712789e][e756e622][199888ab][95e8906c][5271d122]
      [f48b80c3][954e545c][ef2d7d84][778ce379][1a0cc947][11b186c8][dec40dc4][d38d76d5]
      [f31bd5ba][e1af7407][33fc8950][a62da301][0736bf7d][437f9f46][6e95e1b0][6723d3ad]
      [24fd100d][b3f7ad2f][c29a2bf0][b07224f6][7de42d4b][7b5e1434][68cadd79][f980898f]
      [bec2ac4c][d66068c1][31197cd3][2899d737][d4231b1f][c2a1ee95][6d3f1c12][dceef85f]
      [859d8f04][5ea1c346][2a58eb39][3d6e8d6d][ea4bdf94][38a0eb82][2075489e][13ca677e]
    + Be better at inlining `any` Junction [76923bee]
    + Optimize symbol lookup at compunit creation time [35832540][75da4cfe]
    + Numerous small optimizations and improvements [014d493a][776ef800][87226876]
      [49d1dcd3][d8366ff4][61b5e488][6793713b][2edce41b][d0e427dc][0b414c0a][88a9a36e]
      [604085fb][f70d95e2][db6048e3][a66f5c29][80be7d19][a5535b2a][0d5f87cc][3c83ce75]
      [3aaca26a][43c7e96f][dc7a7962][e78483ed][7bbf12d3][b9b46c0a][b0a720cb][fcda03ba]
      [4339073b][cfc6cc3c][33f41966][0aa8b2a8][9cabea01][9b503292][6bb87106]
  + Internal:
    + Update Appveyor perl requirement on Windows to 5.22 [370956b9]
    + Add optional "lazy" flag to `Rakudo::Iterator.SequentialIterators` [101a80f2]
    + Give `IterationBuffer` its own `iterator` method [2b49d685]
    + Adopt MoarVM-provided `value_desc_cont` [4221f822]
    + Add `Rakudo::Iterator.AllButLast` iterator [77defa77][aa5154e0]
    + Add `Rakudo::Iterator.AllButFirst` iterator [4fe18a48]
    + Add and use `Rakudo::Iterator.ReifiedListReverse` iterator
      [3ca38022][270cc275][cea0fc78][4025ca43][447b396f]
    + Add `Exception.message` stub [2e605520]
    + Make `Mu.iterator` use `Rakudo::Iterator.OneValue` [65fdea7d]
    + Make `Rakudo:Iterator.OneValue` a `PredictiveIterator` [ec50b961]
    + Rename `SlippyIterator` to `Rakudo::SlippyIterator` [50f13f03][fa3c0dba]
    + Don't use named variables between internal methods [92750571]
    + Implement `VM.request-garbage-collection` [e223be56]
    + `Rakudo::Iterator.ReifiedList` now returns a `PredictiveIterator` [063bfa05]

The following people contributed to this release:

Elizabeth Mattijsen, Stefan Seifert, Will "Coke" Coleda,
Juan Julián Merelo Guervós, Daniel Green, Vadim Belman,
Tom Browder, Jonathan Worthington, Ben Davies, Patrick Böker, Alexander Kiryuhin,
Stoned Elipot, Christian Bartolomäus, Tinmarino,
Aleks-Daniel Jakimenko-Aleksejev, Luis F. Uceta, Salve J. Nilsen,
Wictor Lund, Jan-Olof Hendig, Dave Lewis, Martin Ryan, Samantha McVey,
lukasvalle, Chloé Kekoa, Konrad Bucheli, Mikhail Khorkov, Suman Khanal,
Timo Paulssen, Will Coleda, cfa, stoned, Carlin, Claudio Ramirez,
Ed Mangimelli, José Joaquín Atria, Justin DeVuyst, Moritz Lenz,
Patrick Boeker, Tim Smith, Tobias Boege, sztanyi.

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2020 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#136), is tentatively scheduled for 2020-05-30.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
