# Announce: Rakudo Perl 6 compiler, Release #128 (2018.11)

On behalf of the Rakudo development team, I’m very happy to announce the
November 2018 release of Rakudo Perl 6 #128. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements 6.c and 6.d versions of the Perl 6 specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2018 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

The tarball for this release is available from <https://rakudo.org/files/rakudo>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] — it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<https://rakudo.org/files/star>.

The changes in this release are outlined below:

New in 2018.11:
  + SPECIAL NOTES:
    + 🎆❇️🔥 Default language version is now `v6.d` 🔥❇️🎆 [46ef0ea0]
  + Deprecations:
    + Deprecated `.path`/`.args` in `Proc::Async`, use `.command`
        instead [45bbc946]
  + Fixes:
    + Fixed `$*PERL.version` to always report the right version [c9ecfb7a]
    + Consistified `:U.pairup` with `:D.pairup` to return a Seq [d73272e4]
    + Provided a stable `.WHICH` for `Map` [4e0a1c24][052067fd]
    + Made sure `DEPRECATED` reports location correctly when
        using `:up` [8561d0ae]
    + Fixed literal `\` in `tr///` [85107ec0]
    + Fixed tap add/remove race in `Supplier` and `Supplier::Preserving`
        [7ee1f3c5][68d79e70]
    + `QuantHash`es now properly report `.of` and `.keyof` [8b93ec9f]
    + Added type constraints to port numbers in `IO::Socket::Async` [547f28ba]
    + Fixed re-initialization on some types of arrays [f1fa5adf]
        [7262b4e8][49f07abe]
    + Gave 6.d correct `is rw` Proxy semantics [7d37f9aa]
    + Fixed `Match.^roles` [becbdeb9]
    + Fixed missing path volume after `..` is resolved [8854bbd3]
    + The `.values` method can now be used to change values in
        object hashes [a728bb2d]
    + Fixed shaped dynamic variables like `my %*a{Int}` [bcdf87a6]
    + Made `my @a is Blob / Buf = ...` work [762c708f]
    + Object hashes and `QuantHash`es can now be used with
        metaops [Hyper refactor]
    + Many improvements to the JS backend [32b7c089][f35dd301][9457f7e5]
        [ea69c0a0][0e4969fe][9df074ba][78389aa2][1ef62aca][f460ad1a][cbbe16ed]
    + Improved error message when using placeholders with methods [deae5bcd]
        [0896c301][48093d0d][0bda7dc1][90103f6d][68b44e33][8549c4c1]
    + Various improvements to produced messages [15c16e35][e6758492]
  + Additions:
    + Implemented `X::Language::TooLate` [3365094f]
    + `$*COLLATION.set` is no longer experimental [20c41ca5]
    + Added dynamic variable `$*FOLDING` [cec1f511]
  + Removals:
    + Removed unspecced `.allowed` attribute in `Pod::Block::Code` [5aba3e96]
    + Set operators `(<+)`, `≼`, `(>+)`, `≽` now die when used [951303f9]
        [7a1a1868][81474bf9][5598f37d]
    + `Associative >>op<< Iterable` now dies, as the results are indeterminate
        due to random hash key order [Hyper refactor]
  + Build system:
    + Fixed `t/*/*.t` rule in generated Makefile [d2c7e327]
    + Made running timing based tests optional [72b896c8]
  + Efficiency:
    + Made `Int eqv Int` 3x and `int eqv int` 5x as fast [fb9a0454][94dd0a41]
    + Made `ObjAt` `eqv` `ObjAt` also faster [5120d3d2]
    + Made `Hash`/`Map` slices about 5x as fast [6fe27894][b83179f0]
        [c4da4c7e][9a2c4b44]
    + Optimized various operations on `Date` and `DateTime` making
        them up to 3x as fast [11cb4fac][b6292fe9][08fac045][98d07cf6]
        [b463746d][bf3eb8ec][a11d599f]
    + Made metaops use the fast path for `&[+=]`-like ops [e7ce194a]
    + Hyper operator refactor makes many things like
        `%h >>+>> 1` 1.3x to 8x as fast [bfe2ad63][130cc817][0bc72e05]
          [75c9456a][ec2848c4][f06e8582][73eb297f][194daab7][a575effe]
          [c50cf82a][1a2b39dc][307a98bd][843118ea][6208c266][9221c08d]
          [c03e71d5][78f64203][63ae9dcc][fa5215b6][d5a751d9][674a0837]
          [8fa72681][80edefcf][cf5c8a09][534d8f65][7fad12b0][800d8fbb]
          [c3f03e67][1ed2b098][21434dda][234e298b][e8285c01][32ab0d30]
          [90ac0940][f7007ac0][dc67ee75][cae9847e][481dbf92][c4445649]
          [19f0c842][86ce4f4e][50f2207b][2e5be5b8][1b7253df][64a47d87]
          [005261a4][10693d16]
  + Internal:
    + Changed CORE.d setting compilation to propagate indicator flags [4a6d9108]
    + Made sure we don't add object to serialization context more
        than once [3995e423]
    + New QAST to mbc compiler [edc4c054][6aafe18d][f8be2fa0][656a8045][bb43acdb]
    + Added `Hash.STORE(\keys,\values)` [faa19ab9]
    + Introduced `R:I.AssociativeIterableKeys` [6fe27894]
    + Various internal optimizations [5f1a81e0][1766435a][8e858c8d][00eb7b85]
        [0fa6988c][bf3575cc][18ded174]


The following people contributed to this release:

Stefan Seifert, Elizabeth Mattijsen, Zoffix Znet,
Aleks-Daniel Jakimenko-Aleksejev, Paweł Murias, Timo Paulssen, Nick Logan,
Tom Browder, Rob Hoelz, Jonathan Worthington, Joelle Maslak, Donald Hunter,
Bart Wiegmans, Daniel Green, Fernando Correa de Oliveira,
Juan Julián Merelo Guervós, Samantha McVey

If you would like to contribute or find out more information, visit
<https://perl6.org>, <https://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put “Perl 6 Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#129), is tentatively scheduled for 2018-12-15.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, Perl 6 introductory
documentation, and other software that can be used with the Rakudo
compiler to enhance its utility.
