% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mixed_info.R
\name{get_mixed_info}
\alias{get_mixed_info}
\alias{get_mixed_info.default}
\alias{get_mixed_info.glmmTMB}
\title{Extract various information from mixed models}
\usage{
get_mixed_info(model, ...)

\method{get_mixed_info}{default}(model, verbose = TRUE, ...)

\method{get_mixed_info}{glmmTMB}(model, component = "conditional", verbose = TRUE, ...)
}
\arguments{
\item{model}{A mixed effects model.}

\item{...}{Not used.}

\item{verbose}{Toggle off warnings.}

\item{component}{For \code{glmmTMB} and \code{MixMod} models, this argument specifies
the component of the model to extract. Possible values are \code{"conditional"}
(default) and \code{"zero_inflated"} (or \code{"zi"}).}
}
\value{
This function returns a list that has the same structure for any
mixed models with the following components:
\itemize{
\item \code{beta} (contains fixed effects, as returned by \code{lme4::fixef(model)})
\item \code{X} (contains the model matrix, as returned by \code{lme4::getME(model, "X")})
\item \code{vc} (contains the variance and correlation parameters, as returned by
\code{lme4::VarCorr(model)})
\item \code{re} (random effects parameters, as returned by \code{lme4::ranef(model)})
}
}
\description{
Small helper function that returns essential information on
coefficients, model matrix, variance and correlation parameters, as well as
random effects parameters of mixed effects models as list. Mainly used for
internal purposes.
}
