% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-month-weekday.R
\name{year-month-weekday-setters}
\alias{year-month-weekday-setters}
\alias{set_year.clock_year_month_weekday}
\alias{set_month.clock_year_month_weekday}
\alias{set_day.clock_year_month_weekday}
\alias{set_index.clock_year_month_weekday}
\alias{set_hour.clock_year_month_weekday}
\alias{set_minute.clock_year_month_weekday}
\alias{set_second.clock_year_month_weekday}
\alias{set_millisecond.clock_year_month_weekday}
\alias{set_microsecond.clock_year_month_weekday}
\alias{set_nanosecond.clock_year_month_weekday}
\title{Setters: year-month-weekday}
\usage{
\method{set_year}{clock_year_month_weekday}(x, value, ...)

\method{set_month}{clock_year_month_weekday}(x, value, ...)

\method{set_day}{clock_year_month_weekday}(x, value, ..., index = NULL)

\method{set_index}{clock_year_month_weekday}(x, value, ...)

\method{set_hour}{clock_year_month_weekday}(x, value, ...)

\method{set_minute}{clock_year_month_weekday}(x, value, ...)

\method{set_second}{clock_year_month_weekday}(x, value, ...)

\method{set_millisecond}{clock_year_month_weekday}(x, value, ...)

\method{set_microsecond}{clock_year_month_weekday}(x, value, ...)

\method{set_nanosecond}{clock_year_month_weekday}(x, value, ...)
}
\arguments{
\item{x}{\verb{[clock_year_month_weekday]}

A year-month-weekday vector.}

\item{value}{\verb{[integer / "last"]}

The value to set the component to.

For \code{set_index()}, this can also be \code{"last"} to adjust to the last
instance of the corresponding weekday in that month.}

\item{...}{These dots are for future extensions and must be empty.}

\item{index}{\verb{[NULL / integer / "last"]}

This argument is only used with \code{set_day()}, and allows you to set the
index while also setting the weekday.

If \code{x} is a month precision year-month-weekday, \code{index} is required to
be set, as you must specify the weekday and the index simultaneously to
promote from month to day precision.}
}
\value{
\code{x} with the component set.
}
\description{
These are year-month-weekday methods for the
\link[=clock-setters]{setter generics}.
\itemize{
\item \code{set_year()} sets the Gregorian year.
\item \code{set_month()} sets the month of the year. Valid values are in the range
of \verb{[1, 12]}.
\item \code{set_day()} sets the day of the week. Valid values are in the range of
\verb{[1, 7]}, with 1 = Sunday, and 7 = Saturday.
\item \code{set_index()} sets the index indicating that the corresponding
weekday is the n-th instance of that weekday in the current month. Valid
values are in the range of \verb{[1, 5]}.
\item There are sub-daily setters for setting more precise components.
}
}
\examples{
x <- year_month_weekday(2019, 1:3)

set_year(x, 2020:2022)

# Setting the weekday on a month precision year-month-weekday requires
# also setting the `index` to fully specify the day information
x <- set_day(x, clock_weekdays$sunday, index = 1)
x

# Once you have at least day precision, you can set the weekday and
# the index separately
set_day(x, clock_weekdays$monday)
set_index(x, 3)

# Set to the "last" instance of the corresponding weekday in this month
# (Note that some months have 4 Sundays, and others have 5)
set_index(x, "last")

# Set to an invalid index
# January and February of 2019 don't have 5 Sundays!
invalid <- set_index(x, 5)
invalid

# Resolve the invalid dates by choosing the previous/next valid moment
invalid_resolve(invalid, invalid = "previous")
invalid_resolve(invalid, invalid = "next")

# You can also "overflow" the index. This keeps the weekday, but resets
# the index to 1 and increments the month value by 1.
invalid_resolve(invalid, invalid = "overflow")
}
