# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.storageactions.aio import StorageActionsMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestStorageActionsMgmtStorageTasksOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(StorageActionsMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_tasks_get(self, resource_group):
        response = await self.client.storage_tasks.get(
            resource_group_name=resource_group.name,
            storage_task_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_tasks_begin_create(self, resource_group):
        response = await (
            await self.client.storage_tasks.begin_create(
                resource_group_name=resource_group.name,
                storage_task_name="str",
                parameters={
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "properties": {
                        "action": {
                            "if": {
                                "condition": "str",
                                "operations": [
                                    {
                                        "name": "str",
                                        "onFailure": "str",
                                        "onSuccess": "str",
                                        "parameters": {"str": "str"},
                                    }
                                ],
                            },
                            "else": {
                                "operations": [
                                    {
                                        "name": "str",
                                        "onFailure": "str",
                                        "onSuccess": "str",
                                        "parameters": {"str": "str"},
                                    }
                                ]
                            },
                        },
                        "description": "str",
                        "enabled": bool,
                        "creationTimeInUtc": "2020-02-20 00:00:00",
                        "provisioningState": "str",
                        "taskVersion": 0,
                    },
                    "id": "str",
                    "name": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_tasks_begin_update(self, resource_group):
        response = await (
            await self.client.storage_tasks.begin_update(
                resource_group_name=resource_group.name,
                storage_task_name="str",
                parameters={
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "properties": {
                        "action": {
                            "if": {
                                "condition": "str",
                                "operations": [
                                    {
                                        "name": "str",
                                        "onFailure": "str",
                                        "onSuccess": "str",
                                        "parameters": {"str": "str"},
                                    }
                                ],
                            },
                            "else": {
                                "operations": [
                                    {
                                        "name": "str",
                                        "onFailure": "str",
                                        "onSuccess": "str",
                                        "parameters": {"str": "str"},
                                    }
                                ]
                            },
                        },
                        "creationTimeInUtc": "2020-02-20 00:00:00",
                        "description": "str",
                        "enabled": bool,
                        "provisioningState": "str",
                        "taskVersion": 0,
                    },
                    "tags": {"str": "str"},
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_tasks_begin_delete(self, resource_group):
        response = await (
            await self.client.storage_tasks.begin_delete(
                resource_group_name=resource_group.name,
                storage_task_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_tasks_list_by_resource_group(self, resource_group):
        response = self.client.storage_tasks.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_tasks_list_by_subscription(self, resource_group):
        response = self.client.storage_tasks.list_by_subscription()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_tasks_preview_actions(self, resource_group):
        response = await self.client.storage_tasks.preview_actions(
            location="str",
            parameters={
                "properties": {
                    "action": {"elseBlockExists": bool, "if": {"condition": "str"}},
                    "blobs": [
                        {
                            "matchedBlock": "str",
                            "metadata": [{"key": "str", "value": "str"}],
                            "name": "str",
                            "properties": [{"key": "str", "value": "str"}],
                            "tags": [{"key": "str", "value": "str"}],
                        }
                    ],
                    "container": {"metadata": [{"key": "str", "value": "str"}], "name": "str"},
                }
            },
        )

        # please add some check logic here by yourself
        # ...
