# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AutoGeneratedDomainNameLabelScope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The scope at which the auto-generated domain name label is generated and at which the resource
    name can be reused.
    """

    NO_REUSE = "NoReuse"
    """The domain name label is randomly generated. The resource name cannot be reused within the same
    region."""
    TENANT_REUSE = "TenantReuse"
    """The domain name label is deterministically generated using the resource name and tenant id. The
    resource name cannot be reused within the same region and tenant."""
    SUBSCRIPTION_REUSE = "SubscriptionReuse"
    """The domain name label is deterministically generated using the resource name, tenant id, and
    subscription id. The resource name cannot be reused within the same region and subscription."""
    RESOURCE_GROUP_REUSE = "ResourceGroupReuse"
    """The domain name label is deterministically generated using the resource name, tenant id,
    subscription id, and resource group name. The resource name cannot be reused within the same
    resource group."""


class CatalogTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Microsoft Planetary Computer Pro GeoCatalog tier."""

    BASIC = "Basic"
    """The basic tier that utilizes shared resources across catalog instances"""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    """No managed identity."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """System assigned managed identity."""
    USER_ASSIGNED = "UserAssigned"
    """User assigned managed identity."""
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"
    """System and user assigned managed identity."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the current operation."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    PROVISIONING = "Provisioning"
    """The catalog is being provisioned."""
    UPDATING = "Updating"
    """The catalog is being updated."""
    DELETING = "Deleting"
    """The catalog is being deleted."""
    ACCEPTED = "Accepted"
    """The catalog request has been accepted."""
