# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.dns import DnsManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDnsManagementZonesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DnsManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_zones_create_or_update(self, resource_group):
        response = self.client.zones.create_or_update(
            resource_group_name=resource_group.name,
            zone_name="str",
            parameters={
                "location": "str",
                "etag": "str",
                "id": "str",
                "maxNumberOfRecordSets": 0,
                "maxNumberOfRecordsPerRecordSet": 0,
                "name": "str",
                "nameServers": ["str"],
                "numberOfRecordSets": 0,
                "registrationVirtualNetworks": [{"id": "str"}],
                "resolutionVirtualNetworks": [{"id": "str"}],
                "tags": {"str": "str"},
                "type": "str",
                "zoneType": "Public",
            },
            api_version="2018-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_zones_begin_delete(self, resource_group):
        response = self.client.zones.begin_delete(
            resource_group_name=resource_group.name,
            zone_name="str",
            api_version="2018-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_zones_get(self, resource_group):
        response = self.client.zones.get(
            resource_group_name=resource_group.name,
            zone_name="str",
            api_version="2018-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_zones_update(self, resource_group):
        response = self.client.zones.update(
            resource_group_name=resource_group.name,
            zone_name="str",
            parameters={"tags": {"str": "str"}},
            api_version="2018-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_zones_list_by_resource_group(self, resource_group):
        response = self.client.zones.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2018-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_zones_list(self, resource_group):
        response = self.client.zones.list(
            api_version="2018-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
