# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.databoxedge import DataBoxEdgeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataBoxEdgeManagementMonitoringConfigOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataBoxEdgeManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_monitoring_config_list(self, resource_group):
        response = self.client.monitoring_config.list(
            device_name="str",
            role_name="str",
            resource_group_name=resource_group.name,
            api_version="2021-02-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_monitoring_config_get(self, resource_group):
        response = self.client.monitoring_config.get(
            device_name="str",
            role_name="str",
            resource_group_name=resource_group.name,
            api_version="2021-02-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_monitoring_config_begin_create_or_update(self, resource_group):
        response = self.client.monitoring_config.begin_create_or_update(
            device_name="str",
            role_name="str",
            resource_group_name=resource_group.name,
            monitoring_metric_configuration={
                "metricConfigurations": [
                    {
                        "counterSets": [
                            {
                                "counters": [
                                    {
                                        "name": "str",
                                        "additionalDimensions": [{"sourceName": "str", "sourceType": "str"}],
                                        "dimensionFilter": [{"sourceName": "str", "sourceType": "str"}],
                                        "instance": "str",
                                    }
                                ]
                            }
                        ],
                        "resourceId": "str",
                        "mdmAccount": "str",
                        "metricNameSpace": "str",
                    }
                ],
                "id": "str",
                "name": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2021-02-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_monitoring_config_begin_delete(self, resource_group):
        response = self.client.monitoring_config.begin_delete(
            device_name="str",
            role_name="str",
            resource_group_name=resource_group.name,
            api_version="2021-02-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
