/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.test.remoting.marshall.dynamic.remote.socket;

import org.jboss.jrunit.extensions.ServerTestCase;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.loading.RemotingClassLoader;
import org.jboss.remoting.transport.Connector;

import javax.management.MBeanServer;

/**
 * Simple remoting server.  Uses inner class SampleInvocationHandler
 * as the invocation target handler class.
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class MarshallerLoadingServer extends ServerTestCase implements MarshallerLoadingConstants
{
   private Connector connector;

   // String to be returned from invocation handler upon client invocation calls.
   private static Object RESPONSE_VALUE = null;

   public void setupServer() throws Exception
   {
      System.out.println("locatorURI: " + locatorURI);
      String newLocatorURI = locatorURI;
      String metadata = System.getProperty("remoting.metadata");
      System.out.println("metadata: " + metadata);
      if(metadata != null)
      {
         newLocatorURI += "&" + metadata;
      }
      InvokerLocator locator = new InvokerLocator(newLocatorURI);
      System.out.println("Starting remoting server with locator uri of: " + newLocatorURI);
      connector = new Connector();
      connector.setInvokerLocator(locator.getLocatorURI());
      connector.start();

      SampleInvocationHandler invocationHandler = new SampleInvocationHandler();
      // first parameter is sub-system name.  can be any String value.
      connector.addInvocationHandler("sample", invocationHandler);
   }

   public void setUp() throws Exception
   {
      setResponseObject();
      setupServer();
   }

   private void setResponseObject() throws ClassNotFoundException, IllegalAccessException, InstantiationException
   {
//      Class testObjClass = Class.forName("org.jboss.test.remoting.marshall.dynamic.remote.socket.TestObject");
      RemotingClassLoader loader = new RemotingClassLoader(MarshallerLoadingServer.class.getClassLoader(), Thread.currentThread().getContextClassLoader());
      Class testObjClass = Class.forName("org.jboss.test.remoting.marshall.dynamic.remote.socket.TestObject", false, loader);
      RESPONSE_VALUE = testObjClass.newInstance();
   }


   public void tearDown() throws Exception
   {
      if(connector != null)
      {
         connector.stop();
         connector.destroy();
      }
   }

   public static void main(String[] args)
   {
      MarshallerLoadingServer server = new MarshallerLoadingServer();
      try
      {
         server.setUp();

         while(true)
         {
            Thread.currentThread().sleep(5000);
         }
      }
      catch(Exception e)
      {
         e.printStackTrace();
      }
   }


   /**
    * Simple invocation handler implementation.
    */
   public static class SampleInvocationHandler implements ServerInvocationHandler
   {
      /**
       * called to handle a specific invocation
       *
       * @param invocation
       * @return
       * @throws Throwable
       */
      public Object invoke(InvocationRequest invocation) throws Throwable
      {
         // Print out the invocation request
         System.out.println("Invocation request is: " + invocation.getParameter());

         // Just going to return static string as this is just simple example code.
         return RESPONSE_VALUE;
      }

      /**
       * Adds a callback handler that will listen for callbacks from
       * the server invoker handler.
       *
       * @param callbackHandler
       */
      public void addListener(InvokerCallbackHandler callbackHandler)
      {
         // NO OP as do not handling callback listeners in this example
      }

      /**
       * Removes the callback handler that was listening for callbacks
       * from the server invoker handler.
       *
       * @param callbackHandler
       */
      public void removeListener(InvokerCallbackHandler callbackHandler)
      {
         // NO OP as do not handling callback listeners in this example
      }

      /**
       * set the mbean server that the handler can reference
       *
       * @param server
       */
      public void setMBeanServer(MBeanServer server)
      {
         // NO OP as do not need reference to MBeanServer for this handler
      }

      /**
       * set the invoker that owns this handler
       *
       * @param invoker
       */
      public void setInvoker(ServerInvoker invoker)
      {
         // NO OP as do not need reference back to the server invoker
      }

   }
}