<!DOCTYPE html><html lang="en"><head><script async="" src="https://www.googletagmanager.com/gtag/js?id=UA-140352188-1"></script><script>window.dataLayer = window.dataLayer || [];
function gtag(){dataLayer.push(arguments);}
gtag('js', new Date());
gtag('config', 'UA-140352188-1');</script><meta charSet="utf-8"/><meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1"/><meta name="description" content="The CDN for tippy.js"/><meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1"/><meta name="timestamp" content="2023-10-17T18:29:16.792Z"/><link rel="shortcut icon" href="/favicon.ico"/><title>UNPKG - tippy.js</title><script>window.Promise || document.write('\x3Cscript src="/es6-promise@4.2.5/dist/es6-promise.min.js">\x3C/script>\x3Cscript>ES6Promise.polyfill()\x3C/script>')</script><script>window.fetch || document.write('\x3Cscript src="/whatwg-fetch@3.0.0/dist/fetch.umd.js">\x3C/script>')</script><script>window.__DATA__ = {"packageName":"tippy.js","packageVersion":"6.3.7","availableVersions":["0.3.4","0.3.5","0.3.6","0.4.0","0.4.1","0.5.0","0.5.1","0.6.0","0.6.1","0.7.0","0.8.0","0.8.1","0.8.2","0.9.0","0.10.0","0.10.1","0.10.2","0.11.0","0.11.1","0.11.2","0.11.3","0.12.0","0.12.1","0.12.2","0.13.0","0.14.0","0.14.1","0.14.2","0.15.0","0.16.0","0.16.1","0.16.2","0.16.3","0.17.0","1.0.0","1.0.1","1.1.0","1.1.1","1.1.2","1.1.3","1.2.0","1.2.1","1.2.2","1.3.0","1.4.0","1.4.1","1.4.2","2.0.0-beta.2","2.0.0","2.0.1","2.0.2","2.0.3","2.0.4","2.0.5","2.0.6","2.0.7","2.0.8","2.0.9","2.1.0","2.1.1","2.2.0","2.2.1","2.2.2","2.2.3","2.3.0","2.4.0","2.4.1","2.4.2","2.5.0","2.5.1","2.5.2","2.5.3","2.5.4","2.6.0","3.0.0-alpha.0","3.0.0-alpha.1","3.0.0-alpha.2","3.0.0-alpha.3","3.0.0-beta.0","3.0.0-beta.2","3.0.0","3.0.1","3.0.2","3.0.3","3.0.4","3.0.5","3.0.6","3.1.0","3.1.1","3.1.2","3.1.3","3.2.0","3.3.0","3.4.0","3.4.1","4.0.0-alpha.0","4.0.0","4.0.1","4.0.2","4.0.3","4.0.4","4.1.0","4.2.0","4.2.1","4.3.0","4.3.1","4.3.2","4.3.3","4.3.4","4.3.5","5.0.0-alpha.0","5.0.0-alpha.1","5.0.0-alpha.2","5.0.0-beta.0","5.0.0-beta.1","5.0.0-beta.2","5.0.0-beta.3","5.0.0","5.0.1","5.0.2","5.0.3","5.0.4","5.1.0","5.1.1","5.1.2","5.1.3","5.1.4","5.2.0","5.2.1","6.0.0-alpha.0","6.0.0","6.0.1","6.0.2","6.0.3","6.1.0","6.1.1","6.2.0","6.2.1","6.2.2","6.2.3","6.2.4","6.2.5","6.2.6","6.2.7","6.3.0","6.3.1","6.3.2","6.3.3","6.3.4","6.3.5","6.3.6","6.3.7"],"filename":"/dist/tippy-bundle.umd.js","target":{"path":"/dist/tippy-bundle.umd.js","type":"file","details":{"contentType":"application/javascript","integrity":"sha384-dtMr4wkcxQWUqsJFgElu4AttgIhOsjr2vYIzP2mv0MZbD/uJ6OHxFdbgE3MOKabN","language":"JavaScript","size":79783,"uri":null,"highlights":["<span class=\"code-comment\">/**!\n</span>","<span class=\"code-comment\">* tippy.js v6.3.7\n</span>","<span class=\"code-comment\">* (c) 2017-2021 atomiks\n</span>","<span class=\"code-comment\">* MIT License\n</span>","<span class=\"code-comment\">*/</span>\n","(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">global, factory</span>) </span>{\n","  <span class=\"code-keyword\">typeof</span> exports === <span class=\"code-string\">'object'</span> &amp;&amp; <span class=\"code-keyword\">typeof</span> <span class=\"code-built_in\">module</span> !== <span class=\"code-string\">'undefined'</span> ? <span class=\"code-built_in\">module</span>.exports = factory(<span class=\"code-built_in\">require</span>(<span class=\"code-string\">'@popperjs/core'</span>)) :\n","  <span class=\"code-keyword\">typeof</span> define === <span class=\"code-string\">'function'</span> &amp;&amp; define.amd ? define([<span class=\"code-string\">'@popperjs/core'</span>], factory) :\n","  (global = global || self, global.tippy = factory(global.Popper));\n","}(<span class=\"code-keyword\">this</span>, (<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">core</span>) </span>{ <span class=\"code-string\">'use strict'</span>;\n","\n","  <span class=\"code-keyword\">var</span> css = <span class=\"code-string\">\".tippy-box[data-animation=fade][data-state=hidden]{opacity:0}[data-tippy-root]{max-width:calc(100vw - 10px)}.tippy-box{position:relative;background-color:#333;color:#fff;border-radius:4px;font-size:14px;line-height:1.4;white-space:normal;outline:0;transition-property:transform,visibility,opacity}.tippy-box[data-placement^=top]&gt;.tippy-arrow{bottom:0}.tippy-box[data-placement^=top]&gt;.tippy-arrow:before{bottom:-7px;left:0;border-width:8px 8px 0;border-top-color:initial;transform-origin:center top}.tippy-box[data-placement^=bottom]&gt;.tippy-arrow{top:0}.tippy-box[data-placement^=bottom]&gt;.tippy-arrow:before{top:-7px;left:0;border-width:0 8px 8px;border-bottom-color:initial;transform-origin:center bottom}.tippy-box[data-placement^=left]&gt;.tippy-arrow{right:0}.tippy-box[data-placement^=left]&gt;.tippy-arrow:before{border-width:8px 0 8px 8px;border-left-color:initial;right:-7px;transform-origin:center left}.tippy-box[data-placement^=right]&gt;.tippy-arrow{left:0}.tippy-box[data-placement^=right]&gt;.tippy-arrow:before{left:-7px;border-width:8px 8px 8px 0;border-right-color:initial;transform-origin:center right}.tippy-box[data-inertia][data-state=visible]{transition-timing-function:cubic-bezier(.54,1.5,.38,1.11)}.tippy-arrow{width:16px;height:16px;color:#333}.tippy-arrow:before{content:\\\"\\\";position:absolute;border-color:transparent;border-style:solid}.tippy-content{position:relative;padding:5px 9px;z-index:1}\"</span>;\n","\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">injectCSS</span>(<span class=\"code-params\">css</span>) </span>{\n","    <span class=\"code-keyword\">var</span> style = <span class=\"code-built_in\">document</span>.createElement(<span class=\"code-string\">'style'</span>);\n","    style.textContent = css;\n","    style.setAttribute(<span class=\"code-string\">'data-tippy-stylesheet'</span>, <span class=\"code-string\">''</span>);\n","    <span class=\"code-keyword\">var</span> head = <span class=\"code-built_in\">document</span>.head;\n","    <span class=\"code-keyword\">var</span> firstStyleOrLinkTag = <span class=\"code-built_in\">document</span>.querySelector(<span class=\"code-string\">'head&gt;style,head&gt;link'</span>);\n","\n","    <span class=\"code-keyword\">if</span> (firstStyleOrLinkTag) {\n","      head.insertBefore(style, firstStyleOrLinkTag);\n","    } <span class=\"code-keyword\">else</span> {\n","      head.appendChild(style);\n","    }\n","  }\n","\n","  <span class=\"code-keyword\">var</span> isBrowser = <span class=\"code-keyword\">typeof</span> <span class=\"code-built_in\">window</span> !== <span class=\"code-string\">'undefined'</span> &amp;&amp; <span class=\"code-keyword\">typeof</span> <span class=\"code-built_in\">document</span> !== <span class=\"code-string\">'undefined'</span>;\n","  <span class=\"code-keyword\">var</span> isIE11 = isBrowser ? <span class=\"code-comment\">// @ts-ignore</span>\n","  !!<span class=\"code-built_in\">window</span>.msCrypto : <span class=\"code-literal\">false</span>;\n","\n","  <span class=\"code-keyword\">var</span> ROUND_ARROW = <span class=\"code-string\">'&lt;svg width=\"16\" height=\"6\" xmlns=\"http://www.w3.org/2000/svg\"&gt;&lt;path d=\"M0 6s1.796-.013 4.67-3.615C5.851.9 6.93.006 8 0c1.07-.006 2.148.887 3.343 2.385C14.233 6.005 16 6 16 6H0z\"&gt;&lt;/svg&gt;'</span>;\n","  <span class=\"code-keyword\">var</span> BOX_CLASS = <span class=\"code-string\">\"tippy-box\"</span>;\n","  <span class=\"code-keyword\">var</span> CONTENT_CLASS = <span class=\"code-string\">\"tippy-content\"</span>;\n","  <span class=\"code-keyword\">var</span> BACKDROP_CLASS = <span class=\"code-string\">\"tippy-backdrop\"</span>;\n","  <span class=\"code-keyword\">var</span> ARROW_CLASS = <span class=\"code-string\">\"tippy-arrow\"</span>;\n","  <span class=\"code-keyword\">var</span> SVG_ARROW_CLASS = <span class=\"code-string\">\"tippy-svg-arrow\"</span>;\n","  <span class=\"code-keyword\">var</span> TOUCH_OPTIONS = {\n","    passive: <span class=\"code-literal\">true</span>,\n","    capture: <span class=\"code-literal\">true</span>\n","  };\n","  <span class=\"code-keyword\">var</span> TIPPY_DEFAULT_APPEND_TO = <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">TIPPY_DEFAULT_APPEND_TO</span>(<span class=\"code-params\"></span>) </span>{\n","    <span class=\"code-keyword\">return</span> <span class=\"code-built_in\">document</span>.body;\n","  };\n","\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">hasOwnProperty</span>(<span class=\"code-params\">obj, key</span>) </span>{\n","    <span class=\"code-keyword\">return</span> {}.hasOwnProperty.call(obj, key);\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getValueAtIndexOrReturn</span>(<span class=\"code-params\">value, index, defaultValue</span>) </span>{\n","    <span class=\"code-keyword\">if</span> (<span class=\"code-built_in\">Array</span>.isArray(value)) {\n","      <span class=\"code-keyword\">var</span> v = value[index];\n","      <span class=\"code-keyword\">return</span> v == <span class=\"code-literal\">null</span> ? <span class=\"code-built_in\">Array</span>.isArray(defaultValue) ? defaultValue[index] : defaultValue : v;\n","    }\n","\n","    <span class=\"code-keyword\">return</span> value;\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">isType</span>(<span class=\"code-params\">value, type</span>) </span>{\n","    <span class=\"code-keyword\">var</span> str = {}.toString.call(value);\n","    <span class=\"code-keyword\">return</span> str.indexOf(<span class=\"code-string\">'[object'</span>) === <span class=\"code-number\">0</span> &amp;&amp; str.indexOf(type + <span class=\"code-string\">\"]\"</span>) &gt; <span class=\"code-number\">-1</span>;\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">invokeWithArgsOrReturn</span>(<span class=\"code-params\">value, args</span>) </span>{\n","    <span class=\"code-keyword\">return</span> <span class=\"code-keyword\">typeof</span> value === <span class=\"code-string\">'function'</span> ? value.apply(<span class=\"code-keyword\">void</span> <span class=\"code-number\">0</span>, args) : value;\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">debounce</span>(<span class=\"code-params\">fn, ms</span>) </span>{\n","    <span class=\"code-comment\">// Avoid wrapping in `setTimeout` if ms is 0 anyway</span>\n","    <span class=\"code-keyword\">if</span> (ms === <span class=\"code-number\">0</span>) {\n","      <span class=\"code-keyword\">return</span> fn;\n","    }\n","\n","    <span class=\"code-keyword\">var</span> timeout;\n","    <span class=\"code-keyword\">return</span> <span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">arg</span>) </span>{\n","      clearTimeout(timeout);\n","      timeout = setTimeout(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\"></span>) </span>{\n","        fn(arg);\n","      }, ms);\n","    };\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">removeProperties</span>(<span class=\"code-params\">obj, keys</span>) </span>{\n","    <span class=\"code-keyword\">var</span> clone = <span class=\"code-built_in\">Object</span>.assign({}, obj);\n","    keys.forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">key</span>) </span>{\n","      <span class=\"code-keyword\">delete</span> clone[key];\n","    });\n","    <span class=\"code-keyword\">return</span> clone;\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">splitBySpaces</span>(<span class=\"code-params\">value</span>) </span>{\n","    <span class=\"code-keyword\">return</span> value.split(<span class=\"code-regexp\">/\\s+/</span>).filter(<span class=\"code-built_in\">Boolean</span>);\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">normalizeToArray</span>(<span class=\"code-params\">value</span>) </span>{\n","    <span class=\"code-keyword\">return</span> [].concat(value);\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">pushIfUnique</span>(<span class=\"code-params\">arr, value</span>) </span>{\n","    <span class=\"code-keyword\">if</span> (arr.indexOf(value) === <span class=\"code-number\">-1</span>) {\n","      arr.push(value);\n","    }\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">unique</span>(<span class=\"code-params\">arr</span>) </span>{\n","    <span class=\"code-keyword\">return</span> arr.filter(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">item, index</span>) </span>{\n","      <span class=\"code-keyword\">return</span> arr.indexOf(item) === index;\n","    });\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getBasePlacement</span>(<span class=\"code-params\">placement</span>) </span>{\n","    <span class=\"code-keyword\">return</span> placement.split(<span class=\"code-string\">'-'</span>)[<span class=\"code-number\">0</span>];\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">arrayFrom</span>(<span class=\"code-params\">value</span>) </span>{\n","    <span class=\"code-keyword\">return</span> [].slice.call(value);\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">removeUndefinedProps</span>(<span class=\"code-params\">obj</span>) </span>{\n","    <span class=\"code-keyword\">return</span> <span class=\"code-built_in\">Object</span>.keys(obj).reduce(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">acc, key</span>) </span>{\n","      <span class=\"code-keyword\">if</span> (obj[key] !== <span class=\"code-literal\">undefined</span>) {\n","        acc[key] = obj[key];\n","      }\n","\n","      <span class=\"code-keyword\">return</span> acc;\n","    }, {});\n","  }\n","\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">div</span>(<span class=\"code-params\"></span>) </span>{\n","    <span class=\"code-keyword\">return</span> <span class=\"code-built_in\">document</span>.createElement(<span class=\"code-string\">'div'</span>);\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">isElement</span>(<span class=\"code-params\">value</span>) </span>{\n","    <span class=\"code-keyword\">return</span> [<span class=\"code-string\">'Element'</span>, <span class=\"code-string\">'Fragment'</span>].some(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">type</span>) </span>{\n","      <span class=\"code-keyword\">return</span> isType(value, type);\n","    });\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">isNodeList</span>(<span class=\"code-params\">value</span>) </span>{\n","    <span class=\"code-keyword\">return</span> isType(value, <span class=\"code-string\">'NodeList'</span>);\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">isMouseEvent</span>(<span class=\"code-params\">value</span>) </span>{\n","    <span class=\"code-keyword\">return</span> isType(value, <span class=\"code-string\">'MouseEvent'</span>);\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">isReferenceElement</span>(<span class=\"code-params\">value</span>) </span>{\n","    <span class=\"code-keyword\">return</span> !!(value &amp;&amp; value._tippy &amp;&amp; value._tippy.reference === value);\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getArrayOfElements</span>(<span class=\"code-params\">value</span>) </span>{\n","    <span class=\"code-keyword\">if</span> (isElement(value)) {\n","      <span class=\"code-keyword\">return</span> [value];\n","    }\n","\n","    <span class=\"code-keyword\">if</span> (isNodeList(value)) {\n","      <span class=\"code-keyword\">return</span> arrayFrom(value);\n","    }\n","\n","    <span class=\"code-keyword\">if</span> (<span class=\"code-built_in\">Array</span>.isArray(value)) {\n","      <span class=\"code-keyword\">return</span> value;\n","    }\n","\n","    <span class=\"code-keyword\">return</span> arrayFrom(<span class=\"code-built_in\">document</span>.querySelectorAll(value));\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">setTransitionDuration</span>(<span class=\"code-params\">els, value</span>) </span>{\n","    els.forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">el</span>) </span>{\n","      <span class=\"code-keyword\">if</span> (el) {\n","        el.style.transitionDuration = value + <span class=\"code-string\">\"ms\"</span>;\n","      }\n","    });\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">setVisibilityState</span>(<span class=\"code-params\">els, state</span>) </span>{\n","    els.forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">el</span>) </span>{\n","      <span class=\"code-keyword\">if</span> (el) {\n","        el.setAttribute(<span class=\"code-string\">'data-state'</span>, state);\n","      }\n","    });\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getOwnerDocument</span>(<span class=\"code-params\">elementOrElements</span>) </span>{\n","    <span class=\"code-keyword\">var</span> _element$ownerDocumen;\n","\n","    <span class=\"code-keyword\">var</span> _normalizeToArray = normalizeToArray(elementOrElements),\n","        element = _normalizeToArray[<span class=\"code-number\">0</span>]; <span class=\"code-comment\">// Elements created via a &lt;template&gt; have an ownerDocument with no reference to the body</span>\n","\n","\n","    <span class=\"code-keyword\">return</span> element != <span class=\"code-literal\">null</span> &amp;&amp; (_element$ownerDocumen = element.ownerDocument) != <span class=\"code-literal\">null</span> &amp;&amp; _element$ownerDocumen.body ? element.ownerDocument : <span class=\"code-built_in\">document</span>;\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">isCursorOutsideInteractiveBorder</span>(<span class=\"code-params\">popperTreeData, event</span>) </span>{\n","    <span class=\"code-keyword\">var</span> clientX = event.clientX,\n","        clientY = event.clientY;\n","    <span class=\"code-keyword\">return</span> popperTreeData.every(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">_ref</span>) </span>{\n","      <span class=\"code-keyword\">var</span> popperRect = _ref.popperRect,\n","          popperState = _ref.popperState,\n","          props = _ref.props;\n","      <span class=\"code-keyword\">var</span> interactiveBorder = props.interactiveBorder;\n","      <span class=\"code-keyword\">var</span> basePlacement = getBasePlacement(popperState.placement);\n","      <span class=\"code-keyword\">var</span> offsetData = popperState.modifiersData.offset;\n","\n","      <span class=\"code-keyword\">if</span> (!offsetData) {\n","        <span class=\"code-keyword\">return</span> <span class=\"code-literal\">true</span>;\n","      }\n","\n","      <span class=\"code-keyword\">var</span> topDistance = basePlacement === <span class=\"code-string\">'bottom'</span> ? offsetData.top.y : <span class=\"code-number\">0</span>;\n","      <span class=\"code-keyword\">var</span> bottomDistance = basePlacement === <span class=\"code-string\">'top'</span> ? offsetData.bottom.y : <span class=\"code-number\">0</span>;\n","      <span class=\"code-keyword\">var</span> leftDistance = basePlacement === <span class=\"code-string\">'right'</span> ? offsetData.left.x : <span class=\"code-number\">0</span>;\n","      <span class=\"code-keyword\">var</span> rightDistance = basePlacement === <span class=\"code-string\">'left'</span> ? offsetData.right.x : <span class=\"code-number\">0</span>;\n","      <span class=\"code-keyword\">var</span> exceedsTop = popperRect.top - clientY + topDistance &gt; interactiveBorder;\n","      <span class=\"code-keyword\">var</span> exceedsBottom = clientY - popperRect.bottom - bottomDistance &gt; interactiveBorder;\n","      <span class=\"code-keyword\">var</span> exceedsLeft = popperRect.left - clientX + leftDistance &gt; interactiveBorder;\n","      <span class=\"code-keyword\">var</span> exceedsRight = clientX - popperRect.right - rightDistance &gt; interactiveBorder;\n","      <span class=\"code-keyword\">return</span> exceedsTop || exceedsBottom || exceedsLeft || exceedsRight;\n","    });\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">updateTransitionEndListener</span>(<span class=\"code-params\">box, action, listener</span>) </span>{\n","    <span class=\"code-keyword\">var</span> method = action + <span class=\"code-string\">\"EventListener\"</span>; <span class=\"code-comment\">// some browsers apparently support `transition` (unprefixed) but only fire</span>\n","    <span class=\"code-comment\">// `webkitTransitionEnd`...</span>\n","\n","    [<span class=\"code-string\">'transitionend'</span>, <span class=\"code-string\">'webkitTransitionEnd'</span>].forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">event</span>) </span>{\n","      box[method](event, listener);\n","    });\n","  }\n","  <span class=\"code-comment\">/**\n</span>","<span class=\"code-comment\">   * Compared to xxx.contains, this function works for dom structures with shadow\n</span>","<span class=\"code-comment\">   * dom\n</span>","<span class=\"code-comment\">   */</span>\n","\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">actualContains</span>(<span class=\"code-params\">parent, child</span>) </span>{\n","    <span class=\"code-keyword\">var</span> target = child;\n","\n","    <span class=\"code-keyword\">while</span> (target) {\n","      <span class=\"code-keyword\">var</span> _target$getRootNode;\n","\n","      <span class=\"code-keyword\">if</span> (parent.contains(target)) {\n","        <span class=\"code-keyword\">return</span> <span class=\"code-literal\">true</span>;\n","      }\n","\n","      target = target.getRootNode == <span class=\"code-literal\">null</span> ? <span class=\"code-keyword\">void</span> <span class=\"code-number\">0</span> : (_target$getRootNode = target.getRootNode()) == <span class=\"code-literal\">null</span> ? <span class=\"code-keyword\">void</span> <span class=\"code-number\">0</span> : _target$getRootNode.host;\n","    }\n","\n","    <span class=\"code-keyword\">return</span> <span class=\"code-literal\">false</span>;\n","  }\n","\n","  <span class=\"code-keyword\">var</span> currentInput = {\n","    isTouch: <span class=\"code-literal\">false</span>\n","  };\n","  <span class=\"code-keyword\">var</span> lastMouseMoveTime = <span class=\"code-number\">0</span>;\n","  <span class=\"code-comment\">/**\n</span>","<span class=\"code-comment\">   * When a `touchstart` event is fired, it's assumed the user is using touch\n</span>","<span class=\"code-comment\">   * input. We'll bind a `mousemove` event listener to listen for mouse input in\n</span>","<span class=\"code-comment\">   * the future. This way, the `isTouch` property is fully dynamic and will handle\n</span>","<span class=\"code-comment\">   * hybrid devices that use a mix of touch + mouse input.\n</span>","<span class=\"code-comment\">   */</span>\n","\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onDocumentTouchStart</span>(<span class=\"code-params\"></span>) </span>{\n","    <span class=\"code-keyword\">if</span> (currentInput.isTouch) {\n","      <span class=\"code-keyword\">return</span>;\n","    }\n","\n","    currentInput.isTouch = <span class=\"code-literal\">true</span>;\n","\n","    <span class=\"code-keyword\">if</span> (<span class=\"code-built_in\">window</span>.performance) {\n","      <span class=\"code-built_in\">document</span>.addEventListener(<span class=\"code-string\">'mousemove'</span>, onDocumentMouseMove);\n","    }\n","  }\n","  <span class=\"code-comment\">/**\n</span>","<span class=\"code-comment\">   * When two `mousemove` event are fired consecutively within 20ms, it's assumed\n</span>","<span class=\"code-comment\">   * the user is using mouse input again. `mousemove` can fire on touch devices as\n</span>","<span class=\"code-comment\">   * well, but very rarely that quickly.\n</span>","<span class=\"code-comment\">   */</span>\n","\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onDocumentMouseMove</span>(<span class=\"code-params\"></span>) </span>{\n","    <span class=\"code-keyword\">var</span> now = performance.now();\n","\n","    <span class=\"code-keyword\">if</span> (now - lastMouseMoveTime &lt; <span class=\"code-number\">20</span>) {\n","      currentInput.isTouch = <span class=\"code-literal\">false</span>;\n","      <span class=\"code-built_in\">document</span>.removeEventListener(<span class=\"code-string\">'mousemove'</span>, onDocumentMouseMove);\n","    }\n","\n","    lastMouseMoveTime = now;\n","  }\n","  <span class=\"code-comment\">/**\n</span>","<span class=\"code-comment\">   * When an element is in focus and has a tippy, leaving the tab/window and\n</span>","<span class=\"code-comment\">   * returning causes it to show again. For mouse users this is unexpected, but\n</span>","<span class=\"code-comment\">   * for keyboard use it makes sense.\n</span>","<span class=\"code-comment\">   * <span class=\"code-doctag\">TODO:</span> find a better technique to solve this problem\n</span>","<span class=\"code-comment\">   */</span>\n","\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onWindowBlur</span>(<span class=\"code-params\"></span>) </span>{\n","    <span class=\"code-keyword\">var</span> activeElement = <span class=\"code-built_in\">document</span>.activeElement;\n","\n","    <span class=\"code-keyword\">if</span> (isReferenceElement(activeElement)) {\n","      <span class=\"code-keyword\">var</span> instance = activeElement._tippy;\n","\n","      <span class=\"code-keyword\">if</span> (activeElement.blur &amp;&amp; !instance.state.isVisible) {\n","        activeElement.blur();\n","      }\n","    }\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">bindGlobalEventListeners</span>(<span class=\"code-params\"></span>) </span>{\n","    <span class=\"code-built_in\">document</span>.addEventListener(<span class=\"code-string\">'touchstart'</span>, onDocumentTouchStart, TOUCH_OPTIONS);\n","    <span class=\"code-built_in\">window</span>.addEventListener(<span class=\"code-string\">'blur'</span>, onWindowBlur);\n","  }\n","\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">createMemoryLeakWarning</span>(<span class=\"code-params\">method</span>) </span>{\n","    <span class=\"code-keyword\">var</span> txt = method === <span class=\"code-string\">'destroy'</span> ? <span class=\"code-string\">'n already-'</span> : <span class=\"code-string\">' '</span>;\n","    <span class=\"code-keyword\">return</span> [method + <span class=\"code-string\">\"() was called on a\"</span> + txt + <span class=\"code-string\">\"destroyed instance. This is a no-op but\"</span>, <span class=\"code-string\">'indicates a potential memory leak.'</span>].join(<span class=\"code-string\">' '</span>);\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">clean</span>(<span class=\"code-params\">value</span>) </span>{\n","    <span class=\"code-keyword\">var</span> spacesAndTabs = <span class=\"code-regexp\">/[ \\t]{2,}/g</span>;\n","    <span class=\"code-keyword\">var</span> lineStartWithSpaces = <span class=\"code-regexp\">/^[ \\t]*/gm</span>;\n","    <span class=\"code-keyword\">return</span> value.replace(spacesAndTabs, <span class=\"code-string\">' '</span>).replace(lineStartWithSpaces, <span class=\"code-string\">''</span>).trim();\n","  }\n","\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getDevMessage</span>(<span class=\"code-params\">message</span>) </span>{\n","    <span class=\"code-keyword\">return</span> clean(<span class=\"code-string\">\"\\n  %ctippy.js\\n\\n  %c\"</span> + clean(message) + <span class=\"code-string\">\"\\n\\n  %c\\uD83D\\uDC77\\u200D This is a development-only message. It will be removed in production.\\n  \"</span>);\n","  }\n","\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getFormattedMessage</span>(<span class=\"code-params\">message</span>) </span>{\n","    <span class=\"code-keyword\">return</span> [getDevMessage(message), <span class=\"code-comment\">// title</span>\n","    <span class=\"code-string\">'color: #00C584; font-size: 1.3em; font-weight: bold;'</span>, <span class=\"code-comment\">// message</span>\n","    <span class=\"code-string\">'line-height: 1.5'</span>, <span class=\"code-comment\">// footer</span>\n","    <span class=\"code-string\">'color: #a6a095;'</span>];\n","  } <span class=\"code-comment\">// Assume warnings and errors never have the same message</span>\n","\n","  <span class=\"code-keyword\">var</span> visitedMessages;\n","\n","  {\n","    resetVisitedMessages();\n","  }\n","\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">resetVisitedMessages</span>(<span class=\"code-params\"></span>) </span>{\n","    visitedMessages = <span class=\"code-keyword\">new</span> <span class=\"code-built_in\">Set</span>();\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">warnWhen</span>(<span class=\"code-params\">condition, message</span>) </span>{\n","    <span class=\"code-keyword\">if</span> (condition &amp;&amp; !visitedMessages.has(message)) {\n","      <span class=\"code-keyword\">var</span> _console;\n","\n","      visitedMessages.add(message);\n","\n","      (_console = <span class=\"code-built_in\">console</span>).warn.apply(_console, getFormattedMessage(message));\n","    }\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">errorWhen</span>(<span class=\"code-params\">condition, message</span>) </span>{\n","    <span class=\"code-keyword\">if</span> (condition &amp;&amp; !visitedMessages.has(message)) {\n","      <span class=\"code-keyword\">var</span> _console2;\n","\n","      visitedMessages.add(message);\n","\n","      (_console2 = <span class=\"code-built_in\">console</span>).error.apply(_console2, getFormattedMessage(message));\n","    }\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">validateTargets</span>(<span class=\"code-params\">targets</span>) </span>{\n","    <span class=\"code-keyword\">var</span> didPassFalsyValue = !targets;\n","    <span class=\"code-keyword\">var</span> didPassPlainObject = <span class=\"code-built_in\">Object</span>.prototype.toString.call(targets) === <span class=\"code-string\">'[object Object]'</span> &amp;&amp; !targets.addEventListener;\n","    errorWhen(didPassFalsyValue, [<span class=\"code-string\">'tippy() was passed'</span>, <span class=\"code-string\">'`'</span> + <span class=\"code-built_in\">String</span>(targets) + <span class=\"code-string\">'`'</span>, <span class=\"code-string\">'as its targets (first) argument. Valid types are: String, Element,'</span>, <span class=\"code-string\">'Element[], or NodeList.'</span>].join(<span class=\"code-string\">' '</span>));\n","    errorWhen(didPassPlainObject, [<span class=\"code-string\">'tippy() was passed a plain object which is not supported as an argument'</span>, <span class=\"code-string\">'for virtual positioning. Use props.getReferenceClientRect instead.'</span>].join(<span class=\"code-string\">' '</span>));\n","  }\n","\n","  <span class=\"code-keyword\">var</span> pluginProps = {\n","    animateFill: <span class=\"code-literal\">false</span>,\n","    followCursor: <span class=\"code-literal\">false</span>,\n","    inlinePositioning: <span class=\"code-literal\">false</span>,\n","    sticky: <span class=\"code-literal\">false</span>\n","  };\n","  <span class=\"code-keyword\">var</span> renderProps = {\n","    allowHTML: <span class=\"code-literal\">false</span>,\n","    animation: <span class=\"code-string\">'fade'</span>,\n","    arrow: <span class=\"code-literal\">true</span>,\n","    content: <span class=\"code-string\">''</span>,\n","    inertia: <span class=\"code-literal\">false</span>,\n","    maxWidth: <span class=\"code-number\">350</span>,\n","    role: <span class=\"code-string\">'tooltip'</span>,\n","    theme: <span class=\"code-string\">''</span>,\n","    zIndex: <span class=\"code-number\">9999</span>\n","  };\n","  <span class=\"code-keyword\">var</span> defaultProps = <span class=\"code-built_in\">Object</span>.assign({\n","    appendTo: TIPPY_DEFAULT_APPEND_TO,\n","    aria: {\n","      content: <span class=\"code-string\">'auto'</span>,\n","      expanded: <span class=\"code-string\">'auto'</span>\n","    },\n","    delay: <span class=\"code-number\">0</span>,\n","    duration: [<span class=\"code-number\">300</span>, <span class=\"code-number\">250</span>],\n","    getReferenceClientRect: <span class=\"code-literal\">null</span>,\n","    hideOnClick: <span class=\"code-literal\">true</span>,\n","    ignoreAttributes: <span class=\"code-literal\">false</span>,\n","    interactive: <span class=\"code-literal\">false</span>,\n","    interactiveBorder: <span class=\"code-number\">2</span>,\n","    interactiveDebounce: <span class=\"code-number\">0</span>,\n","    moveTransition: <span class=\"code-string\">''</span>,\n","    offset: [<span class=\"code-number\">0</span>, <span class=\"code-number\">10</span>],\n","    onAfterUpdate: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onAfterUpdate</span>(<span class=\"code-params\"></span>) </span>{},\n","    onBeforeUpdate: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onBeforeUpdate</span>(<span class=\"code-params\"></span>) </span>{},\n","    onCreate: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onCreate</span>(<span class=\"code-params\"></span>) </span>{},\n","    onDestroy: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onDestroy</span>(<span class=\"code-params\"></span>) </span>{},\n","    onHidden: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onHidden</span>(<span class=\"code-params\"></span>) </span>{},\n","    onHide: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onHide</span>(<span class=\"code-params\"></span>) </span>{},\n","    onMount: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onMount</span>(<span class=\"code-params\"></span>) </span>{},\n","    onShow: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onShow</span>(<span class=\"code-params\"></span>) </span>{},\n","    onShown: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onShown</span>(<span class=\"code-params\"></span>) </span>{},\n","    onTrigger: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onTrigger</span>(<span class=\"code-params\"></span>) </span>{},\n","    onUntrigger: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onUntrigger</span>(<span class=\"code-params\"></span>) </span>{},\n","    onClickOutside: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onClickOutside</span>(<span class=\"code-params\"></span>) </span>{},\n","    placement: <span class=\"code-string\">'top'</span>,\n","    plugins: [],\n","    popperOptions: {},\n","    render: <span class=\"code-literal\">null</span>,\n","    showOnCreate: <span class=\"code-literal\">false</span>,\n","    touch: <span class=\"code-literal\">true</span>,\n","    trigger: <span class=\"code-string\">'mouseenter focus'</span>,\n","    triggerTarget: <span class=\"code-literal\">null</span>\n","  }, pluginProps, renderProps);\n","  <span class=\"code-keyword\">var</span> defaultKeys = <span class=\"code-built_in\">Object</span>.keys(defaultProps);\n","  <span class=\"code-keyword\">var</span> setDefaultProps = <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">setDefaultProps</span>(<span class=\"code-params\">partialProps</span>) </span>{\n","    <span class=\"code-comment\">/* istanbul ignore else */</span>\n","    {\n","      validateProps(partialProps, []);\n","    }\n","\n","    <span class=\"code-keyword\">var</span> keys = <span class=\"code-built_in\">Object</span>.keys(partialProps);\n","    keys.forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">key</span>) </span>{\n","      defaultProps[key] = partialProps[key];\n","    });\n","  };\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getExtendedPassedProps</span>(<span class=\"code-params\">passedProps</span>) </span>{\n","    <span class=\"code-keyword\">var</span> plugins = passedProps.plugins || [];\n","    <span class=\"code-keyword\">var</span> pluginProps = plugins.reduce(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">acc, plugin</span>) </span>{\n","      <span class=\"code-keyword\">var</span> name = plugin.name,\n","          defaultValue = plugin.defaultValue;\n","\n","      <span class=\"code-keyword\">if</span> (name) {\n","        <span class=\"code-keyword\">var</span> _name;\n","\n","        acc[name] = passedProps[name] !== <span class=\"code-literal\">undefined</span> ? passedProps[name] : (_name = defaultProps[name]) != <span class=\"code-literal\">null</span> ? _name : defaultValue;\n","      }\n","\n","      <span class=\"code-keyword\">return</span> acc;\n","    }, {});\n","    <span class=\"code-keyword\">return</span> <span class=\"code-built_in\">Object</span>.assign({}, passedProps, pluginProps);\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getDataAttributeProps</span>(<span class=\"code-params\">reference, plugins</span>) </span>{\n","    <span class=\"code-keyword\">var</span> propKeys = plugins ? <span class=\"code-built_in\">Object</span>.keys(getExtendedPassedProps(<span class=\"code-built_in\">Object</span>.assign({}, defaultProps, {\n","      plugins: plugins\n","    }))) : defaultKeys;\n","    <span class=\"code-keyword\">var</span> props = propKeys.reduce(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">acc, key</span>) </span>{\n","      <span class=\"code-keyword\">var</span> valueAsString = (reference.getAttribute(<span class=\"code-string\">\"data-tippy-\"</span> + key) || <span class=\"code-string\">''</span>).trim();\n","\n","      <span class=\"code-keyword\">if</span> (!valueAsString) {\n","        <span class=\"code-keyword\">return</span> acc;\n","      }\n","\n","      <span class=\"code-keyword\">if</span> (key === <span class=\"code-string\">'content'</span>) {\n","        acc[key] = valueAsString;\n","      } <span class=\"code-keyword\">else</span> {\n","        <span class=\"code-keyword\">try</span> {\n","          acc[key] = <span class=\"code-built_in\">JSON</span>.parse(valueAsString);\n","        } <span class=\"code-keyword\">catch</span> (e) {\n","          acc[key] = valueAsString;\n","        }\n","      }\n","\n","      <span class=\"code-keyword\">return</span> acc;\n","    }, {});\n","    <span class=\"code-keyword\">return</span> props;\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">evaluateProps</span>(<span class=\"code-params\">reference, props</span>) </span>{\n","    <span class=\"code-keyword\">var</span> out = <span class=\"code-built_in\">Object</span>.assign({}, props, {\n","      content: invokeWithArgsOrReturn(props.content, [reference])\n","    }, props.ignoreAttributes ? {} : getDataAttributeProps(reference, props.plugins));\n","    out.aria = <span class=\"code-built_in\">Object</span>.assign({}, defaultProps.aria, out.aria);\n","    out.aria = {\n","      expanded: out.aria.expanded === <span class=\"code-string\">'auto'</span> ? props.interactive : out.aria.expanded,\n","      content: out.aria.content === <span class=\"code-string\">'auto'</span> ? props.interactive ? <span class=\"code-literal\">null</span> : <span class=\"code-string\">'describedby'</span> : out.aria.content\n","    };\n","    <span class=\"code-keyword\">return</span> out;\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">validateProps</span>(<span class=\"code-params\">partialProps, plugins</span>) </span>{\n","    <span class=\"code-keyword\">if</span> (partialProps === <span class=\"code-keyword\">void</span> <span class=\"code-number\">0</span>) {\n","      partialProps = {};\n","    }\n","\n","    <span class=\"code-keyword\">if</span> (plugins === <span class=\"code-keyword\">void</span> <span class=\"code-number\">0</span>) {\n","      plugins = [];\n","    }\n","\n","    <span class=\"code-keyword\">var</span> keys = <span class=\"code-built_in\">Object</span>.keys(partialProps);\n","    keys.forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">prop</span>) </span>{\n","      <span class=\"code-keyword\">var</span> nonPluginProps = removeProperties(defaultProps, <span class=\"code-built_in\">Object</span>.keys(pluginProps));\n","      <span class=\"code-keyword\">var</span> didPassUnknownProp = !hasOwnProperty(nonPluginProps, prop); <span class=\"code-comment\">// Check if the prop exists in `plugins`</span>\n","\n","      <span class=\"code-keyword\">if</span> (didPassUnknownProp) {\n","        didPassUnknownProp = plugins.filter(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">plugin</span>) </span>{\n","          <span class=\"code-keyword\">return</span> plugin.name === prop;\n","        }).length === <span class=\"code-number\">0</span>;\n","      }\n","\n","      warnWhen(didPassUnknownProp, [<span class=\"code-string\">\"`\"</span> + prop + <span class=\"code-string\">\"`\"</span>, <span class=\"code-string\">\"is not a valid prop. You may have spelled it incorrectly, or if it's\"</span>, <span class=\"code-string\">'a plugin, forgot to pass it in an array as props.plugins.'</span>, <span class=\"code-string\">'\\n\\n'</span>, <span class=\"code-string\">'All props: https://atomiks.github.io/tippyjs/v6/all-props/\\n'</span>, <span class=\"code-string\">'Plugins: https://atomiks.github.io/tippyjs/v6/plugins/'</span>].join(<span class=\"code-string\">' '</span>));\n","    });\n","  }\n","\n","  <span class=\"code-keyword\">var</span> innerHTML = <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">innerHTML</span>(<span class=\"code-params\"></span>) </span>{\n","    <span class=\"code-keyword\">return</span> <span class=\"code-string\">'innerHTML'</span>;\n","  };\n","\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">dangerouslySetInnerHTML</span>(<span class=\"code-params\">element, html</span>) </span>{\n","    element[innerHTML()] = html;\n","  }\n","\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">createArrowElement</span>(<span class=\"code-params\">value</span>) </span>{\n","    <span class=\"code-keyword\">var</span> arrow = div();\n","\n","    <span class=\"code-keyword\">if</span> (value === <span class=\"code-literal\">true</span>) {\n","      arrow.className = ARROW_CLASS;\n","    } <span class=\"code-keyword\">else</span> {\n","      arrow.className = SVG_ARROW_CLASS;\n","\n","      <span class=\"code-keyword\">if</span> (isElement(value)) {\n","        arrow.appendChild(value);\n","      } <span class=\"code-keyword\">else</span> {\n","        dangerouslySetInnerHTML(arrow, value);\n","      }\n","    }\n","\n","    <span class=\"code-keyword\">return</span> arrow;\n","  }\n","\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">setContent</span>(<span class=\"code-params\">content, props</span>) </span>{\n","    <span class=\"code-keyword\">if</span> (isElement(props.content)) {\n","      dangerouslySetInnerHTML(content, <span class=\"code-string\">''</span>);\n","      content.appendChild(props.content);\n","    } <span class=\"code-keyword\">else</span> <span class=\"code-keyword\">if</span> (<span class=\"code-keyword\">typeof</span> props.content !== <span class=\"code-string\">'function'</span>) {\n","      <span class=\"code-keyword\">if</span> (props.allowHTML) {\n","        dangerouslySetInnerHTML(content, props.content);\n","      } <span class=\"code-keyword\">else</span> {\n","        content.textContent = props.content;\n","      }\n","    }\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getChildren</span>(<span class=\"code-params\">popper</span>) </span>{\n","    <span class=\"code-keyword\">var</span> box = popper.firstElementChild;\n","    <span class=\"code-keyword\">var</span> boxChildren = arrayFrom(box.children);\n","    <span class=\"code-keyword\">return</span> {\n","      box: box,\n","      content: boxChildren.find(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">node</span>) </span>{\n","        <span class=\"code-keyword\">return</span> node.classList.contains(CONTENT_CLASS);\n","      }),\n","      arrow: boxChildren.find(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">node</span>) </span>{\n","        <span class=\"code-keyword\">return</span> node.classList.contains(ARROW_CLASS) || node.classList.contains(SVG_ARROW_CLASS);\n","      }),\n","      backdrop: boxChildren.find(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">node</span>) </span>{\n","        <span class=\"code-keyword\">return</span> node.classList.contains(BACKDROP_CLASS);\n","      })\n","    };\n","  }\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">render</span>(<span class=\"code-params\">instance</span>) </span>{\n","    <span class=\"code-keyword\">var</span> popper = div();\n","    <span class=\"code-keyword\">var</span> box = div();\n","    box.className = BOX_CLASS;\n","    box.setAttribute(<span class=\"code-string\">'data-state'</span>, <span class=\"code-string\">'hidden'</span>);\n","    box.setAttribute(<span class=\"code-string\">'tabindex'</span>, <span class=\"code-string\">'-1'</span>);\n","    <span class=\"code-keyword\">var</span> content = div();\n","    content.className = CONTENT_CLASS;\n","    content.setAttribute(<span class=\"code-string\">'data-state'</span>, <span class=\"code-string\">'hidden'</span>);\n","    setContent(content, instance.props);\n","    popper.appendChild(box);\n","    box.appendChild(content);\n","    onUpdate(instance.props, instance.props);\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onUpdate</span>(<span class=\"code-params\">prevProps, nextProps</span>) </span>{\n","      <span class=\"code-keyword\">var</span> _getChildren = getChildren(popper),\n","          box = _getChildren.box,\n","          content = _getChildren.content,\n","          arrow = _getChildren.arrow;\n","\n","      <span class=\"code-keyword\">if</span> (nextProps.theme) {\n","        box.setAttribute(<span class=\"code-string\">'data-theme'</span>, nextProps.theme);\n","      } <span class=\"code-keyword\">else</span> {\n","        box.removeAttribute(<span class=\"code-string\">'data-theme'</span>);\n","      }\n","\n","      <span class=\"code-keyword\">if</span> (<span class=\"code-keyword\">typeof</span> nextProps.animation === <span class=\"code-string\">'string'</span>) {\n","        box.setAttribute(<span class=\"code-string\">'data-animation'</span>, nextProps.animation);\n","      } <span class=\"code-keyword\">else</span> {\n","        box.removeAttribute(<span class=\"code-string\">'data-animation'</span>);\n","      }\n","\n","      <span class=\"code-keyword\">if</span> (nextProps.inertia) {\n","        box.setAttribute(<span class=\"code-string\">'data-inertia'</span>, <span class=\"code-string\">''</span>);\n","      } <span class=\"code-keyword\">else</span> {\n","        box.removeAttribute(<span class=\"code-string\">'data-inertia'</span>);\n","      }\n","\n","      box.style.maxWidth = <span class=\"code-keyword\">typeof</span> nextProps.maxWidth === <span class=\"code-string\">'number'</span> ? nextProps.maxWidth + <span class=\"code-string\">\"px\"</span> : nextProps.maxWidth;\n","\n","      <span class=\"code-keyword\">if</span> (nextProps.role) {\n","        box.setAttribute(<span class=\"code-string\">'role'</span>, nextProps.role);\n","      } <span class=\"code-keyword\">else</span> {\n","        box.removeAttribute(<span class=\"code-string\">'role'</span>);\n","      }\n","\n","      <span class=\"code-keyword\">if</span> (prevProps.content !== nextProps.content || prevProps.allowHTML !== nextProps.allowHTML) {\n","        setContent(content, instance.props);\n","      }\n","\n","      <span class=\"code-keyword\">if</span> (nextProps.arrow) {\n","        <span class=\"code-keyword\">if</span> (!arrow) {\n","          box.appendChild(createArrowElement(nextProps.arrow));\n","        } <span class=\"code-keyword\">else</span> <span class=\"code-keyword\">if</span> (prevProps.arrow !== nextProps.arrow) {\n","          box.removeChild(arrow);\n","          box.appendChild(createArrowElement(nextProps.arrow));\n","        }\n","      } <span class=\"code-keyword\">else</span> <span class=\"code-keyword\">if</span> (arrow) {\n","        box.removeChild(arrow);\n","      }\n","    }\n","\n","    <span class=\"code-keyword\">return</span> {\n","      popper: popper,\n","      onUpdate: onUpdate\n","    };\n","  } <span class=\"code-comment\">// Runtime check to identify if the render function is the default one; this</span>\n","  <span class=\"code-comment\">// way we can apply default CSS transitions logic and it can be tree-shaken away</span>\n","\n","  render.$$tippy = <span class=\"code-literal\">true</span>;\n","\n","  <span class=\"code-keyword\">var</span> idCounter = <span class=\"code-number\">1</span>;\n","  <span class=\"code-keyword\">var</span> mouseMoveListeners = []; <span class=\"code-comment\">// Used by `hideAll()`</span>\n","\n","  <span class=\"code-keyword\">var</span> mountedInstances = [];\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">createTippy</span>(<span class=\"code-params\">reference, passedProps</span>) </span>{\n","    <span class=\"code-keyword\">var</span> props = evaluateProps(reference, <span class=\"code-built_in\">Object</span>.assign({}, defaultProps, getExtendedPassedProps(removeUndefinedProps(passedProps)))); <span class=\"code-comment\">// ===========================================================================</span>\n","    <span class=\"code-comment\">// \uD83D\uDD12 Private members</span>\n","    <span class=\"code-comment\">// ===========================================================================</span>\n","\n","    <span class=\"code-keyword\">var</span> showTimeout;\n","    <span class=\"code-keyword\">var</span> hideTimeout;\n","    <span class=\"code-keyword\">var</span> scheduleHideAnimationFrame;\n","    <span class=\"code-keyword\">var</span> isVisibleFromClick = <span class=\"code-literal\">false</span>;\n","    <span class=\"code-keyword\">var</span> didHideDueToDocumentMouseDown = <span class=\"code-literal\">false</span>;\n","    <span class=\"code-keyword\">var</span> didTouchMove = <span class=\"code-literal\">false</span>;\n","    <span class=\"code-keyword\">var</span> ignoreOnFirstUpdate = <span class=\"code-literal\">false</span>;\n","    <span class=\"code-keyword\">var</span> lastTriggerEvent;\n","    <span class=\"code-keyword\">var</span> currentTransitionEndListener;\n","    <span class=\"code-keyword\">var</span> onFirstUpdate;\n","    <span class=\"code-keyword\">var</span> listeners = [];\n","    <span class=\"code-keyword\">var</span> debouncedOnMouseMove = debounce(onMouseMove, props.interactiveDebounce);\n","    <span class=\"code-keyword\">var</span> currentTarget; <span class=\"code-comment\">// ===========================================================================</span>\n","    <span class=\"code-comment\">// \uD83D\uDD11 Public members</span>\n","    <span class=\"code-comment\">// ===========================================================================</span>\n","\n","    <span class=\"code-keyword\">var</span> id = idCounter++;\n","    <span class=\"code-keyword\">var</span> popperInstance = <span class=\"code-literal\">null</span>;\n","    <span class=\"code-keyword\">var</span> plugins = unique(props.plugins);\n","    <span class=\"code-keyword\">var</span> state = {\n","      <span class=\"code-comment\">// Is the instance currently enabled?</span>\n","      isEnabled: <span class=\"code-literal\">true</span>,\n","      <span class=\"code-comment\">// Is the tippy currently showing and not transitioning out?</span>\n","      isVisible: <span class=\"code-literal\">false</span>,\n","      <span class=\"code-comment\">// Has the instance been destroyed?</span>\n","      isDestroyed: <span class=\"code-literal\">false</span>,\n","      <span class=\"code-comment\">// Is the tippy currently mounted to the DOM?</span>\n","      isMounted: <span class=\"code-literal\">false</span>,\n","      <span class=\"code-comment\">// Has the tippy finished transitioning in?</span>\n","      isShown: <span class=\"code-literal\">false</span>\n","    };\n","    <span class=\"code-keyword\">var</span> instance = {\n","      <span class=\"code-comment\">// properties</span>\n","      id: id,\n","      reference: reference,\n","      popper: div(),\n","      popperInstance: popperInstance,\n","      props: props,\n","      state: state,\n","      plugins: plugins,\n","      <span class=\"code-comment\">// methods</span>\n","      clearDelayTimeouts: clearDelayTimeouts,\n","      setProps: setProps,\n","      setContent: setContent,\n","      show: show,\n","      hide: hide,\n","      hideWithInteractivity: hideWithInteractivity,\n","      enable: enable,\n","      disable: disable,\n","      unmount: unmount,\n","      destroy: destroy\n","    }; <span class=\"code-comment\">// <span class=\"code-doctag\">TODO:</span> Investigate why this early return causes a TDZ error in the tests \u2014</span>\n","    <span class=\"code-comment\">// it doesn't seem to happen in the browser</span>\n","\n","    <span class=\"code-comment\">/* istanbul ignore if */</span>\n","\n","    <span class=\"code-keyword\">if</span> (!props.render) {\n","      {\n","        errorWhen(<span class=\"code-literal\">true</span>, <span class=\"code-string\">'render() function has not been supplied.'</span>);\n","      }\n","\n","      <span class=\"code-keyword\">return</span> instance;\n","    } <span class=\"code-comment\">// ===========================================================================</span>\n","    <span class=\"code-comment\">// Initial mutations</span>\n","    <span class=\"code-comment\">// ===========================================================================</span>\n","\n","\n","    <span class=\"code-keyword\">var</span> _props$render = props.render(instance),\n","        popper = _props$render.popper,\n","        onUpdate = _props$render.onUpdate;\n","\n","    popper.setAttribute(<span class=\"code-string\">'data-tippy-root'</span>, <span class=\"code-string\">''</span>);\n","    popper.id = <span class=\"code-string\">\"tippy-\"</span> + instance.id;\n","    instance.popper = popper;\n","    reference._tippy = instance;\n","    popper._tippy = instance;\n","    <span class=\"code-keyword\">var</span> pluginsHooks = plugins.map(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">plugin</span>) </span>{\n","      <span class=\"code-keyword\">return</span> plugin.fn(instance);\n","    });\n","    <span class=\"code-keyword\">var</span> hasAriaExpanded = reference.hasAttribute(<span class=\"code-string\">'aria-expanded'</span>);\n","    addListeners();\n","    handleAriaExpandedAttribute();\n","    handleStyles();\n","    invokeHook(<span class=\"code-string\">'onCreate'</span>, [instance]);\n","\n","    <span class=\"code-keyword\">if</span> (props.showOnCreate) {\n","      scheduleShow();\n","    } <span class=\"code-comment\">// Prevent a tippy with a delay from hiding if the cursor left then returned</span>\n","    <span class=\"code-comment\">// before it started hiding</span>\n","\n","\n","    popper.addEventListener(<span class=\"code-string\">'mouseenter'</span>, <span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-keyword\">if</span> (instance.props.interactive &amp;&amp; instance.state.isVisible) {\n","        instance.clearDelayTimeouts();\n","      }\n","    });\n","    popper.addEventListener(<span class=\"code-string\">'mouseleave'</span>, <span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-keyword\">if</span> (instance.props.interactive &amp;&amp; instance.props.trigger.indexOf(<span class=\"code-string\">'mouseenter'</span>) &gt;= <span class=\"code-number\">0</span>) {\n","        getDocument().addEventListener(<span class=\"code-string\">'mousemove'</span>, debouncedOnMouseMove);\n","      }\n","    });\n","    <span class=\"code-keyword\">return</span> instance; <span class=\"code-comment\">// ===========================================================================</span>\n","    <span class=\"code-comment\">// \uD83D\uDD12 Private methods</span>\n","    <span class=\"code-comment\">// ===========================================================================</span>\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getNormalizedTouchSettings</span>(<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-keyword\">var</span> touch = instance.props.touch;\n","      <span class=\"code-keyword\">return</span> <span class=\"code-built_in\">Array</span>.isArray(touch) ? touch : [touch, <span class=\"code-number\">0</span>];\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getIsCustomTouchBehavior</span>(<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-keyword\">return</span> getNormalizedTouchSettings()[<span class=\"code-number\">0</span>] === <span class=\"code-string\">'hold'</span>;\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getIsDefaultRenderFn</span>(<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-keyword\">var</span> _instance$props$rende;\n","\n","      <span class=\"code-comment\">// @ts-ignore</span>\n","      <span class=\"code-keyword\">return</span> !!((_instance$props$rende = instance.props.render) != <span class=\"code-literal\">null</span> &amp;&amp; _instance$props$rende.$$tippy);\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getCurrentTarget</span>(<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-keyword\">return</span> currentTarget || reference;\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getDocument</span>(<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-keyword\">var</span> parent = getCurrentTarget().parentNode;\n","      <span class=\"code-keyword\">return</span> parent ? getOwnerDocument(parent) : <span class=\"code-built_in\">document</span>;\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getDefaultTemplateChildren</span>(<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-keyword\">return</span> getChildren(popper);\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getDelay</span>(<span class=\"code-params\">isShow</span>) </span>{\n","      <span class=\"code-comment\">// For touch or keyboard input, force `0` delay for UX reasons</span>\n","      <span class=\"code-comment\">// Also if the instance is mounted but not visible (transitioning out),</span>\n","      <span class=\"code-comment\">// ignore delay</span>\n","      <span class=\"code-keyword\">if</span> (instance.state.isMounted &amp;&amp; !instance.state.isVisible || currentInput.isTouch || lastTriggerEvent &amp;&amp; lastTriggerEvent.type === <span class=\"code-string\">'focus'</span>) {\n","        <span class=\"code-keyword\">return</span> <span class=\"code-number\">0</span>;\n","      }\n","\n","      <span class=\"code-keyword\">return</span> getValueAtIndexOrReturn(instance.props.delay, isShow ? <span class=\"code-number\">0</span> : <span class=\"code-number\">1</span>, defaultProps.delay);\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">handleStyles</span>(<span class=\"code-params\">fromHide</span>) </span>{\n","      <span class=\"code-keyword\">if</span> (fromHide === <span class=\"code-keyword\">void</span> <span class=\"code-number\">0</span>) {\n","        fromHide = <span class=\"code-literal\">false</span>;\n","      }\n","\n","      popper.style.pointerEvents = instance.props.interactive &amp;&amp; !fromHide ? <span class=\"code-string\">''</span> : <span class=\"code-string\">'none'</span>;\n","      popper.style.zIndex = <span class=\"code-string\">\"\"</span> + instance.props.zIndex;\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">invokeHook</span>(<span class=\"code-params\">hook, args, shouldInvokePropsHook</span>) </span>{\n","      <span class=\"code-keyword\">if</span> (shouldInvokePropsHook === <span class=\"code-keyword\">void</span> <span class=\"code-number\">0</span>) {\n","        shouldInvokePropsHook = <span class=\"code-literal\">true</span>;\n","      }\n","\n","      pluginsHooks.forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">pluginHooks</span>) </span>{\n","        <span class=\"code-keyword\">if</span> (pluginHooks[hook]) {\n","          pluginHooks[hook].apply(pluginHooks, args);\n","        }\n","      });\n","\n","      <span class=\"code-keyword\">if</span> (shouldInvokePropsHook) {\n","        <span class=\"code-keyword\">var</span> _instance$props;\n","\n","        (_instance$props = instance.props)[hook].apply(_instance$props, args);\n","      }\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">handleAriaContentAttribute</span>(<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-keyword\">var</span> aria = instance.props.aria;\n","\n","      <span class=\"code-keyword\">if</span> (!aria.content) {\n","        <span class=\"code-keyword\">return</span>;\n","      }\n","\n","      <span class=\"code-keyword\">var</span> attr = <span class=\"code-string\">\"aria-\"</span> + aria.content;\n","      <span class=\"code-keyword\">var</span> id = popper.id;\n","      <span class=\"code-keyword\">var</span> nodes = normalizeToArray(instance.props.triggerTarget || reference);\n","      nodes.forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">node</span>) </span>{\n","        <span class=\"code-keyword\">var</span> currentValue = node.getAttribute(attr);\n","\n","        <span class=\"code-keyword\">if</span> (instance.state.isVisible) {\n","          node.setAttribute(attr, currentValue ? currentValue + <span class=\"code-string\">\" \"</span> + id : id);\n","        } <span class=\"code-keyword\">else</span> {\n","          <span class=\"code-keyword\">var</span> nextValue = currentValue &amp;&amp; currentValue.replace(id, <span class=\"code-string\">''</span>).trim();\n","\n","          <span class=\"code-keyword\">if</span> (nextValue) {\n","            node.setAttribute(attr, nextValue);\n","          } <span class=\"code-keyword\">else</span> {\n","            node.removeAttribute(attr);\n","          }\n","        }\n","      });\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">handleAriaExpandedAttribute</span>(<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-keyword\">if</span> (hasAriaExpanded || !instance.props.aria.expanded) {\n","        <span class=\"code-keyword\">return</span>;\n","      }\n","\n","      <span class=\"code-keyword\">var</span> nodes = normalizeToArray(instance.props.triggerTarget || reference);\n","      nodes.forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">node</span>) </span>{\n","        <span class=\"code-keyword\">if</span> (instance.props.interactive) {\n","          node.setAttribute(<span class=\"code-string\">'aria-expanded'</span>, instance.state.isVisible &amp;&amp; node === getCurrentTarget() ? <span class=\"code-string\">'true'</span> : <span class=\"code-string\">'false'</span>);\n","        } <span class=\"code-keyword\">else</span> {\n","          node.removeAttribute(<span class=\"code-string\">'aria-expanded'</span>);\n","        }\n","      });\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">cleanupInteractiveMouseListeners</span>(<span class=\"code-params\"></span>) </span>{\n","      getDocument().removeEventListener(<span class=\"code-string\">'mousemove'</span>, debouncedOnMouseMove);\n","      mouseMoveListeners = mouseMoveListeners.filter(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">listener</span>) </span>{\n","        <span class=\"code-keyword\">return</span> listener !== debouncedOnMouseMove;\n","      });\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onDocumentPress</span>(<span class=\"code-params\">event</span>) </span>{\n","      <span class=\"code-comment\">// Moved finger to scroll instead of an intentional tap outside</span>\n","      <span class=\"code-keyword\">if</span> (currentInput.isTouch) {\n","        <span class=\"code-keyword\">if</span> (didTouchMove || event.type === <span class=\"code-string\">'mousedown'</span>) {\n","          <span class=\"code-keyword\">return</span>;\n","        }\n","      }\n","\n","      <span class=\"code-keyword\">var</span> actualTarget = event.composedPath &amp;&amp; event.composedPath()[<span class=\"code-number\">0</span>] || event.target; <span class=\"code-comment\">// Clicked on interactive popper</span>\n","\n","      <span class=\"code-keyword\">if</span> (instance.props.interactive &amp;&amp; actualContains(popper, actualTarget)) {\n","        <span class=\"code-keyword\">return</span>;\n","      } <span class=\"code-comment\">// Clicked on the event listeners target</span>\n","\n","\n","      <span class=\"code-keyword\">if</span> (normalizeToArray(instance.props.triggerTarget || reference).some(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">el</span>) </span>{\n","        <span class=\"code-keyword\">return</span> actualContains(el, actualTarget);\n","      })) {\n","        <span class=\"code-keyword\">if</span> (currentInput.isTouch) {\n","          <span class=\"code-keyword\">return</span>;\n","        }\n","\n","        <span class=\"code-keyword\">if</span> (instance.state.isVisible &amp;&amp; instance.props.trigger.indexOf(<span class=\"code-string\">'click'</span>) &gt;= <span class=\"code-number\">0</span>) {\n","          <span class=\"code-keyword\">return</span>;\n","        }\n","      } <span class=\"code-keyword\">else</span> {\n","        invokeHook(<span class=\"code-string\">'onClickOutside'</span>, [instance, event]);\n","      }\n","\n","      <span class=\"code-keyword\">if</span> (instance.props.hideOnClick === <span class=\"code-literal\">true</span>) {\n","        instance.clearDelayTimeouts();\n","        instance.hide(); <span class=\"code-comment\">// `mousedown` event is fired right before `focus` if pressing the</span>\n","        <span class=\"code-comment\">// currentTarget. This lets a tippy with `focus` trigger know that it</span>\n","        <span class=\"code-comment\">// should not show</span>\n","\n","        didHideDueToDocumentMouseDown = <span class=\"code-literal\">true</span>;\n","        setTimeout(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\"></span>) </span>{\n","          didHideDueToDocumentMouseDown = <span class=\"code-literal\">false</span>;\n","        }); <span class=\"code-comment\">// The listener gets added in `scheduleShow()`, but this may be hiding it</span>\n","        <span class=\"code-comment\">// before it shows, and hide()'s early bail-out behavior can prevent it</span>\n","        <span class=\"code-comment\">// from being cleaned up</span>\n","\n","        <span class=\"code-keyword\">if</span> (!instance.state.isMounted) {\n","          removeDocumentPress();\n","        }\n","      }\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onTouchMove</span>(<span class=\"code-params\"></span>) </span>{\n","      didTouchMove = <span class=\"code-literal\">true</span>;\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onTouchStart</span>(<span class=\"code-params\"></span>) </span>{\n","      didTouchMove = <span class=\"code-literal\">false</span>;\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">addDocumentPress</span>(<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-keyword\">var</span> doc = getDocument();\n","      doc.addEventListener(<span class=\"code-string\">'mousedown'</span>, onDocumentPress, <span class=\"code-literal\">true</span>);\n","      doc.addEventListener(<span class=\"code-string\">'touchend'</span>, onDocumentPress, TOUCH_OPTIONS);\n","      doc.addEventListener(<span class=\"code-string\">'touchstart'</span>, onTouchStart, TOUCH_OPTIONS);\n","      doc.addEventListener(<span class=\"code-string\">'touchmove'</span>, onTouchMove, TOUCH_OPTIONS);\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">removeDocumentPress</span>(<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-keyword\">var</span> doc = getDocument();\n","      doc.removeEventListener(<span class=\"code-string\">'mousedown'</span>, onDocumentPress, <span class=\"code-literal\">true</span>);\n","      doc.removeEventListener(<span class=\"code-string\">'touchend'</span>, onDocumentPress, TOUCH_OPTIONS);\n","      doc.removeEventListener(<span class=\"code-string\">'touchstart'</span>, onTouchStart, TOUCH_OPTIONS);\n","      doc.removeEventListener(<span class=\"code-string\">'touchmove'</span>, onTouchMove, TOUCH_OPTIONS);\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onTransitionedOut</span>(<span class=\"code-params\">duration, callback</span>) </span>{\n","      onTransitionEnd(duration, <span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\"></span>) </span>{\n","        <span class=\"code-keyword\">if</span> (!instance.state.isVisible &amp;&amp; popper.parentNode &amp;&amp; popper.parentNode.contains(popper)) {\n","          callback();\n","        }\n","      });\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onTransitionedIn</span>(<span class=\"code-params\">duration, callback</span>) </span>{\n","      onTransitionEnd(duration, callback);\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onTransitionEnd</span>(<span class=\"code-params\">duration, callback</span>) </span>{\n","      <span class=\"code-keyword\">var</span> box = getDefaultTemplateChildren().box;\n","\n","      <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">listener</span>(<span class=\"code-params\">event</span>) </span>{\n","        <span class=\"code-keyword\">if</span> (event.target === box) {\n","          updateTransitionEndListener(box, <span class=\"code-string\">'remove'</span>, listener);\n","          callback();\n","        }\n","      } <span class=\"code-comment\">// Make callback synchronous if duration is 0</span>\n","      <span class=\"code-comment\">// `transitionend` won't fire otherwise</span>\n","\n","\n","      <span class=\"code-keyword\">if</span> (duration === <span class=\"code-number\">0</span>) {\n","        <span class=\"code-keyword\">return</span> callback();\n","      }\n","\n","      updateTransitionEndListener(box, <span class=\"code-string\">'remove'</span>, currentTransitionEndListener);\n","      updateTransitionEndListener(box, <span class=\"code-string\">'add'</span>, listener);\n","      currentTransitionEndListener = listener;\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">on</span>(<span class=\"code-params\">eventType, handler, options</span>) </span>{\n","      <span class=\"code-keyword\">if</span> (options === <span class=\"code-keyword\">void</span> <span class=\"code-number\">0</span>) {\n","        options = <span class=\"code-literal\">false</span>;\n","      }\n","\n","      <span class=\"code-keyword\">var</span> nodes = normalizeToArray(instance.props.triggerTarget || reference);\n","      nodes.forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">node</span>) </span>{\n","        node.addEventListener(eventType, handler, options);\n","        listeners.push({\n","          node: node,\n","          eventType: eventType,\n","          handler: handler,\n","          options: options\n","        });\n","      });\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">addListeners</span>(<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-keyword\">if</span> (getIsCustomTouchBehavior()) {\n","        on(<span class=\"code-string\">'touchstart'</span>, onTrigger, {\n","          passive: <span class=\"code-literal\">true</span>\n","        });\n","        on(<span class=\"code-string\">'touchend'</span>, onMouseLeave, {\n","          passive: <span class=\"code-literal\">true</span>\n","        });\n","      }\n","\n","      splitBySpaces(instance.props.trigger).forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">eventType</span>) </span>{\n","        <span class=\"code-keyword\">if</span> (eventType === <span class=\"code-string\">'manual'</span>) {\n","          <span class=\"code-keyword\">return</span>;\n","        }\n","\n","        on(eventType, onTrigger);\n","\n","        <span class=\"code-keyword\">switch</span> (eventType) {\n","          <span class=\"code-keyword\">case</span> <span class=\"code-string\">'mouseenter'</span>:\n","            on(<span class=\"code-string\">'mouseleave'</span>, onMouseLeave);\n","            <span class=\"code-keyword\">break</span>;\n","\n","          <span class=\"code-keyword\">case</span> <span class=\"code-string\">'focus'</span>:\n","            on(isIE11 ? <span class=\"code-string\">'focusout'</span> : <span class=\"code-string\">'blur'</span>, onBlurOrFocusOut);\n","            <span class=\"code-keyword\">break</span>;\n","\n","          <span class=\"code-keyword\">case</span> <span class=\"code-string\">'focusin'</span>:\n","            on(<span class=\"code-string\">'focusout'</span>, onBlurOrFocusOut);\n","            <span class=\"code-keyword\">break</span>;\n","        }\n","      });\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">removeListeners</span>(<span class=\"code-params\"></span>) </span>{\n","      listeners.forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">_ref</span>) </span>{\n","        <span class=\"code-keyword\">var</span> node = _ref.node,\n","            eventType = _ref.eventType,\n","            handler = _ref.handler,\n","            options = _ref.options;\n","        node.removeEventListener(eventType, handler, options);\n","      });\n","      listeners = [];\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onTrigger</span>(<span class=\"code-params\">event</span>) </span>{\n","      <span class=\"code-keyword\">var</span> _lastTriggerEvent;\n","\n","      <span class=\"code-keyword\">var</span> shouldScheduleClickHide = <span class=\"code-literal\">false</span>;\n","\n","      <span class=\"code-keyword\">if</span> (!instance.state.isEnabled || isEventListenerStopped(event) || didHideDueToDocumentMouseDown) {\n","        <span class=\"code-keyword\">return</span>;\n","      }\n","\n","      <span class=\"code-keyword\">var</span> wasFocused = ((_lastTriggerEvent = lastTriggerEvent) == <span class=\"code-literal\">null</span> ? <span class=\"code-keyword\">void</span> <span class=\"code-number\">0</span> : _lastTriggerEvent.type) === <span class=\"code-string\">'focus'</span>;\n","      lastTriggerEvent = event;\n","      currentTarget = event.currentTarget;\n","      handleAriaExpandedAttribute();\n","\n","      <span class=\"code-keyword\">if</span> (!instance.state.isVisible &amp;&amp; isMouseEvent(event)) {\n","        <span class=\"code-comment\">// If scrolling, `mouseenter` events can be fired if the cursor lands</span>\n","        <span class=\"code-comment\">// over a new target, but `mousemove` events don't get fired. This</span>\n","        <span class=\"code-comment\">// causes interactive tooltips to get stuck open until the cursor is</span>\n","        <span class=\"code-comment\">// moved</span>\n","        mouseMoveListeners.forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">listener</span>) </span>{\n","          <span class=\"code-keyword\">return</span> listener(event);\n","        });\n","      } <span class=\"code-comment\">// Toggle show/hide when clicking click-triggered tooltips</span>\n","\n","\n","      <span class=\"code-keyword\">if</span> (event.type === <span class=\"code-string\">'click'</span> &amp;&amp; (instance.props.trigger.indexOf(<span class=\"code-string\">'mouseenter'</span>) &lt; <span class=\"code-number\">0</span> || isVisibleFromClick) &amp;&amp; instance.props.hideOnClick !== <span class=\"code-literal\">false</span> &amp;&amp; instance.state.isVisible) {\n","        shouldScheduleClickHide = <span class=\"code-literal\">true</span>;\n","      } <span class=\"code-keyword\">else</span> {\n","        scheduleShow(event);\n","      }\n","\n","      <span class=\"code-keyword\">if</span> (event.type === <span class=\"code-string\">'click'</span>) {\n","        isVisibleFromClick = !shouldScheduleClickHide;\n","      }\n","\n","      <span class=\"code-keyword\">if</span> (shouldScheduleClickHide &amp;&amp; !wasFocused) {\n","        scheduleHide(event);\n","      }\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onMouseMove</span>(<span class=\"code-params\">event</span>) </span>{\n","      <span class=\"code-keyword\">var</span> target = event.target;\n","      <span class=\"code-keyword\">var</span> isCursorOverReferenceOrPopper = getCurrentTarget().contains(target) || popper.contains(target);\n","\n","      <span class=\"code-keyword\">if</span> (event.type === <span class=\"code-string\">'mousemove'</span> &amp;&amp; isCursorOverReferenceOrPopper) {\n","        <span class=\"code-keyword\">return</span>;\n","      }\n","\n","      <span class=\"code-keyword\">var</span> popperTreeData = getNestedPopperTree().concat(popper).map(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">popper</span>) </span>{\n","        <span class=\"code-keyword\">var</span> _instance$popperInsta;\n","\n","        <span class=\"code-keyword\">var</span> instance = popper._tippy;\n","        <span class=\"code-keyword\">var</span> state = (_instance$popperInsta = instance.popperInstance) == <span class=\"code-literal\">null</span> ? <span class=\"code-keyword\">void</span> <span class=\"code-number\">0</span> : _instance$popperInsta.state;\n","\n","        <span class=\"code-keyword\">if</span> (state) {\n","          <span class=\"code-keyword\">return</span> {\n","            popperRect: popper.getBoundingClientRect(),\n","            popperState: state,\n","            props: props\n","          };\n","        }\n","\n","        <span class=\"code-keyword\">return</span> <span class=\"code-literal\">null</span>;\n","      }).filter(<span class=\"code-built_in\">Boolean</span>);\n","\n","      <span class=\"code-keyword\">if</span> (isCursorOutsideInteractiveBorder(popperTreeData, event)) {\n","        cleanupInteractiveMouseListeners();\n","        scheduleHide(event);\n","      }\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onMouseLeave</span>(<span class=\"code-params\">event</span>) </span>{\n","      <span class=\"code-keyword\">var</span> shouldBail = isEventListenerStopped(event) || instance.props.trigger.indexOf(<span class=\"code-string\">'click'</span>) &gt;= <span class=\"code-number\">0</span> &amp;&amp; isVisibleFromClick;\n","\n","      <span class=\"code-keyword\">if</span> (shouldBail) {\n","        <span class=\"code-keyword\">return</span>;\n","      }\n","\n","      <span class=\"code-keyword\">if</span> (instance.props.interactive) {\n","        instance.hideWithInteractivity(event);\n","        <span class=\"code-keyword\">return</span>;\n","      }\n","\n","      scheduleHide(event);\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onBlurOrFocusOut</span>(<span class=\"code-params\">event</span>) </span>{\n","      <span class=\"code-keyword\">if</span> (instance.props.trigger.indexOf(<span class=\"code-string\">'focusin'</span>) &lt; <span class=\"code-number\">0</span> &amp;&amp; event.target !== getCurrentTarget()) {\n","        <span class=\"code-keyword\">return</span>;\n","      } <span class=\"code-comment\">// If focus was moved to within the popper</span>\n","\n","\n","      <span class=\"code-keyword\">if</span> (instance.props.interactive &amp;&amp; event.relatedTarget &amp;&amp; popper.contains(event.relatedTarget)) {\n","        <span class=\"code-keyword\">return</span>;\n","      }\n","\n","      scheduleHide(event);\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">isEventListenerStopped</span>(<span class=\"code-params\">event</span>) </span>{\n","      <span class=\"code-keyword\">return</span> currentInput.isTouch ? getIsCustomTouchBehavior() !== event.type.indexOf(<span class=\"code-string\">'touch'</span>) &gt;= <span class=\"code-number\">0</span> : <span class=\"code-literal\">false</span>;\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">createPopperInstance</span>(<span class=\"code-params\"></span>) </span>{\n","      destroyPopperInstance();\n","      <span class=\"code-keyword\">var</span> _instance$props2 = instance.props,\n","          popperOptions = _instance$props2.popperOptions,\n","          placement = _instance$props2.placement,\n","          offset = _instance$props2.offset,\n","          getReferenceClientRect = _instance$props2.getReferenceClientRect,\n","          moveTransition = _instance$props2.moveTransition;\n","      <span class=\"code-keyword\">var</span> arrow = getIsDefaultRenderFn() ? getChildren(popper).arrow : <span class=\"code-literal\">null</span>;\n","      <span class=\"code-keyword\">var</span> computedReference = getReferenceClientRect ? {\n","        getBoundingClientRect: getReferenceClientRect,\n","        contextElement: getReferenceClientRect.contextElement || getCurrentTarget()\n","      } : reference;\n","      <span class=\"code-keyword\">var</span> tippyModifier = {\n","        name: <span class=\"code-string\">'$$tippy'</span>,\n","        enabled: <span class=\"code-literal\">true</span>,\n","        phase: <span class=\"code-string\">'beforeWrite'</span>,\n","        requires: [<span class=\"code-string\">'computeStyles'</span>],\n","        fn: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">fn</span>(<span class=\"code-params\">_ref2</span>) </span>{\n","          <span class=\"code-keyword\">var</span> state = _ref2.state;\n","\n","          <span class=\"code-keyword\">if</span> (getIsDefaultRenderFn()) {\n","            <span class=\"code-keyword\">var</span> _getDefaultTemplateCh = getDefaultTemplateChildren(),\n","                box = _getDefaultTemplateCh.box;\n","\n","            [<span class=\"code-string\">'placement'</span>, <span class=\"code-string\">'reference-hidden'</span>, <span class=\"code-string\">'escaped'</span>].forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">attr</span>) </span>{\n","              <span class=\"code-keyword\">if</span> (attr === <span class=\"code-string\">'placement'</span>) {\n","                box.setAttribute(<span class=\"code-string\">'data-placement'</span>, state.placement);\n","              } <span class=\"code-keyword\">else</span> {\n","                <span class=\"code-keyword\">if</span> (state.attributes.popper[<span class=\"code-string\">\"data-popper-\"</span> + attr]) {\n","                  box.setAttribute(<span class=\"code-string\">\"data-\"</span> + attr, <span class=\"code-string\">''</span>);\n","                } <span class=\"code-keyword\">else</span> {\n","                  box.removeAttribute(<span class=\"code-string\">\"data-\"</span> + attr);\n","                }\n","              }\n","            });\n","            state.attributes.popper = {};\n","          }\n","        }\n","      };\n","      <span class=\"code-keyword\">var</span> modifiers = [{\n","        name: <span class=\"code-string\">'offset'</span>,\n","        options: {\n","          offset: offset\n","        }\n","      }, {\n","        name: <span class=\"code-string\">'preventOverflow'</span>,\n","        options: {\n","          padding: {\n","            top: <span class=\"code-number\">2</span>,\n","            bottom: <span class=\"code-number\">2</span>,\n","            left: <span class=\"code-number\">5</span>,\n","            right: <span class=\"code-number\">5</span>\n","          }\n","        }\n","      }, {\n","        name: <span class=\"code-string\">'flip'</span>,\n","        options: {\n","          padding: <span class=\"code-number\">5</span>\n","        }\n","      }, {\n","        name: <span class=\"code-string\">'computeStyles'</span>,\n","        options: {\n","          adaptive: !moveTransition\n","        }\n","      }, tippyModifier];\n","\n","      <span class=\"code-keyword\">if</span> (getIsDefaultRenderFn() &amp;&amp; arrow) {\n","        modifiers.push({\n","          name: <span class=\"code-string\">'arrow'</span>,\n","          options: {\n","            element: arrow,\n","            padding: <span class=\"code-number\">3</span>\n","          }\n","        });\n","      }\n","\n","      modifiers.push.apply(modifiers, (popperOptions == <span class=\"code-literal\">null</span> ? <span class=\"code-keyword\">void</span> <span class=\"code-number\">0</span> : popperOptions.modifiers) || []);\n","      instance.popperInstance = core.createPopper(computedReference, popper, <span class=\"code-built_in\">Object</span>.assign({}, popperOptions, {\n","        placement: placement,\n","        onFirstUpdate: onFirstUpdate,\n","        modifiers: modifiers\n","      }));\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">destroyPopperInstance</span>(<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-keyword\">if</span> (instance.popperInstance) {\n","        instance.popperInstance.destroy();\n","        instance.popperInstance = <span class=\"code-literal\">null</span>;\n","      }\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">mount</span>(<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-keyword\">var</span> appendTo = instance.props.appendTo;\n","      <span class=\"code-keyword\">var</span> parentNode; <span class=\"code-comment\">// By default, we'll append the popper to the triggerTargets's parentNode so</span>\n","      <span class=\"code-comment\">// it's directly after the reference element so the elements inside the</span>\n","      <span class=\"code-comment\">// tippy can be tabbed to</span>\n","      <span class=\"code-comment\">// If there are clipping issues, the user can specify a different appendTo</span>\n","      <span class=\"code-comment\">// and ensure focus management is handled correctly manually</span>\n","\n","      <span class=\"code-keyword\">var</span> node = getCurrentTarget();\n","\n","      <span class=\"code-keyword\">if</span> (instance.props.interactive &amp;&amp; appendTo === TIPPY_DEFAULT_APPEND_TO || appendTo === <span class=\"code-string\">'parent'</span>) {\n","        parentNode = node.parentNode;\n","      } <span class=\"code-keyword\">else</span> {\n","        parentNode = invokeWithArgsOrReturn(appendTo, [node]);\n","      } <span class=\"code-comment\">// The popper element needs to exist on the DOM before its position can be</span>\n","      <span class=\"code-comment\">// updated as Popper needs to read its dimensions</span>\n","\n","\n","      <span class=\"code-keyword\">if</span> (!parentNode.contains(popper)) {\n","        parentNode.appendChild(popper);\n","      }\n","\n","      instance.state.isMounted = <span class=\"code-literal\">true</span>;\n","      createPopperInstance();\n","      <span class=\"code-comment\">/* istanbul ignore else */</span>\n","\n","      {\n","        <span class=\"code-comment\">// Accessibility check</span>\n","        warnWhen(instance.props.interactive &amp;&amp; appendTo === defaultProps.appendTo &amp;&amp; node.nextElementSibling !== popper, [<span class=\"code-string\">'Interactive tippy element may not be accessible via keyboard'</span>, <span class=\"code-string\">'navigation because it is not directly after the reference element'</span>, <span class=\"code-string\">'in the DOM source order.'</span>, <span class=\"code-string\">'\\n\\n'</span>, <span class=\"code-string\">'Using a wrapper &lt;div&gt; or &lt;span&gt; tag around the reference element'</span>, <span class=\"code-string\">'solves this by creating a new parentNode context.'</span>, <span class=\"code-string\">'\\n\\n'</span>, <span class=\"code-string\">'Specifying `appendTo: document.body` silences this warning, but it'</span>, <span class=\"code-string\">'assumes you are using a focus management solution to handle'</span>, <span class=\"code-string\">'keyboard navigation.'</span>, <span class=\"code-string\">'\\n\\n'</span>, <span class=\"code-string\">'See: https://atomiks.github.io/tippyjs/v6/accessibility/#interactivity'</span>].join(<span class=\"code-string\">' '</span>));\n","      }\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getNestedPopperTree</span>(<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-keyword\">return</span> arrayFrom(popper.querySelectorAll(<span class=\"code-string\">'[data-tippy-root]'</span>));\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">scheduleShow</span>(<span class=\"code-params\">event</span>) </span>{\n","      instance.clearDelayTimeouts();\n","\n","      <span class=\"code-keyword\">if</span> (event) {\n","        invokeHook(<span class=\"code-string\">'onTrigger'</span>, [instance, event]);\n","      }\n","\n","      addDocumentPress();\n","      <span class=\"code-keyword\">var</span> delay = getDelay(<span class=\"code-literal\">true</span>);\n","\n","      <span class=\"code-keyword\">var</span> _getNormalizedTouchSe = getNormalizedTouchSettings(),\n","          touchValue = _getNormalizedTouchSe[<span class=\"code-number\">0</span>],\n","          touchDelay = _getNormalizedTouchSe[<span class=\"code-number\">1</span>];\n","\n","      <span class=\"code-keyword\">if</span> (currentInput.isTouch &amp;&amp; touchValue === <span class=\"code-string\">'hold'</span> &amp;&amp; touchDelay) {\n","        delay = touchDelay;\n","      }\n","\n","      <span class=\"code-keyword\">if</span> (delay) {\n","        showTimeout = setTimeout(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\"></span>) </span>{\n","          instance.show();\n","        }, delay);\n","      } <span class=\"code-keyword\">else</span> {\n","        instance.show();\n","      }\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">scheduleHide</span>(<span class=\"code-params\">event</span>) </span>{\n","      instance.clearDelayTimeouts();\n","      invokeHook(<span class=\"code-string\">'onUntrigger'</span>, [instance, event]);\n","\n","      <span class=\"code-keyword\">if</span> (!instance.state.isVisible) {\n","        removeDocumentPress();\n","        <span class=\"code-keyword\">return</span>;\n","      } <span class=\"code-comment\">// For interactive tippies, scheduleHide is added to a document.body handler</span>\n","      <span class=\"code-comment\">// from onMouseLeave so must intercept scheduled hides from mousemove/leave</span>\n","      <span class=\"code-comment\">// events when trigger contains mouseenter and click, and the tip is</span>\n","      <span class=\"code-comment\">// currently shown as a result of a click.</span>\n","\n","\n","      <span class=\"code-keyword\">if</span> (instance.props.trigger.indexOf(<span class=\"code-string\">'mouseenter'</span>) &gt;= <span class=\"code-number\">0</span> &amp;&amp; instance.props.trigger.indexOf(<span class=\"code-string\">'click'</span>) &gt;= <span class=\"code-number\">0</span> &amp;&amp; [<span class=\"code-string\">'mouseleave'</span>, <span class=\"code-string\">'mousemove'</span>].indexOf(event.type) &gt;= <span class=\"code-number\">0</span> &amp;&amp; isVisibleFromClick) {\n","        <span class=\"code-keyword\">return</span>;\n","      }\n","\n","      <span class=\"code-keyword\">var</span> delay = getDelay(<span class=\"code-literal\">false</span>);\n","\n","      <span class=\"code-keyword\">if</span> (delay) {\n","        hideTimeout = setTimeout(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\"></span>) </span>{\n","          <span class=\"code-keyword\">if</span> (instance.state.isVisible) {\n","            instance.hide();\n","          }\n","        }, delay);\n","      } <span class=\"code-keyword\">else</span> {\n","        <span class=\"code-comment\">// Fixes a `transitionend` problem when it fires 1 frame too</span>\n","        <span class=\"code-comment\">// late sometimes, we don't want hide() to be called.</span>\n","        scheduleHideAnimationFrame = requestAnimationFrame(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\"></span>) </span>{\n","          instance.hide();\n","        });\n","      }\n","    } <span class=\"code-comment\">// ===========================================================================</span>\n","    <span class=\"code-comment\">// \uD83D\uDD11 Public methods</span>\n","    <span class=\"code-comment\">// ===========================================================================</span>\n","\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">enable</span>(<span class=\"code-params\"></span>) </span>{\n","      instance.state.isEnabled = <span class=\"code-literal\">true</span>;\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">disable</span>(<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-comment\">// Disabling the instance should also hide it</span>\n","      <span class=\"code-comment\">// https://github.com/atomiks/tippy.js-react/issues/106</span>\n","      instance.hide();\n","      instance.state.isEnabled = <span class=\"code-literal\">false</span>;\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">clearDelayTimeouts</span>(<span class=\"code-params\"></span>) </span>{\n","      clearTimeout(showTimeout);\n","      clearTimeout(hideTimeout);\n","      cancelAnimationFrame(scheduleHideAnimationFrame);\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">setProps</span>(<span class=\"code-params\">partialProps</span>) </span>{\n","      <span class=\"code-comment\">/* istanbul ignore else */</span>\n","      {\n","        warnWhen(instance.state.isDestroyed, createMemoryLeakWarning(<span class=\"code-string\">'setProps'</span>));\n","      }\n","\n","      <span class=\"code-keyword\">if</span> (instance.state.isDestroyed) {\n","        <span class=\"code-keyword\">return</span>;\n","      }\n","\n","      invokeHook(<span class=\"code-string\">'onBeforeUpdate'</span>, [instance, partialProps]);\n","      removeListeners();\n","      <span class=\"code-keyword\">var</span> prevProps = instance.props;\n","      <span class=\"code-keyword\">var</span> nextProps = evaluateProps(reference, <span class=\"code-built_in\">Object</span>.assign({}, prevProps, removeUndefinedProps(partialProps), {\n","        ignoreAttributes: <span class=\"code-literal\">true</span>\n","      }));\n","      instance.props = nextProps;\n","      addListeners();\n","\n","      <span class=\"code-keyword\">if</span> (prevProps.interactiveDebounce !== nextProps.interactiveDebounce) {\n","        cleanupInteractiveMouseListeners();\n","        debouncedOnMouseMove = debounce(onMouseMove, nextProps.interactiveDebounce);\n","      } <span class=\"code-comment\">// Ensure stale aria-expanded attributes are removed</span>\n","\n","\n","      <span class=\"code-keyword\">if</span> (prevProps.triggerTarget &amp;&amp; !nextProps.triggerTarget) {\n","        normalizeToArray(prevProps.triggerTarget).forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">node</span>) </span>{\n","          node.removeAttribute(<span class=\"code-string\">'aria-expanded'</span>);\n","        });\n","      } <span class=\"code-keyword\">else</span> <span class=\"code-keyword\">if</span> (nextProps.triggerTarget) {\n","        reference.removeAttribute(<span class=\"code-string\">'aria-expanded'</span>);\n","      }\n","\n","      handleAriaExpandedAttribute();\n","      handleStyles();\n","\n","      <span class=\"code-keyword\">if</span> (onUpdate) {\n","        onUpdate(prevProps, nextProps);\n","      }\n","\n","      <span class=\"code-keyword\">if</span> (instance.popperInstance) {\n","        createPopperInstance(); <span class=\"code-comment\">// Fixes an issue with nested tippies if they are all getting re-rendered,</span>\n","        <span class=\"code-comment\">// and the nested ones get re-rendered first.</span>\n","        <span class=\"code-comment\">// https://github.com/atomiks/tippyjs-react/issues/177</span>\n","        <span class=\"code-comment\">// <span class=\"code-doctag\">TODO:</span> find a cleaner / more efficient solution(!)</span>\n","\n","        getNestedPopperTree().forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">nestedPopper</span>) </span>{\n","          <span class=\"code-comment\">// React (and other UI libs likely) requires a rAF wrapper as it flushes</span>\n","          <span class=\"code-comment\">// its work in one</span>\n","          requestAnimationFrame(nestedPopper._tippy.popperInstance.forceUpdate);\n","        });\n","      }\n","\n","      invokeHook(<span class=\"code-string\">'onAfterUpdate'</span>, [instance, partialProps]);\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">setContent</span>(<span class=\"code-params\">content</span>) </span>{\n","      instance.setProps({\n","        content: content\n","      });\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">show</span>(<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-comment\">/* istanbul ignore else */</span>\n","      {\n","        warnWhen(instance.state.isDestroyed, createMemoryLeakWarning(<span class=\"code-string\">'show'</span>));\n","      } <span class=\"code-comment\">// Early bail-out</span>\n","\n","\n","      <span class=\"code-keyword\">var</span> isAlreadyVisible = instance.state.isVisible;\n","      <span class=\"code-keyword\">var</span> isDestroyed = instance.state.isDestroyed;\n","      <span class=\"code-keyword\">var</span> isDisabled = !instance.state.isEnabled;\n","      <span class=\"code-keyword\">var</span> isTouchAndTouchDisabled = currentInput.isTouch &amp;&amp; !instance.props.touch;\n","      <span class=\"code-keyword\">var</span> duration = getValueAtIndexOrReturn(instance.props.duration, <span class=\"code-number\">0</span>, defaultProps.duration);\n","\n","      <span class=\"code-keyword\">if</span> (isAlreadyVisible || isDestroyed || isDisabled || isTouchAndTouchDisabled) {\n","        <span class=\"code-keyword\">return</span>;\n","      } <span class=\"code-comment\">// Normalize `disabled` behavior across browsers.</span>\n","      <span class=\"code-comment\">// Firefox allows events on disabled elements, but Chrome doesn't.</span>\n","      <span class=\"code-comment\">// Using a wrapper element (i.e. &lt;span&gt;) is recommended.</span>\n","\n","\n","      <span class=\"code-keyword\">if</span> (getCurrentTarget().hasAttribute(<span class=\"code-string\">'disabled'</span>)) {\n","        <span class=\"code-keyword\">return</span>;\n","      }\n","\n","      invokeHook(<span class=\"code-string\">'onShow'</span>, [instance], <span class=\"code-literal\">false</span>);\n","\n","      <span class=\"code-keyword\">if</span> (instance.props.onShow(instance) === <span class=\"code-literal\">false</span>) {\n","        <span class=\"code-keyword\">return</span>;\n","      }\n","\n","      instance.state.isVisible = <span class=\"code-literal\">true</span>;\n","\n","      <span class=\"code-keyword\">if</span> (getIsDefaultRenderFn()) {\n","        popper.style.visibility = <span class=\"code-string\">'visible'</span>;\n","      }\n","\n","      handleStyles();\n","      addDocumentPress();\n","\n","      <span class=\"code-keyword\">if</span> (!instance.state.isMounted) {\n","        popper.style.transition = <span class=\"code-string\">'none'</span>;\n","      } <span class=\"code-comment\">// If flipping to the opposite side after hiding at least once, the</span>\n","      <span class=\"code-comment\">// animation will use the wrong placement without resetting the duration</span>\n","\n","\n","      <span class=\"code-keyword\">if</span> (getIsDefaultRenderFn()) {\n","        <span class=\"code-keyword\">var</span> _getDefaultTemplateCh2 = getDefaultTemplateChildren(),\n","            box = _getDefaultTemplateCh2.box,\n","            content = _getDefaultTemplateCh2.content;\n","\n","        setTransitionDuration([box, content], <span class=\"code-number\">0</span>);\n","      }\n","\n","      onFirstUpdate = <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onFirstUpdate</span>(<span class=\"code-params\"></span>) </span>{\n","        <span class=\"code-keyword\">var</span> _instance$popperInsta2;\n","\n","        <span class=\"code-keyword\">if</span> (!instance.state.isVisible || ignoreOnFirstUpdate) {\n","          <span class=\"code-keyword\">return</span>;\n","        }\n","\n","        ignoreOnFirstUpdate = <span class=\"code-literal\">true</span>; <span class=\"code-comment\">// reflow</span>\n","\n","        <span class=\"code-keyword\">void</span> popper.offsetHeight;\n","        popper.style.transition = instance.props.moveTransition;\n","\n","        <span class=\"code-keyword\">if</span> (getIsDefaultRenderFn() &amp;&amp; instance.props.animation) {\n","          <span class=\"code-keyword\">var</span> _getDefaultTemplateCh3 = getDefaultTemplateChildren(),\n","              _box = _getDefaultTemplateCh3.box,\n","              _content = _getDefaultTemplateCh3.content;\n","\n","          setTransitionDuration([_box, _content], duration);\n","          setVisibilityState([_box, _content], <span class=\"code-string\">'visible'</span>);\n","        }\n","\n","        handleAriaContentAttribute();\n","        handleAriaExpandedAttribute();\n","        pushIfUnique(mountedInstances, instance); <span class=\"code-comment\">// certain modifiers (e.g. `maxSize`) require a second update after the</span>\n","        <span class=\"code-comment\">// popper has been positioned for the first time</span>\n","\n","        (_instance$popperInsta2 = instance.popperInstance) == <span class=\"code-literal\">null</span> ? <span class=\"code-keyword\">void</span> <span class=\"code-number\">0</span> : _instance$popperInsta2.forceUpdate();\n","        invokeHook(<span class=\"code-string\">'onMount'</span>, [instance]);\n","\n","        <span class=\"code-keyword\">if</span> (instance.props.animation &amp;&amp; getIsDefaultRenderFn()) {\n","          onTransitionedIn(duration, <span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\"></span>) </span>{\n","            instance.state.isShown = <span class=\"code-literal\">true</span>;\n","            invokeHook(<span class=\"code-string\">'onShown'</span>, [instance]);\n","          });\n","        }\n","      };\n","\n","      mount();\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">hide</span>(<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-comment\">/* istanbul ignore else */</span>\n","      {\n","        warnWhen(instance.state.isDestroyed, createMemoryLeakWarning(<span class=\"code-string\">'hide'</span>));\n","      } <span class=\"code-comment\">// Early bail-out</span>\n","\n","\n","      <span class=\"code-keyword\">var</span> isAlreadyHidden = !instance.state.isVisible;\n","      <span class=\"code-keyword\">var</span> isDestroyed = instance.state.isDestroyed;\n","      <span class=\"code-keyword\">var</span> isDisabled = !instance.state.isEnabled;\n","      <span class=\"code-keyword\">var</span> duration = getValueAtIndexOrReturn(instance.props.duration, <span class=\"code-number\">1</span>, defaultProps.duration);\n","\n","      <span class=\"code-keyword\">if</span> (isAlreadyHidden || isDestroyed || isDisabled) {\n","        <span class=\"code-keyword\">return</span>;\n","      }\n","\n","      invokeHook(<span class=\"code-string\">'onHide'</span>, [instance], <span class=\"code-literal\">false</span>);\n","\n","      <span class=\"code-keyword\">if</span> (instance.props.onHide(instance) === <span class=\"code-literal\">false</span>) {\n","        <span class=\"code-keyword\">return</span>;\n","      }\n","\n","      instance.state.isVisible = <span class=\"code-literal\">false</span>;\n","      instance.state.isShown = <span class=\"code-literal\">false</span>;\n","      ignoreOnFirstUpdate = <span class=\"code-literal\">false</span>;\n","      isVisibleFromClick = <span class=\"code-literal\">false</span>;\n","\n","      <span class=\"code-keyword\">if</span> (getIsDefaultRenderFn()) {\n","        popper.style.visibility = <span class=\"code-string\">'hidden'</span>;\n","      }\n","\n","      cleanupInteractiveMouseListeners();\n","      removeDocumentPress();\n","      handleStyles(<span class=\"code-literal\">true</span>);\n","\n","      <span class=\"code-keyword\">if</span> (getIsDefaultRenderFn()) {\n","        <span class=\"code-keyword\">var</span> _getDefaultTemplateCh4 = getDefaultTemplateChildren(),\n","            box = _getDefaultTemplateCh4.box,\n","            content = _getDefaultTemplateCh4.content;\n","\n","        <span class=\"code-keyword\">if</span> (instance.props.animation) {\n","          setTransitionDuration([box, content], duration);\n","          setVisibilityState([box, content], <span class=\"code-string\">'hidden'</span>);\n","        }\n","      }\n","\n","      handleAriaContentAttribute();\n","      handleAriaExpandedAttribute();\n","\n","      <span class=\"code-keyword\">if</span> (instance.props.animation) {\n","        <span class=\"code-keyword\">if</span> (getIsDefaultRenderFn()) {\n","          onTransitionedOut(duration, instance.unmount);\n","        }\n","      } <span class=\"code-keyword\">else</span> {\n","        instance.unmount();\n","      }\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">hideWithInteractivity</span>(<span class=\"code-params\">event</span>) </span>{\n","      <span class=\"code-comment\">/* istanbul ignore else */</span>\n","      {\n","        warnWhen(instance.state.isDestroyed, createMemoryLeakWarning(<span class=\"code-string\">'hideWithInteractivity'</span>));\n","      }\n","\n","      getDocument().addEventListener(<span class=\"code-string\">'mousemove'</span>, debouncedOnMouseMove);\n","      pushIfUnique(mouseMoveListeners, debouncedOnMouseMove);\n","      debouncedOnMouseMove(event);\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">unmount</span>(<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-comment\">/* istanbul ignore else */</span>\n","      {\n","        warnWhen(instance.state.isDestroyed, createMemoryLeakWarning(<span class=\"code-string\">'unmount'</span>));\n","      }\n","\n","      <span class=\"code-keyword\">if</span> (instance.state.isVisible) {\n","        instance.hide();\n","      }\n","\n","      <span class=\"code-keyword\">if</span> (!instance.state.isMounted) {\n","        <span class=\"code-keyword\">return</span>;\n","      }\n","\n","      destroyPopperInstance(); <span class=\"code-comment\">// If a popper is not interactive, it will be appended outside the popper</span>\n","      <span class=\"code-comment\">// tree by default. This seems mainly for interactive tippies, but we should</span>\n","      <span class=\"code-comment\">// find a workaround if possible</span>\n","\n","      getNestedPopperTree().forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">nestedPopper</span>) </span>{\n","        nestedPopper._tippy.unmount();\n","      });\n","\n","      <span class=\"code-keyword\">if</span> (popper.parentNode) {\n","        popper.parentNode.removeChild(popper);\n","      }\n","\n","      mountedInstances = mountedInstances.filter(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">i</span>) </span>{\n","        <span class=\"code-keyword\">return</span> i !== instance;\n","      });\n","      instance.state.isMounted = <span class=\"code-literal\">false</span>;\n","      invokeHook(<span class=\"code-string\">'onHidden'</span>, [instance]);\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">destroy</span>(<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-comment\">/* istanbul ignore else */</span>\n","      {\n","        warnWhen(instance.state.isDestroyed, createMemoryLeakWarning(<span class=\"code-string\">'destroy'</span>));\n","      }\n","\n","      <span class=\"code-keyword\">if</span> (instance.state.isDestroyed) {\n","        <span class=\"code-keyword\">return</span>;\n","      }\n","\n","      instance.clearDelayTimeouts();\n","      instance.unmount();\n","      removeListeners();\n","      <span class=\"code-keyword\">delete</span> reference._tippy;\n","      instance.state.isDestroyed = <span class=\"code-literal\">true</span>;\n","      invokeHook(<span class=\"code-string\">'onDestroy'</span>, [instance]);\n","    }\n","  }\n","\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">tippy</span>(<span class=\"code-params\">targets, optionalProps</span>) </span>{\n","    <span class=\"code-keyword\">if</span> (optionalProps === <span class=\"code-keyword\">void</span> <span class=\"code-number\">0</span>) {\n","      optionalProps = {};\n","    }\n","\n","    <span class=\"code-keyword\">var</span> plugins = defaultProps.plugins.concat(optionalProps.plugins || []);\n","    <span class=\"code-comment\">/* istanbul ignore else */</span>\n","\n","    {\n","      validateTargets(targets);\n","      validateProps(optionalProps, plugins);\n","    }\n","\n","    bindGlobalEventListeners();\n","    <span class=\"code-keyword\">var</span> passedProps = <span class=\"code-built_in\">Object</span>.assign({}, optionalProps, {\n","      plugins: plugins\n","    });\n","    <span class=\"code-keyword\">var</span> elements = getArrayOfElements(targets);\n","    <span class=\"code-comment\">/* istanbul ignore else */</span>\n","\n","    {\n","      <span class=\"code-keyword\">var</span> isSingleContentElement = isElement(passedProps.content);\n","      <span class=\"code-keyword\">var</span> isMoreThanOneReferenceElement = elements.length &gt; <span class=\"code-number\">1</span>;\n","      warnWhen(isSingleContentElement &amp;&amp; isMoreThanOneReferenceElement, [<span class=\"code-string\">'tippy() was passed an Element as the `content` prop, but more than'</span>, <span class=\"code-string\">'one tippy instance was created by this invocation. This means the'</span>, <span class=\"code-string\">'content element will only be appended to the last tippy instance.'</span>, <span class=\"code-string\">'\\n\\n'</span>, <span class=\"code-string\">'Instead, pass the .innerHTML of the element, or use a function that'</span>, <span class=\"code-string\">'returns a cloned version of the element instead.'</span>, <span class=\"code-string\">'\\n\\n'</span>, <span class=\"code-string\">'1) content: element.innerHTML\\n'</span>, <span class=\"code-string\">'2) content: () =&gt; element.cloneNode(true)'</span>].join(<span class=\"code-string\">' '</span>));\n","    }\n","\n","    <span class=\"code-keyword\">var</span> instances = elements.reduce(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">acc, reference</span>) </span>{\n","      <span class=\"code-keyword\">var</span> instance = reference &amp;&amp; createTippy(reference, passedProps);\n","\n","      <span class=\"code-keyword\">if</span> (instance) {\n","        acc.push(instance);\n","      }\n","\n","      <span class=\"code-keyword\">return</span> acc;\n","    }, []);\n","    <span class=\"code-keyword\">return</span> isElement(targets) ? instances[<span class=\"code-number\">0</span>] : instances;\n","  }\n","\n","  tippy.defaultProps = defaultProps;\n","  tippy.setDefaultProps = setDefaultProps;\n","  tippy.currentInput = currentInput;\n","  <span class=\"code-keyword\">var</span> hideAll = <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">hideAll</span>(<span class=\"code-params\">_temp</span>) </span>{\n","    <span class=\"code-keyword\">var</span> _ref = _temp === <span class=\"code-keyword\">void</span> <span class=\"code-number\">0</span> ? {} : _temp,\n","        excludedReferenceOrInstance = _ref.exclude,\n","        duration = _ref.duration;\n","\n","    mountedInstances.forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">instance</span>) </span>{\n","      <span class=\"code-keyword\">var</span> isExcluded = <span class=\"code-literal\">false</span>;\n","\n","      <span class=\"code-keyword\">if</span> (excludedReferenceOrInstance) {\n","        isExcluded = isReferenceElement(excludedReferenceOrInstance) ? instance.reference === excludedReferenceOrInstance : instance.popper === excludedReferenceOrInstance.popper;\n","      }\n","\n","      <span class=\"code-keyword\">if</span> (!isExcluded) {\n","        <span class=\"code-keyword\">var</span> originalDuration = instance.props.duration;\n","        instance.setProps({\n","          duration: duration\n","        });\n","        instance.hide();\n","\n","        <span class=\"code-keyword\">if</span> (!instance.state.isDestroyed) {\n","          instance.setProps({\n","            duration: originalDuration\n","          });\n","        }\n","      }\n","    });\n","  };\n","\n","  <span class=\"code-comment\">// every time the popper is destroyed (i.e. a new target), removing the styles</span>\n","  <span class=\"code-comment\">// and causing transitions to break for singletons when the console is open, but</span>\n","  <span class=\"code-comment\">// most notably for non-transform styles being used, `gpuAcceleration: false`.</span>\n","\n","  <span class=\"code-keyword\">var</span> applyStylesModifier = <span class=\"code-built_in\">Object</span>.assign({}, core.applyStyles, {\n","    effect: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">effect</span>(<span class=\"code-params\">_ref</span>) </span>{\n","      <span class=\"code-keyword\">var</span> state = _ref.state;\n","      <span class=\"code-keyword\">var</span> initialStyles = {\n","        popper: {\n","          position: state.options.strategy,\n","          left: <span class=\"code-string\">'0'</span>,\n","          top: <span class=\"code-string\">'0'</span>,\n","          margin: <span class=\"code-string\">'0'</span>\n","        },\n","        arrow: {\n","          position: <span class=\"code-string\">'absolute'</span>\n","        },\n","        reference: {}\n","      };\n","      <span class=\"code-built_in\">Object</span>.assign(state.elements.popper.style, initialStyles.popper);\n","      state.styles = initialStyles;\n","\n","      <span class=\"code-keyword\">if</span> (state.elements.arrow) {\n","        <span class=\"code-built_in\">Object</span>.assign(state.elements.arrow.style, initialStyles.arrow);\n","      } <span class=\"code-comment\">// intentionally return no cleanup function</span>\n","      <span class=\"code-comment\">// return () =&gt; { ... }</span>\n","\n","    }\n","  });\n","\n","  <span class=\"code-keyword\">var</span> createSingleton = <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">createSingleton</span>(<span class=\"code-params\">tippyInstances, optionalProps</span>) </span>{\n","    <span class=\"code-keyword\">var</span> _optionalProps$popper;\n","\n","    <span class=\"code-keyword\">if</span> (optionalProps === <span class=\"code-keyword\">void</span> <span class=\"code-number\">0</span>) {\n","      optionalProps = {};\n","    }\n","\n","    <span class=\"code-comment\">/* istanbul ignore else */</span>\n","    {\n","      errorWhen(!<span class=\"code-built_in\">Array</span>.isArray(tippyInstances), [<span class=\"code-string\">'The first argument passed to createSingleton() must be an array of'</span>, <span class=\"code-string\">'tippy instances. The passed value was'</span>, <span class=\"code-built_in\">String</span>(tippyInstances)].join(<span class=\"code-string\">' '</span>));\n","    }\n","\n","    <span class=\"code-keyword\">var</span> individualInstances = tippyInstances;\n","    <span class=\"code-keyword\">var</span> references = [];\n","    <span class=\"code-keyword\">var</span> triggerTargets = [];\n","    <span class=\"code-keyword\">var</span> currentTarget;\n","    <span class=\"code-keyword\">var</span> overrides = optionalProps.overrides;\n","    <span class=\"code-keyword\">var</span> interceptSetPropsCleanups = [];\n","    <span class=\"code-keyword\">var</span> shownOnCreate = <span class=\"code-literal\">false</span>;\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">setTriggerTargets</span>(<span class=\"code-params\"></span>) </span>{\n","      triggerTargets = individualInstances.map(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">instance</span>) </span>{\n","        <span class=\"code-keyword\">return</span> normalizeToArray(instance.props.triggerTarget || instance.reference);\n","      }).reduce(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">acc, item</span>) </span>{\n","        <span class=\"code-keyword\">return</span> acc.concat(item);\n","      }, []);\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">setReferences</span>(<span class=\"code-params\"></span>) </span>{\n","      references = individualInstances.map(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">instance</span>) </span>{\n","        <span class=\"code-keyword\">return</span> instance.reference;\n","      });\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">enableInstances</span>(<span class=\"code-params\">isEnabled</span>) </span>{\n","      individualInstances.forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">instance</span>) </span>{\n","        <span class=\"code-keyword\">if</span> (isEnabled) {\n","          instance.enable();\n","        } <span class=\"code-keyword\">else</span> {\n","          instance.disable();\n","        }\n","      });\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">interceptSetProps</span>(<span class=\"code-params\">singleton</span>) </span>{\n","      <span class=\"code-keyword\">return</span> individualInstances.map(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">instance</span>) </span>{\n","        <span class=\"code-keyword\">var</span> originalSetProps = instance.setProps;\n","\n","        instance.setProps = <span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">props</span>) </span>{\n","          originalSetProps(props);\n","\n","          <span class=\"code-keyword\">if</span> (instance.reference === currentTarget) {\n","            singleton.setProps(props);\n","          }\n","        };\n","\n","        <span class=\"code-keyword\">return</span> <span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\"></span>) </span>{\n","          instance.setProps = originalSetProps;\n","        };\n","      });\n","    } <span class=\"code-comment\">// have to pass singleton, as it maybe undefined on first call</span>\n","\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">prepareInstance</span>(<span class=\"code-params\">singleton, target</span>) </span>{\n","      <span class=\"code-keyword\">var</span> index = triggerTargets.indexOf(target); <span class=\"code-comment\">// bail-out</span>\n","\n","      <span class=\"code-keyword\">if</span> (target === currentTarget) {\n","        <span class=\"code-keyword\">return</span>;\n","      }\n","\n","      currentTarget = target;\n","      <span class=\"code-keyword\">var</span> overrideProps = (overrides || []).concat(<span class=\"code-string\">'content'</span>).reduce(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">acc, prop</span>) </span>{\n","        acc[prop] = individualInstances[index].props[prop];\n","        <span class=\"code-keyword\">return</span> acc;\n","      }, {});\n","      singleton.setProps(<span class=\"code-built_in\">Object</span>.assign({}, overrideProps, {\n","        getReferenceClientRect: <span class=\"code-keyword\">typeof</span> overrideProps.getReferenceClientRect === <span class=\"code-string\">'function'</span> ? overrideProps.getReferenceClientRect : <span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\"></span>) </span>{\n","          <span class=\"code-keyword\">var</span> _references$index;\n","\n","          <span class=\"code-keyword\">return</span> (_references$index = references[index]) == <span class=\"code-literal\">null</span> ? <span class=\"code-keyword\">void</span> <span class=\"code-number\">0</span> : _references$index.getBoundingClientRect();\n","        }\n","      }));\n","    }\n","\n","    enableInstances(<span class=\"code-literal\">false</span>);\n","    setReferences();\n","    setTriggerTargets();\n","    <span class=\"code-keyword\">var</span> plugin = {\n","      fn: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">fn</span>(<span class=\"code-params\"></span>) </span>{\n","        <span class=\"code-keyword\">return</span> {\n","          onDestroy: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onDestroy</span>(<span class=\"code-params\"></span>) </span>{\n","            enableInstances(<span class=\"code-literal\">true</span>);\n","          },\n","          onHidden: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onHidden</span>(<span class=\"code-params\"></span>) </span>{\n","            currentTarget = <span class=\"code-literal\">null</span>;\n","          },\n","          onClickOutside: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onClickOutside</span>(<span class=\"code-params\">instance</span>) </span>{\n","            <span class=\"code-keyword\">if</span> (instance.props.showOnCreate &amp;&amp; !shownOnCreate) {\n","              shownOnCreate = <span class=\"code-literal\">true</span>;\n","              currentTarget = <span class=\"code-literal\">null</span>;\n","            }\n","          },\n","          onShow: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onShow</span>(<span class=\"code-params\">instance</span>) </span>{\n","            <span class=\"code-keyword\">if</span> (instance.props.showOnCreate &amp;&amp; !shownOnCreate) {\n","              shownOnCreate = <span class=\"code-literal\">true</span>;\n","              prepareInstance(instance, references[<span class=\"code-number\">0</span>]);\n","            }\n","          },\n","          onTrigger: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onTrigger</span>(<span class=\"code-params\">instance, event</span>) </span>{\n","            prepareInstance(instance, event.currentTarget);\n","          }\n","        };\n","      }\n","    };\n","    <span class=\"code-keyword\">var</span> singleton = tippy(div(), <span class=\"code-built_in\">Object</span>.assign({}, removeProperties(optionalProps, [<span class=\"code-string\">'overrides'</span>]), {\n","      plugins: [plugin].concat(optionalProps.plugins || []),\n","      triggerTarget: triggerTargets,\n","      popperOptions: <span class=\"code-built_in\">Object</span>.assign({}, optionalProps.popperOptions, {\n","        modifiers: [].concat(((_optionalProps$popper = optionalProps.popperOptions) == <span class=\"code-literal\">null</span> ? <span class=\"code-keyword\">void</span> <span class=\"code-number\">0</span> : _optionalProps$popper.modifiers) || [], [applyStylesModifier])\n","      })\n","    }));\n","    <span class=\"code-keyword\">var</span> originalShow = singleton.show;\n","\n","    singleton.show = <span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">target</span>) </span>{\n","      originalShow(); <span class=\"code-comment\">// first time, showOnCreate or programmatic call with no params</span>\n","      <span class=\"code-comment\">// default to showing first instance</span>\n","\n","      <span class=\"code-keyword\">if</span> (!currentTarget &amp;&amp; target == <span class=\"code-literal\">null</span>) {\n","        <span class=\"code-keyword\">return</span> prepareInstance(singleton, references[<span class=\"code-number\">0</span>]);\n","      } <span class=\"code-comment\">// triggered from event (do nothing as prepareInstance already called by onTrigger)</span>\n","      <span class=\"code-comment\">// programmatic call with no params when already visible (do nothing again)</span>\n","\n","\n","      <span class=\"code-keyword\">if</span> (currentTarget &amp;&amp; target == <span class=\"code-literal\">null</span>) {\n","        <span class=\"code-keyword\">return</span>;\n","      } <span class=\"code-comment\">// target is index of instance</span>\n","\n","\n","      <span class=\"code-keyword\">if</span> (<span class=\"code-keyword\">typeof</span> target === <span class=\"code-string\">'number'</span>) {\n","        <span class=\"code-keyword\">return</span> references[target] &amp;&amp; prepareInstance(singleton, references[target]);\n","      } <span class=\"code-comment\">// target is a child tippy instance</span>\n","\n","\n","      <span class=\"code-keyword\">if</span> (individualInstances.indexOf(target) &gt;= <span class=\"code-number\">0</span>) {\n","        <span class=\"code-keyword\">var</span> ref = target.reference;\n","        <span class=\"code-keyword\">return</span> prepareInstance(singleton, ref);\n","      } <span class=\"code-comment\">// target is a ReferenceElement</span>\n","\n","\n","      <span class=\"code-keyword\">if</span> (references.indexOf(target) &gt;= <span class=\"code-number\">0</span>) {\n","        <span class=\"code-keyword\">return</span> prepareInstance(singleton, target);\n","      }\n","    };\n","\n","    singleton.showNext = <span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-keyword\">var</span> first = references[<span class=\"code-number\">0</span>];\n","\n","      <span class=\"code-keyword\">if</span> (!currentTarget) {\n","        <span class=\"code-keyword\">return</span> singleton.show(<span class=\"code-number\">0</span>);\n","      }\n","\n","      <span class=\"code-keyword\">var</span> index = references.indexOf(currentTarget);\n","      singleton.show(references[index + <span class=\"code-number\">1</span>] || first);\n","    };\n","\n","    singleton.showPrevious = <span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\"></span>) </span>{\n","      <span class=\"code-keyword\">var</span> last = references[references.length - <span class=\"code-number\">1</span>];\n","\n","      <span class=\"code-keyword\">if</span> (!currentTarget) {\n","        <span class=\"code-keyword\">return</span> singleton.show(last);\n","      }\n","\n","      <span class=\"code-keyword\">var</span> index = references.indexOf(currentTarget);\n","      <span class=\"code-keyword\">var</span> target = references[index - <span class=\"code-number\">1</span>] || last;\n","      singleton.show(target);\n","    };\n","\n","    <span class=\"code-keyword\">var</span> originalSetProps = singleton.setProps;\n","\n","    singleton.setProps = <span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">props</span>) </span>{\n","      overrides = props.overrides || overrides;\n","      originalSetProps(props);\n","    };\n","\n","    singleton.setInstances = <span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">nextInstances</span>) </span>{\n","      enableInstances(<span class=\"code-literal\">true</span>);\n","      interceptSetPropsCleanups.forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">fn</span>) </span>{\n","        <span class=\"code-keyword\">return</span> fn();\n","      });\n","      individualInstances = nextInstances;\n","      enableInstances(<span class=\"code-literal\">false</span>);\n","      setReferences();\n","      setTriggerTargets();\n","      interceptSetPropsCleanups = interceptSetProps(singleton);\n","      singleton.setProps({\n","        triggerTarget: triggerTargets\n","      });\n","    };\n","\n","    interceptSetPropsCleanups = interceptSetProps(singleton);\n","    <span class=\"code-keyword\">return</span> singleton;\n","  };\n","\n","  <span class=\"code-keyword\">var</span> BUBBLING_EVENTS_MAP = {\n","    mouseover: <span class=\"code-string\">'mouseenter'</span>,\n","    focusin: <span class=\"code-string\">'focus'</span>,\n","    click: <span class=\"code-string\">'click'</span>\n","  };\n","  <span class=\"code-comment\">/**\n</span>","<span class=\"code-comment\">   * Creates a delegate instance that controls the creation of tippy instances\n</span>","<span class=\"code-comment\">   * for child elements (`target` CSS selector).\n</span>","<span class=\"code-comment\">   */</span>\n","\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">delegate</span>(<span class=\"code-params\">targets, props</span>) </span>{\n","    <span class=\"code-comment\">/* istanbul ignore else */</span>\n","    {\n","      errorWhen(!(props &amp;&amp; props.target), [<span class=\"code-string\">'You must specity a `target` prop indicating a CSS selector string matching'</span>, <span class=\"code-string\">'the target elements that should receive a tippy.'</span>].join(<span class=\"code-string\">' '</span>));\n","    }\n","\n","    <span class=\"code-keyword\">var</span> listeners = [];\n","    <span class=\"code-keyword\">var</span> childTippyInstances = [];\n","    <span class=\"code-keyword\">var</span> disabled = <span class=\"code-literal\">false</span>;\n","    <span class=\"code-keyword\">var</span> target = props.target;\n","    <span class=\"code-keyword\">var</span> nativeProps = removeProperties(props, [<span class=\"code-string\">'target'</span>]);\n","    <span class=\"code-keyword\">var</span> parentProps = <span class=\"code-built_in\">Object</span>.assign({}, nativeProps, {\n","      trigger: <span class=\"code-string\">'manual'</span>,\n","      touch: <span class=\"code-literal\">false</span>\n","    });\n","    <span class=\"code-keyword\">var</span> childProps = <span class=\"code-built_in\">Object</span>.assign({\n","      touch: defaultProps.touch\n","    }, nativeProps, {\n","      showOnCreate: <span class=\"code-literal\">true</span>\n","    });\n","    <span class=\"code-keyword\">var</span> returnValue = tippy(targets, parentProps);\n","    <span class=\"code-keyword\">var</span> normalizedReturnValue = normalizeToArray(returnValue);\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onTrigger</span>(<span class=\"code-params\">event</span>) </span>{\n","      <span class=\"code-keyword\">if</span> (!event.target || disabled) {\n","        <span class=\"code-keyword\">return</span>;\n","      }\n","\n","      <span class=\"code-keyword\">var</span> targetNode = event.target.closest(target);\n","\n","      <span class=\"code-keyword\">if</span> (!targetNode) {\n","        <span class=\"code-keyword\">return</span>;\n","      } <span class=\"code-comment\">// Get relevant trigger with fallbacks:</span>\n","      <span class=\"code-comment\">// 1. Check `data-tippy-trigger` attribute on target node</span>\n","      <span class=\"code-comment\">// 2. Fallback to `trigger` passed to `delegate()`</span>\n","      <span class=\"code-comment\">// 3. Fallback to `defaultProps.trigger`</span>\n","\n","\n","      <span class=\"code-keyword\">var</span> trigger = targetNode.getAttribute(<span class=\"code-string\">'data-tippy-trigger'</span>) || props.trigger || defaultProps.trigger; <span class=\"code-comment\">// @ts-ignore</span>\n","\n","      <span class=\"code-keyword\">if</span> (targetNode._tippy) {\n","        <span class=\"code-keyword\">return</span>;\n","      }\n","\n","      <span class=\"code-keyword\">if</span> (event.type === <span class=\"code-string\">'touchstart'</span> &amp;&amp; <span class=\"code-keyword\">typeof</span> childProps.touch === <span class=\"code-string\">'boolean'</span>) {\n","        <span class=\"code-keyword\">return</span>;\n","      }\n","\n","      <span class=\"code-keyword\">if</span> (event.type !== <span class=\"code-string\">'touchstart'</span> &amp;&amp; trigger.indexOf(BUBBLING_EVENTS_MAP[event.type]) &lt; <span class=\"code-number\">0</span>) {\n","        <span class=\"code-keyword\">return</span>;\n","      }\n","\n","      <span class=\"code-keyword\">var</span> instance = tippy(targetNode, childProps);\n","\n","      <span class=\"code-keyword\">if</span> (instance) {\n","        childTippyInstances = childTippyInstances.concat(instance);\n","      }\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">on</span>(<span class=\"code-params\">node, eventType, handler, options</span>) </span>{\n","      <span class=\"code-keyword\">if</span> (options === <span class=\"code-keyword\">void</span> <span class=\"code-number\">0</span>) {\n","        options = <span class=\"code-literal\">false</span>;\n","      }\n","\n","      node.addEventListener(eventType, handler, options);\n","      listeners.push({\n","        node: node,\n","        eventType: eventType,\n","        handler: handler,\n","        options: options\n","      });\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">addEventListeners</span>(<span class=\"code-params\">instance</span>) </span>{\n","      <span class=\"code-keyword\">var</span> reference = instance.reference;\n","      on(reference, <span class=\"code-string\">'touchstart'</span>, onTrigger, TOUCH_OPTIONS);\n","      on(reference, <span class=\"code-string\">'mouseover'</span>, onTrigger);\n","      on(reference, <span class=\"code-string\">'focusin'</span>, onTrigger);\n","      on(reference, <span class=\"code-string\">'click'</span>, onTrigger);\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">removeEventListeners</span>(<span class=\"code-params\"></span>) </span>{\n","      listeners.forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">_ref</span>) </span>{\n","        <span class=\"code-keyword\">var</span> node = _ref.node,\n","            eventType = _ref.eventType,\n","            handler = _ref.handler,\n","            options = _ref.options;\n","        node.removeEventListener(eventType, handler, options);\n","      });\n","      listeners = [];\n","    }\n","\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">applyMutations</span>(<span class=\"code-params\">instance</span>) </span>{\n","      <span class=\"code-keyword\">var</span> originalDestroy = instance.destroy;\n","      <span class=\"code-keyword\">var</span> originalEnable = instance.enable;\n","      <span class=\"code-keyword\">var</span> originalDisable = instance.disable;\n","\n","      instance.destroy = <span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">shouldDestroyChildInstances</span>) </span>{\n","        <span class=\"code-keyword\">if</span> (shouldDestroyChildInstances === <span class=\"code-keyword\">void</span> <span class=\"code-number\">0</span>) {\n","          shouldDestroyChildInstances = <span class=\"code-literal\">true</span>;\n","        }\n","\n","        <span class=\"code-keyword\">if</span> (shouldDestroyChildInstances) {\n","          childTippyInstances.forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">instance</span>) </span>{\n","            instance.destroy();\n","          });\n","        }\n","\n","        childTippyInstances = [];\n","        removeEventListeners();\n","        originalDestroy();\n","      };\n","\n","      instance.enable = <span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\"></span>) </span>{\n","        originalEnable();\n","        childTippyInstances.forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">instance</span>) </span>{\n","          <span class=\"code-keyword\">return</span> instance.enable();\n","        });\n","        disabled = <span class=\"code-literal\">false</span>;\n","      };\n","\n","      instance.disable = <span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\"></span>) </span>{\n","        originalDisable();\n","        childTippyInstances.forEach(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">instance</span>) </span>{\n","          <span class=\"code-keyword\">return</span> instance.disable();\n","        });\n","        disabled = <span class=\"code-literal\">true</span>;\n","      };\n","\n","      addEventListeners(instance);\n","    }\n","\n","    normalizedReturnValue.forEach(applyMutations);\n","    <span class=\"code-keyword\">return</span> returnValue;\n","  }\n","\n","  <span class=\"code-keyword\">var</span> animateFill = {\n","    name: <span class=\"code-string\">'animateFill'</span>,\n","    defaultValue: <span class=\"code-literal\">false</span>,\n","    fn: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">fn</span>(<span class=\"code-params\">instance</span>) </span>{\n","      <span class=\"code-keyword\">var</span> _instance$props$rende;\n","\n","      <span class=\"code-comment\">// @ts-ignore</span>\n","      <span class=\"code-keyword\">if</span> (!((_instance$props$rende = instance.props.render) != <span class=\"code-literal\">null</span> &amp;&amp; _instance$props$rende.$$tippy)) {\n","        {\n","          errorWhen(instance.props.animateFill, <span class=\"code-string\">'The `animateFill` plugin requires the default render function.'</span>);\n","        }\n","\n","        <span class=\"code-keyword\">return</span> {};\n","      }\n","\n","      <span class=\"code-keyword\">var</span> _getChildren = getChildren(instance.popper),\n","          box = _getChildren.box,\n","          content = _getChildren.content;\n","\n","      <span class=\"code-keyword\">var</span> backdrop = instance.props.animateFill ? createBackdropElement() : <span class=\"code-literal\">null</span>;\n","      <span class=\"code-keyword\">return</span> {\n","        onCreate: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onCreate</span>(<span class=\"code-params\"></span>) </span>{\n","          <span class=\"code-keyword\">if</span> (backdrop) {\n","            box.insertBefore(backdrop, box.firstElementChild);\n","            box.setAttribute(<span class=\"code-string\">'data-animatefill'</span>, <span class=\"code-string\">''</span>);\n","            box.style.overflow = <span class=\"code-string\">'hidden'</span>;\n","            instance.setProps({\n","              arrow: <span class=\"code-literal\">false</span>,\n","              animation: <span class=\"code-string\">'shift-away'</span>\n","            });\n","          }\n","        },\n","        onMount: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onMount</span>(<span class=\"code-params\"></span>) </span>{\n","          <span class=\"code-keyword\">if</span> (backdrop) {\n","            <span class=\"code-keyword\">var</span> transitionDuration = box.style.transitionDuration;\n","            <span class=\"code-keyword\">var</span> duration = <span class=\"code-built_in\">Number</span>(transitionDuration.replace(<span class=\"code-string\">'ms'</span>, <span class=\"code-string\">''</span>)); <span class=\"code-comment\">// The content should fade in after the backdrop has mostly filled the</span>\n","            <span class=\"code-comment\">// tooltip element. `clip-path` is the other alternative but is not</span>\n","            <span class=\"code-comment\">// well-supported and is buggy on some devices.</span>\n","\n","            content.style.transitionDelay = <span class=\"code-built_in\">Math</span>.round(duration / <span class=\"code-number\">10</span>) + <span class=\"code-string\">\"ms\"</span>;\n","            backdrop.style.transitionDuration = transitionDuration;\n","            setVisibilityState([backdrop], <span class=\"code-string\">'visible'</span>);\n","          }\n","        },\n","        onShow: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onShow</span>(<span class=\"code-params\"></span>) </span>{\n","          <span class=\"code-keyword\">if</span> (backdrop) {\n","            backdrop.style.transitionDuration = <span class=\"code-string\">'0ms'</span>;\n","          }\n","        },\n","        onHide: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onHide</span>(<span class=\"code-params\"></span>) </span>{\n","          <span class=\"code-keyword\">if</span> (backdrop) {\n","            setVisibilityState([backdrop], <span class=\"code-string\">'hidden'</span>);\n","          }\n","        }\n","      };\n","    }\n","  };\n","\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">createBackdropElement</span>(<span class=\"code-params\"></span>) </span>{\n","    <span class=\"code-keyword\">var</span> backdrop = div();\n","    backdrop.className = BACKDROP_CLASS;\n","    setVisibilityState([backdrop], <span class=\"code-string\">'hidden'</span>);\n","    <span class=\"code-keyword\">return</span> backdrop;\n","  }\n","\n","  <span class=\"code-keyword\">var</span> mouseCoords = {\n","    clientX: <span class=\"code-number\">0</span>,\n","    clientY: <span class=\"code-number\">0</span>\n","  };\n","  <span class=\"code-keyword\">var</span> activeInstances = [];\n","\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">storeMouseCoords</span>(<span class=\"code-params\">_ref</span>) </span>{\n","    <span class=\"code-keyword\">var</span> clientX = _ref.clientX,\n","        clientY = _ref.clientY;\n","    mouseCoords = {\n","      clientX: clientX,\n","      clientY: clientY\n","    };\n","  }\n","\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">addMouseCoordsListener</span>(<span class=\"code-params\">doc</span>) </span>{\n","    doc.addEventListener(<span class=\"code-string\">'mousemove'</span>, storeMouseCoords);\n","  }\n","\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">removeMouseCoordsListener</span>(<span class=\"code-params\">doc</span>) </span>{\n","    doc.removeEventListener(<span class=\"code-string\">'mousemove'</span>, storeMouseCoords);\n","  }\n","\n","  <span class=\"code-keyword\">var</span> followCursor = {\n","    name: <span class=\"code-string\">'followCursor'</span>,\n","    defaultValue: <span class=\"code-literal\">false</span>,\n","    fn: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">fn</span>(<span class=\"code-params\">instance</span>) </span>{\n","      <span class=\"code-keyword\">var</span> reference = instance.reference;\n","      <span class=\"code-keyword\">var</span> doc = getOwnerDocument(instance.props.triggerTarget || reference);\n","      <span class=\"code-keyword\">var</span> isInternalUpdate = <span class=\"code-literal\">false</span>;\n","      <span class=\"code-keyword\">var</span> wasFocusEvent = <span class=\"code-literal\">false</span>;\n","      <span class=\"code-keyword\">var</span> isUnmounted = <span class=\"code-literal\">true</span>;\n","      <span class=\"code-keyword\">var</span> prevProps = instance.props;\n","\n","      <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getIsInitialBehavior</span>(<span class=\"code-params\"></span>) </span>{\n","        <span class=\"code-keyword\">return</span> instance.props.followCursor === <span class=\"code-string\">'initial'</span> &amp;&amp; instance.state.isVisible;\n","      }\n","\n","      <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">addListener</span>(<span class=\"code-params\"></span>) </span>{\n","        doc.addEventListener(<span class=\"code-string\">'mousemove'</span>, onMouseMove);\n","      }\n","\n","      <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">removeListener</span>(<span class=\"code-params\"></span>) </span>{\n","        doc.removeEventListener(<span class=\"code-string\">'mousemove'</span>, onMouseMove);\n","      }\n","\n","      <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">unsetGetReferenceClientRect</span>(<span class=\"code-params\"></span>) </span>{\n","        isInternalUpdate = <span class=\"code-literal\">true</span>;\n","        instance.setProps({\n","          getReferenceClientRect: <span class=\"code-literal\">null</span>\n","        });\n","        isInternalUpdate = <span class=\"code-literal\">false</span>;\n","      }\n","\n","      <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onMouseMove</span>(<span class=\"code-params\">event</span>) </span>{\n","        <span class=\"code-comment\">// If the instance is interactive, avoid updating the position unless it's</span>\n","        <span class=\"code-comment\">// over the reference element</span>\n","        <span class=\"code-keyword\">var</span> isCursorOverReference = event.target ? reference.contains(event.target) : <span class=\"code-literal\">true</span>;\n","        <span class=\"code-keyword\">var</span> followCursor = instance.props.followCursor;\n","        <span class=\"code-keyword\">var</span> clientX = event.clientX,\n","            clientY = event.clientY;\n","        <span class=\"code-keyword\">var</span> rect = reference.getBoundingClientRect();\n","        <span class=\"code-keyword\">var</span> relativeX = clientX - rect.left;\n","        <span class=\"code-keyword\">var</span> relativeY = clientY - rect.top;\n","\n","        <span class=\"code-keyword\">if</span> (isCursorOverReference || !instance.props.interactive) {\n","          instance.setProps({\n","            <span class=\"code-comment\">// @ts-ignore - unneeded DOMRect properties</span>\n","            getReferenceClientRect: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getReferenceClientRect</span>(<span class=\"code-params\"></span>) </span>{\n","              <span class=\"code-keyword\">var</span> rect = reference.getBoundingClientRect();\n","              <span class=\"code-keyword\">var</span> x = clientX;\n","              <span class=\"code-keyword\">var</span> y = clientY;\n","\n","              <span class=\"code-keyword\">if</span> (followCursor === <span class=\"code-string\">'initial'</span>) {\n","                x = rect.left + relativeX;\n","                y = rect.top + relativeY;\n","              }\n","\n","              <span class=\"code-keyword\">var</span> top = followCursor === <span class=\"code-string\">'horizontal'</span> ? rect.top : y;\n","              <span class=\"code-keyword\">var</span> right = followCursor === <span class=\"code-string\">'vertical'</span> ? rect.right : x;\n","              <span class=\"code-keyword\">var</span> bottom = followCursor === <span class=\"code-string\">'horizontal'</span> ? rect.bottom : y;\n","              <span class=\"code-keyword\">var</span> left = followCursor === <span class=\"code-string\">'vertical'</span> ? rect.left : x;\n","              <span class=\"code-keyword\">return</span> {\n","                width: right - left,\n","                height: bottom - top,\n","                top: top,\n","                right: right,\n","                bottom: bottom,\n","                left: left\n","              };\n","            }\n","          });\n","        }\n","      }\n","\n","      <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">create</span>(<span class=\"code-params\"></span>) </span>{\n","        <span class=\"code-keyword\">if</span> (instance.props.followCursor) {\n","          activeInstances.push({\n","            instance: instance,\n","            doc: doc\n","          });\n","          addMouseCoordsListener(doc);\n","        }\n","      }\n","\n","      <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">destroy</span>(<span class=\"code-params\"></span>) </span>{\n","        activeInstances = activeInstances.filter(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">data</span>) </span>{\n","          <span class=\"code-keyword\">return</span> data.instance !== instance;\n","        });\n","\n","        <span class=\"code-keyword\">if</span> (activeInstances.filter(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">data</span>) </span>{\n","          <span class=\"code-keyword\">return</span> data.doc === doc;\n","        }).length === <span class=\"code-number\">0</span>) {\n","          removeMouseCoordsListener(doc);\n","        }\n","      }\n","\n","      <span class=\"code-keyword\">return</span> {\n","        onCreate: create,\n","        onDestroy: destroy,\n","        onBeforeUpdate: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onBeforeUpdate</span>(<span class=\"code-params\"></span>) </span>{\n","          prevProps = instance.props;\n","        },\n","        onAfterUpdate: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onAfterUpdate</span>(<span class=\"code-params\">_, _ref2</span>) </span>{\n","          <span class=\"code-keyword\">var</span> followCursor = _ref2.followCursor;\n","\n","          <span class=\"code-keyword\">if</span> (isInternalUpdate) {\n","            <span class=\"code-keyword\">return</span>;\n","          }\n","\n","          <span class=\"code-keyword\">if</span> (followCursor !== <span class=\"code-literal\">undefined</span> &amp;&amp; prevProps.followCursor !== followCursor) {\n","            destroy();\n","\n","            <span class=\"code-keyword\">if</span> (followCursor) {\n","              create();\n","\n","              <span class=\"code-keyword\">if</span> (instance.state.isMounted &amp;&amp; !wasFocusEvent &amp;&amp; !getIsInitialBehavior()) {\n","                addListener();\n","              }\n","            } <span class=\"code-keyword\">else</span> {\n","              removeListener();\n","              unsetGetReferenceClientRect();\n","            }\n","          }\n","        },\n","        onMount: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onMount</span>(<span class=\"code-params\"></span>) </span>{\n","          <span class=\"code-keyword\">if</span> (instance.props.followCursor &amp;&amp; !wasFocusEvent) {\n","            <span class=\"code-keyword\">if</span> (isUnmounted) {\n","              onMouseMove(mouseCoords);\n","              isUnmounted = <span class=\"code-literal\">false</span>;\n","            }\n","\n","            <span class=\"code-keyword\">if</span> (!getIsInitialBehavior()) {\n","              addListener();\n","            }\n","          }\n","        },\n","        onTrigger: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onTrigger</span>(<span class=\"code-params\">_, event</span>) </span>{\n","          <span class=\"code-keyword\">if</span> (isMouseEvent(event)) {\n","            mouseCoords = {\n","              clientX: event.clientX,\n","              clientY: event.clientY\n","            };\n","          }\n","\n","          wasFocusEvent = event.type === <span class=\"code-string\">'focus'</span>;\n","        },\n","        onHidden: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onHidden</span>(<span class=\"code-params\"></span>) </span>{\n","          <span class=\"code-keyword\">if</span> (instance.props.followCursor) {\n","            unsetGetReferenceClientRect();\n","            removeListener();\n","            isUnmounted = <span class=\"code-literal\">true</span>;\n","          }\n","        }\n","      };\n","    }\n","  };\n","\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getProps</span>(<span class=\"code-params\">props, modifier</span>) </span>{\n","    <span class=\"code-keyword\">var</span> _props$popperOptions;\n","\n","    <span class=\"code-keyword\">return</span> {\n","      popperOptions: <span class=\"code-built_in\">Object</span>.assign({}, props.popperOptions, {\n","        modifiers: [].concat((((_props$popperOptions = props.popperOptions) == <span class=\"code-literal\">null</span> ? <span class=\"code-keyword\">void</span> <span class=\"code-number\">0</span> : _props$popperOptions.modifiers) || []).filter(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">_ref</span>) </span>{\n","          <span class=\"code-keyword\">var</span> name = _ref.name;\n","          <span class=\"code-keyword\">return</span> name !== modifier.name;\n","        }), [modifier])\n","      })\n","    };\n","  }\n","\n","  <span class=\"code-keyword\">var</span> inlinePositioning = {\n","    name: <span class=\"code-string\">'inlinePositioning'</span>,\n","    defaultValue: <span class=\"code-literal\">false</span>,\n","    fn: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">fn</span>(<span class=\"code-params\">instance</span>) </span>{\n","      <span class=\"code-keyword\">var</span> reference = instance.reference;\n","\n","      <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">isEnabled</span>(<span class=\"code-params\"></span>) </span>{\n","        <span class=\"code-keyword\">return</span> !!instance.props.inlinePositioning;\n","      }\n","\n","      <span class=\"code-keyword\">var</span> placement;\n","      <span class=\"code-keyword\">var</span> cursorRectIndex = <span class=\"code-number\">-1</span>;\n","      <span class=\"code-keyword\">var</span> isInternalUpdate = <span class=\"code-literal\">false</span>;\n","      <span class=\"code-keyword\">var</span> triedPlacements = [];\n","      <span class=\"code-keyword\">var</span> modifier = {\n","        name: <span class=\"code-string\">'tippyInlinePositioning'</span>,\n","        enabled: <span class=\"code-literal\">true</span>,\n","        phase: <span class=\"code-string\">'afterWrite'</span>,\n","        fn: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">fn</span>(<span class=\"code-params\">_ref2</span>) </span>{\n","          <span class=\"code-keyword\">var</span> state = _ref2.state;\n","\n","          <span class=\"code-keyword\">if</span> (isEnabled()) {\n","            <span class=\"code-keyword\">if</span> (triedPlacements.indexOf(state.placement) !== <span class=\"code-number\">-1</span>) {\n","              triedPlacements = [];\n","            }\n","\n","            <span class=\"code-keyword\">if</span> (placement !== state.placement &amp;&amp; triedPlacements.indexOf(state.placement) === <span class=\"code-number\">-1</span>) {\n","              triedPlacements.push(state.placement);\n","              instance.setProps({\n","                <span class=\"code-comment\">// @ts-ignore - unneeded DOMRect properties</span>\n","                getReferenceClientRect: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getReferenceClientRect</span>(<span class=\"code-params\"></span>) </span>{\n","                  <span class=\"code-keyword\">return</span> _getReferenceClientRect(state.placement);\n","                }\n","              });\n","            }\n","\n","            placement = state.placement;\n","          }\n","        }\n","      };\n","\n","      <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">_getReferenceClientRect</span>(<span class=\"code-params\">placement</span>) </span>{\n","        <span class=\"code-keyword\">return</span> getInlineBoundingClientRect(getBasePlacement(placement), reference.getBoundingClientRect(), arrayFrom(reference.getClientRects()), cursorRectIndex);\n","      }\n","\n","      <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">setInternalProps</span>(<span class=\"code-params\">partialProps</span>) </span>{\n","        isInternalUpdate = <span class=\"code-literal\">true</span>;\n","        instance.setProps(partialProps);\n","        isInternalUpdate = <span class=\"code-literal\">false</span>;\n","      }\n","\n","      <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">addModifier</span>(<span class=\"code-params\"></span>) </span>{\n","        <span class=\"code-keyword\">if</span> (!isInternalUpdate) {\n","          setInternalProps(getProps(instance.props, modifier));\n","        }\n","      }\n","\n","      <span class=\"code-keyword\">return</span> {\n","        onCreate: addModifier,\n","        onAfterUpdate: addModifier,\n","        onTrigger: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onTrigger</span>(<span class=\"code-params\">_, event</span>) </span>{\n","          <span class=\"code-keyword\">if</span> (isMouseEvent(event)) {\n","            <span class=\"code-keyword\">var</span> rects = arrayFrom(instance.reference.getClientRects());\n","            <span class=\"code-keyword\">var</span> cursorRect = rects.find(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">rect</span>) </span>{\n","              <span class=\"code-keyword\">return</span> rect.left - <span class=\"code-number\">2</span> &lt;= event.clientX &amp;&amp; rect.right + <span class=\"code-number\">2</span> &gt;= event.clientX &amp;&amp; rect.top - <span class=\"code-number\">2</span> &lt;= event.clientY &amp;&amp; rect.bottom + <span class=\"code-number\">2</span> &gt;= event.clientY;\n","            });\n","            <span class=\"code-keyword\">var</span> index = rects.indexOf(cursorRect);\n","            cursorRectIndex = index &gt; <span class=\"code-number\">-1</span> ? index : cursorRectIndex;\n","          }\n","        },\n","        onHidden: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onHidden</span>(<span class=\"code-params\"></span>) </span>{\n","          cursorRectIndex = <span class=\"code-number\">-1</span>;\n","        }\n","      };\n","    }\n","  };\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getInlineBoundingClientRect</span>(<span class=\"code-params\">currentBasePlacement, boundingRect, clientRects, cursorRectIndex</span>) </span>{\n","    <span class=\"code-comment\">// Not an inline element, or placement is not yet known</span>\n","    <span class=\"code-keyword\">if</span> (clientRects.length &lt; <span class=\"code-number\">2</span> || currentBasePlacement === <span class=\"code-literal\">null</span>) {\n","      <span class=\"code-keyword\">return</span> boundingRect;\n","    } <span class=\"code-comment\">// There are two rects and they are disjoined</span>\n","\n","\n","    <span class=\"code-keyword\">if</span> (clientRects.length === <span class=\"code-number\">2</span> &amp;&amp; cursorRectIndex &gt;= <span class=\"code-number\">0</span> &amp;&amp; clientRects[<span class=\"code-number\">0</span>].left &gt; clientRects[<span class=\"code-number\">1</span>].right) {\n","      <span class=\"code-keyword\">return</span> clientRects[cursorRectIndex] || boundingRect;\n","    }\n","\n","    <span class=\"code-keyword\">switch</span> (currentBasePlacement) {\n","      <span class=\"code-keyword\">case</span> <span class=\"code-string\">'top'</span>:\n","      <span class=\"code-keyword\">case</span> <span class=\"code-string\">'bottom'</span>:\n","        {\n","          <span class=\"code-keyword\">var</span> firstRect = clientRects[<span class=\"code-number\">0</span>];\n","          <span class=\"code-keyword\">var</span> lastRect = clientRects[clientRects.length - <span class=\"code-number\">1</span>];\n","          <span class=\"code-keyword\">var</span> isTop = currentBasePlacement === <span class=\"code-string\">'top'</span>;\n","          <span class=\"code-keyword\">var</span> top = firstRect.top;\n","          <span class=\"code-keyword\">var</span> bottom = lastRect.bottom;\n","          <span class=\"code-keyword\">var</span> left = isTop ? firstRect.left : lastRect.left;\n","          <span class=\"code-keyword\">var</span> right = isTop ? firstRect.right : lastRect.right;\n","          <span class=\"code-keyword\">var</span> width = right - left;\n","          <span class=\"code-keyword\">var</span> height = bottom - top;\n","          <span class=\"code-keyword\">return</span> {\n","            top: top,\n","            bottom: bottom,\n","            left: left,\n","            right: right,\n","            width: width,\n","            height: height\n","          };\n","        }\n","\n","      <span class=\"code-keyword\">case</span> <span class=\"code-string\">'left'</span>:\n","      <span class=\"code-keyword\">case</span> <span class=\"code-string\">'right'</span>:\n","        {\n","          <span class=\"code-keyword\">var</span> minLeft = <span class=\"code-built_in\">Math</span>.min.apply(<span class=\"code-built_in\">Math</span>, clientRects.map(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">rects</span>) </span>{\n","            <span class=\"code-keyword\">return</span> rects.left;\n","          }));\n","          <span class=\"code-keyword\">var</span> maxRight = <span class=\"code-built_in\">Math</span>.max.apply(<span class=\"code-built_in\">Math</span>, clientRects.map(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">rects</span>) </span>{\n","            <span class=\"code-keyword\">return</span> rects.right;\n","          }));\n","          <span class=\"code-keyword\">var</span> measureRects = clientRects.filter(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">rect</span>) </span>{\n","            <span class=\"code-keyword\">return</span> currentBasePlacement === <span class=\"code-string\">'left'</span> ? rect.left === minLeft : rect.right === maxRight;\n","          });\n","          <span class=\"code-keyword\">var</span> _top = measureRects[<span class=\"code-number\">0</span>].top;\n","          <span class=\"code-keyword\">var</span> _bottom = measureRects[measureRects.length - <span class=\"code-number\">1</span>].bottom;\n","          <span class=\"code-keyword\">var</span> _left = minLeft;\n","          <span class=\"code-keyword\">var</span> _right = maxRight;\n","\n","          <span class=\"code-keyword\">var</span> _width = _right - _left;\n","\n","          <span class=\"code-keyword\">var</span> _height = _bottom - _top;\n","\n","          <span class=\"code-keyword\">return</span> {\n","            top: _top,\n","            bottom: _bottom,\n","            left: _left,\n","            right: _right,\n","            width: _width,\n","            height: _height\n","          };\n","        }\n","\n","      <span class=\"code-keyword\">default</span>:\n","        {\n","          <span class=\"code-keyword\">return</span> boundingRect;\n","        }\n","    }\n","  }\n","\n","  <span class=\"code-keyword\">var</span> sticky = {\n","    name: <span class=\"code-string\">'sticky'</span>,\n","    defaultValue: <span class=\"code-literal\">false</span>,\n","    fn: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">fn</span>(<span class=\"code-params\">instance</span>) </span>{\n","      <span class=\"code-keyword\">var</span> reference = instance.reference,\n","          popper = instance.popper;\n","\n","      <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getReference</span>(<span class=\"code-params\"></span>) </span>{\n","        <span class=\"code-keyword\">return</span> instance.popperInstance ? instance.popperInstance.state.elements.reference : reference;\n","      }\n","\n","      <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">shouldCheck</span>(<span class=\"code-params\">value</span>) </span>{\n","        <span class=\"code-keyword\">return</span> instance.props.sticky === <span class=\"code-literal\">true</span> || instance.props.sticky === value;\n","      }\n","\n","      <span class=\"code-keyword\">var</span> prevRefRect = <span class=\"code-literal\">null</span>;\n","      <span class=\"code-keyword\">var</span> prevPopRect = <span class=\"code-literal\">null</span>;\n","\n","      <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">updatePosition</span>(<span class=\"code-params\"></span>) </span>{\n","        <span class=\"code-keyword\">var</span> currentRefRect = shouldCheck(<span class=\"code-string\">'reference'</span>) ? getReference().getBoundingClientRect() : <span class=\"code-literal\">null</span>;\n","        <span class=\"code-keyword\">var</span> currentPopRect = shouldCheck(<span class=\"code-string\">'popper'</span>) ? popper.getBoundingClientRect() : <span class=\"code-literal\">null</span>;\n","\n","        <span class=\"code-keyword\">if</span> (currentRefRect &amp;&amp; areRectsDifferent(prevRefRect, currentRefRect) || currentPopRect &amp;&amp; areRectsDifferent(prevPopRect, currentPopRect)) {\n","          <span class=\"code-keyword\">if</span> (instance.popperInstance) {\n","            instance.popperInstance.update();\n","          }\n","        }\n","\n","        prevRefRect = currentRefRect;\n","        prevPopRect = currentPopRect;\n","\n","        <span class=\"code-keyword\">if</span> (instance.state.isMounted) {\n","          requestAnimationFrame(updatePosition);\n","        }\n","      }\n","\n","      <span class=\"code-keyword\">return</span> {\n","        onMount: <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">onMount</span>(<span class=\"code-params\"></span>) </span>{\n","          <span class=\"code-keyword\">if</span> (instance.props.sticky) {\n","            updatePosition();\n","          }\n","        }\n","      };\n","    }\n","  };\n","\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">areRectsDifferent</span>(<span class=\"code-params\">rectA, rectB</span>) </span>{\n","    <span class=\"code-keyword\">if</span> (rectA &amp;&amp; rectB) {\n","      <span class=\"code-keyword\">return</span> rectA.top !== rectB.top || rectA.right !== rectB.right || rectA.bottom !== rectB.bottom || rectA.left !== rectB.left;\n","    }\n","\n","    <span class=\"code-keyword\">return</span> <span class=\"code-literal\">true</span>;\n","  }\n","\n","  <span class=\"code-keyword\">if</span> (isBrowser) {\n","    injectCSS(css);\n","  }\n","\n","  tippy.setDefaultProps({\n","    plugins: [animateFill, followCursor, inlinePositioning, sticky],\n","    render: render\n","  });\n","  tippy.createSingleton = createSingleton;\n","  tippy.delegate = delegate;\n","  tippy.hideAll = hideAll;\n","  tippy.roundArrow = ROUND_ARROW;\n","\n","  <span class=\"code-keyword\">return</span> tippy;\n","\n","})));\n","<span class=\"code-comment\">//# sourceMappingURL=tippy-bundle.umd.js.map</span>\n",""]}}}</script></head><body><div id="root"><style data-emotion-css="gtfibm">html{box-sizing:border-box;}*,*:before,*:after{box-sizing:inherit;}html,body,#root{height:100%;margin:0;}body{font-family:-apple-system, BlinkMacSystemFont, "Segoe UI", "Roboto", "Oxygen", "Ubuntu", "Cantarell", "Fira Sans", "Droid Sans", "Helvetica Neue", sans-serif;font-size:16px;line-height:1.5;overflow-wrap:break-word;background:white;color:black;}code{font-family:Menlo, Monaco, Lucida Console, Liberation Mono, DejaVu Sans Mono, Bitstream Vera Sans Mono, Courier New, monospace;}th,td{padding:0;}select{font-size:inherit;}#root{display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-direction:column;-ms-flex-direction:column;flex-direction:column;}</style><style data-emotion-css="1r6h1r6">.code-listing{background:#fbfdff;color:#383a42;}.code-comment,.code-quote{color:#a0a1a7;font-style:italic;}.code-doctag,.code-keyword,.code-link,.code-formula{color:#a626a4;}.code-section,.code-name,.code-selector-tag,.code-deletion,.code-subst{color:#e45649;}.code-literal{color:#0184bb;}.code-string,.code-regexp,.code-addition,.code-attribute,.code-meta-string{color:#50a14f;}.code-built_in,.code-class .code-title{color:#c18401;}.code-attr,.code-variable,.code-template-variable,.code-type,.code-selector-class,.code-selector-attr,.code-selector-pseudo,.code-number{color:#986801;}.code-symbol,.code-bullet,.code-meta,.code-selector-id,.code-title{color:#4078f2;}.code-emphasis{font-style:italic;}.code-strong{font-weight:bold;}</style><style data-emotion-css="1c3h18e">.css-1c3h18e{-webkit-flex:1 0 auto;-ms-flex:1 0 auto;flex:1 0 auto;}</style><div class="css-1c3h18e"><style data-emotion-css="1cfuj1t">.css-1cfuj1t{max-width:940px;padding:0 20px;margin:0 auto;}</style><div class="css-1cfuj1t"><style data-emotion-css="i51og3">.css-i51og3{margin-top:2rem;}</style><header class="css-i51og3"><style data-emotion-css="1y7u1xh">.css-1y7u1xh{text-align:center;font-size:3rem;-webkit-letter-spacing:0.05em;-moz-letter-spacing:0.05em;-ms-letter-spacing:0.05em;letter-spacing:0.05em;}</style><h1 class="css-1y7u1xh"><style data-emotion-css="1ydg16i">.css-1ydg16i{color:#000;-webkit-text-decoration:none;text-decoration:none;}</style><a href="/" class="css-1ydg16i">UNPKG</a></h1></header></div><div class="css-1cfuj1t"><style data-emotion-css="93o42g">.css-93o42g{display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-direction:row;-ms-flex-direction:row;flex-direction:row;-webkit-align-items:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;}@media (max-width:700px){.css-93o42g{-webkit-flex-direction:column-reverse;-ms-flex-direction:column-reverse;flex-direction:column-reverse;-webkit-align-items:flex-start;-webkit-box-align:flex-start;-ms-flex-align:flex-start;align-items:flex-start;}}</style><header class="css-93o42g"><style data-emotion-css="1dlpvgi">.css-1dlpvgi{font-size:1.5rem;font-weight:normal;-webkit-flex:1;-ms-flex:1;flex:1;word-break:break-all;}</style><h1 class="css-1dlpvgi"><nav><style data-emotion-css="xt128v">.css-xt128v{color:#0076ff;-webkit-text-decoration:none;text-decoration:none;}.css-xt128v:hover{-webkit-text-decoration:underline;text-decoration:underline;}</style><a href="/browse/tippy.js@6.3.7/" class="css-xt128v">tippy.js</a><style data-emotion-css="lllnmq">.css-lllnmq{padding-left:5px;padding-right:5px;}</style><span class="css-lllnmq">/</span><a href="/browse/tippy.js@6.3.7/dist/" class="css-xt128v">dist</a><span class="css-lllnmq">/</span><strong>tippy-bundle.umd.js</strong></nav></h1><style data-emotion-css="1nr3dab">.css-1nr3dab{margin-left:20px;}@media (max-width:700px){.css-1nr3dab{margin-left:0;margin-bottom:0;}}</style><p class="css-1nr3dab"><label>Version:<!-- --> <style data-emotion-css="un3bt6">.css-un3bt6{-webkit-appearance:none;-moz-appearance:none;appearance:none;cursor:pointer;padding:4px 24px 4px 8px;font-weight:600;font-size:0.9em;color:#24292e;border:1px solid rgba(27,31,35,.2);border-radius:3px;background-color:#eff3f6;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAKCAYAAAC9vt6cAAAAAXNSR0IArs4c6QAAARFJREFUKBVjZAACNS39RhBNKrh17WI9o4quoT3Dn78HSNUMUs/CzOTI/O7Vi4dCYpJ3/jP+92BkYGAlyiBGhm8MjIxJt65e3MQM0vDu9YvLYmISILYZELOBxHABRkaGr0yMzF23r12YDFIDNgDEePv65SEhEXENBkYGFSAXuyGMjF8Z/jOsvX3tYiFIDwgwQSgIaaijnvj/P8M5IO8HsjiY/f//D4b//88A1SQhywG9jQr09PS4v/1mPAeUUPzP8B8cJowMjL+Bqu6xMQmaXL164AuyDgwDQJLa2qYSP//9vARkCoMVMzK8YeVkNbh+9uxzMB+JwGoASF5Vx0jz/98/18BqmZi171w9D2EjaaYKEwAEK00XQLdJuwAAAABJRU5ErkJggg==);background-position:right 8px center;background-repeat:no-repeat;background-size:auto 25%;}.css-un3bt6:hover{background-color:#e6ebf1;border-color:rgba(27,31,35,.35);}.css-un3bt6:active{background-color:#e9ecef;border-color:rgba(27,31,35,.35);box-shadow:inset 0 0.15em 0.3em rgba(27,31,35,.15);}</style><select name="version" class="css-un3bt6"><option value="0.3.4">0.3.4</option><option value="0.3.5">0.3.5</option><option value="0.3.6">0.3.6</option><option value="0.4.0">0.4.0</option><option value="0.4.1">0.4.1</option><option value="0.5.0">0.5.0</option><option value="0.5.1">0.5.1</option><option value="0.6.0">0.6.0</option><option value="0.6.1">0.6.1</option><option value="0.7.0">0.7.0</option><option value="0.8.0">0.8.0</option><option value="0.8.1">0.8.1</option><option value="0.8.2">0.8.2</option><option value="0.9.0">0.9.0</option><option value="0.10.0">0.10.0</option><option value="0.10.1">0.10.1</option><option value="0.10.2">0.10.2</option><option value="0.11.0">0.11.0</option><option value="0.11.1">0.11.1</option><option value="0.11.2">0.11.2</option><option value="0.11.3">0.11.3</option><option value="0.12.0">0.12.0</option><option value="0.12.1">0.12.1</option><option value="0.12.2">0.12.2</option><option value="0.13.0">0.13.0</option><option value="0.14.0">0.14.0</option><option value="0.14.1">0.14.1</option><option value="0.14.2">0.14.2</option><option value="0.15.0">0.15.0</option><option value="0.16.0">0.16.0</option><option value="0.16.1">0.16.1</option><option value="0.16.2">0.16.2</option><option value="0.16.3">0.16.3</option><option value="0.17.0">0.17.0</option><option value="1.0.0">1.0.0</option><option value="1.0.1">1.0.1</option><option value="1.1.0">1.1.0</option><option value="1.1.1">1.1.1</option><option value="1.1.2">1.1.2</option><option value="1.1.3">1.1.3</option><option value="1.2.0">1.2.0</option><option value="1.2.1">1.2.1</option><option value="1.2.2">1.2.2</option><option value="1.3.0">1.3.0</option><option value="1.4.0">1.4.0</option><option value="1.4.1">1.4.1</option><option value="1.4.2">1.4.2</option><option value="2.0.0-beta.2">2.0.0-beta.2</option><option value="2.0.0">2.0.0</option><option value="2.0.1">2.0.1</option><option value="2.0.2">2.0.2</option><option value="2.0.3">2.0.3</option><option value="2.0.4">2.0.4</option><option value="2.0.5">2.0.5</option><option value="2.0.6">2.0.6</option><option value="2.0.7">2.0.7</option><option value="2.0.8">2.0.8</option><option value="2.0.9">2.0.9</option><option value="2.1.0">2.1.0</option><option value="2.1.1">2.1.1</option><option value="2.2.0">2.2.0</option><option value="2.2.1">2.2.1</option><option value="2.2.2">2.2.2</option><option value="2.2.3">2.2.3</option><option value="2.3.0">2.3.0</option><option value="2.4.0">2.4.0</option><option value="2.4.1">2.4.1</option><option value="2.4.2">2.4.2</option><option value="2.5.0">2.5.0</option><option value="2.5.1">2.5.1</option><option value="2.5.2">2.5.2</option><option value="2.5.3">2.5.3</option><option value="2.5.4">2.5.4</option><option value="2.6.0">2.6.0</option><option value="3.0.0-alpha.0">3.0.0-alpha.0</option><option value="3.0.0-alpha.1">3.0.0-alpha.1</option><option value="3.0.0-alpha.2">3.0.0-alpha.2</option><option value="3.0.0-alpha.3">3.0.0-alpha.3</option><option value="3.0.0-beta.0">3.0.0-beta.0</option><option value="3.0.0-beta.2">3.0.0-beta.2</option><option value="3.0.0">3.0.0</option><option value="3.0.1">3.0.1</option><option value="3.0.2">3.0.2</option><option value="3.0.3">3.0.3</option><option value="3.0.4">3.0.4</option><option value="3.0.5">3.0.5</option><option value="3.0.6">3.0.6</option><option value="3.1.0">3.1.0</option><option value="3.1.1">3.1.1</option><option value="3.1.2">3.1.2</option><option value="3.1.3">3.1.3</option><option value="3.2.0">3.2.0</option><option value="3.3.0">3.3.0</option><option value="3.4.0">3.4.0</option><option value="3.4.1">3.4.1</option><option value="4.0.0-alpha.0">4.0.0-alpha.0</option><option value="4.0.0">4.0.0</option><option value="4.0.1">4.0.1</option><option value="4.0.2">4.0.2</option><option value="4.0.3">4.0.3</option><option value="4.0.4">4.0.4</option><option value="4.1.0">4.1.0</option><option value="4.2.0">4.2.0</option><option value="4.2.1">4.2.1</option><option value="4.3.0">4.3.0</option><option value="4.3.1">4.3.1</option><option value="4.3.2">4.3.2</option><option value="4.3.3">4.3.3</option><option value="4.3.4">4.3.4</option><option value="4.3.5">4.3.5</option><option value="5.0.0-alpha.0">5.0.0-alpha.0</option><option value="5.0.0-alpha.1">5.0.0-alpha.1</option><option value="5.0.0-alpha.2">5.0.0-alpha.2</option><option value="5.0.0-beta.0">5.0.0-beta.0</option><option value="5.0.0-beta.1">5.0.0-beta.1</option><option value="5.0.0-beta.2">5.0.0-beta.2</option><option value="5.0.0-beta.3">5.0.0-beta.3</option><option value="5.0.0">5.0.0</option><option value="5.0.1">5.0.1</option><option value="5.0.2">5.0.2</option><option value="5.0.3">5.0.3</option><option value="5.0.4">5.0.4</option><option value="5.1.0">5.1.0</option><option value="5.1.1">5.1.1</option><option value="5.1.2">5.1.2</option><option value="5.1.3">5.1.3</option><option value="5.1.4">5.1.4</option><option value="5.2.0">5.2.0</option><option value="5.2.1">5.2.1</option><option value="6.0.0-alpha.0">6.0.0-alpha.0</option><option value="6.0.0">6.0.0</option><option value="6.0.1">6.0.1</option><option value="6.0.2">6.0.2</option><option value="6.0.3">6.0.3</option><option value="6.1.0">6.1.0</option><option value="6.1.1">6.1.1</option><option value="6.2.0">6.2.0</option><option value="6.2.1">6.2.1</option><option value="6.2.2">6.2.2</option><option value="6.2.3">6.2.3</option><option value="6.2.4">6.2.4</option><option value="6.2.5">6.2.5</option><option value="6.2.6">6.2.6</option><option value="6.2.7">6.2.7</option><option value="6.3.0">6.3.0</option><option value="6.3.1">6.3.1</option><option value="6.3.2">6.3.2</option><option value="6.3.3">6.3.3</option><option value="6.3.4">6.3.4</option><option value="6.3.5">6.3.5</option><option value="6.3.6">6.3.6</option><option selected="" value="6.3.7">6.3.7</option></select></label></p></header></div><style data-emotion-css="107j3ms">.css-107j3ms{max-width:940px;padding:0 20px;margin:0 auto;}@media (max-width:700px){.css-107j3ms{padding:0;margin:0;}}</style><div class="css-107j3ms"><style data-emotion-css="q3frg4">.css-q3frg4{border:1px solid #dfe2e5;border-radius:3px;}@media (max-width:700px){.css-q3frg4{border-right-width:0;border-left-width:0;}}</style><div class="css-q3frg4"><style data-emotion-css="10o5omr">.css-10o5omr{padding:10px;background:#f6f8fa;color:#424242;border:1px solid #d1d5da;border-top-left-radius:3px;border-top-right-radius:3px;margin:-1px -1px 0;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-direction:row;-ms-flex-direction:row;flex-direction:row;-webkit-align-items:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-pack:justify;-webkit-justify-content:space-between;-ms-flex-pack:justify;justify-content:space-between;}@media (max-width:700px){.css-10o5omr{padding-right:20px;padding-left:20px;}}</style><div class="css-10o5omr"><span>79.8 kB</span><span>JavaScript</span><span><style data-emotion-css="18x593j">.css-18x593j{display:inline-block;margin-left:8px;padding:2px 8px;-webkit-text-decoration:none;text-decoration:none;font-weight:600;font-size:0.9rem;color:#24292e;background-color:#eff3f6;border:1px solid rgba(27,31,35,.2);border-radius:3px;}.css-18x593j:hover{background-color:#e6ebf1;border-color:rgba(27,31,35,.35);}.css-18x593j:active{background-color:#e9ecef;border-color:rgba(27,31,35,.35);box-shadow:inset 0 0.15em 0.3em rgba(27,31,35,.15);}</style><a href="/tippy.js@6.3.7/dist/tippy-bundle.umd.js" class="css-18x593j">View Raw</a></span></div><style data-emotion-css="1i31ihw">.css-1i31ihw{overflow-x:auto;overflow-y:hidden;padding-top:5px;padding-bottom:5px;}</style><div class="code-listing css-1i31ihw"><style data-emotion-css="173nir8">.css-173nir8{border:none;border-collapse:collapse;border-spacing:0;}</style><table class="css-173nir8"><tbody><tr><style data-emotion-css="a4x74f">.css-a4x74f{padding-left:10px;padding-right:10px;color:rgba(27,31,35,.3);text-align:right;vertical-align:top;width:1%;min-width:50px;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;}</style><td id="L1" class="css-a4x74f"><span>1</span></td><style data-emotion-css="1dcdqdg">.css-1dcdqdg{padding-left:10px;padding-right:10px;color:#24292e;white-space:pre;}</style><td id="LC1" class="css-1dcdqdg"><code><span class="code-comment">/**!
</span></code></td></tr><tr><td id="L2" class="css-a4x74f"><span>2</span></td><td id="LC2" class="css-1dcdqdg"><code><span class="code-comment">* tippy.js v6.3.7
</span></code></td></tr><tr><td id="L3" class="css-a4x74f"><span>3</span></td><td id="LC3" class="css-1dcdqdg"><code><span class="code-comment">* (c) 2017-2021 atomiks
</span></code></td></tr><tr><td id="L4" class="css-a4x74f"><span>4</span></td><td id="LC4" class="css-1dcdqdg"><code><span class="code-comment">* MIT License
</span></code></td></tr><tr><td id="L5" class="css-a4x74f"><span>5</span></td><td id="LC5" class="css-1dcdqdg"><code><span class="code-comment">*/</span>
</code></td></tr><tr><td id="L6" class="css-a4x74f"><span>6</span></td><td id="LC6" class="css-1dcdqdg"><code>(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">global, factory</span>) </span>{
</code></td></tr><tr><td id="L7" class="css-a4x74f"><span>7</span></td><td id="LC7" class="css-1dcdqdg"><code>  <span class="code-keyword">typeof</span> exports === <span class="code-string">'object'</span> &amp;&amp; <span class="code-keyword">typeof</span> <span class="code-built_in">module</span> !== <span class="code-string">'undefined'</span> ? <span class="code-built_in">module</span>.exports = factory(<span class="code-built_in">require</span>(<span class="code-string">'@popperjs/core'</span>)) :
</code></td></tr><tr><td id="L8" class="css-a4x74f"><span>8</span></td><td id="LC8" class="css-1dcdqdg"><code>  <span class="code-keyword">typeof</span> define === <span class="code-string">'function'</span> &amp;&amp; define.amd ? define([<span class="code-string">'@popperjs/core'</span>], factory) :
</code></td></tr><tr><td id="L9" class="css-a4x74f"><span>9</span></td><td id="LC9" class="css-1dcdqdg"><code>  (global = global || self, global.tippy = factory(global.Popper));
</code></td></tr><tr><td id="L10" class="css-a4x74f"><span>10</span></td><td id="LC10" class="css-1dcdqdg"><code>}(<span class="code-keyword">this</span>, (<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">core</span>) </span>{ <span class="code-string">'use strict'</span>;
</code></td></tr><tr><td id="L11" class="css-a4x74f"><span>11</span></td><td id="LC11" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L12" class="css-a4x74f"><span>12</span></td><td id="LC12" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> css = <span class="code-string">".tippy-box[data-animation=fade][data-state=hidden]{opacity:0}[data-tippy-root]{max-width:calc(100vw - 10px)}.tippy-box{position:relative;background-color:#333;color:#fff;border-radius:4px;font-size:14px;line-height:1.4;white-space:normal;outline:0;transition-property:transform,visibility,opacity}.tippy-box[data-placement^=top]&gt;.tippy-arrow{bottom:0}.tippy-box[data-placement^=top]&gt;.tippy-arrow:before{bottom:-7px;left:0;border-width:8px 8px 0;border-top-color:initial;transform-origin:center top}.tippy-box[data-placement^=bottom]&gt;.tippy-arrow{top:0}.tippy-box[data-placement^=bottom]&gt;.tippy-arrow:before{top:-7px;left:0;border-width:0 8px 8px;border-bottom-color:initial;transform-origin:center bottom}.tippy-box[data-placement^=left]&gt;.tippy-arrow{right:0}.tippy-box[data-placement^=left]&gt;.tippy-arrow:before{border-width:8px 0 8px 8px;border-left-color:initial;right:-7px;transform-origin:center left}.tippy-box[data-placement^=right]&gt;.tippy-arrow{left:0}.tippy-box[data-placement^=right]&gt;.tippy-arrow:before{left:-7px;border-width:8px 8px 8px 0;border-right-color:initial;transform-origin:center right}.tippy-box[data-inertia][data-state=visible]{transition-timing-function:cubic-bezier(.54,1.5,.38,1.11)}.tippy-arrow{width:16px;height:16px;color:#333}.tippy-arrow:before{content:\"\";position:absolute;border-color:transparent;border-style:solid}.tippy-content{position:relative;padding:5px 9px;z-index:1}"</span>;
</code></td></tr><tr><td id="L13" class="css-a4x74f"><span>13</span></td><td id="LC13" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L14" class="css-a4x74f"><span>14</span></td><td id="LC14" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">injectCSS</span>(<span class="code-params">css</span>) </span>{
</code></td></tr><tr><td id="L15" class="css-a4x74f"><span>15</span></td><td id="LC15" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> style = <span class="code-built_in">document</span>.createElement(<span class="code-string">'style'</span>);
</code></td></tr><tr><td id="L16" class="css-a4x74f"><span>16</span></td><td id="LC16" class="css-1dcdqdg"><code>    style.textContent = css;
</code></td></tr><tr><td id="L17" class="css-a4x74f"><span>17</span></td><td id="LC17" class="css-1dcdqdg"><code>    style.setAttribute(<span class="code-string">'data-tippy-stylesheet'</span>, <span class="code-string">''</span>);
</code></td></tr><tr><td id="L18" class="css-a4x74f"><span>18</span></td><td id="LC18" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> head = <span class="code-built_in">document</span>.head;
</code></td></tr><tr><td id="L19" class="css-a4x74f"><span>19</span></td><td id="LC19" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> firstStyleOrLinkTag = <span class="code-built_in">document</span>.querySelector(<span class="code-string">'head&gt;style,head&gt;link'</span>);
</code></td></tr><tr><td id="L20" class="css-a4x74f"><span>20</span></td><td id="LC20" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L21" class="css-a4x74f"><span>21</span></td><td id="LC21" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (firstStyleOrLinkTag) {
</code></td></tr><tr><td id="L22" class="css-a4x74f"><span>22</span></td><td id="LC22" class="css-1dcdqdg"><code>      head.insertBefore(style, firstStyleOrLinkTag);
</code></td></tr><tr><td id="L23" class="css-a4x74f"><span>23</span></td><td id="LC23" class="css-1dcdqdg"><code>    } <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L24" class="css-a4x74f"><span>24</span></td><td id="LC24" class="css-1dcdqdg"><code>      head.appendChild(style);
</code></td></tr><tr><td id="L25" class="css-a4x74f"><span>25</span></td><td id="LC25" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L26" class="css-a4x74f"><span>26</span></td><td id="LC26" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L27" class="css-a4x74f"><span>27</span></td><td id="LC27" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L28" class="css-a4x74f"><span>28</span></td><td id="LC28" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> isBrowser = <span class="code-keyword">typeof</span> <span class="code-built_in">window</span> !== <span class="code-string">'undefined'</span> &amp;&amp; <span class="code-keyword">typeof</span> <span class="code-built_in">document</span> !== <span class="code-string">'undefined'</span>;
</code></td></tr><tr><td id="L29" class="css-a4x74f"><span>29</span></td><td id="LC29" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> isIE11 = isBrowser ? <span class="code-comment">// @ts-ignore</span>
</code></td></tr><tr><td id="L30" class="css-a4x74f"><span>30</span></td><td id="LC30" class="css-1dcdqdg"><code>  !!<span class="code-built_in">window</span>.msCrypto : <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L31" class="css-a4x74f"><span>31</span></td><td id="LC31" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L32" class="css-a4x74f"><span>32</span></td><td id="LC32" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> ROUND_ARROW = <span class="code-string">'&lt;svg width="16" height="6" xmlns="http://www.w3.org/2000/svg"&gt;&lt;path d="M0 6s1.796-.013 4.67-3.615C5.851.9 6.93.006 8 0c1.07-.006 2.148.887 3.343 2.385C14.233 6.005 16 6 16 6H0z"&gt;&lt;/svg&gt;'</span>;
</code></td></tr><tr><td id="L33" class="css-a4x74f"><span>33</span></td><td id="LC33" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> BOX_CLASS = <span class="code-string">"tippy-box"</span>;
</code></td></tr><tr><td id="L34" class="css-a4x74f"><span>34</span></td><td id="LC34" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> CONTENT_CLASS = <span class="code-string">"tippy-content"</span>;
</code></td></tr><tr><td id="L35" class="css-a4x74f"><span>35</span></td><td id="LC35" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> BACKDROP_CLASS = <span class="code-string">"tippy-backdrop"</span>;
</code></td></tr><tr><td id="L36" class="css-a4x74f"><span>36</span></td><td id="LC36" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> ARROW_CLASS = <span class="code-string">"tippy-arrow"</span>;
</code></td></tr><tr><td id="L37" class="css-a4x74f"><span>37</span></td><td id="LC37" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> SVG_ARROW_CLASS = <span class="code-string">"tippy-svg-arrow"</span>;
</code></td></tr><tr><td id="L38" class="css-a4x74f"><span>38</span></td><td id="LC38" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> TOUCH_OPTIONS = {
</code></td></tr><tr><td id="L39" class="css-a4x74f"><span>39</span></td><td id="LC39" class="css-1dcdqdg"><code>    passive: <span class="code-literal">true</span>,
</code></td></tr><tr><td id="L40" class="css-a4x74f"><span>40</span></td><td id="LC40" class="css-1dcdqdg"><code>    capture: <span class="code-literal">true</span>
</code></td></tr><tr><td id="L41" class="css-a4x74f"><span>41</span></td><td id="LC41" class="css-1dcdqdg"><code>  };
</code></td></tr><tr><td id="L42" class="css-a4x74f"><span>42</span></td><td id="LC42" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> TIPPY_DEFAULT_APPEND_TO = <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">TIPPY_DEFAULT_APPEND_TO</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L43" class="css-a4x74f"><span>43</span></td><td id="LC43" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> <span class="code-built_in">document</span>.body;
</code></td></tr><tr><td id="L44" class="css-a4x74f"><span>44</span></td><td id="LC44" class="css-1dcdqdg"><code>  };
</code></td></tr><tr><td id="L45" class="css-a4x74f"><span>45</span></td><td id="LC45" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L46" class="css-a4x74f"><span>46</span></td><td id="LC46" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">hasOwnProperty</span>(<span class="code-params">obj, key</span>) </span>{
</code></td></tr><tr><td id="L47" class="css-a4x74f"><span>47</span></td><td id="LC47" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> {}.hasOwnProperty.call(obj, key);
</code></td></tr><tr><td id="L48" class="css-a4x74f"><span>48</span></td><td id="LC48" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L49" class="css-a4x74f"><span>49</span></td><td id="LC49" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getValueAtIndexOrReturn</span>(<span class="code-params">value, index, defaultValue</span>) </span>{
</code></td></tr><tr><td id="L50" class="css-a4x74f"><span>50</span></td><td id="LC50" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (<span class="code-built_in">Array</span>.isArray(value)) {
</code></td></tr><tr><td id="L51" class="css-a4x74f"><span>51</span></td><td id="LC51" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> v = value[index];
</code></td></tr><tr><td id="L52" class="css-a4x74f"><span>52</span></td><td id="LC52" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> v == <span class="code-literal">null</span> ? <span class="code-built_in">Array</span>.isArray(defaultValue) ? defaultValue[index] : defaultValue : v;
</code></td></tr><tr><td id="L53" class="css-a4x74f"><span>53</span></td><td id="LC53" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L54" class="css-a4x74f"><span>54</span></td><td id="LC54" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L55" class="css-a4x74f"><span>55</span></td><td id="LC55" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> value;
</code></td></tr><tr><td id="L56" class="css-a4x74f"><span>56</span></td><td id="LC56" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L57" class="css-a4x74f"><span>57</span></td><td id="LC57" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">isType</span>(<span class="code-params">value, type</span>) </span>{
</code></td></tr><tr><td id="L58" class="css-a4x74f"><span>58</span></td><td id="LC58" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> str = {}.toString.call(value);
</code></td></tr><tr><td id="L59" class="css-a4x74f"><span>59</span></td><td id="LC59" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> str.indexOf(<span class="code-string">'[object'</span>) === <span class="code-number">0</span> &amp;&amp; str.indexOf(type + <span class="code-string">"]"</span>) &gt; <span class="code-number">-1</span>;
</code></td></tr><tr><td id="L60" class="css-a4x74f"><span>60</span></td><td id="LC60" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L61" class="css-a4x74f"><span>61</span></td><td id="LC61" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">invokeWithArgsOrReturn</span>(<span class="code-params">value, args</span>) </span>{
</code></td></tr><tr><td id="L62" class="css-a4x74f"><span>62</span></td><td id="LC62" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> <span class="code-keyword">typeof</span> value === <span class="code-string">'function'</span> ? value.apply(<span class="code-keyword">void</span> <span class="code-number">0</span>, args) : value;
</code></td></tr><tr><td id="L63" class="css-a4x74f"><span>63</span></td><td id="LC63" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L64" class="css-a4x74f"><span>64</span></td><td id="LC64" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">debounce</span>(<span class="code-params">fn, ms</span>) </span>{
</code></td></tr><tr><td id="L65" class="css-a4x74f"><span>65</span></td><td id="LC65" class="css-1dcdqdg"><code>    <span class="code-comment">// Avoid wrapping in `setTimeout` if ms is 0 anyway</span>
</code></td></tr><tr><td id="L66" class="css-a4x74f"><span>66</span></td><td id="LC66" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (ms === <span class="code-number">0</span>) {
</code></td></tr><tr><td id="L67" class="css-a4x74f"><span>67</span></td><td id="LC67" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> fn;
</code></td></tr><tr><td id="L68" class="css-a4x74f"><span>68</span></td><td id="LC68" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L69" class="css-a4x74f"><span>69</span></td><td id="LC69" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L70" class="css-a4x74f"><span>70</span></td><td id="LC70" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> timeout;
</code></td></tr><tr><td id="L71" class="css-a4x74f"><span>71</span></td><td id="LC71" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> <span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">arg</span>) </span>{
</code></td></tr><tr><td id="L72" class="css-a4x74f"><span>72</span></td><td id="LC72" class="css-1dcdqdg"><code>      clearTimeout(timeout);
</code></td></tr><tr><td id="L73" class="css-a4x74f"><span>73</span></td><td id="LC73" class="css-1dcdqdg"><code>      timeout = setTimeout(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L74" class="css-a4x74f"><span>74</span></td><td id="LC74" class="css-1dcdqdg"><code>        fn(arg);
</code></td></tr><tr><td id="L75" class="css-a4x74f"><span>75</span></td><td id="LC75" class="css-1dcdqdg"><code>      }, ms);
</code></td></tr><tr><td id="L76" class="css-a4x74f"><span>76</span></td><td id="LC76" class="css-1dcdqdg"><code>    };
</code></td></tr><tr><td id="L77" class="css-a4x74f"><span>77</span></td><td id="LC77" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L78" class="css-a4x74f"><span>78</span></td><td id="LC78" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">removeProperties</span>(<span class="code-params">obj, keys</span>) </span>{
</code></td></tr><tr><td id="L79" class="css-a4x74f"><span>79</span></td><td id="LC79" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> clone = <span class="code-built_in">Object</span>.assign({}, obj);
</code></td></tr><tr><td id="L80" class="css-a4x74f"><span>80</span></td><td id="LC80" class="css-1dcdqdg"><code>    keys.forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">key</span>) </span>{
</code></td></tr><tr><td id="L81" class="css-a4x74f"><span>81</span></td><td id="LC81" class="css-1dcdqdg"><code>      <span class="code-keyword">delete</span> clone[key];
</code></td></tr><tr><td id="L82" class="css-a4x74f"><span>82</span></td><td id="LC82" class="css-1dcdqdg"><code>    });
</code></td></tr><tr><td id="L83" class="css-a4x74f"><span>83</span></td><td id="LC83" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> clone;
</code></td></tr><tr><td id="L84" class="css-a4x74f"><span>84</span></td><td id="LC84" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L85" class="css-a4x74f"><span>85</span></td><td id="LC85" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">splitBySpaces</span>(<span class="code-params">value</span>) </span>{
</code></td></tr><tr><td id="L86" class="css-a4x74f"><span>86</span></td><td id="LC86" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> value.split(<span class="code-regexp">/\s+/</span>).filter(<span class="code-built_in">Boolean</span>);
</code></td></tr><tr><td id="L87" class="css-a4x74f"><span>87</span></td><td id="LC87" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L88" class="css-a4x74f"><span>88</span></td><td id="LC88" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">normalizeToArray</span>(<span class="code-params">value</span>) </span>{
</code></td></tr><tr><td id="L89" class="css-a4x74f"><span>89</span></td><td id="LC89" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> [].concat(value);
</code></td></tr><tr><td id="L90" class="css-a4x74f"><span>90</span></td><td id="LC90" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L91" class="css-a4x74f"><span>91</span></td><td id="LC91" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">pushIfUnique</span>(<span class="code-params">arr, value</span>) </span>{
</code></td></tr><tr><td id="L92" class="css-a4x74f"><span>92</span></td><td id="LC92" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (arr.indexOf(value) === <span class="code-number">-1</span>) {
</code></td></tr><tr><td id="L93" class="css-a4x74f"><span>93</span></td><td id="LC93" class="css-1dcdqdg"><code>      arr.push(value);
</code></td></tr><tr><td id="L94" class="css-a4x74f"><span>94</span></td><td id="LC94" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L95" class="css-a4x74f"><span>95</span></td><td id="LC95" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L96" class="css-a4x74f"><span>96</span></td><td id="LC96" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">unique</span>(<span class="code-params">arr</span>) </span>{
</code></td></tr><tr><td id="L97" class="css-a4x74f"><span>97</span></td><td id="LC97" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> arr.filter(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">item, index</span>) </span>{
</code></td></tr><tr><td id="L98" class="css-a4x74f"><span>98</span></td><td id="LC98" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> arr.indexOf(item) === index;
</code></td></tr><tr><td id="L99" class="css-a4x74f"><span>99</span></td><td id="LC99" class="css-1dcdqdg"><code>    });
</code></td></tr><tr><td id="L100" class="css-a4x74f"><span>100</span></td><td id="LC100" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L101" class="css-a4x74f"><span>101</span></td><td id="LC101" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getBasePlacement</span>(<span class="code-params">placement</span>) </span>{
</code></td></tr><tr><td id="L102" class="css-a4x74f"><span>102</span></td><td id="LC102" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> placement.split(<span class="code-string">'-'</span>)[<span class="code-number">0</span>];
</code></td></tr><tr><td id="L103" class="css-a4x74f"><span>103</span></td><td id="LC103" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L104" class="css-a4x74f"><span>104</span></td><td id="LC104" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">arrayFrom</span>(<span class="code-params">value</span>) </span>{
</code></td></tr><tr><td id="L105" class="css-a4x74f"><span>105</span></td><td id="LC105" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> [].slice.call(value);
</code></td></tr><tr><td id="L106" class="css-a4x74f"><span>106</span></td><td id="LC106" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L107" class="css-a4x74f"><span>107</span></td><td id="LC107" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">removeUndefinedProps</span>(<span class="code-params">obj</span>) </span>{
</code></td></tr><tr><td id="L108" class="css-a4x74f"><span>108</span></td><td id="LC108" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> <span class="code-built_in">Object</span>.keys(obj).reduce(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">acc, key</span>) </span>{
</code></td></tr><tr><td id="L109" class="css-a4x74f"><span>109</span></td><td id="LC109" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (obj[key] !== <span class="code-literal">undefined</span>) {
</code></td></tr><tr><td id="L110" class="css-a4x74f"><span>110</span></td><td id="LC110" class="css-1dcdqdg"><code>        acc[key] = obj[key];
</code></td></tr><tr><td id="L111" class="css-a4x74f"><span>111</span></td><td id="LC111" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L112" class="css-a4x74f"><span>112</span></td><td id="LC112" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L113" class="css-a4x74f"><span>113</span></td><td id="LC113" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> acc;
</code></td></tr><tr><td id="L114" class="css-a4x74f"><span>114</span></td><td id="LC114" class="css-1dcdqdg"><code>    }, {});
</code></td></tr><tr><td id="L115" class="css-a4x74f"><span>115</span></td><td id="LC115" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L116" class="css-a4x74f"><span>116</span></td><td id="LC116" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L117" class="css-a4x74f"><span>117</span></td><td id="LC117" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">div</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L118" class="css-a4x74f"><span>118</span></td><td id="LC118" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> <span class="code-built_in">document</span>.createElement(<span class="code-string">'div'</span>);
</code></td></tr><tr><td id="L119" class="css-a4x74f"><span>119</span></td><td id="LC119" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L120" class="css-a4x74f"><span>120</span></td><td id="LC120" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">isElement</span>(<span class="code-params">value</span>) </span>{
</code></td></tr><tr><td id="L121" class="css-a4x74f"><span>121</span></td><td id="LC121" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> [<span class="code-string">'Element'</span>, <span class="code-string">'Fragment'</span>].some(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">type</span>) </span>{
</code></td></tr><tr><td id="L122" class="css-a4x74f"><span>122</span></td><td id="LC122" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> isType(value, type);
</code></td></tr><tr><td id="L123" class="css-a4x74f"><span>123</span></td><td id="LC123" class="css-1dcdqdg"><code>    });
</code></td></tr><tr><td id="L124" class="css-a4x74f"><span>124</span></td><td id="LC124" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L125" class="css-a4x74f"><span>125</span></td><td id="LC125" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">isNodeList</span>(<span class="code-params">value</span>) </span>{
</code></td></tr><tr><td id="L126" class="css-a4x74f"><span>126</span></td><td id="LC126" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> isType(value, <span class="code-string">'NodeList'</span>);
</code></td></tr><tr><td id="L127" class="css-a4x74f"><span>127</span></td><td id="LC127" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L128" class="css-a4x74f"><span>128</span></td><td id="LC128" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">isMouseEvent</span>(<span class="code-params">value</span>) </span>{
</code></td></tr><tr><td id="L129" class="css-a4x74f"><span>129</span></td><td id="LC129" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> isType(value, <span class="code-string">'MouseEvent'</span>);
</code></td></tr><tr><td id="L130" class="css-a4x74f"><span>130</span></td><td id="LC130" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L131" class="css-a4x74f"><span>131</span></td><td id="LC131" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">isReferenceElement</span>(<span class="code-params">value</span>) </span>{
</code></td></tr><tr><td id="L132" class="css-a4x74f"><span>132</span></td><td id="LC132" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> !!(value &amp;&amp; value._tippy &amp;&amp; value._tippy.reference === value);
</code></td></tr><tr><td id="L133" class="css-a4x74f"><span>133</span></td><td id="LC133" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L134" class="css-a4x74f"><span>134</span></td><td id="LC134" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getArrayOfElements</span>(<span class="code-params">value</span>) </span>{
</code></td></tr><tr><td id="L135" class="css-a4x74f"><span>135</span></td><td id="LC135" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (isElement(value)) {
</code></td></tr><tr><td id="L136" class="css-a4x74f"><span>136</span></td><td id="LC136" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> [value];
</code></td></tr><tr><td id="L137" class="css-a4x74f"><span>137</span></td><td id="LC137" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L138" class="css-a4x74f"><span>138</span></td><td id="LC138" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L139" class="css-a4x74f"><span>139</span></td><td id="LC139" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (isNodeList(value)) {
</code></td></tr><tr><td id="L140" class="css-a4x74f"><span>140</span></td><td id="LC140" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> arrayFrom(value);
</code></td></tr><tr><td id="L141" class="css-a4x74f"><span>141</span></td><td id="LC141" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L142" class="css-a4x74f"><span>142</span></td><td id="LC142" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L143" class="css-a4x74f"><span>143</span></td><td id="LC143" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (<span class="code-built_in">Array</span>.isArray(value)) {
</code></td></tr><tr><td id="L144" class="css-a4x74f"><span>144</span></td><td id="LC144" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> value;
</code></td></tr><tr><td id="L145" class="css-a4x74f"><span>145</span></td><td id="LC145" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L146" class="css-a4x74f"><span>146</span></td><td id="LC146" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L147" class="css-a4x74f"><span>147</span></td><td id="LC147" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> arrayFrom(<span class="code-built_in">document</span>.querySelectorAll(value));
</code></td></tr><tr><td id="L148" class="css-a4x74f"><span>148</span></td><td id="LC148" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L149" class="css-a4x74f"><span>149</span></td><td id="LC149" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">setTransitionDuration</span>(<span class="code-params">els, value</span>) </span>{
</code></td></tr><tr><td id="L150" class="css-a4x74f"><span>150</span></td><td id="LC150" class="css-1dcdqdg"><code>    els.forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">el</span>) </span>{
</code></td></tr><tr><td id="L151" class="css-a4x74f"><span>151</span></td><td id="LC151" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (el) {
</code></td></tr><tr><td id="L152" class="css-a4x74f"><span>152</span></td><td id="LC152" class="css-1dcdqdg"><code>        el.style.transitionDuration = value + <span class="code-string">"ms"</span>;
</code></td></tr><tr><td id="L153" class="css-a4x74f"><span>153</span></td><td id="LC153" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L154" class="css-a4x74f"><span>154</span></td><td id="LC154" class="css-1dcdqdg"><code>    });
</code></td></tr><tr><td id="L155" class="css-a4x74f"><span>155</span></td><td id="LC155" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L156" class="css-a4x74f"><span>156</span></td><td id="LC156" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">setVisibilityState</span>(<span class="code-params">els, state</span>) </span>{
</code></td></tr><tr><td id="L157" class="css-a4x74f"><span>157</span></td><td id="LC157" class="css-1dcdqdg"><code>    els.forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">el</span>) </span>{
</code></td></tr><tr><td id="L158" class="css-a4x74f"><span>158</span></td><td id="LC158" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (el) {
</code></td></tr><tr><td id="L159" class="css-a4x74f"><span>159</span></td><td id="LC159" class="css-1dcdqdg"><code>        el.setAttribute(<span class="code-string">'data-state'</span>, state);
</code></td></tr><tr><td id="L160" class="css-a4x74f"><span>160</span></td><td id="LC160" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L161" class="css-a4x74f"><span>161</span></td><td id="LC161" class="css-1dcdqdg"><code>    });
</code></td></tr><tr><td id="L162" class="css-a4x74f"><span>162</span></td><td id="LC162" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L163" class="css-a4x74f"><span>163</span></td><td id="LC163" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getOwnerDocument</span>(<span class="code-params">elementOrElements</span>) </span>{
</code></td></tr><tr><td id="L164" class="css-a4x74f"><span>164</span></td><td id="LC164" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> _element$ownerDocumen;
</code></td></tr><tr><td id="L165" class="css-a4x74f"><span>165</span></td><td id="LC165" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L166" class="css-a4x74f"><span>166</span></td><td id="LC166" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> _normalizeToArray = normalizeToArray(elementOrElements),
</code></td></tr><tr><td id="L167" class="css-a4x74f"><span>167</span></td><td id="LC167" class="css-1dcdqdg"><code>        element = _normalizeToArray[<span class="code-number">0</span>]; <span class="code-comment">// Elements created via a &lt;template&gt; have an ownerDocument with no reference to the body</span>
</code></td></tr><tr><td id="L168" class="css-a4x74f"><span>168</span></td><td id="LC168" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L169" class="css-a4x74f"><span>169</span></td><td id="LC169" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L170" class="css-a4x74f"><span>170</span></td><td id="LC170" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> element != <span class="code-literal">null</span> &amp;&amp; (_element$ownerDocumen = element.ownerDocument) != <span class="code-literal">null</span> &amp;&amp; _element$ownerDocumen.body ? element.ownerDocument : <span class="code-built_in">document</span>;
</code></td></tr><tr><td id="L171" class="css-a4x74f"><span>171</span></td><td id="LC171" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L172" class="css-a4x74f"><span>172</span></td><td id="LC172" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">isCursorOutsideInteractiveBorder</span>(<span class="code-params">popperTreeData, event</span>) </span>{
</code></td></tr><tr><td id="L173" class="css-a4x74f"><span>173</span></td><td id="LC173" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> clientX = event.clientX,
</code></td></tr><tr><td id="L174" class="css-a4x74f"><span>174</span></td><td id="LC174" class="css-1dcdqdg"><code>        clientY = event.clientY;
</code></td></tr><tr><td id="L175" class="css-a4x74f"><span>175</span></td><td id="LC175" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> popperTreeData.every(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">_ref</span>) </span>{
</code></td></tr><tr><td id="L176" class="css-a4x74f"><span>176</span></td><td id="LC176" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> popperRect = _ref.popperRect,
</code></td></tr><tr><td id="L177" class="css-a4x74f"><span>177</span></td><td id="LC177" class="css-1dcdqdg"><code>          popperState = _ref.popperState,
</code></td></tr><tr><td id="L178" class="css-a4x74f"><span>178</span></td><td id="LC178" class="css-1dcdqdg"><code>          props = _ref.props;
</code></td></tr><tr><td id="L179" class="css-a4x74f"><span>179</span></td><td id="LC179" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> interactiveBorder = props.interactiveBorder;
</code></td></tr><tr><td id="L180" class="css-a4x74f"><span>180</span></td><td id="LC180" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> basePlacement = getBasePlacement(popperState.placement);
</code></td></tr><tr><td id="L181" class="css-a4x74f"><span>181</span></td><td id="LC181" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> offsetData = popperState.modifiersData.offset;
</code></td></tr><tr><td id="L182" class="css-a4x74f"><span>182</span></td><td id="LC182" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L183" class="css-a4x74f"><span>183</span></td><td id="LC183" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (!offsetData) {
</code></td></tr><tr><td id="L184" class="css-a4x74f"><span>184</span></td><td id="LC184" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L185" class="css-a4x74f"><span>185</span></td><td id="LC185" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L186" class="css-a4x74f"><span>186</span></td><td id="LC186" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L187" class="css-a4x74f"><span>187</span></td><td id="LC187" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> topDistance = basePlacement === <span class="code-string">'bottom'</span> ? offsetData.top.y : <span class="code-number">0</span>;
</code></td></tr><tr><td id="L188" class="css-a4x74f"><span>188</span></td><td id="LC188" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> bottomDistance = basePlacement === <span class="code-string">'top'</span> ? offsetData.bottom.y : <span class="code-number">0</span>;
</code></td></tr><tr><td id="L189" class="css-a4x74f"><span>189</span></td><td id="LC189" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> leftDistance = basePlacement === <span class="code-string">'right'</span> ? offsetData.left.x : <span class="code-number">0</span>;
</code></td></tr><tr><td id="L190" class="css-a4x74f"><span>190</span></td><td id="LC190" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> rightDistance = basePlacement === <span class="code-string">'left'</span> ? offsetData.right.x : <span class="code-number">0</span>;
</code></td></tr><tr><td id="L191" class="css-a4x74f"><span>191</span></td><td id="LC191" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> exceedsTop = popperRect.top - clientY + topDistance &gt; interactiveBorder;
</code></td></tr><tr><td id="L192" class="css-a4x74f"><span>192</span></td><td id="LC192" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> exceedsBottom = clientY - popperRect.bottom - bottomDistance &gt; interactiveBorder;
</code></td></tr><tr><td id="L193" class="css-a4x74f"><span>193</span></td><td id="LC193" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> exceedsLeft = popperRect.left - clientX + leftDistance &gt; interactiveBorder;
</code></td></tr><tr><td id="L194" class="css-a4x74f"><span>194</span></td><td id="LC194" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> exceedsRight = clientX - popperRect.right - rightDistance &gt; interactiveBorder;
</code></td></tr><tr><td id="L195" class="css-a4x74f"><span>195</span></td><td id="LC195" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> exceedsTop || exceedsBottom || exceedsLeft || exceedsRight;
</code></td></tr><tr><td id="L196" class="css-a4x74f"><span>196</span></td><td id="LC196" class="css-1dcdqdg"><code>    });
</code></td></tr><tr><td id="L197" class="css-a4x74f"><span>197</span></td><td id="LC197" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L198" class="css-a4x74f"><span>198</span></td><td id="LC198" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">updateTransitionEndListener</span>(<span class="code-params">box, action, listener</span>) </span>{
</code></td></tr><tr><td id="L199" class="css-a4x74f"><span>199</span></td><td id="LC199" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> method = action + <span class="code-string">"EventListener"</span>; <span class="code-comment">// some browsers apparently support `transition` (unprefixed) but only fire</span>
</code></td></tr><tr><td id="L200" class="css-a4x74f"><span>200</span></td><td id="LC200" class="css-1dcdqdg"><code>    <span class="code-comment">// `webkitTransitionEnd`...</span>
</code></td></tr><tr><td id="L201" class="css-a4x74f"><span>201</span></td><td id="LC201" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L202" class="css-a4x74f"><span>202</span></td><td id="LC202" class="css-1dcdqdg"><code>    [<span class="code-string">'transitionend'</span>, <span class="code-string">'webkitTransitionEnd'</span>].forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">event</span>) </span>{
</code></td></tr><tr><td id="L203" class="css-a4x74f"><span>203</span></td><td id="LC203" class="css-1dcdqdg"><code>      box[method](event, listener);
</code></td></tr><tr><td id="L204" class="css-a4x74f"><span>204</span></td><td id="LC204" class="css-1dcdqdg"><code>    });
</code></td></tr><tr><td id="L205" class="css-a4x74f"><span>205</span></td><td id="LC205" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L206" class="css-a4x74f"><span>206</span></td><td id="LC206" class="css-1dcdqdg"><code>  <span class="code-comment">/**
</span></code></td></tr><tr><td id="L207" class="css-a4x74f"><span>207</span></td><td id="LC207" class="css-1dcdqdg"><code><span class="code-comment">   * Compared to xxx.contains, this function works for dom structures with shadow
</span></code></td></tr><tr><td id="L208" class="css-a4x74f"><span>208</span></td><td id="LC208" class="css-1dcdqdg"><code><span class="code-comment">   * dom
</span></code></td></tr><tr><td id="L209" class="css-a4x74f"><span>209</span></td><td id="LC209" class="css-1dcdqdg"><code><span class="code-comment">   */</span>
</code></td></tr><tr><td id="L210" class="css-a4x74f"><span>210</span></td><td id="LC210" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L211" class="css-a4x74f"><span>211</span></td><td id="LC211" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">actualContains</span>(<span class="code-params">parent, child</span>) </span>{
</code></td></tr><tr><td id="L212" class="css-a4x74f"><span>212</span></td><td id="LC212" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> target = child;
</code></td></tr><tr><td id="L213" class="css-a4x74f"><span>213</span></td><td id="LC213" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L214" class="css-a4x74f"><span>214</span></td><td id="LC214" class="css-1dcdqdg"><code>    <span class="code-keyword">while</span> (target) {
</code></td></tr><tr><td id="L215" class="css-a4x74f"><span>215</span></td><td id="LC215" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> _target$getRootNode;
</code></td></tr><tr><td id="L216" class="css-a4x74f"><span>216</span></td><td id="LC216" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L217" class="css-a4x74f"><span>217</span></td><td id="LC217" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (parent.contains(target)) {
</code></td></tr><tr><td id="L218" class="css-a4x74f"><span>218</span></td><td id="LC218" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L219" class="css-a4x74f"><span>219</span></td><td id="LC219" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L220" class="css-a4x74f"><span>220</span></td><td id="LC220" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L221" class="css-a4x74f"><span>221</span></td><td id="LC221" class="css-1dcdqdg"><code>      target = target.getRootNode == <span class="code-literal">null</span> ? <span class="code-keyword">void</span> <span class="code-number">0</span> : (_target$getRootNode = target.getRootNode()) == <span class="code-literal">null</span> ? <span class="code-keyword">void</span> <span class="code-number">0</span> : _target$getRootNode.host;
</code></td></tr><tr><td id="L222" class="css-a4x74f"><span>222</span></td><td id="LC222" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L223" class="css-a4x74f"><span>223</span></td><td id="LC223" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L224" class="css-a4x74f"><span>224</span></td><td id="LC224" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L225" class="css-a4x74f"><span>225</span></td><td id="LC225" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L226" class="css-a4x74f"><span>226</span></td><td id="LC226" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L227" class="css-a4x74f"><span>227</span></td><td id="LC227" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> currentInput = {
</code></td></tr><tr><td id="L228" class="css-a4x74f"><span>228</span></td><td id="LC228" class="css-1dcdqdg"><code>    isTouch: <span class="code-literal">false</span>
</code></td></tr><tr><td id="L229" class="css-a4x74f"><span>229</span></td><td id="LC229" class="css-1dcdqdg"><code>  };
</code></td></tr><tr><td id="L230" class="css-a4x74f"><span>230</span></td><td id="LC230" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> lastMouseMoveTime = <span class="code-number">0</span>;
</code></td></tr><tr><td id="L231" class="css-a4x74f"><span>231</span></td><td id="LC231" class="css-1dcdqdg"><code>  <span class="code-comment">/**
</span></code></td></tr><tr><td id="L232" class="css-a4x74f"><span>232</span></td><td id="LC232" class="css-1dcdqdg"><code><span class="code-comment">   * When a `touchstart` event is fired, it's assumed the user is using touch
</span></code></td></tr><tr><td id="L233" class="css-a4x74f"><span>233</span></td><td id="LC233" class="css-1dcdqdg"><code><span class="code-comment">   * input. We'll bind a `mousemove` event listener to listen for mouse input in
</span></code></td></tr><tr><td id="L234" class="css-a4x74f"><span>234</span></td><td id="LC234" class="css-1dcdqdg"><code><span class="code-comment">   * the future. This way, the `isTouch` property is fully dynamic and will handle
</span></code></td></tr><tr><td id="L235" class="css-a4x74f"><span>235</span></td><td id="LC235" class="css-1dcdqdg"><code><span class="code-comment">   * hybrid devices that use a mix of touch + mouse input.
</span></code></td></tr><tr><td id="L236" class="css-a4x74f"><span>236</span></td><td id="LC236" class="css-1dcdqdg"><code><span class="code-comment">   */</span>
</code></td></tr><tr><td id="L237" class="css-a4x74f"><span>237</span></td><td id="LC237" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L238" class="css-a4x74f"><span>238</span></td><td id="LC238" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onDocumentTouchStart</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L239" class="css-a4x74f"><span>239</span></td><td id="LC239" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (currentInput.isTouch) {
</code></td></tr><tr><td id="L240" class="css-a4x74f"><span>240</span></td><td id="LC240" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L241" class="css-a4x74f"><span>241</span></td><td id="LC241" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L242" class="css-a4x74f"><span>242</span></td><td id="LC242" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L243" class="css-a4x74f"><span>243</span></td><td id="LC243" class="css-1dcdqdg"><code>    currentInput.isTouch = <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L244" class="css-a4x74f"><span>244</span></td><td id="LC244" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L245" class="css-a4x74f"><span>245</span></td><td id="LC245" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (<span class="code-built_in">window</span>.performance) {
</code></td></tr><tr><td id="L246" class="css-a4x74f"><span>246</span></td><td id="LC246" class="css-1dcdqdg"><code>      <span class="code-built_in">document</span>.addEventListener(<span class="code-string">'mousemove'</span>, onDocumentMouseMove);
</code></td></tr><tr><td id="L247" class="css-a4x74f"><span>247</span></td><td id="LC247" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L248" class="css-a4x74f"><span>248</span></td><td id="LC248" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L249" class="css-a4x74f"><span>249</span></td><td id="LC249" class="css-1dcdqdg"><code>  <span class="code-comment">/**
</span></code></td></tr><tr><td id="L250" class="css-a4x74f"><span>250</span></td><td id="LC250" class="css-1dcdqdg"><code><span class="code-comment">   * When two `mousemove` event are fired consecutively within 20ms, it's assumed
</span></code></td></tr><tr><td id="L251" class="css-a4x74f"><span>251</span></td><td id="LC251" class="css-1dcdqdg"><code><span class="code-comment">   * the user is using mouse input again. `mousemove` can fire on touch devices as
</span></code></td></tr><tr><td id="L252" class="css-a4x74f"><span>252</span></td><td id="LC252" class="css-1dcdqdg"><code><span class="code-comment">   * well, but very rarely that quickly.
</span></code></td></tr><tr><td id="L253" class="css-a4x74f"><span>253</span></td><td id="LC253" class="css-1dcdqdg"><code><span class="code-comment">   */</span>
</code></td></tr><tr><td id="L254" class="css-a4x74f"><span>254</span></td><td id="LC254" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L255" class="css-a4x74f"><span>255</span></td><td id="LC255" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onDocumentMouseMove</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L256" class="css-a4x74f"><span>256</span></td><td id="LC256" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> now = performance.now();
</code></td></tr><tr><td id="L257" class="css-a4x74f"><span>257</span></td><td id="LC257" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L258" class="css-a4x74f"><span>258</span></td><td id="LC258" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (now - lastMouseMoveTime &lt; <span class="code-number">20</span>) {
</code></td></tr><tr><td id="L259" class="css-a4x74f"><span>259</span></td><td id="LC259" class="css-1dcdqdg"><code>      currentInput.isTouch = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L260" class="css-a4x74f"><span>260</span></td><td id="LC260" class="css-1dcdqdg"><code>      <span class="code-built_in">document</span>.removeEventListener(<span class="code-string">'mousemove'</span>, onDocumentMouseMove);
</code></td></tr><tr><td id="L261" class="css-a4x74f"><span>261</span></td><td id="LC261" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L262" class="css-a4x74f"><span>262</span></td><td id="LC262" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L263" class="css-a4x74f"><span>263</span></td><td id="LC263" class="css-1dcdqdg"><code>    lastMouseMoveTime = now;
</code></td></tr><tr><td id="L264" class="css-a4x74f"><span>264</span></td><td id="LC264" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L265" class="css-a4x74f"><span>265</span></td><td id="LC265" class="css-1dcdqdg"><code>  <span class="code-comment">/**
</span></code></td></tr><tr><td id="L266" class="css-a4x74f"><span>266</span></td><td id="LC266" class="css-1dcdqdg"><code><span class="code-comment">   * When an element is in focus and has a tippy, leaving the tab/window and
</span></code></td></tr><tr><td id="L267" class="css-a4x74f"><span>267</span></td><td id="LC267" class="css-1dcdqdg"><code><span class="code-comment">   * returning causes it to show again. For mouse users this is unexpected, but
</span></code></td></tr><tr><td id="L268" class="css-a4x74f"><span>268</span></td><td id="LC268" class="css-1dcdqdg"><code><span class="code-comment">   * for keyboard use it makes sense.
</span></code></td></tr><tr><td id="L269" class="css-a4x74f"><span>269</span></td><td id="LC269" class="css-1dcdqdg"><code><span class="code-comment">   * <span class="code-doctag">TODO:</span> find a better technique to solve this problem
</span></code></td></tr><tr><td id="L270" class="css-a4x74f"><span>270</span></td><td id="LC270" class="css-1dcdqdg"><code><span class="code-comment">   */</span>
</code></td></tr><tr><td id="L271" class="css-a4x74f"><span>271</span></td><td id="LC271" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L272" class="css-a4x74f"><span>272</span></td><td id="LC272" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onWindowBlur</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L273" class="css-a4x74f"><span>273</span></td><td id="LC273" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> activeElement = <span class="code-built_in">document</span>.activeElement;
</code></td></tr><tr><td id="L274" class="css-a4x74f"><span>274</span></td><td id="LC274" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L275" class="css-a4x74f"><span>275</span></td><td id="LC275" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (isReferenceElement(activeElement)) {
</code></td></tr><tr><td id="L276" class="css-a4x74f"><span>276</span></td><td id="LC276" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> instance = activeElement._tippy;
</code></td></tr><tr><td id="L277" class="css-a4x74f"><span>277</span></td><td id="LC277" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L278" class="css-a4x74f"><span>278</span></td><td id="LC278" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (activeElement.blur &amp;&amp; !instance.state.isVisible) {
</code></td></tr><tr><td id="L279" class="css-a4x74f"><span>279</span></td><td id="LC279" class="css-1dcdqdg"><code>        activeElement.blur();
</code></td></tr><tr><td id="L280" class="css-a4x74f"><span>280</span></td><td id="LC280" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L281" class="css-a4x74f"><span>281</span></td><td id="LC281" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L282" class="css-a4x74f"><span>282</span></td><td id="LC282" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L283" class="css-a4x74f"><span>283</span></td><td id="LC283" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">bindGlobalEventListeners</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L284" class="css-a4x74f"><span>284</span></td><td id="LC284" class="css-1dcdqdg"><code>    <span class="code-built_in">document</span>.addEventListener(<span class="code-string">'touchstart'</span>, onDocumentTouchStart, TOUCH_OPTIONS);
</code></td></tr><tr><td id="L285" class="css-a4x74f"><span>285</span></td><td id="LC285" class="css-1dcdqdg"><code>    <span class="code-built_in">window</span>.addEventListener(<span class="code-string">'blur'</span>, onWindowBlur);
</code></td></tr><tr><td id="L286" class="css-a4x74f"><span>286</span></td><td id="LC286" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L287" class="css-a4x74f"><span>287</span></td><td id="LC287" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L288" class="css-a4x74f"><span>288</span></td><td id="LC288" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">createMemoryLeakWarning</span>(<span class="code-params">method</span>) </span>{
</code></td></tr><tr><td id="L289" class="css-a4x74f"><span>289</span></td><td id="LC289" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> txt = method === <span class="code-string">'destroy'</span> ? <span class="code-string">'n already-'</span> : <span class="code-string">' '</span>;
</code></td></tr><tr><td id="L290" class="css-a4x74f"><span>290</span></td><td id="LC290" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> [method + <span class="code-string">"() was called on a"</span> + txt + <span class="code-string">"destroyed instance. This is a no-op but"</span>, <span class="code-string">'indicates a potential memory leak.'</span>].join(<span class="code-string">' '</span>);
</code></td></tr><tr><td id="L291" class="css-a4x74f"><span>291</span></td><td id="LC291" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L292" class="css-a4x74f"><span>292</span></td><td id="LC292" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">clean</span>(<span class="code-params">value</span>) </span>{
</code></td></tr><tr><td id="L293" class="css-a4x74f"><span>293</span></td><td id="LC293" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> spacesAndTabs = <span class="code-regexp">/[ \t]{2,}/g</span>;
</code></td></tr><tr><td id="L294" class="css-a4x74f"><span>294</span></td><td id="LC294" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> lineStartWithSpaces = <span class="code-regexp">/^[ \t]*/gm</span>;
</code></td></tr><tr><td id="L295" class="css-a4x74f"><span>295</span></td><td id="LC295" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> value.replace(spacesAndTabs, <span class="code-string">' '</span>).replace(lineStartWithSpaces, <span class="code-string">''</span>).trim();
</code></td></tr><tr><td id="L296" class="css-a4x74f"><span>296</span></td><td id="LC296" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L297" class="css-a4x74f"><span>297</span></td><td id="LC297" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L298" class="css-a4x74f"><span>298</span></td><td id="LC298" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getDevMessage</span>(<span class="code-params">message</span>) </span>{
</code></td></tr><tr><td id="L299" class="css-a4x74f"><span>299</span></td><td id="LC299" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> clean(<span class="code-string">"\n  %ctippy.js\n\n  %c"</span> + clean(message) + <span class="code-string">"\n\n  %c\uD83D\uDC77\u200D This is a development-only message. It will be removed in production.\n  "</span>);
</code></td></tr><tr><td id="L300" class="css-a4x74f"><span>300</span></td><td id="LC300" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L301" class="css-a4x74f"><span>301</span></td><td id="LC301" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L302" class="css-a4x74f"><span>302</span></td><td id="LC302" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getFormattedMessage</span>(<span class="code-params">message</span>) </span>{
</code></td></tr><tr><td id="L303" class="css-a4x74f"><span>303</span></td><td id="LC303" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> [getDevMessage(message), <span class="code-comment">// title</span>
</code></td></tr><tr><td id="L304" class="css-a4x74f"><span>304</span></td><td id="LC304" class="css-1dcdqdg"><code>    <span class="code-string">'color: #00C584; font-size: 1.3em; font-weight: bold;'</span>, <span class="code-comment">// message</span>
</code></td></tr><tr><td id="L305" class="css-a4x74f"><span>305</span></td><td id="LC305" class="css-1dcdqdg"><code>    <span class="code-string">'line-height: 1.5'</span>, <span class="code-comment">// footer</span>
</code></td></tr><tr><td id="L306" class="css-a4x74f"><span>306</span></td><td id="LC306" class="css-1dcdqdg"><code>    <span class="code-string">'color: #a6a095;'</span>];
</code></td></tr><tr><td id="L307" class="css-a4x74f"><span>307</span></td><td id="LC307" class="css-1dcdqdg"><code>  } <span class="code-comment">// Assume warnings and errors never have the same message</span>
</code></td></tr><tr><td id="L308" class="css-a4x74f"><span>308</span></td><td id="LC308" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L309" class="css-a4x74f"><span>309</span></td><td id="LC309" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> visitedMessages;
</code></td></tr><tr><td id="L310" class="css-a4x74f"><span>310</span></td><td id="LC310" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L311" class="css-a4x74f"><span>311</span></td><td id="LC311" class="css-1dcdqdg"><code>  {
</code></td></tr><tr><td id="L312" class="css-a4x74f"><span>312</span></td><td id="LC312" class="css-1dcdqdg"><code>    resetVisitedMessages();
</code></td></tr><tr><td id="L313" class="css-a4x74f"><span>313</span></td><td id="LC313" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L314" class="css-a4x74f"><span>314</span></td><td id="LC314" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L315" class="css-a4x74f"><span>315</span></td><td id="LC315" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">resetVisitedMessages</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L316" class="css-a4x74f"><span>316</span></td><td id="LC316" class="css-1dcdqdg"><code>    visitedMessages = <span class="code-keyword">new</span> <span class="code-built_in">Set</span>();
</code></td></tr><tr><td id="L317" class="css-a4x74f"><span>317</span></td><td id="LC317" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L318" class="css-a4x74f"><span>318</span></td><td id="LC318" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">warnWhen</span>(<span class="code-params">condition, message</span>) </span>{
</code></td></tr><tr><td id="L319" class="css-a4x74f"><span>319</span></td><td id="LC319" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (condition &amp;&amp; !visitedMessages.has(message)) {
</code></td></tr><tr><td id="L320" class="css-a4x74f"><span>320</span></td><td id="LC320" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> _console;
</code></td></tr><tr><td id="L321" class="css-a4x74f"><span>321</span></td><td id="LC321" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L322" class="css-a4x74f"><span>322</span></td><td id="LC322" class="css-1dcdqdg"><code>      visitedMessages.add(message);
</code></td></tr><tr><td id="L323" class="css-a4x74f"><span>323</span></td><td id="LC323" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L324" class="css-a4x74f"><span>324</span></td><td id="LC324" class="css-1dcdqdg"><code>      (_console = <span class="code-built_in">console</span>).warn.apply(_console, getFormattedMessage(message));
</code></td></tr><tr><td id="L325" class="css-a4x74f"><span>325</span></td><td id="LC325" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L326" class="css-a4x74f"><span>326</span></td><td id="LC326" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L327" class="css-a4x74f"><span>327</span></td><td id="LC327" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">errorWhen</span>(<span class="code-params">condition, message</span>) </span>{
</code></td></tr><tr><td id="L328" class="css-a4x74f"><span>328</span></td><td id="LC328" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (condition &amp;&amp; !visitedMessages.has(message)) {
</code></td></tr><tr><td id="L329" class="css-a4x74f"><span>329</span></td><td id="LC329" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> _console2;
</code></td></tr><tr><td id="L330" class="css-a4x74f"><span>330</span></td><td id="LC330" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L331" class="css-a4x74f"><span>331</span></td><td id="LC331" class="css-1dcdqdg"><code>      visitedMessages.add(message);
</code></td></tr><tr><td id="L332" class="css-a4x74f"><span>332</span></td><td id="LC332" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L333" class="css-a4x74f"><span>333</span></td><td id="LC333" class="css-1dcdqdg"><code>      (_console2 = <span class="code-built_in">console</span>).error.apply(_console2, getFormattedMessage(message));
</code></td></tr><tr><td id="L334" class="css-a4x74f"><span>334</span></td><td id="LC334" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L335" class="css-a4x74f"><span>335</span></td><td id="LC335" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L336" class="css-a4x74f"><span>336</span></td><td id="LC336" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">validateTargets</span>(<span class="code-params">targets</span>) </span>{
</code></td></tr><tr><td id="L337" class="css-a4x74f"><span>337</span></td><td id="LC337" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> didPassFalsyValue = !targets;
</code></td></tr><tr><td id="L338" class="css-a4x74f"><span>338</span></td><td id="LC338" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> didPassPlainObject = <span class="code-built_in">Object</span>.prototype.toString.call(targets) === <span class="code-string">'[object Object]'</span> &amp;&amp; !targets.addEventListener;
</code></td></tr><tr><td id="L339" class="css-a4x74f"><span>339</span></td><td id="LC339" class="css-1dcdqdg"><code>    errorWhen(didPassFalsyValue, [<span class="code-string">'tippy() was passed'</span>, <span class="code-string">'`'</span> + <span class="code-built_in">String</span>(targets) + <span class="code-string">'`'</span>, <span class="code-string">'as its targets (first) argument. Valid types are: String, Element,'</span>, <span class="code-string">'Element[], or NodeList.'</span>].join(<span class="code-string">' '</span>));
</code></td></tr><tr><td id="L340" class="css-a4x74f"><span>340</span></td><td id="LC340" class="css-1dcdqdg"><code>    errorWhen(didPassPlainObject, [<span class="code-string">'tippy() was passed a plain object which is not supported as an argument'</span>, <span class="code-string">'for virtual positioning. Use props.getReferenceClientRect instead.'</span>].join(<span class="code-string">' '</span>));
</code></td></tr><tr><td id="L341" class="css-a4x74f"><span>341</span></td><td id="LC341" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L342" class="css-a4x74f"><span>342</span></td><td id="LC342" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L343" class="css-a4x74f"><span>343</span></td><td id="LC343" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> pluginProps = {
</code></td></tr><tr><td id="L344" class="css-a4x74f"><span>344</span></td><td id="LC344" class="css-1dcdqdg"><code>    animateFill: <span class="code-literal">false</span>,
</code></td></tr><tr><td id="L345" class="css-a4x74f"><span>345</span></td><td id="LC345" class="css-1dcdqdg"><code>    followCursor: <span class="code-literal">false</span>,
</code></td></tr><tr><td id="L346" class="css-a4x74f"><span>346</span></td><td id="LC346" class="css-1dcdqdg"><code>    inlinePositioning: <span class="code-literal">false</span>,
</code></td></tr><tr><td id="L347" class="css-a4x74f"><span>347</span></td><td id="LC347" class="css-1dcdqdg"><code>    sticky: <span class="code-literal">false</span>
</code></td></tr><tr><td id="L348" class="css-a4x74f"><span>348</span></td><td id="LC348" class="css-1dcdqdg"><code>  };
</code></td></tr><tr><td id="L349" class="css-a4x74f"><span>349</span></td><td id="LC349" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> renderProps = {
</code></td></tr><tr><td id="L350" class="css-a4x74f"><span>350</span></td><td id="LC350" class="css-1dcdqdg"><code>    allowHTML: <span class="code-literal">false</span>,
</code></td></tr><tr><td id="L351" class="css-a4x74f"><span>351</span></td><td id="LC351" class="css-1dcdqdg"><code>    animation: <span class="code-string">'fade'</span>,
</code></td></tr><tr><td id="L352" class="css-a4x74f"><span>352</span></td><td id="LC352" class="css-1dcdqdg"><code>    arrow: <span class="code-literal">true</span>,
</code></td></tr><tr><td id="L353" class="css-a4x74f"><span>353</span></td><td id="LC353" class="css-1dcdqdg"><code>    content: <span class="code-string">''</span>,
</code></td></tr><tr><td id="L354" class="css-a4x74f"><span>354</span></td><td id="LC354" class="css-1dcdqdg"><code>    inertia: <span class="code-literal">false</span>,
</code></td></tr><tr><td id="L355" class="css-a4x74f"><span>355</span></td><td id="LC355" class="css-1dcdqdg"><code>    maxWidth: <span class="code-number">350</span>,
</code></td></tr><tr><td id="L356" class="css-a4x74f"><span>356</span></td><td id="LC356" class="css-1dcdqdg"><code>    role: <span class="code-string">'tooltip'</span>,
</code></td></tr><tr><td id="L357" class="css-a4x74f"><span>357</span></td><td id="LC357" class="css-1dcdqdg"><code>    theme: <span class="code-string">''</span>,
</code></td></tr><tr><td id="L358" class="css-a4x74f"><span>358</span></td><td id="LC358" class="css-1dcdqdg"><code>    zIndex: <span class="code-number">9999</span>
</code></td></tr><tr><td id="L359" class="css-a4x74f"><span>359</span></td><td id="LC359" class="css-1dcdqdg"><code>  };
</code></td></tr><tr><td id="L360" class="css-a4x74f"><span>360</span></td><td id="LC360" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> defaultProps = <span class="code-built_in">Object</span>.assign({
</code></td></tr><tr><td id="L361" class="css-a4x74f"><span>361</span></td><td id="LC361" class="css-1dcdqdg"><code>    appendTo: TIPPY_DEFAULT_APPEND_TO,
</code></td></tr><tr><td id="L362" class="css-a4x74f"><span>362</span></td><td id="LC362" class="css-1dcdqdg"><code>    aria: {
</code></td></tr><tr><td id="L363" class="css-a4x74f"><span>363</span></td><td id="LC363" class="css-1dcdqdg"><code>      content: <span class="code-string">'auto'</span>,
</code></td></tr><tr><td id="L364" class="css-a4x74f"><span>364</span></td><td id="LC364" class="css-1dcdqdg"><code>      expanded: <span class="code-string">'auto'</span>
</code></td></tr><tr><td id="L365" class="css-a4x74f"><span>365</span></td><td id="LC365" class="css-1dcdqdg"><code>    },
</code></td></tr><tr><td id="L366" class="css-a4x74f"><span>366</span></td><td id="LC366" class="css-1dcdqdg"><code>    delay: <span class="code-number">0</span>,
</code></td></tr><tr><td id="L367" class="css-a4x74f"><span>367</span></td><td id="LC367" class="css-1dcdqdg"><code>    duration: [<span class="code-number">300</span>, <span class="code-number">250</span>],
</code></td></tr><tr><td id="L368" class="css-a4x74f"><span>368</span></td><td id="LC368" class="css-1dcdqdg"><code>    getReferenceClientRect: <span class="code-literal">null</span>,
</code></td></tr><tr><td id="L369" class="css-a4x74f"><span>369</span></td><td id="LC369" class="css-1dcdqdg"><code>    hideOnClick: <span class="code-literal">true</span>,
</code></td></tr><tr><td id="L370" class="css-a4x74f"><span>370</span></td><td id="LC370" class="css-1dcdqdg"><code>    ignoreAttributes: <span class="code-literal">false</span>,
</code></td></tr><tr><td id="L371" class="css-a4x74f"><span>371</span></td><td id="LC371" class="css-1dcdqdg"><code>    interactive: <span class="code-literal">false</span>,
</code></td></tr><tr><td id="L372" class="css-a4x74f"><span>372</span></td><td id="LC372" class="css-1dcdqdg"><code>    interactiveBorder: <span class="code-number">2</span>,
</code></td></tr><tr><td id="L373" class="css-a4x74f"><span>373</span></td><td id="LC373" class="css-1dcdqdg"><code>    interactiveDebounce: <span class="code-number">0</span>,
</code></td></tr><tr><td id="L374" class="css-a4x74f"><span>374</span></td><td id="LC374" class="css-1dcdqdg"><code>    moveTransition: <span class="code-string">''</span>,
</code></td></tr><tr><td id="L375" class="css-a4x74f"><span>375</span></td><td id="LC375" class="css-1dcdqdg"><code>    offset: [<span class="code-number">0</span>, <span class="code-number">10</span>],
</code></td></tr><tr><td id="L376" class="css-a4x74f"><span>376</span></td><td id="LC376" class="css-1dcdqdg"><code>    onAfterUpdate: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onAfterUpdate</span>(<span class="code-params"></span>) </span>{},
</code></td></tr><tr><td id="L377" class="css-a4x74f"><span>377</span></td><td id="LC377" class="css-1dcdqdg"><code>    onBeforeUpdate: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onBeforeUpdate</span>(<span class="code-params"></span>) </span>{},
</code></td></tr><tr><td id="L378" class="css-a4x74f"><span>378</span></td><td id="LC378" class="css-1dcdqdg"><code>    onCreate: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onCreate</span>(<span class="code-params"></span>) </span>{},
</code></td></tr><tr><td id="L379" class="css-a4x74f"><span>379</span></td><td id="LC379" class="css-1dcdqdg"><code>    onDestroy: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onDestroy</span>(<span class="code-params"></span>) </span>{},
</code></td></tr><tr><td id="L380" class="css-a4x74f"><span>380</span></td><td id="LC380" class="css-1dcdqdg"><code>    onHidden: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onHidden</span>(<span class="code-params"></span>) </span>{},
</code></td></tr><tr><td id="L381" class="css-a4x74f"><span>381</span></td><td id="LC381" class="css-1dcdqdg"><code>    onHide: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onHide</span>(<span class="code-params"></span>) </span>{},
</code></td></tr><tr><td id="L382" class="css-a4x74f"><span>382</span></td><td id="LC382" class="css-1dcdqdg"><code>    onMount: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onMount</span>(<span class="code-params"></span>) </span>{},
</code></td></tr><tr><td id="L383" class="css-a4x74f"><span>383</span></td><td id="LC383" class="css-1dcdqdg"><code>    onShow: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onShow</span>(<span class="code-params"></span>) </span>{},
</code></td></tr><tr><td id="L384" class="css-a4x74f"><span>384</span></td><td id="LC384" class="css-1dcdqdg"><code>    onShown: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onShown</span>(<span class="code-params"></span>) </span>{},
</code></td></tr><tr><td id="L385" class="css-a4x74f"><span>385</span></td><td id="LC385" class="css-1dcdqdg"><code>    onTrigger: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onTrigger</span>(<span class="code-params"></span>) </span>{},
</code></td></tr><tr><td id="L386" class="css-a4x74f"><span>386</span></td><td id="LC386" class="css-1dcdqdg"><code>    onUntrigger: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onUntrigger</span>(<span class="code-params"></span>) </span>{},
</code></td></tr><tr><td id="L387" class="css-a4x74f"><span>387</span></td><td id="LC387" class="css-1dcdqdg"><code>    onClickOutside: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onClickOutside</span>(<span class="code-params"></span>) </span>{},
</code></td></tr><tr><td id="L388" class="css-a4x74f"><span>388</span></td><td id="LC388" class="css-1dcdqdg"><code>    placement: <span class="code-string">'top'</span>,
</code></td></tr><tr><td id="L389" class="css-a4x74f"><span>389</span></td><td id="LC389" class="css-1dcdqdg"><code>    plugins: [],
</code></td></tr><tr><td id="L390" class="css-a4x74f"><span>390</span></td><td id="LC390" class="css-1dcdqdg"><code>    popperOptions: {},
</code></td></tr><tr><td id="L391" class="css-a4x74f"><span>391</span></td><td id="LC391" class="css-1dcdqdg"><code>    render: <span class="code-literal">null</span>,
</code></td></tr><tr><td id="L392" class="css-a4x74f"><span>392</span></td><td id="LC392" class="css-1dcdqdg"><code>    showOnCreate: <span class="code-literal">false</span>,
</code></td></tr><tr><td id="L393" class="css-a4x74f"><span>393</span></td><td id="LC393" class="css-1dcdqdg"><code>    touch: <span class="code-literal">true</span>,
</code></td></tr><tr><td id="L394" class="css-a4x74f"><span>394</span></td><td id="LC394" class="css-1dcdqdg"><code>    trigger: <span class="code-string">'mouseenter focus'</span>,
</code></td></tr><tr><td id="L395" class="css-a4x74f"><span>395</span></td><td id="LC395" class="css-1dcdqdg"><code>    triggerTarget: <span class="code-literal">null</span>
</code></td></tr><tr><td id="L396" class="css-a4x74f"><span>396</span></td><td id="LC396" class="css-1dcdqdg"><code>  }, pluginProps, renderProps);
</code></td></tr><tr><td id="L397" class="css-a4x74f"><span>397</span></td><td id="LC397" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> defaultKeys = <span class="code-built_in">Object</span>.keys(defaultProps);
</code></td></tr><tr><td id="L398" class="css-a4x74f"><span>398</span></td><td id="LC398" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> setDefaultProps = <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">setDefaultProps</span>(<span class="code-params">partialProps</span>) </span>{
</code></td></tr><tr><td id="L399" class="css-a4x74f"><span>399</span></td><td id="LC399" class="css-1dcdqdg"><code>    <span class="code-comment">/* istanbul ignore else */</span>
</code></td></tr><tr><td id="L400" class="css-a4x74f"><span>400</span></td><td id="LC400" class="css-1dcdqdg"><code>    {
</code></td></tr><tr><td id="L401" class="css-a4x74f"><span>401</span></td><td id="LC401" class="css-1dcdqdg"><code>      validateProps(partialProps, []);
</code></td></tr><tr><td id="L402" class="css-a4x74f"><span>402</span></td><td id="LC402" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L403" class="css-a4x74f"><span>403</span></td><td id="LC403" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L404" class="css-a4x74f"><span>404</span></td><td id="LC404" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> keys = <span class="code-built_in">Object</span>.keys(partialProps);
</code></td></tr><tr><td id="L405" class="css-a4x74f"><span>405</span></td><td id="LC405" class="css-1dcdqdg"><code>    keys.forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">key</span>) </span>{
</code></td></tr><tr><td id="L406" class="css-a4x74f"><span>406</span></td><td id="LC406" class="css-1dcdqdg"><code>      defaultProps[key] = partialProps[key];
</code></td></tr><tr><td id="L407" class="css-a4x74f"><span>407</span></td><td id="LC407" class="css-1dcdqdg"><code>    });
</code></td></tr><tr><td id="L408" class="css-a4x74f"><span>408</span></td><td id="LC408" class="css-1dcdqdg"><code>  };
</code></td></tr><tr><td id="L409" class="css-a4x74f"><span>409</span></td><td id="LC409" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getExtendedPassedProps</span>(<span class="code-params">passedProps</span>) </span>{
</code></td></tr><tr><td id="L410" class="css-a4x74f"><span>410</span></td><td id="LC410" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> plugins = passedProps.plugins || [];
</code></td></tr><tr><td id="L411" class="css-a4x74f"><span>411</span></td><td id="LC411" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> pluginProps = plugins.reduce(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">acc, plugin</span>) </span>{
</code></td></tr><tr><td id="L412" class="css-a4x74f"><span>412</span></td><td id="LC412" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> name = plugin.name,
</code></td></tr><tr><td id="L413" class="css-a4x74f"><span>413</span></td><td id="LC413" class="css-1dcdqdg"><code>          defaultValue = plugin.defaultValue;
</code></td></tr><tr><td id="L414" class="css-a4x74f"><span>414</span></td><td id="LC414" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L415" class="css-a4x74f"><span>415</span></td><td id="LC415" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (name) {
</code></td></tr><tr><td id="L416" class="css-a4x74f"><span>416</span></td><td id="LC416" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> _name;
</code></td></tr><tr><td id="L417" class="css-a4x74f"><span>417</span></td><td id="LC417" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L418" class="css-a4x74f"><span>418</span></td><td id="LC418" class="css-1dcdqdg"><code>        acc[name] = passedProps[name] !== <span class="code-literal">undefined</span> ? passedProps[name] : (_name = defaultProps[name]) != <span class="code-literal">null</span> ? _name : defaultValue;
</code></td></tr><tr><td id="L419" class="css-a4x74f"><span>419</span></td><td id="LC419" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L420" class="css-a4x74f"><span>420</span></td><td id="LC420" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L421" class="css-a4x74f"><span>421</span></td><td id="LC421" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> acc;
</code></td></tr><tr><td id="L422" class="css-a4x74f"><span>422</span></td><td id="LC422" class="css-1dcdqdg"><code>    }, {});
</code></td></tr><tr><td id="L423" class="css-a4x74f"><span>423</span></td><td id="LC423" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> <span class="code-built_in">Object</span>.assign({}, passedProps, pluginProps);
</code></td></tr><tr><td id="L424" class="css-a4x74f"><span>424</span></td><td id="LC424" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L425" class="css-a4x74f"><span>425</span></td><td id="LC425" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getDataAttributeProps</span>(<span class="code-params">reference, plugins</span>) </span>{
</code></td></tr><tr><td id="L426" class="css-a4x74f"><span>426</span></td><td id="LC426" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> propKeys = plugins ? <span class="code-built_in">Object</span>.keys(getExtendedPassedProps(<span class="code-built_in">Object</span>.assign({}, defaultProps, {
</code></td></tr><tr><td id="L427" class="css-a4x74f"><span>427</span></td><td id="LC427" class="css-1dcdqdg"><code>      plugins: plugins
</code></td></tr><tr><td id="L428" class="css-a4x74f"><span>428</span></td><td id="LC428" class="css-1dcdqdg"><code>    }))) : defaultKeys;
</code></td></tr><tr><td id="L429" class="css-a4x74f"><span>429</span></td><td id="LC429" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> props = propKeys.reduce(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">acc, key</span>) </span>{
</code></td></tr><tr><td id="L430" class="css-a4x74f"><span>430</span></td><td id="LC430" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> valueAsString = (reference.getAttribute(<span class="code-string">"data-tippy-"</span> + key) || <span class="code-string">''</span>).trim();
</code></td></tr><tr><td id="L431" class="css-a4x74f"><span>431</span></td><td id="LC431" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L432" class="css-a4x74f"><span>432</span></td><td id="LC432" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (!valueAsString) {
</code></td></tr><tr><td id="L433" class="css-a4x74f"><span>433</span></td><td id="LC433" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> acc;
</code></td></tr><tr><td id="L434" class="css-a4x74f"><span>434</span></td><td id="LC434" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L435" class="css-a4x74f"><span>435</span></td><td id="LC435" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L436" class="css-a4x74f"><span>436</span></td><td id="LC436" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (key === <span class="code-string">'content'</span>) {
</code></td></tr><tr><td id="L437" class="css-a4x74f"><span>437</span></td><td id="LC437" class="css-1dcdqdg"><code>        acc[key] = valueAsString;
</code></td></tr><tr><td id="L438" class="css-a4x74f"><span>438</span></td><td id="LC438" class="css-1dcdqdg"><code>      } <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L439" class="css-a4x74f"><span>439</span></td><td id="LC439" class="css-1dcdqdg"><code>        <span class="code-keyword">try</span> {
</code></td></tr><tr><td id="L440" class="css-a4x74f"><span>440</span></td><td id="LC440" class="css-1dcdqdg"><code>          acc[key] = <span class="code-built_in">JSON</span>.parse(valueAsString);
</code></td></tr><tr><td id="L441" class="css-a4x74f"><span>441</span></td><td id="LC441" class="css-1dcdqdg"><code>        } <span class="code-keyword">catch</span> (e) {
</code></td></tr><tr><td id="L442" class="css-a4x74f"><span>442</span></td><td id="LC442" class="css-1dcdqdg"><code>          acc[key] = valueAsString;
</code></td></tr><tr><td id="L443" class="css-a4x74f"><span>443</span></td><td id="LC443" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L444" class="css-a4x74f"><span>444</span></td><td id="LC444" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L445" class="css-a4x74f"><span>445</span></td><td id="LC445" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L446" class="css-a4x74f"><span>446</span></td><td id="LC446" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> acc;
</code></td></tr><tr><td id="L447" class="css-a4x74f"><span>447</span></td><td id="LC447" class="css-1dcdqdg"><code>    }, {});
</code></td></tr><tr><td id="L448" class="css-a4x74f"><span>448</span></td><td id="LC448" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> props;
</code></td></tr><tr><td id="L449" class="css-a4x74f"><span>449</span></td><td id="LC449" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L450" class="css-a4x74f"><span>450</span></td><td id="LC450" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">evaluateProps</span>(<span class="code-params">reference, props</span>) </span>{
</code></td></tr><tr><td id="L451" class="css-a4x74f"><span>451</span></td><td id="LC451" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> out = <span class="code-built_in">Object</span>.assign({}, props, {
</code></td></tr><tr><td id="L452" class="css-a4x74f"><span>452</span></td><td id="LC452" class="css-1dcdqdg"><code>      content: invokeWithArgsOrReturn(props.content, [reference])
</code></td></tr><tr><td id="L453" class="css-a4x74f"><span>453</span></td><td id="LC453" class="css-1dcdqdg"><code>    }, props.ignoreAttributes ? {} : getDataAttributeProps(reference, props.plugins));
</code></td></tr><tr><td id="L454" class="css-a4x74f"><span>454</span></td><td id="LC454" class="css-1dcdqdg"><code>    out.aria = <span class="code-built_in">Object</span>.assign({}, defaultProps.aria, out.aria);
</code></td></tr><tr><td id="L455" class="css-a4x74f"><span>455</span></td><td id="LC455" class="css-1dcdqdg"><code>    out.aria = {
</code></td></tr><tr><td id="L456" class="css-a4x74f"><span>456</span></td><td id="LC456" class="css-1dcdqdg"><code>      expanded: out.aria.expanded === <span class="code-string">'auto'</span> ? props.interactive : out.aria.expanded,
</code></td></tr><tr><td id="L457" class="css-a4x74f"><span>457</span></td><td id="LC457" class="css-1dcdqdg"><code>      content: out.aria.content === <span class="code-string">'auto'</span> ? props.interactive ? <span class="code-literal">null</span> : <span class="code-string">'describedby'</span> : out.aria.content
</code></td></tr><tr><td id="L458" class="css-a4x74f"><span>458</span></td><td id="LC458" class="css-1dcdqdg"><code>    };
</code></td></tr><tr><td id="L459" class="css-a4x74f"><span>459</span></td><td id="LC459" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> out;
</code></td></tr><tr><td id="L460" class="css-a4x74f"><span>460</span></td><td id="LC460" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L461" class="css-a4x74f"><span>461</span></td><td id="LC461" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">validateProps</span>(<span class="code-params">partialProps, plugins</span>) </span>{
</code></td></tr><tr><td id="L462" class="css-a4x74f"><span>462</span></td><td id="LC462" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (partialProps === <span class="code-keyword">void</span> <span class="code-number">0</span>) {
</code></td></tr><tr><td id="L463" class="css-a4x74f"><span>463</span></td><td id="LC463" class="css-1dcdqdg"><code>      partialProps = {};
</code></td></tr><tr><td id="L464" class="css-a4x74f"><span>464</span></td><td id="LC464" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L465" class="css-a4x74f"><span>465</span></td><td id="LC465" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L466" class="css-a4x74f"><span>466</span></td><td id="LC466" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (plugins === <span class="code-keyword">void</span> <span class="code-number">0</span>) {
</code></td></tr><tr><td id="L467" class="css-a4x74f"><span>467</span></td><td id="LC467" class="css-1dcdqdg"><code>      plugins = [];
</code></td></tr><tr><td id="L468" class="css-a4x74f"><span>468</span></td><td id="LC468" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L469" class="css-a4x74f"><span>469</span></td><td id="LC469" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L470" class="css-a4x74f"><span>470</span></td><td id="LC470" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> keys = <span class="code-built_in">Object</span>.keys(partialProps);
</code></td></tr><tr><td id="L471" class="css-a4x74f"><span>471</span></td><td id="LC471" class="css-1dcdqdg"><code>    keys.forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">prop</span>) </span>{
</code></td></tr><tr><td id="L472" class="css-a4x74f"><span>472</span></td><td id="LC472" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> nonPluginProps = removeProperties(defaultProps, <span class="code-built_in">Object</span>.keys(pluginProps));
</code></td></tr><tr><td id="L473" class="css-a4x74f"><span>473</span></td><td id="LC473" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> didPassUnknownProp = !hasOwnProperty(nonPluginProps, prop); <span class="code-comment">// Check if the prop exists in `plugins`</span>
</code></td></tr><tr><td id="L474" class="css-a4x74f"><span>474</span></td><td id="LC474" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L475" class="css-a4x74f"><span>475</span></td><td id="LC475" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (didPassUnknownProp) {
</code></td></tr><tr><td id="L476" class="css-a4x74f"><span>476</span></td><td id="LC476" class="css-1dcdqdg"><code>        didPassUnknownProp = plugins.filter(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">plugin</span>) </span>{
</code></td></tr><tr><td id="L477" class="css-a4x74f"><span>477</span></td><td id="LC477" class="css-1dcdqdg"><code>          <span class="code-keyword">return</span> plugin.name === prop;
</code></td></tr><tr><td id="L478" class="css-a4x74f"><span>478</span></td><td id="LC478" class="css-1dcdqdg"><code>        }).length === <span class="code-number">0</span>;
</code></td></tr><tr><td id="L479" class="css-a4x74f"><span>479</span></td><td id="LC479" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L480" class="css-a4x74f"><span>480</span></td><td id="LC480" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L481" class="css-a4x74f"><span>481</span></td><td id="LC481" class="css-1dcdqdg"><code>      warnWhen(didPassUnknownProp, [<span class="code-string">"`"</span> + prop + <span class="code-string">"`"</span>, <span class="code-string">"is not a valid prop. You may have spelled it incorrectly, or if it's"</span>, <span class="code-string">'a plugin, forgot to pass it in an array as props.plugins.'</span>, <span class="code-string">'\n\n'</span>, <span class="code-string">'All props: https://atomiks.github.io/tippyjs/v6/all-props/\n'</span>, <span class="code-string">'Plugins: https://atomiks.github.io/tippyjs/v6/plugins/'</span>].join(<span class="code-string">' '</span>));
</code></td></tr><tr><td id="L482" class="css-a4x74f"><span>482</span></td><td id="LC482" class="css-1dcdqdg"><code>    });
</code></td></tr><tr><td id="L483" class="css-a4x74f"><span>483</span></td><td id="LC483" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L484" class="css-a4x74f"><span>484</span></td><td id="LC484" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L485" class="css-a4x74f"><span>485</span></td><td id="LC485" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> innerHTML = <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">innerHTML</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L486" class="css-a4x74f"><span>486</span></td><td id="LC486" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> <span class="code-string">'innerHTML'</span>;
</code></td></tr><tr><td id="L487" class="css-a4x74f"><span>487</span></td><td id="LC487" class="css-1dcdqdg"><code>  };
</code></td></tr><tr><td id="L488" class="css-a4x74f"><span>488</span></td><td id="LC488" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L489" class="css-a4x74f"><span>489</span></td><td id="LC489" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">dangerouslySetInnerHTML</span>(<span class="code-params">element, html</span>) </span>{
</code></td></tr><tr><td id="L490" class="css-a4x74f"><span>490</span></td><td id="LC490" class="css-1dcdqdg"><code>    element[innerHTML()] = html;
</code></td></tr><tr><td id="L491" class="css-a4x74f"><span>491</span></td><td id="LC491" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L492" class="css-a4x74f"><span>492</span></td><td id="LC492" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L493" class="css-a4x74f"><span>493</span></td><td id="LC493" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">createArrowElement</span>(<span class="code-params">value</span>) </span>{
</code></td></tr><tr><td id="L494" class="css-a4x74f"><span>494</span></td><td id="LC494" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> arrow = div();
</code></td></tr><tr><td id="L495" class="css-a4x74f"><span>495</span></td><td id="LC495" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L496" class="css-a4x74f"><span>496</span></td><td id="LC496" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (value === <span class="code-literal">true</span>) {
</code></td></tr><tr><td id="L497" class="css-a4x74f"><span>497</span></td><td id="LC497" class="css-1dcdqdg"><code>      arrow.className = ARROW_CLASS;
</code></td></tr><tr><td id="L498" class="css-a4x74f"><span>498</span></td><td id="LC498" class="css-1dcdqdg"><code>    } <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L499" class="css-a4x74f"><span>499</span></td><td id="LC499" class="css-1dcdqdg"><code>      arrow.className = SVG_ARROW_CLASS;
</code></td></tr><tr><td id="L500" class="css-a4x74f"><span>500</span></td><td id="LC500" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L501" class="css-a4x74f"><span>501</span></td><td id="LC501" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (isElement(value)) {
</code></td></tr><tr><td id="L502" class="css-a4x74f"><span>502</span></td><td id="LC502" class="css-1dcdqdg"><code>        arrow.appendChild(value);
</code></td></tr><tr><td id="L503" class="css-a4x74f"><span>503</span></td><td id="LC503" class="css-1dcdqdg"><code>      } <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L504" class="css-a4x74f"><span>504</span></td><td id="LC504" class="css-1dcdqdg"><code>        dangerouslySetInnerHTML(arrow, value);
</code></td></tr><tr><td id="L505" class="css-a4x74f"><span>505</span></td><td id="LC505" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L506" class="css-a4x74f"><span>506</span></td><td id="LC506" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L507" class="css-a4x74f"><span>507</span></td><td id="LC507" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L508" class="css-a4x74f"><span>508</span></td><td id="LC508" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> arrow;
</code></td></tr><tr><td id="L509" class="css-a4x74f"><span>509</span></td><td id="LC509" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L510" class="css-a4x74f"><span>510</span></td><td id="LC510" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L511" class="css-a4x74f"><span>511</span></td><td id="LC511" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">setContent</span>(<span class="code-params">content, props</span>) </span>{
</code></td></tr><tr><td id="L512" class="css-a4x74f"><span>512</span></td><td id="LC512" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (isElement(props.content)) {
</code></td></tr><tr><td id="L513" class="css-a4x74f"><span>513</span></td><td id="LC513" class="css-1dcdqdg"><code>      dangerouslySetInnerHTML(content, <span class="code-string">''</span>);
</code></td></tr><tr><td id="L514" class="css-a4x74f"><span>514</span></td><td id="LC514" class="css-1dcdqdg"><code>      content.appendChild(props.content);
</code></td></tr><tr><td id="L515" class="css-a4x74f"><span>515</span></td><td id="LC515" class="css-1dcdqdg"><code>    } <span class="code-keyword">else</span> <span class="code-keyword">if</span> (<span class="code-keyword">typeof</span> props.content !== <span class="code-string">'function'</span>) {
</code></td></tr><tr><td id="L516" class="css-a4x74f"><span>516</span></td><td id="LC516" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (props.allowHTML) {
</code></td></tr><tr><td id="L517" class="css-a4x74f"><span>517</span></td><td id="LC517" class="css-1dcdqdg"><code>        dangerouslySetInnerHTML(content, props.content);
</code></td></tr><tr><td id="L518" class="css-a4x74f"><span>518</span></td><td id="LC518" class="css-1dcdqdg"><code>      } <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L519" class="css-a4x74f"><span>519</span></td><td id="LC519" class="css-1dcdqdg"><code>        content.textContent = props.content;
</code></td></tr><tr><td id="L520" class="css-a4x74f"><span>520</span></td><td id="LC520" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L521" class="css-a4x74f"><span>521</span></td><td id="LC521" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L522" class="css-a4x74f"><span>522</span></td><td id="LC522" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L523" class="css-a4x74f"><span>523</span></td><td id="LC523" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getChildren</span>(<span class="code-params">popper</span>) </span>{
</code></td></tr><tr><td id="L524" class="css-a4x74f"><span>524</span></td><td id="LC524" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> box = popper.firstElementChild;
</code></td></tr><tr><td id="L525" class="css-a4x74f"><span>525</span></td><td id="LC525" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> boxChildren = arrayFrom(box.children);
</code></td></tr><tr><td id="L526" class="css-a4x74f"><span>526</span></td><td id="LC526" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> {
</code></td></tr><tr><td id="L527" class="css-a4x74f"><span>527</span></td><td id="LC527" class="css-1dcdqdg"><code>      box: box,
</code></td></tr><tr><td id="L528" class="css-a4x74f"><span>528</span></td><td id="LC528" class="css-1dcdqdg"><code>      content: boxChildren.find(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">node</span>) </span>{
</code></td></tr><tr><td id="L529" class="css-a4x74f"><span>529</span></td><td id="LC529" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> node.classList.contains(CONTENT_CLASS);
</code></td></tr><tr><td id="L530" class="css-a4x74f"><span>530</span></td><td id="LC530" class="css-1dcdqdg"><code>      }),
</code></td></tr><tr><td id="L531" class="css-a4x74f"><span>531</span></td><td id="LC531" class="css-1dcdqdg"><code>      arrow: boxChildren.find(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">node</span>) </span>{
</code></td></tr><tr><td id="L532" class="css-a4x74f"><span>532</span></td><td id="LC532" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> node.classList.contains(ARROW_CLASS) || node.classList.contains(SVG_ARROW_CLASS);
</code></td></tr><tr><td id="L533" class="css-a4x74f"><span>533</span></td><td id="LC533" class="css-1dcdqdg"><code>      }),
</code></td></tr><tr><td id="L534" class="css-a4x74f"><span>534</span></td><td id="LC534" class="css-1dcdqdg"><code>      backdrop: boxChildren.find(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">node</span>) </span>{
</code></td></tr><tr><td id="L535" class="css-a4x74f"><span>535</span></td><td id="LC535" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> node.classList.contains(BACKDROP_CLASS);
</code></td></tr><tr><td id="L536" class="css-a4x74f"><span>536</span></td><td id="LC536" class="css-1dcdqdg"><code>      })
</code></td></tr><tr><td id="L537" class="css-a4x74f"><span>537</span></td><td id="LC537" class="css-1dcdqdg"><code>    };
</code></td></tr><tr><td id="L538" class="css-a4x74f"><span>538</span></td><td id="LC538" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L539" class="css-a4x74f"><span>539</span></td><td id="LC539" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">render</span>(<span class="code-params">instance</span>) </span>{
</code></td></tr><tr><td id="L540" class="css-a4x74f"><span>540</span></td><td id="LC540" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> popper = div();
</code></td></tr><tr><td id="L541" class="css-a4x74f"><span>541</span></td><td id="LC541" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> box = div();
</code></td></tr><tr><td id="L542" class="css-a4x74f"><span>542</span></td><td id="LC542" class="css-1dcdqdg"><code>    box.className = BOX_CLASS;
</code></td></tr><tr><td id="L543" class="css-a4x74f"><span>543</span></td><td id="LC543" class="css-1dcdqdg"><code>    box.setAttribute(<span class="code-string">'data-state'</span>, <span class="code-string">'hidden'</span>);
</code></td></tr><tr><td id="L544" class="css-a4x74f"><span>544</span></td><td id="LC544" class="css-1dcdqdg"><code>    box.setAttribute(<span class="code-string">'tabindex'</span>, <span class="code-string">'-1'</span>);
</code></td></tr><tr><td id="L545" class="css-a4x74f"><span>545</span></td><td id="LC545" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> content = div();
</code></td></tr><tr><td id="L546" class="css-a4x74f"><span>546</span></td><td id="LC546" class="css-1dcdqdg"><code>    content.className = CONTENT_CLASS;
</code></td></tr><tr><td id="L547" class="css-a4x74f"><span>547</span></td><td id="LC547" class="css-1dcdqdg"><code>    content.setAttribute(<span class="code-string">'data-state'</span>, <span class="code-string">'hidden'</span>);
</code></td></tr><tr><td id="L548" class="css-a4x74f"><span>548</span></td><td id="LC548" class="css-1dcdqdg"><code>    setContent(content, instance.props);
</code></td></tr><tr><td id="L549" class="css-a4x74f"><span>549</span></td><td id="LC549" class="css-1dcdqdg"><code>    popper.appendChild(box);
</code></td></tr><tr><td id="L550" class="css-a4x74f"><span>550</span></td><td id="LC550" class="css-1dcdqdg"><code>    box.appendChild(content);
</code></td></tr><tr><td id="L551" class="css-a4x74f"><span>551</span></td><td id="LC551" class="css-1dcdqdg"><code>    onUpdate(instance.props, instance.props);
</code></td></tr><tr><td id="L552" class="css-a4x74f"><span>552</span></td><td id="LC552" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L553" class="css-a4x74f"><span>553</span></td><td id="LC553" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onUpdate</span>(<span class="code-params">prevProps, nextProps</span>) </span>{
</code></td></tr><tr><td id="L554" class="css-a4x74f"><span>554</span></td><td id="LC554" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> _getChildren = getChildren(popper),
</code></td></tr><tr><td id="L555" class="css-a4x74f"><span>555</span></td><td id="LC555" class="css-1dcdqdg"><code>          box = _getChildren.box,
</code></td></tr><tr><td id="L556" class="css-a4x74f"><span>556</span></td><td id="LC556" class="css-1dcdqdg"><code>          content = _getChildren.content,
</code></td></tr><tr><td id="L557" class="css-a4x74f"><span>557</span></td><td id="LC557" class="css-1dcdqdg"><code>          arrow = _getChildren.arrow;
</code></td></tr><tr><td id="L558" class="css-a4x74f"><span>558</span></td><td id="LC558" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L559" class="css-a4x74f"><span>559</span></td><td id="LC559" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (nextProps.theme) {
</code></td></tr><tr><td id="L560" class="css-a4x74f"><span>560</span></td><td id="LC560" class="css-1dcdqdg"><code>        box.setAttribute(<span class="code-string">'data-theme'</span>, nextProps.theme);
</code></td></tr><tr><td id="L561" class="css-a4x74f"><span>561</span></td><td id="LC561" class="css-1dcdqdg"><code>      } <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L562" class="css-a4x74f"><span>562</span></td><td id="LC562" class="css-1dcdqdg"><code>        box.removeAttribute(<span class="code-string">'data-theme'</span>);
</code></td></tr><tr><td id="L563" class="css-a4x74f"><span>563</span></td><td id="LC563" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L564" class="css-a4x74f"><span>564</span></td><td id="LC564" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L565" class="css-a4x74f"><span>565</span></td><td id="LC565" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (<span class="code-keyword">typeof</span> nextProps.animation === <span class="code-string">'string'</span>) {
</code></td></tr><tr><td id="L566" class="css-a4x74f"><span>566</span></td><td id="LC566" class="css-1dcdqdg"><code>        box.setAttribute(<span class="code-string">'data-animation'</span>, nextProps.animation);
</code></td></tr><tr><td id="L567" class="css-a4x74f"><span>567</span></td><td id="LC567" class="css-1dcdqdg"><code>      } <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L568" class="css-a4x74f"><span>568</span></td><td id="LC568" class="css-1dcdqdg"><code>        box.removeAttribute(<span class="code-string">'data-animation'</span>);
</code></td></tr><tr><td id="L569" class="css-a4x74f"><span>569</span></td><td id="LC569" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L570" class="css-a4x74f"><span>570</span></td><td id="LC570" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L571" class="css-a4x74f"><span>571</span></td><td id="LC571" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (nextProps.inertia) {
</code></td></tr><tr><td id="L572" class="css-a4x74f"><span>572</span></td><td id="LC572" class="css-1dcdqdg"><code>        box.setAttribute(<span class="code-string">'data-inertia'</span>, <span class="code-string">''</span>);
</code></td></tr><tr><td id="L573" class="css-a4x74f"><span>573</span></td><td id="LC573" class="css-1dcdqdg"><code>      } <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L574" class="css-a4x74f"><span>574</span></td><td id="LC574" class="css-1dcdqdg"><code>        box.removeAttribute(<span class="code-string">'data-inertia'</span>);
</code></td></tr><tr><td id="L575" class="css-a4x74f"><span>575</span></td><td id="LC575" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L576" class="css-a4x74f"><span>576</span></td><td id="LC576" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L577" class="css-a4x74f"><span>577</span></td><td id="LC577" class="css-1dcdqdg"><code>      box.style.maxWidth = <span class="code-keyword">typeof</span> nextProps.maxWidth === <span class="code-string">'number'</span> ? nextProps.maxWidth + <span class="code-string">"px"</span> : nextProps.maxWidth;
</code></td></tr><tr><td id="L578" class="css-a4x74f"><span>578</span></td><td id="LC578" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L579" class="css-a4x74f"><span>579</span></td><td id="LC579" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (nextProps.role) {
</code></td></tr><tr><td id="L580" class="css-a4x74f"><span>580</span></td><td id="LC580" class="css-1dcdqdg"><code>        box.setAttribute(<span class="code-string">'role'</span>, nextProps.role);
</code></td></tr><tr><td id="L581" class="css-a4x74f"><span>581</span></td><td id="LC581" class="css-1dcdqdg"><code>      } <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L582" class="css-a4x74f"><span>582</span></td><td id="LC582" class="css-1dcdqdg"><code>        box.removeAttribute(<span class="code-string">'role'</span>);
</code></td></tr><tr><td id="L583" class="css-a4x74f"><span>583</span></td><td id="LC583" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L584" class="css-a4x74f"><span>584</span></td><td id="LC584" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L585" class="css-a4x74f"><span>585</span></td><td id="LC585" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (prevProps.content !== nextProps.content || prevProps.allowHTML !== nextProps.allowHTML) {
</code></td></tr><tr><td id="L586" class="css-a4x74f"><span>586</span></td><td id="LC586" class="css-1dcdqdg"><code>        setContent(content, instance.props);
</code></td></tr><tr><td id="L587" class="css-a4x74f"><span>587</span></td><td id="LC587" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L588" class="css-a4x74f"><span>588</span></td><td id="LC588" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L589" class="css-a4x74f"><span>589</span></td><td id="LC589" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (nextProps.arrow) {
</code></td></tr><tr><td id="L590" class="css-a4x74f"><span>590</span></td><td id="LC590" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (!arrow) {
</code></td></tr><tr><td id="L591" class="css-a4x74f"><span>591</span></td><td id="LC591" class="css-1dcdqdg"><code>          box.appendChild(createArrowElement(nextProps.arrow));
</code></td></tr><tr><td id="L592" class="css-a4x74f"><span>592</span></td><td id="LC592" class="css-1dcdqdg"><code>        } <span class="code-keyword">else</span> <span class="code-keyword">if</span> (prevProps.arrow !== nextProps.arrow) {
</code></td></tr><tr><td id="L593" class="css-a4x74f"><span>593</span></td><td id="LC593" class="css-1dcdqdg"><code>          box.removeChild(arrow);
</code></td></tr><tr><td id="L594" class="css-a4x74f"><span>594</span></td><td id="LC594" class="css-1dcdqdg"><code>          box.appendChild(createArrowElement(nextProps.arrow));
</code></td></tr><tr><td id="L595" class="css-a4x74f"><span>595</span></td><td id="LC595" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L596" class="css-a4x74f"><span>596</span></td><td id="LC596" class="css-1dcdqdg"><code>      } <span class="code-keyword">else</span> <span class="code-keyword">if</span> (arrow) {
</code></td></tr><tr><td id="L597" class="css-a4x74f"><span>597</span></td><td id="LC597" class="css-1dcdqdg"><code>        box.removeChild(arrow);
</code></td></tr><tr><td id="L598" class="css-a4x74f"><span>598</span></td><td id="LC598" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L599" class="css-a4x74f"><span>599</span></td><td id="LC599" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L600" class="css-a4x74f"><span>600</span></td><td id="LC600" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L601" class="css-a4x74f"><span>601</span></td><td id="LC601" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> {
</code></td></tr><tr><td id="L602" class="css-a4x74f"><span>602</span></td><td id="LC602" class="css-1dcdqdg"><code>      popper: popper,
</code></td></tr><tr><td id="L603" class="css-a4x74f"><span>603</span></td><td id="LC603" class="css-1dcdqdg"><code>      onUpdate: onUpdate
</code></td></tr><tr><td id="L604" class="css-a4x74f"><span>604</span></td><td id="LC604" class="css-1dcdqdg"><code>    };
</code></td></tr><tr><td id="L605" class="css-a4x74f"><span>605</span></td><td id="LC605" class="css-1dcdqdg"><code>  } <span class="code-comment">// Runtime check to identify if the render function is the default one; this</span>
</code></td></tr><tr><td id="L606" class="css-a4x74f"><span>606</span></td><td id="LC606" class="css-1dcdqdg"><code>  <span class="code-comment">// way we can apply default CSS transitions logic and it can be tree-shaken away</span>
</code></td></tr><tr><td id="L607" class="css-a4x74f"><span>607</span></td><td id="LC607" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L608" class="css-a4x74f"><span>608</span></td><td id="LC608" class="css-1dcdqdg"><code>  render.$$tippy = <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L609" class="css-a4x74f"><span>609</span></td><td id="LC609" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L610" class="css-a4x74f"><span>610</span></td><td id="LC610" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> idCounter = <span class="code-number">1</span>;
</code></td></tr><tr><td id="L611" class="css-a4x74f"><span>611</span></td><td id="LC611" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> mouseMoveListeners = []; <span class="code-comment">// Used by `hideAll()`</span>
</code></td></tr><tr><td id="L612" class="css-a4x74f"><span>612</span></td><td id="LC612" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L613" class="css-a4x74f"><span>613</span></td><td id="LC613" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> mountedInstances = [];
</code></td></tr><tr><td id="L614" class="css-a4x74f"><span>614</span></td><td id="LC614" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">createTippy</span>(<span class="code-params">reference, passedProps</span>) </span>{
</code></td></tr><tr><td id="L615" class="css-a4x74f"><span>615</span></td><td id="LC615" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> props = evaluateProps(reference, <span class="code-built_in">Object</span>.assign({}, defaultProps, getExtendedPassedProps(removeUndefinedProps(passedProps)))); <span class="code-comment">// ===========================================================================</span>
</code></td></tr><tr><td id="L616" class="css-a4x74f"><span>616</span></td><td id="LC616" class="css-1dcdqdg"><code>    <span class="code-comment">// 🔒 Private members</span>
</code></td></tr><tr><td id="L617" class="css-a4x74f"><span>617</span></td><td id="LC617" class="css-1dcdqdg"><code>    <span class="code-comment">// ===========================================================================</span>
</code></td></tr><tr><td id="L618" class="css-a4x74f"><span>618</span></td><td id="LC618" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L619" class="css-a4x74f"><span>619</span></td><td id="LC619" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> showTimeout;
</code></td></tr><tr><td id="L620" class="css-a4x74f"><span>620</span></td><td id="LC620" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> hideTimeout;
</code></td></tr><tr><td id="L621" class="css-a4x74f"><span>621</span></td><td id="LC621" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> scheduleHideAnimationFrame;
</code></td></tr><tr><td id="L622" class="css-a4x74f"><span>622</span></td><td id="LC622" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> isVisibleFromClick = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L623" class="css-a4x74f"><span>623</span></td><td id="LC623" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> didHideDueToDocumentMouseDown = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L624" class="css-a4x74f"><span>624</span></td><td id="LC624" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> didTouchMove = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L625" class="css-a4x74f"><span>625</span></td><td id="LC625" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> ignoreOnFirstUpdate = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L626" class="css-a4x74f"><span>626</span></td><td id="LC626" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> lastTriggerEvent;
</code></td></tr><tr><td id="L627" class="css-a4x74f"><span>627</span></td><td id="LC627" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> currentTransitionEndListener;
</code></td></tr><tr><td id="L628" class="css-a4x74f"><span>628</span></td><td id="LC628" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> onFirstUpdate;
</code></td></tr><tr><td id="L629" class="css-a4x74f"><span>629</span></td><td id="LC629" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> listeners = [];
</code></td></tr><tr><td id="L630" class="css-a4x74f"><span>630</span></td><td id="LC630" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> debouncedOnMouseMove = debounce(onMouseMove, props.interactiveDebounce);
</code></td></tr><tr><td id="L631" class="css-a4x74f"><span>631</span></td><td id="LC631" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> currentTarget; <span class="code-comment">// ===========================================================================</span>
</code></td></tr><tr><td id="L632" class="css-a4x74f"><span>632</span></td><td id="LC632" class="css-1dcdqdg"><code>    <span class="code-comment">// 🔑 Public members</span>
</code></td></tr><tr><td id="L633" class="css-a4x74f"><span>633</span></td><td id="LC633" class="css-1dcdqdg"><code>    <span class="code-comment">// ===========================================================================</span>
</code></td></tr><tr><td id="L634" class="css-a4x74f"><span>634</span></td><td id="LC634" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L635" class="css-a4x74f"><span>635</span></td><td id="LC635" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> id = idCounter++;
</code></td></tr><tr><td id="L636" class="css-a4x74f"><span>636</span></td><td id="LC636" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> popperInstance = <span class="code-literal">null</span>;
</code></td></tr><tr><td id="L637" class="css-a4x74f"><span>637</span></td><td id="LC637" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> plugins = unique(props.plugins);
</code></td></tr><tr><td id="L638" class="css-a4x74f"><span>638</span></td><td id="LC638" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> state = {
</code></td></tr><tr><td id="L639" class="css-a4x74f"><span>639</span></td><td id="LC639" class="css-1dcdqdg"><code>      <span class="code-comment">// Is the instance currently enabled?</span>
</code></td></tr><tr><td id="L640" class="css-a4x74f"><span>640</span></td><td id="LC640" class="css-1dcdqdg"><code>      isEnabled: <span class="code-literal">true</span>,
</code></td></tr><tr><td id="L641" class="css-a4x74f"><span>641</span></td><td id="LC641" class="css-1dcdqdg"><code>      <span class="code-comment">// Is the tippy currently showing and not transitioning out?</span>
</code></td></tr><tr><td id="L642" class="css-a4x74f"><span>642</span></td><td id="LC642" class="css-1dcdqdg"><code>      isVisible: <span class="code-literal">false</span>,
</code></td></tr><tr><td id="L643" class="css-a4x74f"><span>643</span></td><td id="LC643" class="css-1dcdqdg"><code>      <span class="code-comment">// Has the instance been destroyed?</span>
</code></td></tr><tr><td id="L644" class="css-a4x74f"><span>644</span></td><td id="LC644" class="css-1dcdqdg"><code>      isDestroyed: <span class="code-literal">false</span>,
</code></td></tr><tr><td id="L645" class="css-a4x74f"><span>645</span></td><td id="LC645" class="css-1dcdqdg"><code>      <span class="code-comment">// Is the tippy currently mounted to the DOM?</span>
</code></td></tr><tr><td id="L646" class="css-a4x74f"><span>646</span></td><td id="LC646" class="css-1dcdqdg"><code>      isMounted: <span class="code-literal">false</span>,
</code></td></tr><tr><td id="L647" class="css-a4x74f"><span>647</span></td><td id="LC647" class="css-1dcdqdg"><code>      <span class="code-comment">// Has the tippy finished transitioning in?</span>
</code></td></tr><tr><td id="L648" class="css-a4x74f"><span>648</span></td><td id="LC648" class="css-1dcdqdg"><code>      isShown: <span class="code-literal">false</span>
</code></td></tr><tr><td id="L649" class="css-a4x74f"><span>649</span></td><td id="LC649" class="css-1dcdqdg"><code>    };
</code></td></tr><tr><td id="L650" class="css-a4x74f"><span>650</span></td><td id="LC650" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> instance = {
</code></td></tr><tr><td id="L651" class="css-a4x74f"><span>651</span></td><td id="LC651" class="css-1dcdqdg"><code>      <span class="code-comment">// properties</span>
</code></td></tr><tr><td id="L652" class="css-a4x74f"><span>652</span></td><td id="LC652" class="css-1dcdqdg"><code>      id: id,
</code></td></tr><tr><td id="L653" class="css-a4x74f"><span>653</span></td><td id="LC653" class="css-1dcdqdg"><code>      reference: reference,
</code></td></tr><tr><td id="L654" class="css-a4x74f"><span>654</span></td><td id="LC654" class="css-1dcdqdg"><code>      popper: div(),
</code></td></tr><tr><td id="L655" class="css-a4x74f"><span>655</span></td><td id="LC655" class="css-1dcdqdg"><code>      popperInstance: popperInstance,
</code></td></tr><tr><td id="L656" class="css-a4x74f"><span>656</span></td><td id="LC656" class="css-1dcdqdg"><code>      props: props,
</code></td></tr><tr><td id="L657" class="css-a4x74f"><span>657</span></td><td id="LC657" class="css-1dcdqdg"><code>      state: state,
</code></td></tr><tr><td id="L658" class="css-a4x74f"><span>658</span></td><td id="LC658" class="css-1dcdqdg"><code>      plugins: plugins,
</code></td></tr><tr><td id="L659" class="css-a4x74f"><span>659</span></td><td id="LC659" class="css-1dcdqdg"><code>      <span class="code-comment">// methods</span>
</code></td></tr><tr><td id="L660" class="css-a4x74f"><span>660</span></td><td id="LC660" class="css-1dcdqdg"><code>      clearDelayTimeouts: clearDelayTimeouts,
</code></td></tr><tr><td id="L661" class="css-a4x74f"><span>661</span></td><td id="LC661" class="css-1dcdqdg"><code>      setProps: setProps,
</code></td></tr><tr><td id="L662" class="css-a4x74f"><span>662</span></td><td id="LC662" class="css-1dcdqdg"><code>      setContent: setContent,
</code></td></tr><tr><td id="L663" class="css-a4x74f"><span>663</span></td><td id="LC663" class="css-1dcdqdg"><code>      show: show,
</code></td></tr><tr><td id="L664" class="css-a4x74f"><span>664</span></td><td id="LC664" class="css-1dcdqdg"><code>      hide: hide,
</code></td></tr><tr><td id="L665" class="css-a4x74f"><span>665</span></td><td id="LC665" class="css-1dcdqdg"><code>      hideWithInteractivity: hideWithInteractivity,
</code></td></tr><tr><td id="L666" class="css-a4x74f"><span>666</span></td><td id="LC666" class="css-1dcdqdg"><code>      enable: enable,
</code></td></tr><tr><td id="L667" class="css-a4x74f"><span>667</span></td><td id="LC667" class="css-1dcdqdg"><code>      disable: disable,
</code></td></tr><tr><td id="L668" class="css-a4x74f"><span>668</span></td><td id="LC668" class="css-1dcdqdg"><code>      unmount: unmount,
</code></td></tr><tr><td id="L669" class="css-a4x74f"><span>669</span></td><td id="LC669" class="css-1dcdqdg"><code>      destroy: destroy
</code></td></tr><tr><td id="L670" class="css-a4x74f"><span>670</span></td><td id="LC670" class="css-1dcdqdg"><code>    }; <span class="code-comment">// <span class="code-doctag">TODO:</span> Investigate why this early return causes a TDZ error in the tests —</span>
</code></td></tr><tr><td id="L671" class="css-a4x74f"><span>671</span></td><td id="LC671" class="css-1dcdqdg"><code>    <span class="code-comment">// it doesn't seem to happen in the browser</span>
</code></td></tr><tr><td id="L672" class="css-a4x74f"><span>672</span></td><td id="LC672" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L673" class="css-a4x74f"><span>673</span></td><td id="LC673" class="css-1dcdqdg"><code>    <span class="code-comment">/* istanbul ignore if */</span>
</code></td></tr><tr><td id="L674" class="css-a4x74f"><span>674</span></td><td id="LC674" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L675" class="css-a4x74f"><span>675</span></td><td id="LC675" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (!props.render) {
</code></td></tr><tr><td id="L676" class="css-a4x74f"><span>676</span></td><td id="LC676" class="css-1dcdqdg"><code>      {
</code></td></tr><tr><td id="L677" class="css-a4x74f"><span>677</span></td><td id="LC677" class="css-1dcdqdg"><code>        errorWhen(<span class="code-literal">true</span>, <span class="code-string">'render() function has not been supplied.'</span>);
</code></td></tr><tr><td id="L678" class="css-a4x74f"><span>678</span></td><td id="LC678" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L679" class="css-a4x74f"><span>679</span></td><td id="LC679" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L680" class="css-a4x74f"><span>680</span></td><td id="LC680" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> instance;
</code></td></tr><tr><td id="L681" class="css-a4x74f"><span>681</span></td><td id="LC681" class="css-1dcdqdg"><code>    } <span class="code-comment">// ===========================================================================</span>
</code></td></tr><tr><td id="L682" class="css-a4x74f"><span>682</span></td><td id="LC682" class="css-1dcdqdg"><code>    <span class="code-comment">// Initial mutations</span>
</code></td></tr><tr><td id="L683" class="css-a4x74f"><span>683</span></td><td id="LC683" class="css-1dcdqdg"><code>    <span class="code-comment">// ===========================================================================</span>
</code></td></tr><tr><td id="L684" class="css-a4x74f"><span>684</span></td><td id="LC684" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L685" class="css-a4x74f"><span>685</span></td><td id="LC685" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L686" class="css-a4x74f"><span>686</span></td><td id="LC686" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> _props$render = props.render(instance),
</code></td></tr><tr><td id="L687" class="css-a4x74f"><span>687</span></td><td id="LC687" class="css-1dcdqdg"><code>        popper = _props$render.popper,
</code></td></tr><tr><td id="L688" class="css-a4x74f"><span>688</span></td><td id="LC688" class="css-1dcdqdg"><code>        onUpdate = _props$render.onUpdate;
</code></td></tr><tr><td id="L689" class="css-a4x74f"><span>689</span></td><td id="LC689" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L690" class="css-a4x74f"><span>690</span></td><td id="LC690" class="css-1dcdqdg"><code>    popper.setAttribute(<span class="code-string">'data-tippy-root'</span>, <span class="code-string">''</span>);
</code></td></tr><tr><td id="L691" class="css-a4x74f"><span>691</span></td><td id="LC691" class="css-1dcdqdg"><code>    popper.id = <span class="code-string">"tippy-"</span> + instance.id;
</code></td></tr><tr><td id="L692" class="css-a4x74f"><span>692</span></td><td id="LC692" class="css-1dcdqdg"><code>    instance.popper = popper;
</code></td></tr><tr><td id="L693" class="css-a4x74f"><span>693</span></td><td id="LC693" class="css-1dcdqdg"><code>    reference._tippy = instance;
</code></td></tr><tr><td id="L694" class="css-a4x74f"><span>694</span></td><td id="LC694" class="css-1dcdqdg"><code>    popper._tippy = instance;
</code></td></tr><tr><td id="L695" class="css-a4x74f"><span>695</span></td><td id="LC695" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> pluginsHooks = plugins.map(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">plugin</span>) </span>{
</code></td></tr><tr><td id="L696" class="css-a4x74f"><span>696</span></td><td id="LC696" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> plugin.fn(instance);
</code></td></tr><tr><td id="L697" class="css-a4x74f"><span>697</span></td><td id="LC697" class="css-1dcdqdg"><code>    });
</code></td></tr><tr><td id="L698" class="css-a4x74f"><span>698</span></td><td id="LC698" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> hasAriaExpanded = reference.hasAttribute(<span class="code-string">'aria-expanded'</span>);
</code></td></tr><tr><td id="L699" class="css-a4x74f"><span>699</span></td><td id="LC699" class="css-1dcdqdg"><code>    addListeners();
</code></td></tr><tr><td id="L700" class="css-a4x74f"><span>700</span></td><td id="LC700" class="css-1dcdqdg"><code>    handleAriaExpandedAttribute();
</code></td></tr><tr><td id="L701" class="css-a4x74f"><span>701</span></td><td id="LC701" class="css-1dcdqdg"><code>    handleStyles();
</code></td></tr><tr><td id="L702" class="css-a4x74f"><span>702</span></td><td id="LC702" class="css-1dcdqdg"><code>    invokeHook(<span class="code-string">'onCreate'</span>, [instance]);
</code></td></tr><tr><td id="L703" class="css-a4x74f"><span>703</span></td><td id="LC703" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L704" class="css-a4x74f"><span>704</span></td><td id="LC704" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (props.showOnCreate) {
</code></td></tr><tr><td id="L705" class="css-a4x74f"><span>705</span></td><td id="LC705" class="css-1dcdqdg"><code>      scheduleShow();
</code></td></tr><tr><td id="L706" class="css-a4x74f"><span>706</span></td><td id="LC706" class="css-1dcdqdg"><code>    } <span class="code-comment">// Prevent a tippy with a delay from hiding if the cursor left then returned</span>
</code></td></tr><tr><td id="L707" class="css-a4x74f"><span>707</span></td><td id="LC707" class="css-1dcdqdg"><code>    <span class="code-comment">// before it started hiding</span>
</code></td></tr><tr><td id="L708" class="css-a4x74f"><span>708</span></td><td id="LC708" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L709" class="css-a4x74f"><span>709</span></td><td id="LC709" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L710" class="css-a4x74f"><span>710</span></td><td id="LC710" class="css-1dcdqdg"><code>    popper.addEventListener(<span class="code-string">'mouseenter'</span>, <span class="code-function"><span class="code-keyword">function</span> (<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L711" class="css-a4x74f"><span>711</span></td><td id="LC711" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (instance.props.interactive &amp;&amp; instance.state.isVisible) {
</code></td></tr><tr><td id="L712" class="css-a4x74f"><span>712</span></td><td id="LC712" class="css-1dcdqdg"><code>        instance.clearDelayTimeouts();
</code></td></tr><tr><td id="L713" class="css-a4x74f"><span>713</span></td><td id="LC713" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L714" class="css-a4x74f"><span>714</span></td><td id="LC714" class="css-1dcdqdg"><code>    });
</code></td></tr><tr><td id="L715" class="css-a4x74f"><span>715</span></td><td id="LC715" class="css-1dcdqdg"><code>    popper.addEventListener(<span class="code-string">'mouseleave'</span>, <span class="code-function"><span class="code-keyword">function</span> (<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L716" class="css-a4x74f"><span>716</span></td><td id="LC716" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (instance.props.interactive &amp;&amp; instance.props.trigger.indexOf(<span class="code-string">'mouseenter'</span>) &gt;= <span class="code-number">0</span>) {
</code></td></tr><tr><td id="L717" class="css-a4x74f"><span>717</span></td><td id="LC717" class="css-1dcdqdg"><code>        getDocument().addEventListener(<span class="code-string">'mousemove'</span>, debouncedOnMouseMove);
</code></td></tr><tr><td id="L718" class="css-a4x74f"><span>718</span></td><td id="LC718" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L719" class="css-a4x74f"><span>719</span></td><td id="LC719" class="css-1dcdqdg"><code>    });
</code></td></tr><tr><td id="L720" class="css-a4x74f"><span>720</span></td><td id="LC720" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> instance; <span class="code-comment">// ===========================================================================</span>
</code></td></tr><tr><td id="L721" class="css-a4x74f"><span>721</span></td><td id="LC721" class="css-1dcdqdg"><code>    <span class="code-comment">// 🔒 Private methods</span>
</code></td></tr><tr><td id="L722" class="css-a4x74f"><span>722</span></td><td id="LC722" class="css-1dcdqdg"><code>    <span class="code-comment">// ===========================================================================</span>
</code></td></tr><tr><td id="L723" class="css-a4x74f"><span>723</span></td><td id="LC723" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L724" class="css-a4x74f"><span>724</span></td><td id="LC724" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getNormalizedTouchSettings</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L725" class="css-a4x74f"><span>725</span></td><td id="LC725" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> touch = instance.props.touch;
</code></td></tr><tr><td id="L726" class="css-a4x74f"><span>726</span></td><td id="LC726" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> <span class="code-built_in">Array</span>.isArray(touch) ? touch : [touch, <span class="code-number">0</span>];
</code></td></tr><tr><td id="L727" class="css-a4x74f"><span>727</span></td><td id="LC727" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L728" class="css-a4x74f"><span>728</span></td><td id="LC728" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L729" class="css-a4x74f"><span>729</span></td><td id="LC729" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getIsCustomTouchBehavior</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L730" class="css-a4x74f"><span>730</span></td><td id="LC730" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> getNormalizedTouchSettings()[<span class="code-number">0</span>] === <span class="code-string">'hold'</span>;
</code></td></tr><tr><td id="L731" class="css-a4x74f"><span>731</span></td><td id="LC731" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L732" class="css-a4x74f"><span>732</span></td><td id="LC732" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L733" class="css-a4x74f"><span>733</span></td><td id="LC733" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getIsDefaultRenderFn</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L734" class="css-a4x74f"><span>734</span></td><td id="LC734" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> _instance$props$rende;
</code></td></tr><tr><td id="L735" class="css-a4x74f"><span>735</span></td><td id="LC735" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L736" class="css-a4x74f"><span>736</span></td><td id="LC736" class="css-1dcdqdg"><code>      <span class="code-comment">// @ts-ignore</span>
</code></td></tr><tr><td id="L737" class="css-a4x74f"><span>737</span></td><td id="LC737" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> !!((_instance$props$rende = instance.props.render) != <span class="code-literal">null</span> &amp;&amp; _instance$props$rende.$$tippy);
</code></td></tr><tr><td id="L738" class="css-a4x74f"><span>738</span></td><td id="LC738" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L739" class="css-a4x74f"><span>739</span></td><td id="LC739" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L740" class="css-a4x74f"><span>740</span></td><td id="LC740" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getCurrentTarget</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L741" class="css-a4x74f"><span>741</span></td><td id="LC741" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> currentTarget || reference;
</code></td></tr><tr><td id="L742" class="css-a4x74f"><span>742</span></td><td id="LC742" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L743" class="css-a4x74f"><span>743</span></td><td id="LC743" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L744" class="css-a4x74f"><span>744</span></td><td id="LC744" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getDocument</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L745" class="css-a4x74f"><span>745</span></td><td id="LC745" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> parent = getCurrentTarget().parentNode;
</code></td></tr><tr><td id="L746" class="css-a4x74f"><span>746</span></td><td id="LC746" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> parent ? getOwnerDocument(parent) : <span class="code-built_in">document</span>;
</code></td></tr><tr><td id="L747" class="css-a4x74f"><span>747</span></td><td id="LC747" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L748" class="css-a4x74f"><span>748</span></td><td id="LC748" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L749" class="css-a4x74f"><span>749</span></td><td id="LC749" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getDefaultTemplateChildren</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L750" class="css-a4x74f"><span>750</span></td><td id="LC750" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> getChildren(popper);
</code></td></tr><tr><td id="L751" class="css-a4x74f"><span>751</span></td><td id="LC751" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L752" class="css-a4x74f"><span>752</span></td><td id="LC752" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L753" class="css-a4x74f"><span>753</span></td><td id="LC753" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getDelay</span>(<span class="code-params">isShow</span>) </span>{
</code></td></tr><tr><td id="L754" class="css-a4x74f"><span>754</span></td><td id="LC754" class="css-1dcdqdg"><code>      <span class="code-comment">// For touch or keyboard input, force `0` delay for UX reasons</span>
</code></td></tr><tr><td id="L755" class="css-a4x74f"><span>755</span></td><td id="LC755" class="css-1dcdqdg"><code>      <span class="code-comment">// Also if the instance is mounted but not visible (transitioning out),</span>
</code></td></tr><tr><td id="L756" class="css-a4x74f"><span>756</span></td><td id="LC756" class="css-1dcdqdg"><code>      <span class="code-comment">// ignore delay</span>
</code></td></tr><tr><td id="L757" class="css-a4x74f"><span>757</span></td><td id="LC757" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (instance.state.isMounted &amp;&amp; !instance.state.isVisible || currentInput.isTouch || lastTriggerEvent &amp;&amp; lastTriggerEvent.type === <span class="code-string">'focus'</span>) {
</code></td></tr><tr><td id="L758" class="css-a4x74f"><span>758</span></td><td id="LC758" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> <span class="code-number">0</span>;
</code></td></tr><tr><td id="L759" class="css-a4x74f"><span>759</span></td><td id="LC759" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L760" class="css-a4x74f"><span>760</span></td><td id="LC760" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L761" class="css-a4x74f"><span>761</span></td><td id="LC761" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> getValueAtIndexOrReturn(instance.props.delay, isShow ? <span class="code-number">0</span> : <span class="code-number">1</span>, defaultProps.delay);
</code></td></tr><tr><td id="L762" class="css-a4x74f"><span>762</span></td><td id="LC762" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L763" class="css-a4x74f"><span>763</span></td><td id="LC763" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L764" class="css-a4x74f"><span>764</span></td><td id="LC764" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">handleStyles</span>(<span class="code-params">fromHide</span>) </span>{
</code></td></tr><tr><td id="L765" class="css-a4x74f"><span>765</span></td><td id="LC765" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (fromHide === <span class="code-keyword">void</span> <span class="code-number">0</span>) {
</code></td></tr><tr><td id="L766" class="css-a4x74f"><span>766</span></td><td id="LC766" class="css-1dcdqdg"><code>        fromHide = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L767" class="css-a4x74f"><span>767</span></td><td id="LC767" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L768" class="css-a4x74f"><span>768</span></td><td id="LC768" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L769" class="css-a4x74f"><span>769</span></td><td id="LC769" class="css-1dcdqdg"><code>      popper.style.pointerEvents = instance.props.interactive &amp;&amp; !fromHide ? <span class="code-string">''</span> : <span class="code-string">'none'</span>;
</code></td></tr><tr><td id="L770" class="css-a4x74f"><span>770</span></td><td id="LC770" class="css-1dcdqdg"><code>      popper.style.zIndex = <span class="code-string">""</span> + instance.props.zIndex;
</code></td></tr><tr><td id="L771" class="css-a4x74f"><span>771</span></td><td id="LC771" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L772" class="css-a4x74f"><span>772</span></td><td id="LC772" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L773" class="css-a4x74f"><span>773</span></td><td id="LC773" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">invokeHook</span>(<span class="code-params">hook, args, shouldInvokePropsHook</span>) </span>{
</code></td></tr><tr><td id="L774" class="css-a4x74f"><span>774</span></td><td id="LC774" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (shouldInvokePropsHook === <span class="code-keyword">void</span> <span class="code-number">0</span>) {
</code></td></tr><tr><td id="L775" class="css-a4x74f"><span>775</span></td><td id="LC775" class="css-1dcdqdg"><code>        shouldInvokePropsHook = <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L776" class="css-a4x74f"><span>776</span></td><td id="LC776" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L777" class="css-a4x74f"><span>777</span></td><td id="LC777" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L778" class="css-a4x74f"><span>778</span></td><td id="LC778" class="css-1dcdqdg"><code>      pluginsHooks.forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">pluginHooks</span>) </span>{
</code></td></tr><tr><td id="L779" class="css-a4x74f"><span>779</span></td><td id="LC779" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (pluginHooks[hook]) {
</code></td></tr><tr><td id="L780" class="css-a4x74f"><span>780</span></td><td id="LC780" class="css-1dcdqdg"><code>          pluginHooks[hook].apply(pluginHooks, args);
</code></td></tr><tr><td id="L781" class="css-a4x74f"><span>781</span></td><td id="LC781" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L782" class="css-a4x74f"><span>782</span></td><td id="LC782" class="css-1dcdqdg"><code>      });
</code></td></tr><tr><td id="L783" class="css-a4x74f"><span>783</span></td><td id="LC783" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L784" class="css-a4x74f"><span>784</span></td><td id="LC784" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (shouldInvokePropsHook) {
</code></td></tr><tr><td id="L785" class="css-a4x74f"><span>785</span></td><td id="LC785" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> _instance$props;
</code></td></tr><tr><td id="L786" class="css-a4x74f"><span>786</span></td><td id="LC786" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L787" class="css-a4x74f"><span>787</span></td><td id="LC787" class="css-1dcdqdg"><code>        (_instance$props = instance.props)[hook].apply(_instance$props, args);
</code></td></tr><tr><td id="L788" class="css-a4x74f"><span>788</span></td><td id="LC788" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L789" class="css-a4x74f"><span>789</span></td><td id="LC789" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L790" class="css-a4x74f"><span>790</span></td><td id="LC790" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L791" class="css-a4x74f"><span>791</span></td><td id="LC791" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">handleAriaContentAttribute</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L792" class="css-a4x74f"><span>792</span></td><td id="LC792" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> aria = instance.props.aria;
</code></td></tr><tr><td id="L793" class="css-a4x74f"><span>793</span></td><td id="LC793" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L794" class="css-a4x74f"><span>794</span></td><td id="LC794" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (!aria.content) {
</code></td></tr><tr><td id="L795" class="css-a4x74f"><span>795</span></td><td id="LC795" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L796" class="css-a4x74f"><span>796</span></td><td id="LC796" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L797" class="css-a4x74f"><span>797</span></td><td id="LC797" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L798" class="css-a4x74f"><span>798</span></td><td id="LC798" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> attr = <span class="code-string">"aria-"</span> + aria.content;
</code></td></tr><tr><td id="L799" class="css-a4x74f"><span>799</span></td><td id="LC799" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> id = popper.id;
</code></td></tr><tr><td id="L800" class="css-a4x74f"><span>800</span></td><td id="LC800" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> nodes = normalizeToArray(instance.props.triggerTarget || reference);
</code></td></tr><tr><td id="L801" class="css-a4x74f"><span>801</span></td><td id="LC801" class="css-1dcdqdg"><code>      nodes.forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">node</span>) </span>{
</code></td></tr><tr><td id="L802" class="css-a4x74f"><span>802</span></td><td id="LC802" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> currentValue = node.getAttribute(attr);
</code></td></tr><tr><td id="L803" class="css-a4x74f"><span>803</span></td><td id="LC803" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L804" class="css-a4x74f"><span>804</span></td><td id="LC804" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (instance.state.isVisible) {
</code></td></tr><tr><td id="L805" class="css-a4x74f"><span>805</span></td><td id="LC805" class="css-1dcdqdg"><code>          node.setAttribute(attr, currentValue ? currentValue + <span class="code-string">" "</span> + id : id);
</code></td></tr><tr><td id="L806" class="css-a4x74f"><span>806</span></td><td id="LC806" class="css-1dcdqdg"><code>        } <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L807" class="css-a4x74f"><span>807</span></td><td id="LC807" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> nextValue = currentValue &amp;&amp; currentValue.replace(id, <span class="code-string">''</span>).trim();
</code></td></tr><tr><td id="L808" class="css-a4x74f"><span>808</span></td><td id="LC808" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L809" class="css-a4x74f"><span>809</span></td><td id="LC809" class="css-1dcdqdg"><code>          <span class="code-keyword">if</span> (nextValue) {
</code></td></tr><tr><td id="L810" class="css-a4x74f"><span>810</span></td><td id="LC810" class="css-1dcdqdg"><code>            node.setAttribute(attr, nextValue);
</code></td></tr><tr><td id="L811" class="css-a4x74f"><span>811</span></td><td id="LC811" class="css-1dcdqdg"><code>          } <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L812" class="css-a4x74f"><span>812</span></td><td id="LC812" class="css-1dcdqdg"><code>            node.removeAttribute(attr);
</code></td></tr><tr><td id="L813" class="css-a4x74f"><span>813</span></td><td id="LC813" class="css-1dcdqdg"><code>          }
</code></td></tr><tr><td id="L814" class="css-a4x74f"><span>814</span></td><td id="LC814" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L815" class="css-a4x74f"><span>815</span></td><td id="LC815" class="css-1dcdqdg"><code>      });
</code></td></tr><tr><td id="L816" class="css-a4x74f"><span>816</span></td><td id="LC816" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L817" class="css-a4x74f"><span>817</span></td><td id="LC817" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L818" class="css-a4x74f"><span>818</span></td><td id="LC818" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">handleAriaExpandedAttribute</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L819" class="css-a4x74f"><span>819</span></td><td id="LC819" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (hasAriaExpanded || !instance.props.aria.expanded) {
</code></td></tr><tr><td id="L820" class="css-a4x74f"><span>820</span></td><td id="LC820" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L821" class="css-a4x74f"><span>821</span></td><td id="LC821" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L822" class="css-a4x74f"><span>822</span></td><td id="LC822" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L823" class="css-a4x74f"><span>823</span></td><td id="LC823" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> nodes = normalizeToArray(instance.props.triggerTarget || reference);
</code></td></tr><tr><td id="L824" class="css-a4x74f"><span>824</span></td><td id="LC824" class="css-1dcdqdg"><code>      nodes.forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">node</span>) </span>{
</code></td></tr><tr><td id="L825" class="css-a4x74f"><span>825</span></td><td id="LC825" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (instance.props.interactive) {
</code></td></tr><tr><td id="L826" class="css-a4x74f"><span>826</span></td><td id="LC826" class="css-1dcdqdg"><code>          node.setAttribute(<span class="code-string">'aria-expanded'</span>, instance.state.isVisible &amp;&amp; node === getCurrentTarget() ? <span class="code-string">'true'</span> : <span class="code-string">'false'</span>);
</code></td></tr><tr><td id="L827" class="css-a4x74f"><span>827</span></td><td id="LC827" class="css-1dcdqdg"><code>        } <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L828" class="css-a4x74f"><span>828</span></td><td id="LC828" class="css-1dcdqdg"><code>          node.removeAttribute(<span class="code-string">'aria-expanded'</span>);
</code></td></tr><tr><td id="L829" class="css-a4x74f"><span>829</span></td><td id="LC829" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L830" class="css-a4x74f"><span>830</span></td><td id="LC830" class="css-1dcdqdg"><code>      });
</code></td></tr><tr><td id="L831" class="css-a4x74f"><span>831</span></td><td id="LC831" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L832" class="css-a4x74f"><span>832</span></td><td id="LC832" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L833" class="css-a4x74f"><span>833</span></td><td id="LC833" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">cleanupInteractiveMouseListeners</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L834" class="css-a4x74f"><span>834</span></td><td id="LC834" class="css-1dcdqdg"><code>      getDocument().removeEventListener(<span class="code-string">'mousemove'</span>, debouncedOnMouseMove);
</code></td></tr><tr><td id="L835" class="css-a4x74f"><span>835</span></td><td id="LC835" class="css-1dcdqdg"><code>      mouseMoveListeners = mouseMoveListeners.filter(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">listener</span>) </span>{
</code></td></tr><tr><td id="L836" class="css-a4x74f"><span>836</span></td><td id="LC836" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> listener !== debouncedOnMouseMove;
</code></td></tr><tr><td id="L837" class="css-a4x74f"><span>837</span></td><td id="LC837" class="css-1dcdqdg"><code>      });
</code></td></tr><tr><td id="L838" class="css-a4x74f"><span>838</span></td><td id="LC838" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L839" class="css-a4x74f"><span>839</span></td><td id="LC839" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L840" class="css-a4x74f"><span>840</span></td><td id="LC840" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onDocumentPress</span>(<span class="code-params">event</span>) </span>{
</code></td></tr><tr><td id="L841" class="css-a4x74f"><span>841</span></td><td id="LC841" class="css-1dcdqdg"><code>      <span class="code-comment">// Moved finger to scroll instead of an intentional tap outside</span>
</code></td></tr><tr><td id="L842" class="css-a4x74f"><span>842</span></td><td id="LC842" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (currentInput.isTouch) {
</code></td></tr><tr><td id="L843" class="css-a4x74f"><span>843</span></td><td id="LC843" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (didTouchMove || event.type === <span class="code-string">'mousedown'</span>) {
</code></td></tr><tr><td id="L844" class="css-a4x74f"><span>844</span></td><td id="LC844" class="css-1dcdqdg"><code>          <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L845" class="css-a4x74f"><span>845</span></td><td id="LC845" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L846" class="css-a4x74f"><span>846</span></td><td id="LC846" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L847" class="css-a4x74f"><span>847</span></td><td id="LC847" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L848" class="css-a4x74f"><span>848</span></td><td id="LC848" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> actualTarget = event.composedPath &amp;&amp; event.composedPath()[<span class="code-number">0</span>] || event.target; <span class="code-comment">// Clicked on interactive popper</span>
</code></td></tr><tr><td id="L849" class="css-a4x74f"><span>849</span></td><td id="LC849" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L850" class="css-a4x74f"><span>850</span></td><td id="LC850" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (instance.props.interactive &amp;&amp; actualContains(popper, actualTarget)) {
</code></td></tr><tr><td id="L851" class="css-a4x74f"><span>851</span></td><td id="LC851" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L852" class="css-a4x74f"><span>852</span></td><td id="LC852" class="css-1dcdqdg"><code>      } <span class="code-comment">// Clicked on the event listeners target</span>
</code></td></tr><tr><td id="L853" class="css-a4x74f"><span>853</span></td><td id="LC853" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L854" class="css-a4x74f"><span>854</span></td><td id="LC854" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L855" class="css-a4x74f"><span>855</span></td><td id="LC855" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (normalizeToArray(instance.props.triggerTarget || reference).some(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">el</span>) </span>{
</code></td></tr><tr><td id="L856" class="css-a4x74f"><span>856</span></td><td id="LC856" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> actualContains(el, actualTarget);
</code></td></tr><tr><td id="L857" class="css-a4x74f"><span>857</span></td><td id="LC857" class="css-1dcdqdg"><code>      })) {
</code></td></tr><tr><td id="L858" class="css-a4x74f"><span>858</span></td><td id="LC858" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (currentInput.isTouch) {
</code></td></tr><tr><td id="L859" class="css-a4x74f"><span>859</span></td><td id="LC859" class="css-1dcdqdg"><code>          <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L860" class="css-a4x74f"><span>860</span></td><td id="LC860" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L861" class="css-a4x74f"><span>861</span></td><td id="LC861" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L862" class="css-a4x74f"><span>862</span></td><td id="LC862" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (instance.state.isVisible &amp;&amp; instance.props.trigger.indexOf(<span class="code-string">'click'</span>) &gt;= <span class="code-number">0</span>) {
</code></td></tr><tr><td id="L863" class="css-a4x74f"><span>863</span></td><td id="LC863" class="css-1dcdqdg"><code>          <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L864" class="css-a4x74f"><span>864</span></td><td id="LC864" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L865" class="css-a4x74f"><span>865</span></td><td id="LC865" class="css-1dcdqdg"><code>      } <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L866" class="css-a4x74f"><span>866</span></td><td id="LC866" class="css-1dcdqdg"><code>        invokeHook(<span class="code-string">'onClickOutside'</span>, [instance, event]);
</code></td></tr><tr><td id="L867" class="css-a4x74f"><span>867</span></td><td id="LC867" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L868" class="css-a4x74f"><span>868</span></td><td id="LC868" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L869" class="css-a4x74f"><span>869</span></td><td id="LC869" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (instance.props.hideOnClick === <span class="code-literal">true</span>) {
</code></td></tr><tr><td id="L870" class="css-a4x74f"><span>870</span></td><td id="LC870" class="css-1dcdqdg"><code>        instance.clearDelayTimeouts();
</code></td></tr><tr><td id="L871" class="css-a4x74f"><span>871</span></td><td id="LC871" class="css-1dcdqdg"><code>        instance.hide(); <span class="code-comment">// `mousedown` event is fired right before `focus` if pressing the</span>
</code></td></tr><tr><td id="L872" class="css-a4x74f"><span>872</span></td><td id="LC872" class="css-1dcdqdg"><code>        <span class="code-comment">// currentTarget. This lets a tippy with `focus` trigger know that it</span>
</code></td></tr><tr><td id="L873" class="css-a4x74f"><span>873</span></td><td id="LC873" class="css-1dcdqdg"><code>        <span class="code-comment">// should not show</span>
</code></td></tr><tr><td id="L874" class="css-a4x74f"><span>874</span></td><td id="LC874" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L875" class="css-a4x74f"><span>875</span></td><td id="LC875" class="css-1dcdqdg"><code>        didHideDueToDocumentMouseDown = <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L876" class="css-a4x74f"><span>876</span></td><td id="LC876" class="css-1dcdqdg"><code>        setTimeout(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L877" class="css-a4x74f"><span>877</span></td><td id="LC877" class="css-1dcdqdg"><code>          didHideDueToDocumentMouseDown = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L878" class="css-a4x74f"><span>878</span></td><td id="LC878" class="css-1dcdqdg"><code>        }); <span class="code-comment">// The listener gets added in `scheduleShow()`, but this may be hiding it</span>
</code></td></tr><tr><td id="L879" class="css-a4x74f"><span>879</span></td><td id="LC879" class="css-1dcdqdg"><code>        <span class="code-comment">// before it shows, and hide()'s early bail-out behavior can prevent it</span>
</code></td></tr><tr><td id="L880" class="css-a4x74f"><span>880</span></td><td id="LC880" class="css-1dcdqdg"><code>        <span class="code-comment">// from being cleaned up</span>
</code></td></tr><tr><td id="L881" class="css-a4x74f"><span>881</span></td><td id="LC881" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L882" class="css-a4x74f"><span>882</span></td><td id="LC882" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (!instance.state.isMounted) {
</code></td></tr><tr><td id="L883" class="css-a4x74f"><span>883</span></td><td id="LC883" class="css-1dcdqdg"><code>          removeDocumentPress();
</code></td></tr><tr><td id="L884" class="css-a4x74f"><span>884</span></td><td id="LC884" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L885" class="css-a4x74f"><span>885</span></td><td id="LC885" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L886" class="css-a4x74f"><span>886</span></td><td id="LC886" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L887" class="css-a4x74f"><span>887</span></td><td id="LC887" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L888" class="css-a4x74f"><span>888</span></td><td id="LC888" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onTouchMove</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L889" class="css-a4x74f"><span>889</span></td><td id="LC889" class="css-1dcdqdg"><code>      didTouchMove = <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L890" class="css-a4x74f"><span>890</span></td><td id="LC890" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L891" class="css-a4x74f"><span>891</span></td><td id="LC891" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L892" class="css-a4x74f"><span>892</span></td><td id="LC892" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onTouchStart</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L893" class="css-a4x74f"><span>893</span></td><td id="LC893" class="css-1dcdqdg"><code>      didTouchMove = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L894" class="css-a4x74f"><span>894</span></td><td id="LC894" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L895" class="css-a4x74f"><span>895</span></td><td id="LC895" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L896" class="css-a4x74f"><span>896</span></td><td id="LC896" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">addDocumentPress</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L897" class="css-a4x74f"><span>897</span></td><td id="LC897" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> doc = getDocument();
</code></td></tr><tr><td id="L898" class="css-a4x74f"><span>898</span></td><td id="LC898" class="css-1dcdqdg"><code>      doc.addEventListener(<span class="code-string">'mousedown'</span>, onDocumentPress, <span class="code-literal">true</span>);
</code></td></tr><tr><td id="L899" class="css-a4x74f"><span>899</span></td><td id="LC899" class="css-1dcdqdg"><code>      doc.addEventListener(<span class="code-string">'touchend'</span>, onDocumentPress, TOUCH_OPTIONS);
</code></td></tr><tr><td id="L900" class="css-a4x74f"><span>900</span></td><td id="LC900" class="css-1dcdqdg"><code>      doc.addEventListener(<span class="code-string">'touchstart'</span>, onTouchStart, TOUCH_OPTIONS);
</code></td></tr><tr><td id="L901" class="css-a4x74f"><span>901</span></td><td id="LC901" class="css-1dcdqdg"><code>      doc.addEventListener(<span class="code-string">'touchmove'</span>, onTouchMove, TOUCH_OPTIONS);
</code></td></tr><tr><td id="L902" class="css-a4x74f"><span>902</span></td><td id="LC902" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L903" class="css-a4x74f"><span>903</span></td><td id="LC903" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L904" class="css-a4x74f"><span>904</span></td><td id="LC904" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">removeDocumentPress</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L905" class="css-a4x74f"><span>905</span></td><td id="LC905" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> doc = getDocument();
</code></td></tr><tr><td id="L906" class="css-a4x74f"><span>906</span></td><td id="LC906" class="css-1dcdqdg"><code>      doc.removeEventListener(<span class="code-string">'mousedown'</span>, onDocumentPress, <span class="code-literal">true</span>);
</code></td></tr><tr><td id="L907" class="css-a4x74f"><span>907</span></td><td id="LC907" class="css-1dcdqdg"><code>      doc.removeEventListener(<span class="code-string">'touchend'</span>, onDocumentPress, TOUCH_OPTIONS);
</code></td></tr><tr><td id="L908" class="css-a4x74f"><span>908</span></td><td id="LC908" class="css-1dcdqdg"><code>      doc.removeEventListener(<span class="code-string">'touchstart'</span>, onTouchStart, TOUCH_OPTIONS);
</code></td></tr><tr><td id="L909" class="css-a4x74f"><span>909</span></td><td id="LC909" class="css-1dcdqdg"><code>      doc.removeEventListener(<span class="code-string">'touchmove'</span>, onTouchMove, TOUCH_OPTIONS);
</code></td></tr><tr><td id="L910" class="css-a4x74f"><span>910</span></td><td id="LC910" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L911" class="css-a4x74f"><span>911</span></td><td id="LC911" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L912" class="css-a4x74f"><span>912</span></td><td id="LC912" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onTransitionedOut</span>(<span class="code-params">duration, callback</span>) </span>{
</code></td></tr><tr><td id="L913" class="css-a4x74f"><span>913</span></td><td id="LC913" class="css-1dcdqdg"><code>      onTransitionEnd(duration, <span class="code-function"><span class="code-keyword">function</span> (<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L914" class="css-a4x74f"><span>914</span></td><td id="LC914" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (!instance.state.isVisible &amp;&amp; popper.parentNode &amp;&amp; popper.parentNode.contains(popper)) {
</code></td></tr><tr><td id="L915" class="css-a4x74f"><span>915</span></td><td id="LC915" class="css-1dcdqdg"><code>          callback();
</code></td></tr><tr><td id="L916" class="css-a4x74f"><span>916</span></td><td id="LC916" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L917" class="css-a4x74f"><span>917</span></td><td id="LC917" class="css-1dcdqdg"><code>      });
</code></td></tr><tr><td id="L918" class="css-a4x74f"><span>918</span></td><td id="LC918" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L919" class="css-a4x74f"><span>919</span></td><td id="LC919" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L920" class="css-a4x74f"><span>920</span></td><td id="LC920" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onTransitionedIn</span>(<span class="code-params">duration, callback</span>) </span>{
</code></td></tr><tr><td id="L921" class="css-a4x74f"><span>921</span></td><td id="LC921" class="css-1dcdqdg"><code>      onTransitionEnd(duration, callback);
</code></td></tr><tr><td id="L922" class="css-a4x74f"><span>922</span></td><td id="LC922" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L923" class="css-a4x74f"><span>923</span></td><td id="LC923" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L924" class="css-a4x74f"><span>924</span></td><td id="LC924" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onTransitionEnd</span>(<span class="code-params">duration, callback</span>) </span>{
</code></td></tr><tr><td id="L925" class="css-a4x74f"><span>925</span></td><td id="LC925" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> box = getDefaultTemplateChildren().box;
</code></td></tr><tr><td id="L926" class="css-a4x74f"><span>926</span></td><td id="LC926" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L927" class="css-a4x74f"><span>927</span></td><td id="LC927" class="css-1dcdqdg"><code>      <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">listener</span>(<span class="code-params">event</span>) </span>{
</code></td></tr><tr><td id="L928" class="css-a4x74f"><span>928</span></td><td id="LC928" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (event.target === box) {
</code></td></tr><tr><td id="L929" class="css-a4x74f"><span>929</span></td><td id="LC929" class="css-1dcdqdg"><code>          updateTransitionEndListener(box, <span class="code-string">'remove'</span>, listener);
</code></td></tr><tr><td id="L930" class="css-a4x74f"><span>930</span></td><td id="LC930" class="css-1dcdqdg"><code>          callback();
</code></td></tr><tr><td id="L931" class="css-a4x74f"><span>931</span></td><td id="LC931" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L932" class="css-a4x74f"><span>932</span></td><td id="LC932" class="css-1dcdqdg"><code>      } <span class="code-comment">// Make callback synchronous if duration is 0</span>
</code></td></tr><tr><td id="L933" class="css-a4x74f"><span>933</span></td><td id="LC933" class="css-1dcdqdg"><code>      <span class="code-comment">// `transitionend` won't fire otherwise</span>
</code></td></tr><tr><td id="L934" class="css-a4x74f"><span>934</span></td><td id="LC934" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L935" class="css-a4x74f"><span>935</span></td><td id="LC935" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L936" class="css-a4x74f"><span>936</span></td><td id="LC936" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (duration === <span class="code-number">0</span>) {
</code></td></tr><tr><td id="L937" class="css-a4x74f"><span>937</span></td><td id="LC937" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> callback();
</code></td></tr><tr><td id="L938" class="css-a4x74f"><span>938</span></td><td id="LC938" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L939" class="css-a4x74f"><span>939</span></td><td id="LC939" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L940" class="css-a4x74f"><span>940</span></td><td id="LC940" class="css-1dcdqdg"><code>      updateTransitionEndListener(box, <span class="code-string">'remove'</span>, currentTransitionEndListener);
</code></td></tr><tr><td id="L941" class="css-a4x74f"><span>941</span></td><td id="LC941" class="css-1dcdqdg"><code>      updateTransitionEndListener(box, <span class="code-string">'add'</span>, listener);
</code></td></tr><tr><td id="L942" class="css-a4x74f"><span>942</span></td><td id="LC942" class="css-1dcdqdg"><code>      currentTransitionEndListener = listener;
</code></td></tr><tr><td id="L943" class="css-a4x74f"><span>943</span></td><td id="LC943" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L944" class="css-a4x74f"><span>944</span></td><td id="LC944" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L945" class="css-a4x74f"><span>945</span></td><td id="LC945" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">on</span>(<span class="code-params">eventType, handler, options</span>) </span>{
</code></td></tr><tr><td id="L946" class="css-a4x74f"><span>946</span></td><td id="LC946" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (options === <span class="code-keyword">void</span> <span class="code-number">0</span>) {
</code></td></tr><tr><td id="L947" class="css-a4x74f"><span>947</span></td><td id="LC947" class="css-1dcdqdg"><code>        options = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L948" class="css-a4x74f"><span>948</span></td><td id="LC948" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L949" class="css-a4x74f"><span>949</span></td><td id="LC949" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L950" class="css-a4x74f"><span>950</span></td><td id="LC950" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> nodes = normalizeToArray(instance.props.triggerTarget || reference);
</code></td></tr><tr><td id="L951" class="css-a4x74f"><span>951</span></td><td id="LC951" class="css-1dcdqdg"><code>      nodes.forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">node</span>) </span>{
</code></td></tr><tr><td id="L952" class="css-a4x74f"><span>952</span></td><td id="LC952" class="css-1dcdqdg"><code>        node.addEventListener(eventType, handler, options);
</code></td></tr><tr><td id="L953" class="css-a4x74f"><span>953</span></td><td id="LC953" class="css-1dcdqdg"><code>        listeners.push({
</code></td></tr><tr><td id="L954" class="css-a4x74f"><span>954</span></td><td id="LC954" class="css-1dcdqdg"><code>          node: node,
</code></td></tr><tr><td id="L955" class="css-a4x74f"><span>955</span></td><td id="LC955" class="css-1dcdqdg"><code>          eventType: eventType,
</code></td></tr><tr><td id="L956" class="css-a4x74f"><span>956</span></td><td id="LC956" class="css-1dcdqdg"><code>          handler: handler,
</code></td></tr><tr><td id="L957" class="css-a4x74f"><span>957</span></td><td id="LC957" class="css-1dcdqdg"><code>          options: options
</code></td></tr><tr><td id="L958" class="css-a4x74f"><span>958</span></td><td id="LC958" class="css-1dcdqdg"><code>        });
</code></td></tr><tr><td id="L959" class="css-a4x74f"><span>959</span></td><td id="LC959" class="css-1dcdqdg"><code>      });
</code></td></tr><tr><td id="L960" class="css-a4x74f"><span>960</span></td><td id="LC960" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L961" class="css-a4x74f"><span>961</span></td><td id="LC961" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L962" class="css-a4x74f"><span>962</span></td><td id="LC962" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">addListeners</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L963" class="css-a4x74f"><span>963</span></td><td id="LC963" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (getIsCustomTouchBehavior()) {
</code></td></tr><tr><td id="L964" class="css-a4x74f"><span>964</span></td><td id="LC964" class="css-1dcdqdg"><code>        on(<span class="code-string">'touchstart'</span>, onTrigger, {
</code></td></tr><tr><td id="L965" class="css-a4x74f"><span>965</span></td><td id="LC965" class="css-1dcdqdg"><code>          passive: <span class="code-literal">true</span>
</code></td></tr><tr><td id="L966" class="css-a4x74f"><span>966</span></td><td id="LC966" class="css-1dcdqdg"><code>        });
</code></td></tr><tr><td id="L967" class="css-a4x74f"><span>967</span></td><td id="LC967" class="css-1dcdqdg"><code>        on(<span class="code-string">'touchend'</span>, onMouseLeave, {
</code></td></tr><tr><td id="L968" class="css-a4x74f"><span>968</span></td><td id="LC968" class="css-1dcdqdg"><code>          passive: <span class="code-literal">true</span>
</code></td></tr><tr><td id="L969" class="css-a4x74f"><span>969</span></td><td id="LC969" class="css-1dcdqdg"><code>        });
</code></td></tr><tr><td id="L970" class="css-a4x74f"><span>970</span></td><td id="LC970" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L971" class="css-a4x74f"><span>971</span></td><td id="LC971" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L972" class="css-a4x74f"><span>972</span></td><td id="LC972" class="css-1dcdqdg"><code>      splitBySpaces(instance.props.trigger).forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">eventType</span>) </span>{
</code></td></tr><tr><td id="L973" class="css-a4x74f"><span>973</span></td><td id="LC973" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (eventType === <span class="code-string">'manual'</span>) {
</code></td></tr><tr><td id="L974" class="css-a4x74f"><span>974</span></td><td id="LC974" class="css-1dcdqdg"><code>          <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L975" class="css-a4x74f"><span>975</span></td><td id="LC975" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L976" class="css-a4x74f"><span>976</span></td><td id="LC976" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L977" class="css-a4x74f"><span>977</span></td><td id="LC977" class="css-1dcdqdg"><code>        on(eventType, onTrigger);
</code></td></tr><tr><td id="L978" class="css-a4x74f"><span>978</span></td><td id="LC978" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L979" class="css-a4x74f"><span>979</span></td><td id="LC979" class="css-1dcdqdg"><code>        <span class="code-keyword">switch</span> (eventType) {
</code></td></tr><tr><td id="L980" class="css-a4x74f"><span>980</span></td><td id="LC980" class="css-1dcdqdg"><code>          <span class="code-keyword">case</span> <span class="code-string">'mouseenter'</span>:
</code></td></tr><tr><td id="L981" class="css-a4x74f"><span>981</span></td><td id="LC981" class="css-1dcdqdg"><code>            on(<span class="code-string">'mouseleave'</span>, onMouseLeave);
</code></td></tr><tr><td id="L982" class="css-a4x74f"><span>982</span></td><td id="LC982" class="css-1dcdqdg"><code>            <span class="code-keyword">break</span>;
</code></td></tr><tr><td id="L983" class="css-a4x74f"><span>983</span></td><td id="LC983" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L984" class="css-a4x74f"><span>984</span></td><td id="LC984" class="css-1dcdqdg"><code>          <span class="code-keyword">case</span> <span class="code-string">'focus'</span>:
</code></td></tr><tr><td id="L985" class="css-a4x74f"><span>985</span></td><td id="LC985" class="css-1dcdqdg"><code>            on(isIE11 ? <span class="code-string">'focusout'</span> : <span class="code-string">'blur'</span>, onBlurOrFocusOut);
</code></td></tr><tr><td id="L986" class="css-a4x74f"><span>986</span></td><td id="LC986" class="css-1dcdqdg"><code>            <span class="code-keyword">break</span>;
</code></td></tr><tr><td id="L987" class="css-a4x74f"><span>987</span></td><td id="LC987" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L988" class="css-a4x74f"><span>988</span></td><td id="LC988" class="css-1dcdqdg"><code>          <span class="code-keyword">case</span> <span class="code-string">'focusin'</span>:
</code></td></tr><tr><td id="L989" class="css-a4x74f"><span>989</span></td><td id="LC989" class="css-1dcdqdg"><code>            on(<span class="code-string">'focusout'</span>, onBlurOrFocusOut);
</code></td></tr><tr><td id="L990" class="css-a4x74f"><span>990</span></td><td id="LC990" class="css-1dcdqdg"><code>            <span class="code-keyword">break</span>;
</code></td></tr><tr><td id="L991" class="css-a4x74f"><span>991</span></td><td id="LC991" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L992" class="css-a4x74f"><span>992</span></td><td id="LC992" class="css-1dcdqdg"><code>      });
</code></td></tr><tr><td id="L993" class="css-a4x74f"><span>993</span></td><td id="LC993" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L994" class="css-a4x74f"><span>994</span></td><td id="LC994" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L995" class="css-a4x74f"><span>995</span></td><td id="LC995" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">removeListeners</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L996" class="css-a4x74f"><span>996</span></td><td id="LC996" class="css-1dcdqdg"><code>      listeners.forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">_ref</span>) </span>{
</code></td></tr><tr><td id="L997" class="css-a4x74f"><span>997</span></td><td id="LC997" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> node = _ref.node,
</code></td></tr><tr><td id="L998" class="css-a4x74f"><span>998</span></td><td id="LC998" class="css-1dcdqdg"><code>            eventType = _ref.eventType,
</code></td></tr><tr><td id="L999" class="css-a4x74f"><span>999</span></td><td id="LC999" class="css-1dcdqdg"><code>            handler = _ref.handler,
</code></td></tr><tr><td id="L1000" class="css-a4x74f"><span>1000</span></td><td id="LC1000" class="css-1dcdqdg"><code>            options = _ref.options;
</code></td></tr><tr><td id="L1001" class="css-a4x74f"><span>1001</span></td><td id="LC1001" class="css-1dcdqdg"><code>        node.removeEventListener(eventType, handler, options);
</code></td></tr><tr><td id="L1002" class="css-a4x74f"><span>1002</span></td><td id="LC1002" class="css-1dcdqdg"><code>      });
</code></td></tr><tr><td id="L1003" class="css-a4x74f"><span>1003</span></td><td id="LC1003" class="css-1dcdqdg"><code>      listeners = [];
</code></td></tr><tr><td id="L1004" class="css-a4x74f"><span>1004</span></td><td id="LC1004" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1005" class="css-a4x74f"><span>1005</span></td><td id="LC1005" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1006" class="css-a4x74f"><span>1006</span></td><td id="LC1006" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onTrigger</span>(<span class="code-params">event</span>) </span>{
</code></td></tr><tr><td id="L1007" class="css-a4x74f"><span>1007</span></td><td id="LC1007" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> _lastTriggerEvent;
</code></td></tr><tr><td id="L1008" class="css-a4x74f"><span>1008</span></td><td id="LC1008" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1009" class="css-a4x74f"><span>1009</span></td><td id="LC1009" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> shouldScheduleClickHide = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L1010" class="css-a4x74f"><span>1010</span></td><td id="LC1010" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1011" class="css-a4x74f"><span>1011</span></td><td id="LC1011" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (!instance.state.isEnabled || isEventListenerStopped(event) || didHideDueToDocumentMouseDown) {
</code></td></tr><tr><td id="L1012" class="css-a4x74f"><span>1012</span></td><td id="LC1012" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1013" class="css-a4x74f"><span>1013</span></td><td id="LC1013" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1014" class="css-a4x74f"><span>1014</span></td><td id="LC1014" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1015" class="css-a4x74f"><span>1015</span></td><td id="LC1015" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> wasFocused = ((_lastTriggerEvent = lastTriggerEvent) == <span class="code-literal">null</span> ? <span class="code-keyword">void</span> <span class="code-number">0</span> : _lastTriggerEvent.type) === <span class="code-string">'focus'</span>;
</code></td></tr><tr><td id="L1016" class="css-a4x74f"><span>1016</span></td><td id="LC1016" class="css-1dcdqdg"><code>      lastTriggerEvent = event;
</code></td></tr><tr><td id="L1017" class="css-a4x74f"><span>1017</span></td><td id="LC1017" class="css-1dcdqdg"><code>      currentTarget = event.currentTarget;
</code></td></tr><tr><td id="L1018" class="css-a4x74f"><span>1018</span></td><td id="LC1018" class="css-1dcdqdg"><code>      handleAriaExpandedAttribute();
</code></td></tr><tr><td id="L1019" class="css-a4x74f"><span>1019</span></td><td id="LC1019" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1020" class="css-a4x74f"><span>1020</span></td><td id="LC1020" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (!instance.state.isVisible &amp;&amp; isMouseEvent(event)) {
</code></td></tr><tr><td id="L1021" class="css-a4x74f"><span>1021</span></td><td id="LC1021" class="css-1dcdqdg"><code>        <span class="code-comment">// If scrolling, `mouseenter` events can be fired if the cursor lands</span>
</code></td></tr><tr><td id="L1022" class="css-a4x74f"><span>1022</span></td><td id="LC1022" class="css-1dcdqdg"><code>        <span class="code-comment">// over a new target, but `mousemove` events don't get fired. This</span>
</code></td></tr><tr><td id="L1023" class="css-a4x74f"><span>1023</span></td><td id="LC1023" class="css-1dcdqdg"><code>        <span class="code-comment">// causes interactive tooltips to get stuck open until the cursor is</span>
</code></td></tr><tr><td id="L1024" class="css-a4x74f"><span>1024</span></td><td id="LC1024" class="css-1dcdqdg"><code>        <span class="code-comment">// moved</span>
</code></td></tr><tr><td id="L1025" class="css-a4x74f"><span>1025</span></td><td id="LC1025" class="css-1dcdqdg"><code>        mouseMoveListeners.forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">listener</span>) </span>{
</code></td></tr><tr><td id="L1026" class="css-a4x74f"><span>1026</span></td><td id="LC1026" class="css-1dcdqdg"><code>          <span class="code-keyword">return</span> listener(event);
</code></td></tr><tr><td id="L1027" class="css-a4x74f"><span>1027</span></td><td id="LC1027" class="css-1dcdqdg"><code>        });
</code></td></tr><tr><td id="L1028" class="css-a4x74f"><span>1028</span></td><td id="LC1028" class="css-1dcdqdg"><code>      } <span class="code-comment">// Toggle show/hide when clicking click-triggered tooltips</span>
</code></td></tr><tr><td id="L1029" class="css-a4x74f"><span>1029</span></td><td id="LC1029" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1030" class="css-a4x74f"><span>1030</span></td><td id="LC1030" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1031" class="css-a4x74f"><span>1031</span></td><td id="LC1031" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (event.type === <span class="code-string">'click'</span> &amp;&amp; (instance.props.trigger.indexOf(<span class="code-string">'mouseenter'</span>) &lt; <span class="code-number">0</span> || isVisibleFromClick) &amp;&amp; instance.props.hideOnClick !== <span class="code-literal">false</span> &amp;&amp; instance.state.isVisible) {
</code></td></tr><tr><td id="L1032" class="css-a4x74f"><span>1032</span></td><td id="LC1032" class="css-1dcdqdg"><code>        shouldScheduleClickHide = <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L1033" class="css-a4x74f"><span>1033</span></td><td id="LC1033" class="css-1dcdqdg"><code>      } <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L1034" class="css-a4x74f"><span>1034</span></td><td id="LC1034" class="css-1dcdqdg"><code>        scheduleShow(event);
</code></td></tr><tr><td id="L1035" class="css-a4x74f"><span>1035</span></td><td id="LC1035" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1036" class="css-a4x74f"><span>1036</span></td><td id="LC1036" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1037" class="css-a4x74f"><span>1037</span></td><td id="LC1037" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (event.type === <span class="code-string">'click'</span>) {
</code></td></tr><tr><td id="L1038" class="css-a4x74f"><span>1038</span></td><td id="LC1038" class="css-1dcdqdg"><code>        isVisibleFromClick = !shouldScheduleClickHide;
</code></td></tr><tr><td id="L1039" class="css-a4x74f"><span>1039</span></td><td id="LC1039" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1040" class="css-a4x74f"><span>1040</span></td><td id="LC1040" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1041" class="css-a4x74f"><span>1041</span></td><td id="LC1041" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (shouldScheduleClickHide &amp;&amp; !wasFocused) {
</code></td></tr><tr><td id="L1042" class="css-a4x74f"><span>1042</span></td><td id="LC1042" class="css-1dcdqdg"><code>        scheduleHide(event);
</code></td></tr><tr><td id="L1043" class="css-a4x74f"><span>1043</span></td><td id="LC1043" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1044" class="css-a4x74f"><span>1044</span></td><td id="LC1044" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1045" class="css-a4x74f"><span>1045</span></td><td id="LC1045" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1046" class="css-a4x74f"><span>1046</span></td><td id="LC1046" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onMouseMove</span>(<span class="code-params">event</span>) </span>{
</code></td></tr><tr><td id="L1047" class="css-a4x74f"><span>1047</span></td><td id="LC1047" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> target = event.target;
</code></td></tr><tr><td id="L1048" class="css-a4x74f"><span>1048</span></td><td id="LC1048" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> isCursorOverReferenceOrPopper = getCurrentTarget().contains(target) || popper.contains(target);
</code></td></tr><tr><td id="L1049" class="css-a4x74f"><span>1049</span></td><td id="LC1049" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1050" class="css-a4x74f"><span>1050</span></td><td id="LC1050" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (event.type === <span class="code-string">'mousemove'</span> &amp;&amp; isCursorOverReferenceOrPopper) {
</code></td></tr><tr><td id="L1051" class="css-a4x74f"><span>1051</span></td><td id="LC1051" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1052" class="css-a4x74f"><span>1052</span></td><td id="LC1052" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1053" class="css-a4x74f"><span>1053</span></td><td id="LC1053" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1054" class="css-a4x74f"><span>1054</span></td><td id="LC1054" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> popperTreeData = getNestedPopperTree().concat(popper).map(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">popper</span>) </span>{
</code></td></tr><tr><td id="L1055" class="css-a4x74f"><span>1055</span></td><td id="LC1055" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> _instance$popperInsta;
</code></td></tr><tr><td id="L1056" class="css-a4x74f"><span>1056</span></td><td id="LC1056" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1057" class="css-a4x74f"><span>1057</span></td><td id="LC1057" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> instance = popper._tippy;
</code></td></tr><tr><td id="L1058" class="css-a4x74f"><span>1058</span></td><td id="LC1058" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> state = (_instance$popperInsta = instance.popperInstance) == <span class="code-literal">null</span> ? <span class="code-keyword">void</span> <span class="code-number">0</span> : _instance$popperInsta.state;
</code></td></tr><tr><td id="L1059" class="css-a4x74f"><span>1059</span></td><td id="LC1059" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1060" class="css-a4x74f"><span>1060</span></td><td id="LC1060" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (state) {
</code></td></tr><tr><td id="L1061" class="css-a4x74f"><span>1061</span></td><td id="LC1061" class="css-1dcdqdg"><code>          <span class="code-keyword">return</span> {
</code></td></tr><tr><td id="L1062" class="css-a4x74f"><span>1062</span></td><td id="LC1062" class="css-1dcdqdg"><code>            popperRect: popper.getBoundingClientRect(),
</code></td></tr><tr><td id="L1063" class="css-a4x74f"><span>1063</span></td><td id="LC1063" class="css-1dcdqdg"><code>            popperState: state,
</code></td></tr><tr><td id="L1064" class="css-a4x74f"><span>1064</span></td><td id="LC1064" class="css-1dcdqdg"><code>            props: props
</code></td></tr><tr><td id="L1065" class="css-a4x74f"><span>1065</span></td><td id="LC1065" class="css-1dcdqdg"><code>          };
</code></td></tr><tr><td id="L1066" class="css-a4x74f"><span>1066</span></td><td id="LC1066" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L1067" class="css-a4x74f"><span>1067</span></td><td id="LC1067" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1068" class="css-a4x74f"><span>1068</span></td><td id="LC1068" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> <span class="code-literal">null</span>;
</code></td></tr><tr><td id="L1069" class="css-a4x74f"><span>1069</span></td><td id="LC1069" class="css-1dcdqdg"><code>      }).filter(<span class="code-built_in">Boolean</span>);
</code></td></tr><tr><td id="L1070" class="css-a4x74f"><span>1070</span></td><td id="LC1070" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1071" class="css-a4x74f"><span>1071</span></td><td id="LC1071" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (isCursorOutsideInteractiveBorder(popperTreeData, event)) {
</code></td></tr><tr><td id="L1072" class="css-a4x74f"><span>1072</span></td><td id="LC1072" class="css-1dcdqdg"><code>        cleanupInteractiveMouseListeners();
</code></td></tr><tr><td id="L1073" class="css-a4x74f"><span>1073</span></td><td id="LC1073" class="css-1dcdqdg"><code>        scheduleHide(event);
</code></td></tr><tr><td id="L1074" class="css-a4x74f"><span>1074</span></td><td id="LC1074" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1075" class="css-a4x74f"><span>1075</span></td><td id="LC1075" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1076" class="css-a4x74f"><span>1076</span></td><td id="LC1076" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1077" class="css-a4x74f"><span>1077</span></td><td id="LC1077" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onMouseLeave</span>(<span class="code-params">event</span>) </span>{
</code></td></tr><tr><td id="L1078" class="css-a4x74f"><span>1078</span></td><td id="LC1078" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> shouldBail = isEventListenerStopped(event) || instance.props.trigger.indexOf(<span class="code-string">'click'</span>) &gt;= <span class="code-number">0</span> &amp;&amp; isVisibleFromClick;
</code></td></tr><tr><td id="L1079" class="css-a4x74f"><span>1079</span></td><td id="LC1079" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1080" class="css-a4x74f"><span>1080</span></td><td id="LC1080" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (shouldBail) {
</code></td></tr><tr><td id="L1081" class="css-a4x74f"><span>1081</span></td><td id="LC1081" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1082" class="css-a4x74f"><span>1082</span></td><td id="LC1082" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1083" class="css-a4x74f"><span>1083</span></td><td id="LC1083" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1084" class="css-a4x74f"><span>1084</span></td><td id="LC1084" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (instance.props.interactive) {
</code></td></tr><tr><td id="L1085" class="css-a4x74f"><span>1085</span></td><td id="LC1085" class="css-1dcdqdg"><code>        instance.hideWithInteractivity(event);
</code></td></tr><tr><td id="L1086" class="css-a4x74f"><span>1086</span></td><td id="LC1086" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1087" class="css-a4x74f"><span>1087</span></td><td id="LC1087" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1088" class="css-a4x74f"><span>1088</span></td><td id="LC1088" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1089" class="css-a4x74f"><span>1089</span></td><td id="LC1089" class="css-1dcdqdg"><code>      scheduleHide(event);
</code></td></tr><tr><td id="L1090" class="css-a4x74f"><span>1090</span></td><td id="LC1090" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1091" class="css-a4x74f"><span>1091</span></td><td id="LC1091" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1092" class="css-a4x74f"><span>1092</span></td><td id="LC1092" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onBlurOrFocusOut</span>(<span class="code-params">event</span>) </span>{
</code></td></tr><tr><td id="L1093" class="css-a4x74f"><span>1093</span></td><td id="LC1093" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (instance.props.trigger.indexOf(<span class="code-string">'focusin'</span>) &lt; <span class="code-number">0</span> &amp;&amp; event.target !== getCurrentTarget()) {
</code></td></tr><tr><td id="L1094" class="css-a4x74f"><span>1094</span></td><td id="LC1094" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1095" class="css-a4x74f"><span>1095</span></td><td id="LC1095" class="css-1dcdqdg"><code>      } <span class="code-comment">// If focus was moved to within the popper</span>
</code></td></tr><tr><td id="L1096" class="css-a4x74f"><span>1096</span></td><td id="LC1096" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1097" class="css-a4x74f"><span>1097</span></td><td id="LC1097" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1098" class="css-a4x74f"><span>1098</span></td><td id="LC1098" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (instance.props.interactive &amp;&amp; event.relatedTarget &amp;&amp; popper.contains(event.relatedTarget)) {
</code></td></tr><tr><td id="L1099" class="css-a4x74f"><span>1099</span></td><td id="LC1099" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1100" class="css-a4x74f"><span>1100</span></td><td id="LC1100" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1101" class="css-a4x74f"><span>1101</span></td><td id="LC1101" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1102" class="css-a4x74f"><span>1102</span></td><td id="LC1102" class="css-1dcdqdg"><code>      scheduleHide(event);
</code></td></tr><tr><td id="L1103" class="css-a4x74f"><span>1103</span></td><td id="LC1103" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1104" class="css-a4x74f"><span>1104</span></td><td id="LC1104" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1105" class="css-a4x74f"><span>1105</span></td><td id="LC1105" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">isEventListenerStopped</span>(<span class="code-params">event</span>) </span>{
</code></td></tr><tr><td id="L1106" class="css-a4x74f"><span>1106</span></td><td id="LC1106" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> currentInput.isTouch ? getIsCustomTouchBehavior() !== event.type.indexOf(<span class="code-string">'touch'</span>) &gt;= <span class="code-number">0</span> : <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L1107" class="css-a4x74f"><span>1107</span></td><td id="LC1107" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1108" class="css-a4x74f"><span>1108</span></td><td id="LC1108" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1109" class="css-a4x74f"><span>1109</span></td><td id="LC1109" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">createPopperInstance</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1110" class="css-a4x74f"><span>1110</span></td><td id="LC1110" class="css-1dcdqdg"><code>      destroyPopperInstance();
</code></td></tr><tr><td id="L1111" class="css-a4x74f"><span>1111</span></td><td id="LC1111" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> _instance$props2 = instance.props,
</code></td></tr><tr><td id="L1112" class="css-a4x74f"><span>1112</span></td><td id="LC1112" class="css-1dcdqdg"><code>          popperOptions = _instance$props2.popperOptions,
</code></td></tr><tr><td id="L1113" class="css-a4x74f"><span>1113</span></td><td id="LC1113" class="css-1dcdqdg"><code>          placement = _instance$props2.placement,
</code></td></tr><tr><td id="L1114" class="css-a4x74f"><span>1114</span></td><td id="LC1114" class="css-1dcdqdg"><code>          offset = _instance$props2.offset,
</code></td></tr><tr><td id="L1115" class="css-a4x74f"><span>1115</span></td><td id="LC1115" class="css-1dcdqdg"><code>          getReferenceClientRect = _instance$props2.getReferenceClientRect,
</code></td></tr><tr><td id="L1116" class="css-a4x74f"><span>1116</span></td><td id="LC1116" class="css-1dcdqdg"><code>          moveTransition = _instance$props2.moveTransition;
</code></td></tr><tr><td id="L1117" class="css-a4x74f"><span>1117</span></td><td id="LC1117" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> arrow = getIsDefaultRenderFn() ? getChildren(popper).arrow : <span class="code-literal">null</span>;
</code></td></tr><tr><td id="L1118" class="css-a4x74f"><span>1118</span></td><td id="LC1118" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> computedReference = getReferenceClientRect ? {
</code></td></tr><tr><td id="L1119" class="css-a4x74f"><span>1119</span></td><td id="LC1119" class="css-1dcdqdg"><code>        getBoundingClientRect: getReferenceClientRect,
</code></td></tr><tr><td id="L1120" class="css-a4x74f"><span>1120</span></td><td id="LC1120" class="css-1dcdqdg"><code>        contextElement: getReferenceClientRect.contextElement || getCurrentTarget()
</code></td></tr><tr><td id="L1121" class="css-a4x74f"><span>1121</span></td><td id="LC1121" class="css-1dcdqdg"><code>      } : reference;
</code></td></tr><tr><td id="L1122" class="css-a4x74f"><span>1122</span></td><td id="LC1122" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> tippyModifier = {
</code></td></tr><tr><td id="L1123" class="css-a4x74f"><span>1123</span></td><td id="LC1123" class="css-1dcdqdg"><code>        name: <span class="code-string">'$$tippy'</span>,
</code></td></tr><tr><td id="L1124" class="css-a4x74f"><span>1124</span></td><td id="LC1124" class="css-1dcdqdg"><code>        enabled: <span class="code-literal">true</span>,
</code></td></tr><tr><td id="L1125" class="css-a4x74f"><span>1125</span></td><td id="LC1125" class="css-1dcdqdg"><code>        phase: <span class="code-string">'beforeWrite'</span>,
</code></td></tr><tr><td id="L1126" class="css-a4x74f"><span>1126</span></td><td id="LC1126" class="css-1dcdqdg"><code>        requires: [<span class="code-string">'computeStyles'</span>],
</code></td></tr><tr><td id="L1127" class="css-a4x74f"><span>1127</span></td><td id="LC1127" class="css-1dcdqdg"><code>        fn: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">fn</span>(<span class="code-params">_ref2</span>) </span>{
</code></td></tr><tr><td id="L1128" class="css-a4x74f"><span>1128</span></td><td id="LC1128" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> state = _ref2.state;
</code></td></tr><tr><td id="L1129" class="css-a4x74f"><span>1129</span></td><td id="LC1129" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1130" class="css-a4x74f"><span>1130</span></td><td id="LC1130" class="css-1dcdqdg"><code>          <span class="code-keyword">if</span> (getIsDefaultRenderFn()) {
</code></td></tr><tr><td id="L1131" class="css-a4x74f"><span>1131</span></td><td id="LC1131" class="css-1dcdqdg"><code>            <span class="code-keyword">var</span> _getDefaultTemplateCh = getDefaultTemplateChildren(),
</code></td></tr><tr><td id="L1132" class="css-a4x74f"><span>1132</span></td><td id="LC1132" class="css-1dcdqdg"><code>                box = _getDefaultTemplateCh.box;
</code></td></tr><tr><td id="L1133" class="css-a4x74f"><span>1133</span></td><td id="LC1133" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1134" class="css-a4x74f"><span>1134</span></td><td id="LC1134" class="css-1dcdqdg"><code>            [<span class="code-string">'placement'</span>, <span class="code-string">'reference-hidden'</span>, <span class="code-string">'escaped'</span>].forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">attr</span>) </span>{
</code></td></tr><tr><td id="L1135" class="css-a4x74f"><span>1135</span></td><td id="LC1135" class="css-1dcdqdg"><code>              <span class="code-keyword">if</span> (attr === <span class="code-string">'placement'</span>) {
</code></td></tr><tr><td id="L1136" class="css-a4x74f"><span>1136</span></td><td id="LC1136" class="css-1dcdqdg"><code>                box.setAttribute(<span class="code-string">'data-placement'</span>, state.placement);
</code></td></tr><tr><td id="L1137" class="css-a4x74f"><span>1137</span></td><td id="LC1137" class="css-1dcdqdg"><code>              } <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L1138" class="css-a4x74f"><span>1138</span></td><td id="LC1138" class="css-1dcdqdg"><code>                <span class="code-keyword">if</span> (state.attributes.popper[<span class="code-string">"data-popper-"</span> + attr]) {
</code></td></tr><tr><td id="L1139" class="css-a4x74f"><span>1139</span></td><td id="LC1139" class="css-1dcdqdg"><code>                  box.setAttribute(<span class="code-string">"data-"</span> + attr, <span class="code-string">''</span>);
</code></td></tr><tr><td id="L1140" class="css-a4x74f"><span>1140</span></td><td id="LC1140" class="css-1dcdqdg"><code>                } <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L1141" class="css-a4x74f"><span>1141</span></td><td id="LC1141" class="css-1dcdqdg"><code>                  box.removeAttribute(<span class="code-string">"data-"</span> + attr);
</code></td></tr><tr><td id="L1142" class="css-a4x74f"><span>1142</span></td><td id="LC1142" class="css-1dcdqdg"><code>                }
</code></td></tr><tr><td id="L1143" class="css-a4x74f"><span>1143</span></td><td id="LC1143" class="css-1dcdqdg"><code>              }
</code></td></tr><tr><td id="L1144" class="css-a4x74f"><span>1144</span></td><td id="LC1144" class="css-1dcdqdg"><code>            });
</code></td></tr><tr><td id="L1145" class="css-a4x74f"><span>1145</span></td><td id="LC1145" class="css-1dcdqdg"><code>            state.attributes.popper = {};
</code></td></tr><tr><td id="L1146" class="css-a4x74f"><span>1146</span></td><td id="LC1146" class="css-1dcdqdg"><code>          }
</code></td></tr><tr><td id="L1147" class="css-a4x74f"><span>1147</span></td><td id="LC1147" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L1148" class="css-a4x74f"><span>1148</span></td><td id="LC1148" class="css-1dcdqdg"><code>      };
</code></td></tr><tr><td id="L1149" class="css-a4x74f"><span>1149</span></td><td id="LC1149" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> modifiers = [{
</code></td></tr><tr><td id="L1150" class="css-a4x74f"><span>1150</span></td><td id="LC1150" class="css-1dcdqdg"><code>        name: <span class="code-string">'offset'</span>,
</code></td></tr><tr><td id="L1151" class="css-a4x74f"><span>1151</span></td><td id="LC1151" class="css-1dcdqdg"><code>        options: {
</code></td></tr><tr><td id="L1152" class="css-a4x74f"><span>1152</span></td><td id="LC1152" class="css-1dcdqdg"><code>          offset: offset
</code></td></tr><tr><td id="L1153" class="css-a4x74f"><span>1153</span></td><td id="LC1153" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L1154" class="css-a4x74f"><span>1154</span></td><td id="LC1154" class="css-1dcdqdg"><code>      }, {
</code></td></tr><tr><td id="L1155" class="css-a4x74f"><span>1155</span></td><td id="LC1155" class="css-1dcdqdg"><code>        name: <span class="code-string">'preventOverflow'</span>,
</code></td></tr><tr><td id="L1156" class="css-a4x74f"><span>1156</span></td><td id="LC1156" class="css-1dcdqdg"><code>        options: {
</code></td></tr><tr><td id="L1157" class="css-a4x74f"><span>1157</span></td><td id="LC1157" class="css-1dcdqdg"><code>          padding: {
</code></td></tr><tr><td id="L1158" class="css-a4x74f"><span>1158</span></td><td id="LC1158" class="css-1dcdqdg"><code>            top: <span class="code-number">2</span>,
</code></td></tr><tr><td id="L1159" class="css-a4x74f"><span>1159</span></td><td id="LC1159" class="css-1dcdqdg"><code>            bottom: <span class="code-number">2</span>,
</code></td></tr><tr><td id="L1160" class="css-a4x74f"><span>1160</span></td><td id="LC1160" class="css-1dcdqdg"><code>            left: <span class="code-number">5</span>,
</code></td></tr><tr><td id="L1161" class="css-a4x74f"><span>1161</span></td><td id="LC1161" class="css-1dcdqdg"><code>            right: <span class="code-number">5</span>
</code></td></tr><tr><td id="L1162" class="css-a4x74f"><span>1162</span></td><td id="LC1162" class="css-1dcdqdg"><code>          }
</code></td></tr><tr><td id="L1163" class="css-a4x74f"><span>1163</span></td><td id="LC1163" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L1164" class="css-a4x74f"><span>1164</span></td><td id="LC1164" class="css-1dcdqdg"><code>      }, {
</code></td></tr><tr><td id="L1165" class="css-a4x74f"><span>1165</span></td><td id="LC1165" class="css-1dcdqdg"><code>        name: <span class="code-string">'flip'</span>,
</code></td></tr><tr><td id="L1166" class="css-a4x74f"><span>1166</span></td><td id="LC1166" class="css-1dcdqdg"><code>        options: {
</code></td></tr><tr><td id="L1167" class="css-a4x74f"><span>1167</span></td><td id="LC1167" class="css-1dcdqdg"><code>          padding: <span class="code-number">5</span>
</code></td></tr><tr><td id="L1168" class="css-a4x74f"><span>1168</span></td><td id="LC1168" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L1169" class="css-a4x74f"><span>1169</span></td><td id="LC1169" class="css-1dcdqdg"><code>      }, {
</code></td></tr><tr><td id="L1170" class="css-a4x74f"><span>1170</span></td><td id="LC1170" class="css-1dcdqdg"><code>        name: <span class="code-string">'computeStyles'</span>,
</code></td></tr><tr><td id="L1171" class="css-a4x74f"><span>1171</span></td><td id="LC1171" class="css-1dcdqdg"><code>        options: {
</code></td></tr><tr><td id="L1172" class="css-a4x74f"><span>1172</span></td><td id="LC1172" class="css-1dcdqdg"><code>          adaptive: !moveTransition
</code></td></tr><tr><td id="L1173" class="css-a4x74f"><span>1173</span></td><td id="LC1173" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L1174" class="css-a4x74f"><span>1174</span></td><td id="LC1174" class="css-1dcdqdg"><code>      }, tippyModifier];
</code></td></tr><tr><td id="L1175" class="css-a4x74f"><span>1175</span></td><td id="LC1175" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1176" class="css-a4x74f"><span>1176</span></td><td id="LC1176" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (getIsDefaultRenderFn() &amp;&amp; arrow) {
</code></td></tr><tr><td id="L1177" class="css-a4x74f"><span>1177</span></td><td id="LC1177" class="css-1dcdqdg"><code>        modifiers.push({
</code></td></tr><tr><td id="L1178" class="css-a4x74f"><span>1178</span></td><td id="LC1178" class="css-1dcdqdg"><code>          name: <span class="code-string">'arrow'</span>,
</code></td></tr><tr><td id="L1179" class="css-a4x74f"><span>1179</span></td><td id="LC1179" class="css-1dcdqdg"><code>          options: {
</code></td></tr><tr><td id="L1180" class="css-a4x74f"><span>1180</span></td><td id="LC1180" class="css-1dcdqdg"><code>            element: arrow,
</code></td></tr><tr><td id="L1181" class="css-a4x74f"><span>1181</span></td><td id="LC1181" class="css-1dcdqdg"><code>            padding: <span class="code-number">3</span>
</code></td></tr><tr><td id="L1182" class="css-a4x74f"><span>1182</span></td><td id="LC1182" class="css-1dcdqdg"><code>          }
</code></td></tr><tr><td id="L1183" class="css-a4x74f"><span>1183</span></td><td id="LC1183" class="css-1dcdqdg"><code>        });
</code></td></tr><tr><td id="L1184" class="css-a4x74f"><span>1184</span></td><td id="LC1184" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1185" class="css-a4x74f"><span>1185</span></td><td id="LC1185" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1186" class="css-a4x74f"><span>1186</span></td><td id="LC1186" class="css-1dcdqdg"><code>      modifiers.push.apply(modifiers, (popperOptions == <span class="code-literal">null</span> ? <span class="code-keyword">void</span> <span class="code-number">0</span> : popperOptions.modifiers) || []);
</code></td></tr><tr><td id="L1187" class="css-a4x74f"><span>1187</span></td><td id="LC1187" class="css-1dcdqdg"><code>      instance.popperInstance = core.createPopper(computedReference, popper, <span class="code-built_in">Object</span>.assign({}, popperOptions, {
</code></td></tr><tr><td id="L1188" class="css-a4x74f"><span>1188</span></td><td id="LC1188" class="css-1dcdqdg"><code>        placement: placement,
</code></td></tr><tr><td id="L1189" class="css-a4x74f"><span>1189</span></td><td id="LC1189" class="css-1dcdqdg"><code>        onFirstUpdate: onFirstUpdate,
</code></td></tr><tr><td id="L1190" class="css-a4x74f"><span>1190</span></td><td id="LC1190" class="css-1dcdqdg"><code>        modifiers: modifiers
</code></td></tr><tr><td id="L1191" class="css-a4x74f"><span>1191</span></td><td id="LC1191" class="css-1dcdqdg"><code>      }));
</code></td></tr><tr><td id="L1192" class="css-a4x74f"><span>1192</span></td><td id="LC1192" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1193" class="css-a4x74f"><span>1193</span></td><td id="LC1193" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1194" class="css-a4x74f"><span>1194</span></td><td id="LC1194" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">destroyPopperInstance</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1195" class="css-a4x74f"><span>1195</span></td><td id="LC1195" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (instance.popperInstance) {
</code></td></tr><tr><td id="L1196" class="css-a4x74f"><span>1196</span></td><td id="LC1196" class="css-1dcdqdg"><code>        instance.popperInstance.destroy();
</code></td></tr><tr><td id="L1197" class="css-a4x74f"><span>1197</span></td><td id="LC1197" class="css-1dcdqdg"><code>        instance.popperInstance = <span class="code-literal">null</span>;
</code></td></tr><tr><td id="L1198" class="css-a4x74f"><span>1198</span></td><td id="LC1198" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1199" class="css-a4x74f"><span>1199</span></td><td id="LC1199" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1200" class="css-a4x74f"><span>1200</span></td><td id="LC1200" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1201" class="css-a4x74f"><span>1201</span></td><td id="LC1201" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">mount</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1202" class="css-a4x74f"><span>1202</span></td><td id="LC1202" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> appendTo = instance.props.appendTo;
</code></td></tr><tr><td id="L1203" class="css-a4x74f"><span>1203</span></td><td id="LC1203" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> parentNode; <span class="code-comment">// By default, we'll append the popper to the triggerTargets's parentNode so</span>
</code></td></tr><tr><td id="L1204" class="css-a4x74f"><span>1204</span></td><td id="LC1204" class="css-1dcdqdg"><code>      <span class="code-comment">// it's directly after the reference element so the elements inside the</span>
</code></td></tr><tr><td id="L1205" class="css-a4x74f"><span>1205</span></td><td id="LC1205" class="css-1dcdqdg"><code>      <span class="code-comment">// tippy can be tabbed to</span>
</code></td></tr><tr><td id="L1206" class="css-a4x74f"><span>1206</span></td><td id="LC1206" class="css-1dcdqdg"><code>      <span class="code-comment">// If there are clipping issues, the user can specify a different appendTo</span>
</code></td></tr><tr><td id="L1207" class="css-a4x74f"><span>1207</span></td><td id="LC1207" class="css-1dcdqdg"><code>      <span class="code-comment">// and ensure focus management is handled correctly manually</span>
</code></td></tr><tr><td id="L1208" class="css-a4x74f"><span>1208</span></td><td id="LC1208" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1209" class="css-a4x74f"><span>1209</span></td><td id="LC1209" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> node = getCurrentTarget();
</code></td></tr><tr><td id="L1210" class="css-a4x74f"><span>1210</span></td><td id="LC1210" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1211" class="css-a4x74f"><span>1211</span></td><td id="LC1211" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (instance.props.interactive &amp;&amp; appendTo === TIPPY_DEFAULT_APPEND_TO || appendTo === <span class="code-string">'parent'</span>) {
</code></td></tr><tr><td id="L1212" class="css-a4x74f"><span>1212</span></td><td id="LC1212" class="css-1dcdqdg"><code>        parentNode = node.parentNode;
</code></td></tr><tr><td id="L1213" class="css-a4x74f"><span>1213</span></td><td id="LC1213" class="css-1dcdqdg"><code>      } <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L1214" class="css-a4x74f"><span>1214</span></td><td id="LC1214" class="css-1dcdqdg"><code>        parentNode = invokeWithArgsOrReturn(appendTo, [node]);
</code></td></tr><tr><td id="L1215" class="css-a4x74f"><span>1215</span></td><td id="LC1215" class="css-1dcdqdg"><code>      } <span class="code-comment">// The popper element needs to exist on the DOM before its position can be</span>
</code></td></tr><tr><td id="L1216" class="css-a4x74f"><span>1216</span></td><td id="LC1216" class="css-1dcdqdg"><code>      <span class="code-comment">// updated as Popper needs to read its dimensions</span>
</code></td></tr><tr><td id="L1217" class="css-a4x74f"><span>1217</span></td><td id="LC1217" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1218" class="css-a4x74f"><span>1218</span></td><td id="LC1218" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1219" class="css-a4x74f"><span>1219</span></td><td id="LC1219" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (!parentNode.contains(popper)) {
</code></td></tr><tr><td id="L1220" class="css-a4x74f"><span>1220</span></td><td id="LC1220" class="css-1dcdqdg"><code>        parentNode.appendChild(popper);
</code></td></tr><tr><td id="L1221" class="css-a4x74f"><span>1221</span></td><td id="LC1221" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1222" class="css-a4x74f"><span>1222</span></td><td id="LC1222" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1223" class="css-a4x74f"><span>1223</span></td><td id="LC1223" class="css-1dcdqdg"><code>      instance.state.isMounted = <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L1224" class="css-a4x74f"><span>1224</span></td><td id="LC1224" class="css-1dcdqdg"><code>      createPopperInstance();
</code></td></tr><tr><td id="L1225" class="css-a4x74f"><span>1225</span></td><td id="LC1225" class="css-1dcdqdg"><code>      <span class="code-comment">/* istanbul ignore else */</span>
</code></td></tr><tr><td id="L1226" class="css-a4x74f"><span>1226</span></td><td id="LC1226" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1227" class="css-a4x74f"><span>1227</span></td><td id="LC1227" class="css-1dcdqdg"><code>      {
</code></td></tr><tr><td id="L1228" class="css-a4x74f"><span>1228</span></td><td id="LC1228" class="css-1dcdqdg"><code>        <span class="code-comment">// Accessibility check</span>
</code></td></tr><tr><td id="L1229" class="css-a4x74f"><span>1229</span></td><td id="LC1229" class="css-1dcdqdg"><code>        warnWhen(instance.props.interactive &amp;&amp; appendTo === defaultProps.appendTo &amp;&amp; node.nextElementSibling !== popper, [<span class="code-string">'Interactive tippy element may not be accessible via keyboard'</span>, <span class="code-string">'navigation because it is not directly after the reference element'</span>, <span class="code-string">'in the DOM source order.'</span>, <span class="code-string">'\n\n'</span>, <span class="code-string">'Using a wrapper &lt;div&gt; or &lt;span&gt; tag around the reference element'</span>, <span class="code-string">'solves this by creating a new parentNode context.'</span>, <span class="code-string">'\n\n'</span>, <span class="code-string">'Specifying `appendTo: document.body` silences this warning, but it'</span>, <span class="code-string">'assumes you are using a focus management solution to handle'</span>, <span class="code-string">'keyboard navigation.'</span>, <span class="code-string">'\n\n'</span>, <span class="code-string">'See: https://atomiks.github.io/tippyjs/v6/accessibility/#interactivity'</span>].join(<span class="code-string">' '</span>));
</code></td></tr><tr><td id="L1230" class="css-a4x74f"><span>1230</span></td><td id="LC1230" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1231" class="css-a4x74f"><span>1231</span></td><td id="LC1231" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1232" class="css-a4x74f"><span>1232</span></td><td id="LC1232" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1233" class="css-a4x74f"><span>1233</span></td><td id="LC1233" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getNestedPopperTree</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1234" class="css-a4x74f"><span>1234</span></td><td id="LC1234" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> arrayFrom(popper.querySelectorAll(<span class="code-string">'[data-tippy-root]'</span>));
</code></td></tr><tr><td id="L1235" class="css-a4x74f"><span>1235</span></td><td id="LC1235" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1236" class="css-a4x74f"><span>1236</span></td><td id="LC1236" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1237" class="css-a4x74f"><span>1237</span></td><td id="LC1237" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">scheduleShow</span>(<span class="code-params">event</span>) </span>{
</code></td></tr><tr><td id="L1238" class="css-a4x74f"><span>1238</span></td><td id="LC1238" class="css-1dcdqdg"><code>      instance.clearDelayTimeouts();
</code></td></tr><tr><td id="L1239" class="css-a4x74f"><span>1239</span></td><td id="LC1239" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1240" class="css-a4x74f"><span>1240</span></td><td id="LC1240" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (event) {
</code></td></tr><tr><td id="L1241" class="css-a4x74f"><span>1241</span></td><td id="LC1241" class="css-1dcdqdg"><code>        invokeHook(<span class="code-string">'onTrigger'</span>, [instance, event]);
</code></td></tr><tr><td id="L1242" class="css-a4x74f"><span>1242</span></td><td id="LC1242" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1243" class="css-a4x74f"><span>1243</span></td><td id="LC1243" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1244" class="css-a4x74f"><span>1244</span></td><td id="LC1244" class="css-1dcdqdg"><code>      addDocumentPress();
</code></td></tr><tr><td id="L1245" class="css-a4x74f"><span>1245</span></td><td id="LC1245" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> delay = getDelay(<span class="code-literal">true</span>);
</code></td></tr><tr><td id="L1246" class="css-a4x74f"><span>1246</span></td><td id="LC1246" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1247" class="css-a4x74f"><span>1247</span></td><td id="LC1247" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> _getNormalizedTouchSe = getNormalizedTouchSettings(),
</code></td></tr><tr><td id="L1248" class="css-a4x74f"><span>1248</span></td><td id="LC1248" class="css-1dcdqdg"><code>          touchValue = _getNormalizedTouchSe[<span class="code-number">0</span>],
</code></td></tr><tr><td id="L1249" class="css-a4x74f"><span>1249</span></td><td id="LC1249" class="css-1dcdqdg"><code>          touchDelay = _getNormalizedTouchSe[<span class="code-number">1</span>];
</code></td></tr><tr><td id="L1250" class="css-a4x74f"><span>1250</span></td><td id="LC1250" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1251" class="css-a4x74f"><span>1251</span></td><td id="LC1251" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (currentInput.isTouch &amp;&amp; touchValue === <span class="code-string">'hold'</span> &amp;&amp; touchDelay) {
</code></td></tr><tr><td id="L1252" class="css-a4x74f"><span>1252</span></td><td id="LC1252" class="css-1dcdqdg"><code>        delay = touchDelay;
</code></td></tr><tr><td id="L1253" class="css-a4x74f"><span>1253</span></td><td id="LC1253" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1254" class="css-a4x74f"><span>1254</span></td><td id="LC1254" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1255" class="css-a4x74f"><span>1255</span></td><td id="LC1255" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (delay) {
</code></td></tr><tr><td id="L1256" class="css-a4x74f"><span>1256</span></td><td id="LC1256" class="css-1dcdqdg"><code>        showTimeout = setTimeout(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1257" class="css-a4x74f"><span>1257</span></td><td id="LC1257" class="css-1dcdqdg"><code>          instance.show();
</code></td></tr><tr><td id="L1258" class="css-a4x74f"><span>1258</span></td><td id="LC1258" class="css-1dcdqdg"><code>        }, delay);
</code></td></tr><tr><td id="L1259" class="css-a4x74f"><span>1259</span></td><td id="LC1259" class="css-1dcdqdg"><code>      } <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L1260" class="css-a4x74f"><span>1260</span></td><td id="LC1260" class="css-1dcdqdg"><code>        instance.show();
</code></td></tr><tr><td id="L1261" class="css-a4x74f"><span>1261</span></td><td id="LC1261" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1262" class="css-a4x74f"><span>1262</span></td><td id="LC1262" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1263" class="css-a4x74f"><span>1263</span></td><td id="LC1263" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1264" class="css-a4x74f"><span>1264</span></td><td id="LC1264" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">scheduleHide</span>(<span class="code-params">event</span>) </span>{
</code></td></tr><tr><td id="L1265" class="css-a4x74f"><span>1265</span></td><td id="LC1265" class="css-1dcdqdg"><code>      instance.clearDelayTimeouts();
</code></td></tr><tr><td id="L1266" class="css-a4x74f"><span>1266</span></td><td id="LC1266" class="css-1dcdqdg"><code>      invokeHook(<span class="code-string">'onUntrigger'</span>, [instance, event]);
</code></td></tr><tr><td id="L1267" class="css-a4x74f"><span>1267</span></td><td id="LC1267" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1268" class="css-a4x74f"><span>1268</span></td><td id="LC1268" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (!instance.state.isVisible) {
</code></td></tr><tr><td id="L1269" class="css-a4x74f"><span>1269</span></td><td id="LC1269" class="css-1dcdqdg"><code>        removeDocumentPress();
</code></td></tr><tr><td id="L1270" class="css-a4x74f"><span>1270</span></td><td id="LC1270" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1271" class="css-a4x74f"><span>1271</span></td><td id="LC1271" class="css-1dcdqdg"><code>      } <span class="code-comment">// For interactive tippies, scheduleHide is added to a document.body handler</span>
</code></td></tr><tr><td id="L1272" class="css-a4x74f"><span>1272</span></td><td id="LC1272" class="css-1dcdqdg"><code>      <span class="code-comment">// from onMouseLeave so must intercept scheduled hides from mousemove/leave</span>
</code></td></tr><tr><td id="L1273" class="css-a4x74f"><span>1273</span></td><td id="LC1273" class="css-1dcdqdg"><code>      <span class="code-comment">// events when trigger contains mouseenter and click, and the tip is</span>
</code></td></tr><tr><td id="L1274" class="css-a4x74f"><span>1274</span></td><td id="LC1274" class="css-1dcdqdg"><code>      <span class="code-comment">// currently shown as a result of a click.</span>
</code></td></tr><tr><td id="L1275" class="css-a4x74f"><span>1275</span></td><td id="LC1275" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1276" class="css-a4x74f"><span>1276</span></td><td id="LC1276" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1277" class="css-a4x74f"><span>1277</span></td><td id="LC1277" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (instance.props.trigger.indexOf(<span class="code-string">'mouseenter'</span>) &gt;= <span class="code-number">0</span> &amp;&amp; instance.props.trigger.indexOf(<span class="code-string">'click'</span>) &gt;= <span class="code-number">0</span> &amp;&amp; [<span class="code-string">'mouseleave'</span>, <span class="code-string">'mousemove'</span>].indexOf(event.type) &gt;= <span class="code-number">0</span> &amp;&amp; isVisibleFromClick) {
</code></td></tr><tr><td id="L1278" class="css-a4x74f"><span>1278</span></td><td id="LC1278" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1279" class="css-a4x74f"><span>1279</span></td><td id="LC1279" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1280" class="css-a4x74f"><span>1280</span></td><td id="LC1280" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1281" class="css-a4x74f"><span>1281</span></td><td id="LC1281" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> delay = getDelay(<span class="code-literal">false</span>);
</code></td></tr><tr><td id="L1282" class="css-a4x74f"><span>1282</span></td><td id="LC1282" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1283" class="css-a4x74f"><span>1283</span></td><td id="LC1283" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (delay) {
</code></td></tr><tr><td id="L1284" class="css-a4x74f"><span>1284</span></td><td id="LC1284" class="css-1dcdqdg"><code>        hideTimeout = setTimeout(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1285" class="css-a4x74f"><span>1285</span></td><td id="LC1285" class="css-1dcdqdg"><code>          <span class="code-keyword">if</span> (instance.state.isVisible) {
</code></td></tr><tr><td id="L1286" class="css-a4x74f"><span>1286</span></td><td id="LC1286" class="css-1dcdqdg"><code>            instance.hide();
</code></td></tr><tr><td id="L1287" class="css-a4x74f"><span>1287</span></td><td id="LC1287" class="css-1dcdqdg"><code>          }
</code></td></tr><tr><td id="L1288" class="css-a4x74f"><span>1288</span></td><td id="LC1288" class="css-1dcdqdg"><code>        }, delay);
</code></td></tr><tr><td id="L1289" class="css-a4x74f"><span>1289</span></td><td id="LC1289" class="css-1dcdqdg"><code>      } <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L1290" class="css-a4x74f"><span>1290</span></td><td id="LC1290" class="css-1dcdqdg"><code>        <span class="code-comment">// Fixes a `transitionend` problem when it fires 1 frame too</span>
</code></td></tr><tr><td id="L1291" class="css-a4x74f"><span>1291</span></td><td id="LC1291" class="css-1dcdqdg"><code>        <span class="code-comment">// late sometimes, we don't want hide() to be called.</span>
</code></td></tr><tr><td id="L1292" class="css-a4x74f"><span>1292</span></td><td id="LC1292" class="css-1dcdqdg"><code>        scheduleHideAnimationFrame = requestAnimationFrame(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1293" class="css-a4x74f"><span>1293</span></td><td id="LC1293" class="css-1dcdqdg"><code>          instance.hide();
</code></td></tr><tr><td id="L1294" class="css-a4x74f"><span>1294</span></td><td id="LC1294" class="css-1dcdqdg"><code>        });
</code></td></tr><tr><td id="L1295" class="css-a4x74f"><span>1295</span></td><td id="LC1295" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1296" class="css-a4x74f"><span>1296</span></td><td id="LC1296" class="css-1dcdqdg"><code>    } <span class="code-comment">// ===========================================================================</span>
</code></td></tr><tr><td id="L1297" class="css-a4x74f"><span>1297</span></td><td id="LC1297" class="css-1dcdqdg"><code>    <span class="code-comment">// 🔑 Public methods</span>
</code></td></tr><tr><td id="L1298" class="css-a4x74f"><span>1298</span></td><td id="LC1298" class="css-1dcdqdg"><code>    <span class="code-comment">// ===========================================================================</span>
</code></td></tr><tr><td id="L1299" class="css-a4x74f"><span>1299</span></td><td id="LC1299" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1300" class="css-a4x74f"><span>1300</span></td><td id="LC1300" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1301" class="css-a4x74f"><span>1301</span></td><td id="LC1301" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">enable</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1302" class="css-a4x74f"><span>1302</span></td><td id="LC1302" class="css-1dcdqdg"><code>      instance.state.isEnabled = <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L1303" class="css-a4x74f"><span>1303</span></td><td id="LC1303" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1304" class="css-a4x74f"><span>1304</span></td><td id="LC1304" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1305" class="css-a4x74f"><span>1305</span></td><td id="LC1305" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">disable</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1306" class="css-a4x74f"><span>1306</span></td><td id="LC1306" class="css-1dcdqdg"><code>      <span class="code-comment">// Disabling the instance should also hide it</span>
</code></td></tr><tr><td id="L1307" class="css-a4x74f"><span>1307</span></td><td id="LC1307" class="css-1dcdqdg"><code>      <span class="code-comment">// https://github.com/atomiks/tippy.js-react/issues/106</span>
</code></td></tr><tr><td id="L1308" class="css-a4x74f"><span>1308</span></td><td id="LC1308" class="css-1dcdqdg"><code>      instance.hide();
</code></td></tr><tr><td id="L1309" class="css-a4x74f"><span>1309</span></td><td id="LC1309" class="css-1dcdqdg"><code>      instance.state.isEnabled = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L1310" class="css-a4x74f"><span>1310</span></td><td id="LC1310" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1311" class="css-a4x74f"><span>1311</span></td><td id="LC1311" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1312" class="css-a4x74f"><span>1312</span></td><td id="LC1312" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">clearDelayTimeouts</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1313" class="css-a4x74f"><span>1313</span></td><td id="LC1313" class="css-1dcdqdg"><code>      clearTimeout(showTimeout);
</code></td></tr><tr><td id="L1314" class="css-a4x74f"><span>1314</span></td><td id="LC1314" class="css-1dcdqdg"><code>      clearTimeout(hideTimeout);
</code></td></tr><tr><td id="L1315" class="css-a4x74f"><span>1315</span></td><td id="LC1315" class="css-1dcdqdg"><code>      cancelAnimationFrame(scheduleHideAnimationFrame);
</code></td></tr><tr><td id="L1316" class="css-a4x74f"><span>1316</span></td><td id="LC1316" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1317" class="css-a4x74f"><span>1317</span></td><td id="LC1317" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1318" class="css-a4x74f"><span>1318</span></td><td id="LC1318" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">setProps</span>(<span class="code-params">partialProps</span>) </span>{
</code></td></tr><tr><td id="L1319" class="css-a4x74f"><span>1319</span></td><td id="LC1319" class="css-1dcdqdg"><code>      <span class="code-comment">/* istanbul ignore else */</span>
</code></td></tr><tr><td id="L1320" class="css-a4x74f"><span>1320</span></td><td id="LC1320" class="css-1dcdqdg"><code>      {
</code></td></tr><tr><td id="L1321" class="css-a4x74f"><span>1321</span></td><td id="LC1321" class="css-1dcdqdg"><code>        warnWhen(instance.state.isDestroyed, createMemoryLeakWarning(<span class="code-string">'setProps'</span>));
</code></td></tr><tr><td id="L1322" class="css-a4x74f"><span>1322</span></td><td id="LC1322" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1323" class="css-a4x74f"><span>1323</span></td><td id="LC1323" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1324" class="css-a4x74f"><span>1324</span></td><td id="LC1324" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (instance.state.isDestroyed) {
</code></td></tr><tr><td id="L1325" class="css-a4x74f"><span>1325</span></td><td id="LC1325" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1326" class="css-a4x74f"><span>1326</span></td><td id="LC1326" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1327" class="css-a4x74f"><span>1327</span></td><td id="LC1327" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1328" class="css-a4x74f"><span>1328</span></td><td id="LC1328" class="css-1dcdqdg"><code>      invokeHook(<span class="code-string">'onBeforeUpdate'</span>, [instance, partialProps]);
</code></td></tr><tr><td id="L1329" class="css-a4x74f"><span>1329</span></td><td id="LC1329" class="css-1dcdqdg"><code>      removeListeners();
</code></td></tr><tr><td id="L1330" class="css-a4x74f"><span>1330</span></td><td id="LC1330" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> prevProps = instance.props;
</code></td></tr><tr><td id="L1331" class="css-a4x74f"><span>1331</span></td><td id="LC1331" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> nextProps = evaluateProps(reference, <span class="code-built_in">Object</span>.assign({}, prevProps, removeUndefinedProps(partialProps), {
</code></td></tr><tr><td id="L1332" class="css-a4x74f"><span>1332</span></td><td id="LC1332" class="css-1dcdqdg"><code>        ignoreAttributes: <span class="code-literal">true</span>
</code></td></tr><tr><td id="L1333" class="css-a4x74f"><span>1333</span></td><td id="LC1333" class="css-1dcdqdg"><code>      }));
</code></td></tr><tr><td id="L1334" class="css-a4x74f"><span>1334</span></td><td id="LC1334" class="css-1dcdqdg"><code>      instance.props = nextProps;
</code></td></tr><tr><td id="L1335" class="css-a4x74f"><span>1335</span></td><td id="LC1335" class="css-1dcdqdg"><code>      addListeners();
</code></td></tr><tr><td id="L1336" class="css-a4x74f"><span>1336</span></td><td id="LC1336" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1337" class="css-a4x74f"><span>1337</span></td><td id="LC1337" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (prevProps.interactiveDebounce !== nextProps.interactiveDebounce) {
</code></td></tr><tr><td id="L1338" class="css-a4x74f"><span>1338</span></td><td id="LC1338" class="css-1dcdqdg"><code>        cleanupInteractiveMouseListeners();
</code></td></tr><tr><td id="L1339" class="css-a4x74f"><span>1339</span></td><td id="LC1339" class="css-1dcdqdg"><code>        debouncedOnMouseMove = debounce(onMouseMove, nextProps.interactiveDebounce);
</code></td></tr><tr><td id="L1340" class="css-a4x74f"><span>1340</span></td><td id="LC1340" class="css-1dcdqdg"><code>      } <span class="code-comment">// Ensure stale aria-expanded attributes are removed</span>
</code></td></tr><tr><td id="L1341" class="css-a4x74f"><span>1341</span></td><td id="LC1341" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1342" class="css-a4x74f"><span>1342</span></td><td id="LC1342" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1343" class="css-a4x74f"><span>1343</span></td><td id="LC1343" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (prevProps.triggerTarget &amp;&amp; !nextProps.triggerTarget) {
</code></td></tr><tr><td id="L1344" class="css-a4x74f"><span>1344</span></td><td id="LC1344" class="css-1dcdqdg"><code>        normalizeToArray(prevProps.triggerTarget).forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">node</span>) </span>{
</code></td></tr><tr><td id="L1345" class="css-a4x74f"><span>1345</span></td><td id="LC1345" class="css-1dcdqdg"><code>          node.removeAttribute(<span class="code-string">'aria-expanded'</span>);
</code></td></tr><tr><td id="L1346" class="css-a4x74f"><span>1346</span></td><td id="LC1346" class="css-1dcdqdg"><code>        });
</code></td></tr><tr><td id="L1347" class="css-a4x74f"><span>1347</span></td><td id="LC1347" class="css-1dcdqdg"><code>      } <span class="code-keyword">else</span> <span class="code-keyword">if</span> (nextProps.triggerTarget) {
</code></td></tr><tr><td id="L1348" class="css-a4x74f"><span>1348</span></td><td id="LC1348" class="css-1dcdqdg"><code>        reference.removeAttribute(<span class="code-string">'aria-expanded'</span>);
</code></td></tr><tr><td id="L1349" class="css-a4x74f"><span>1349</span></td><td id="LC1349" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1350" class="css-a4x74f"><span>1350</span></td><td id="LC1350" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1351" class="css-a4x74f"><span>1351</span></td><td id="LC1351" class="css-1dcdqdg"><code>      handleAriaExpandedAttribute();
</code></td></tr><tr><td id="L1352" class="css-a4x74f"><span>1352</span></td><td id="LC1352" class="css-1dcdqdg"><code>      handleStyles();
</code></td></tr><tr><td id="L1353" class="css-a4x74f"><span>1353</span></td><td id="LC1353" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1354" class="css-a4x74f"><span>1354</span></td><td id="LC1354" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (onUpdate) {
</code></td></tr><tr><td id="L1355" class="css-a4x74f"><span>1355</span></td><td id="LC1355" class="css-1dcdqdg"><code>        onUpdate(prevProps, nextProps);
</code></td></tr><tr><td id="L1356" class="css-a4x74f"><span>1356</span></td><td id="LC1356" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1357" class="css-a4x74f"><span>1357</span></td><td id="LC1357" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1358" class="css-a4x74f"><span>1358</span></td><td id="LC1358" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (instance.popperInstance) {
</code></td></tr><tr><td id="L1359" class="css-a4x74f"><span>1359</span></td><td id="LC1359" class="css-1dcdqdg"><code>        createPopperInstance(); <span class="code-comment">// Fixes an issue with nested tippies if they are all getting re-rendered,</span>
</code></td></tr><tr><td id="L1360" class="css-a4x74f"><span>1360</span></td><td id="LC1360" class="css-1dcdqdg"><code>        <span class="code-comment">// and the nested ones get re-rendered first.</span>
</code></td></tr><tr><td id="L1361" class="css-a4x74f"><span>1361</span></td><td id="LC1361" class="css-1dcdqdg"><code>        <span class="code-comment">// https://github.com/atomiks/tippyjs-react/issues/177</span>
</code></td></tr><tr><td id="L1362" class="css-a4x74f"><span>1362</span></td><td id="LC1362" class="css-1dcdqdg"><code>        <span class="code-comment">// <span class="code-doctag">TODO:</span> find a cleaner / more efficient solution(!)</span>
</code></td></tr><tr><td id="L1363" class="css-a4x74f"><span>1363</span></td><td id="LC1363" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1364" class="css-a4x74f"><span>1364</span></td><td id="LC1364" class="css-1dcdqdg"><code>        getNestedPopperTree().forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">nestedPopper</span>) </span>{
</code></td></tr><tr><td id="L1365" class="css-a4x74f"><span>1365</span></td><td id="LC1365" class="css-1dcdqdg"><code>          <span class="code-comment">// React (and other UI libs likely) requires a rAF wrapper as it flushes</span>
</code></td></tr><tr><td id="L1366" class="css-a4x74f"><span>1366</span></td><td id="LC1366" class="css-1dcdqdg"><code>          <span class="code-comment">// its work in one</span>
</code></td></tr><tr><td id="L1367" class="css-a4x74f"><span>1367</span></td><td id="LC1367" class="css-1dcdqdg"><code>          requestAnimationFrame(nestedPopper._tippy.popperInstance.forceUpdate);
</code></td></tr><tr><td id="L1368" class="css-a4x74f"><span>1368</span></td><td id="LC1368" class="css-1dcdqdg"><code>        });
</code></td></tr><tr><td id="L1369" class="css-a4x74f"><span>1369</span></td><td id="LC1369" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1370" class="css-a4x74f"><span>1370</span></td><td id="LC1370" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1371" class="css-a4x74f"><span>1371</span></td><td id="LC1371" class="css-1dcdqdg"><code>      invokeHook(<span class="code-string">'onAfterUpdate'</span>, [instance, partialProps]);
</code></td></tr><tr><td id="L1372" class="css-a4x74f"><span>1372</span></td><td id="LC1372" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1373" class="css-a4x74f"><span>1373</span></td><td id="LC1373" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1374" class="css-a4x74f"><span>1374</span></td><td id="LC1374" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">setContent</span>(<span class="code-params">content</span>) </span>{
</code></td></tr><tr><td id="L1375" class="css-a4x74f"><span>1375</span></td><td id="LC1375" class="css-1dcdqdg"><code>      instance.setProps({
</code></td></tr><tr><td id="L1376" class="css-a4x74f"><span>1376</span></td><td id="LC1376" class="css-1dcdqdg"><code>        content: content
</code></td></tr><tr><td id="L1377" class="css-a4x74f"><span>1377</span></td><td id="LC1377" class="css-1dcdqdg"><code>      });
</code></td></tr><tr><td id="L1378" class="css-a4x74f"><span>1378</span></td><td id="LC1378" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1379" class="css-a4x74f"><span>1379</span></td><td id="LC1379" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1380" class="css-a4x74f"><span>1380</span></td><td id="LC1380" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">show</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1381" class="css-a4x74f"><span>1381</span></td><td id="LC1381" class="css-1dcdqdg"><code>      <span class="code-comment">/* istanbul ignore else */</span>
</code></td></tr><tr><td id="L1382" class="css-a4x74f"><span>1382</span></td><td id="LC1382" class="css-1dcdqdg"><code>      {
</code></td></tr><tr><td id="L1383" class="css-a4x74f"><span>1383</span></td><td id="LC1383" class="css-1dcdqdg"><code>        warnWhen(instance.state.isDestroyed, createMemoryLeakWarning(<span class="code-string">'show'</span>));
</code></td></tr><tr><td id="L1384" class="css-a4x74f"><span>1384</span></td><td id="LC1384" class="css-1dcdqdg"><code>      } <span class="code-comment">// Early bail-out</span>
</code></td></tr><tr><td id="L1385" class="css-a4x74f"><span>1385</span></td><td id="LC1385" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1386" class="css-a4x74f"><span>1386</span></td><td id="LC1386" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1387" class="css-a4x74f"><span>1387</span></td><td id="LC1387" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> isAlreadyVisible = instance.state.isVisible;
</code></td></tr><tr><td id="L1388" class="css-a4x74f"><span>1388</span></td><td id="LC1388" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> isDestroyed = instance.state.isDestroyed;
</code></td></tr><tr><td id="L1389" class="css-a4x74f"><span>1389</span></td><td id="LC1389" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> isDisabled = !instance.state.isEnabled;
</code></td></tr><tr><td id="L1390" class="css-a4x74f"><span>1390</span></td><td id="LC1390" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> isTouchAndTouchDisabled = currentInput.isTouch &amp;&amp; !instance.props.touch;
</code></td></tr><tr><td id="L1391" class="css-a4x74f"><span>1391</span></td><td id="LC1391" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> duration = getValueAtIndexOrReturn(instance.props.duration, <span class="code-number">0</span>, defaultProps.duration);
</code></td></tr><tr><td id="L1392" class="css-a4x74f"><span>1392</span></td><td id="LC1392" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1393" class="css-a4x74f"><span>1393</span></td><td id="LC1393" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (isAlreadyVisible || isDestroyed || isDisabled || isTouchAndTouchDisabled) {
</code></td></tr><tr><td id="L1394" class="css-a4x74f"><span>1394</span></td><td id="LC1394" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1395" class="css-a4x74f"><span>1395</span></td><td id="LC1395" class="css-1dcdqdg"><code>      } <span class="code-comment">// Normalize `disabled` behavior across browsers.</span>
</code></td></tr><tr><td id="L1396" class="css-a4x74f"><span>1396</span></td><td id="LC1396" class="css-1dcdqdg"><code>      <span class="code-comment">// Firefox allows events on disabled elements, but Chrome doesn't.</span>
</code></td></tr><tr><td id="L1397" class="css-a4x74f"><span>1397</span></td><td id="LC1397" class="css-1dcdqdg"><code>      <span class="code-comment">// Using a wrapper element (i.e. &lt;span&gt;) is recommended.</span>
</code></td></tr><tr><td id="L1398" class="css-a4x74f"><span>1398</span></td><td id="LC1398" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1399" class="css-a4x74f"><span>1399</span></td><td id="LC1399" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1400" class="css-a4x74f"><span>1400</span></td><td id="LC1400" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (getCurrentTarget().hasAttribute(<span class="code-string">'disabled'</span>)) {
</code></td></tr><tr><td id="L1401" class="css-a4x74f"><span>1401</span></td><td id="LC1401" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1402" class="css-a4x74f"><span>1402</span></td><td id="LC1402" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1403" class="css-a4x74f"><span>1403</span></td><td id="LC1403" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1404" class="css-a4x74f"><span>1404</span></td><td id="LC1404" class="css-1dcdqdg"><code>      invokeHook(<span class="code-string">'onShow'</span>, [instance], <span class="code-literal">false</span>);
</code></td></tr><tr><td id="L1405" class="css-a4x74f"><span>1405</span></td><td id="LC1405" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1406" class="css-a4x74f"><span>1406</span></td><td id="LC1406" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (instance.props.onShow(instance) === <span class="code-literal">false</span>) {
</code></td></tr><tr><td id="L1407" class="css-a4x74f"><span>1407</span></td><td id="LC1407" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1408" class="css-a4x74f"><span>1408</span></td><td id="LC1408" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1409" class="css-a4x74f"><span>1409</span></td><td id="LC1409" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1410" class="css-a4x74f"><span>1410</span></td><td id="LC1410" class="css-1dcdqdg"><code>      instance.state.isVisible = <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L1411" class="css-a4x74f"><span>1411</span></td><td id="LC1411" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1412" class="css-a4x74f"><span>1412</span></td><td id="LC1412" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (getIsDefaultRenderFn()) {
</code></td></tr><tr><td id="L1413" class="css-a4x74f"><span>1413</span></td><td id="LC1413" class="css-1dcdqdg"><code>        popper.style.visibility = <span class="code-string">'visible'</span>;
</code></td></tr><tr><td id="L1414" class="css-a4x74f"><span>1414</span></td><td id="LC1414" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1415" class="css-a4x74f"><span>1415</span></td><td id="LC1415" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1416" class="css-a4x74f"><span>1416</span></td><td id="LC1416" class="css-1dcdqdg"><code>      handleStyles();
</code></td></tr><tr><td id="L1417" class="css-a4x74f"><span>1417</span></td><td id="LC1417" class="css-1dcdqdg"><code>      addDocumentPress();
</code></td></tr><tr><td id="L1418" class="css-a4x74f"><span>1418</span></td><td id="LC1418" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1419" class="css-a4x74f"><span>1419</span></td><td id="LC1419" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (!instance.state.isMounted) {
</code></td></tr><tr><td id="L1420" class="css-a4x74f"><span>1420</span></td><td id="LC1420" class="css-1dcdqdg"><code>        popper.style.transition = <span class="code-string">'none'</span>;
</code></td></tr><tr><td id="L1421" class="css-a4x74f"><span>1421</span></td><td id="LC1421" class="css-1dcdqdg"><code>      } <span class="code-comment">// If flipping to the opposite side after hiding at least once, the</span>
</code></td></tr><tr><td id="L1422" class="css-a4x74f"><span>1422</span></td><td id="LC1422" class="css-1dcdqdg"><code>      <span class="code-comment">// animation will use the wrong placement without resetting the duration</span>
</code></td></tr><tr><td id="L1423" class="css-a4x74f"><span>1423</span></td><td id="LC1423" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1424" class="css-a4x74f"><span>1424</span></td><td id="LC1424" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1425" class="css-a4x74f"><span>1425</span></td><td id="LC1425" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (getIsDefaultRenderFn()) {
</code></td></tr><tr><td id="L1426" class="css-a4x74f"><span>1426</span></td><td id="LC1426" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> _getDefaultTemplateCh2 = getDefaultTemplateChildren(),
</code></td></tr><tr><td id="L1427" class="css-a4x74f"><span>1427</span></td><td id="LC1427" class="css-1dcdqdg"><code>            box = _getDefaultTemplateCh2.box,
</code></td></tr><tr><td id="L1428" class="css-a4x74f"><span>1428</span></td><td id="LC1428" class="css-1dcdqdg"><code>            content = _getDefaultTemplateCh2.content;
</code></td></tr><tr><td id="L1429" class="css-a4x74f"><span>1429</span></td><td id="LC1429" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1430" class="css-a4x74f"><span>1430</span></td><td id="LC1430" class="css-1dcdqdg"><code>        setTransitionDuration([box, content], <span class="code-number">0</span>);
</code></td></tr><tr><td id="L1431" class="css-a4x74f"><span>1431</span></td><td id="LC1431" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1432" class="css-a4x74f"><span>1432</span></td><td id="LC1432" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1433" class="css-a4x74f"><span>1433</span></td><td id="LC1433" class="css-1dcdqdg"><code>      onFirstUpdate = <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onFirstUpdate</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1434" class="css-a4x74f"><span>1434</span></td><td id="LC1434" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> _instance$popperInsta2;
</code></td></tr><tr><td id="L1435" class="css-a4x74f"><span>1435</span></td><td id="LC1435" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1436" class="css-a4x74f"><span>1436</span></td><td id="LC1436" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (!instance.state.isVisible || ignoreOnFirstUpdate) {
</code></td></tr><tr><td id="L1437" class="css-a4x74f"><span>1437</span></td><td id="LC1437" class="css-1dcdqdg"><code>          <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1438" class="css-a4x74f"><span>1438</span></td><td id="LC1438" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L1439" class="css-a4x74f"><span>1439</span></td><td id="LC1439" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1440" class="css-a4x74f"><span>1440</span></td><td id="LC1440" class="css-1dcdqdg"><code>        ignoreOnFirstUpdate = <span class="code-literal">true</span>; <span class="code-comment">// reflow</span>
</code></td></tr><tr><td id="L1441" class="css-a4x74f"><span>1441</span></td><td id="LC1441" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1442" class="css-a4x74f"><span>1442</span></td><td id="LC1442" class="css-1dcdqdg"><code>        <span class="code-keyword">void</span> popper.offsetHeight;
</code></td></tr><tr><td id="L1443" class="css-a4x74f"><span>1443</span></td><td id="LC1443" class="css-1dcdqdg"><code>        popper.style.transition = instance.props.moveTransition;
</code></td></tr><tr><td id="L1444" class="css-a4x74f"><span>1444</span></td><td id="LC1444" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1445" class="css-a4x74f"><span>1445</span></td><td id="LC1445" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (getIsDefaultRenderFn() &amp;&amp; instance.props.animation) {
</code></td></tr><tr><td id="L1446" class="css-a4x74f"><span>1446</span></td><td id="LC1446" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> _getDefaultTemplateCh3 = getDefaultTemplateChildren(),
</code></td></tr><tr><td id="L1447" class="css-a4x74f"><span>1447</span></td><td id="LC1447" class="css-1dcdqdg"><code>              _box = _getDefaultTemplateCh3.box,
</code></td></tr><tr><td id="L1448" class="css-a4x74f"><span>1448</span></td><td id="LC1448" class="css-1dcdqdg"><code>              _content = _getDefaultTemplateCh3.content;
</code></td></tr><tr><td id="L1449" class="css-a4x74f"><span>1449</span></td><td id="LC1449" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1450" class="css-a4x74f"><span>1450</span></td><td id="LC1450" class="css-1dcdqdg"><code>          setTransitionDuration([_box, _content], duration);
</code></td></tr><tr><td id="L1451" class="css-a4x74f"><span>1451</span></td><td id="LC1451" class="css-1dcdqdg"><code>          setVisibilityState([_box, _content], <span class="code-string">'visible'</span>);
</code></td></tr><tr><td id="L1452" class="css-a4x74f"><span>1452</span></td><td id="LC1452" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L1453" class="css-a4x74f"><span>1453</span></td><td id="LC1453" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1454" class="css-a4x74f"><span>1454</span></td><td id="LC1454" class="css-1dcdqdg"><code>        handleAriaContentAttribute();
</code></td></tr><tr><td id="L1455" class="css-a4x74f"><span>1455</span></td><td id="LC1455" class="css-1dcdqdg"><code>        handleAriaExpandedAttribute();
</code></td></tr><tr><td id="L1456" class="css-a4x74f"><span>1456</span></td><td id="LC1456" class="css-1dcdqdg"><code>        pushIfUnique(mountedInstances, instance); <span class="code-comment">// certain modifiers (e.g. `maxSize`) require a second update after the</span>
</code></td></tr><tr><td id="L1457" class="css-a4x74f"><span>1457</span></td><td id="LC1457" class="css-1dcdqdg"><code>        <span class="code-comment">// popper has been positioned for the first time</span>
</code></td></tr><tr><td id="L1458" class="css-a4x74f"><span>1458</span></td><td id="LC1458" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1459" class="css-a4x74f"><span>1459</span></td><td id="LC1459" class="css-1dcdqdg"><code>        (_instance$popperInsta2 = instance.popperInstance) == <span class="code-literal">null</span> ? <span class="code-keyword">void</span> <span class="code-number">0</span> : _instance$popperInsta2.forceUpdate();
</code></td></tr><tr><td id="L1460" class="css-a4x74f"><span>1460</span></td><td id="LC1460" class="css-1dcdqdg"><code>        invokeHook(<span class="code-string">'onMount'</span>, [instance]);
</code></td></tr><tr><td id="L1461" class="css-a4x74f"><span>1461</span></td><td id="LC1461" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1462" class="css-a4x74f"><span>1462</span></td><td id="LC1462" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (instance.props.animation &amp;&amp; getIsDefaultRenderFn()) {
</code></td></tr><tr><td id="L1463" class="css-a4x74f"><span>1463</span></td><td id="LC1463" class="css-1dcdqdg"><code>          onTransitionedIn(duration, <span class="code-function"><span class="code-keyword">function</span> (<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1464" class="css-a4x74f"><span>1464</span></td><td id="LC1464" class="css-1dcdqdg"><code>            instance.state.isShown = <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L1465" class="css-a4x74f"><span>1465</span></td><td id="LC1465" class="css-1dcdqdg"><code>            invokeHook(<span class="code-string">'onShown'</span>, [instance]);
</code></td></tr><tr><td id="L1466" class="css-a4x74f"><span>1466</span></td><td id="LC1466" class="css-1dcdqdg"><code>          });
</code></td></tr><tr><td id="L1467" class="css-a4x74f"><span>1467</span></td><td id="LC1467" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L1468" class="css-a4x74f"><span>1468</span></td><td id="LC1468" class="css-1dcdqdg"><code>      };
</code></td></tr><tr><td id="L1469" class="css-a4x74f"><span>1469</span></td><td id="LC1469" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1470" class="css-a4x74f"><span>1470</span></td><td id="LC1470" class="css-1dcdqdg"><code>      mount();
</code></td></tr><tr><td id="L1471" class="css-a4x74f"><span>1471</span></td><td id="LC1471" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1472" class="css-a4x74f"><span>1472</span></td><td id="LC1472" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1473" class="css-a4x74f"><span>1473</span></td><td id="LC1473" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">hide</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1474" class="css-a4x74f"><span>1474</span></td><td id="LC1474" class="css-1dcdqdg"><code>      <span class="code-comment">/* istanbul ignore else */</span>
</code></td></tr><tr><td id="L1475" class="css-a4x74f"><span>1475</span></td><td id="LC1475" class="css-1dcdqdg"><code>      {
</code></td></tr><tr><td id="L1476" class="css-a4x74f"><span>1476</span></td><td id="LC1476" class="css-1dcdqdg"><code>        warnWhen(instance.state.isDestroyed, createMemoryLeakWarning(<span class="code-string">'hide'</span>));
</code></td></tr><tr><td id="L1477" class="css-a4x74f"><span>1477</span></td><td id="LC1477" class="css-1dcdqdg"><code>      } <span class="code-comment">// Early bail-out</span>
</code></td></tr><tr><td id="L1478" class="css-a4x74f"><span>1478</span></td><td id="LC1478" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1479" class="css-a4x74f"><span>1479</span></td><td id="LC1479" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1480" class="css-a4x74f"><span>1480</span></td><td id="LC1480" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> isAlreadyHidden = !instance.state.isVisible;
</code></td></tr><tr><td id="L1481" class="css-a4x74f"><span>1481</span></td><td id="LC1481" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> isDestroyed = instance.state.isDestroyed;
</code></td></tr><tr><td id="L1482" class="css-a4x74f"><span>1482</span></td><td id="LC1482" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> isDisabled = !instance.state.isEnabled;
</code></td></tr><tr><td id="L1483" class="css-a4x74f"><span>1483</span></td><td id="LC1483" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> duration = getValueAtIndexOrReturn(instance.props.duration, <span class="code-number">1</span>, defaultProps.duration);
</code></td></tr><tr><td id="L1484" class="css-a4x74f"><span>1484</span></td><td id="LC1484" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1485" class="css-a4x74f"><span>1485</span></td><td id="LC1485" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (isAlreadyHidden || isDestroyed || isDisabled) {
</code></td></tr><tr><td id="L1486" class="css-a4x74f"><span>1486</span></td><td id="LC1486" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1487" class="css-a4x74f"><span>1487</span></td><td id="LC1487" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1488" class="css-a4x74f"><span>1488</span></td><td id="LC1488" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1489" class="css-a4x74f"><span>1489</span></td><td id="LC1489" class="css-1dcdqdg"><code>      invokeHook(<span class="code-string">'onHide'</span>, [instance], <span class="code-literal">false</span>);
</code></td></tr><tr><td id="L1490" class="css-a4x74f"><span>1490</span></td><td id="LC1490" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1491" class="css-a4x74f"><span>1491</span></td><td id="LC1491" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (instance.props.onHide(instance) === <span class="code-literal">false</span>) {
</code></td></tr><tr><td id="L1492" class="css-a4x74f"><span>1492</span></td><td id="LC1492" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1493" class="css-a4x74f"><span>1493</span></td><td id="LC1493" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1494" class="css-a4x74f"><span>1494</span></td><td id="LC1494" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1495" class="css-a4x74f"><span>1495</span></td><td id="LC1495" class="css-1dcdqdg"><code>      instance.state.isVisible = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L1496" class="css-a4x74f"><span>1496</span></td><td id="LC1496" class="css-1dcdqdg"><code>      instance.state.isShown = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L1497" class="css-a4x74f"><span>1497</span></td><td id="LC1497" class="css-1dcdqdg"><code>      ignoreOnFirstUpdate = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L1498" class="css-a4x74f"><span>1498</span></td><td id="LC1498" class="css-1dcdqdg"><code>      isVisibleFromClick = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L1499" class="css-a4x74f"><span>1499</span></td><td id="LC1499" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1500" class="css-a4x74f"><span>1500</span></td><td id="LC1500" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (getIsDefaultRenderFn()) {
</code></td></tr><tr><td id="L1501" class="css-a4x74f"><span>1501</span></td><td id="LC1501" class="css-1dcdqdg"><code>        popper.style.visibility = <span class="code-string">'hidden'</span>;
</code></td></tr><tr><td id="L1502" class="css-a4x74f"><span>1502</span></td><td id="LC1502" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1503" class="css-a4x74f"><span>1503</span></td><td id="LC1503" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1504" class="css-a4x74f"><span>1504</span></td><td id="LC1504" class="css-1dcdqdg"><code>      cleanupInteractiveMouseListeners();
</code></td></tr><tr><td id="L1505" class="css-a4x74f"><span>1505</span></td><td id="LC1505" class="css-1dcdqdg"><code>      removeDocumentPress();
</code></td></tr><tr><td id="L1506" class="css-a4x74f"><span>1506</span></td><td id="LC1506" class="css-1dcdqdg"><code>      handleStyles(<span class="code-literal">true</span>);
</code></td></tr><tr><td id="L1507" class="css-a4x74f"><span>1507</span></td><td id="LC1507" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1508" class="css-a4x74f"><span>1508</span></td><td id="LC1508" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (getIsDefaultRenderFn()) {
</code></td></tr><tr><td id="L1509" class="css-a4x74f"><span>1509</span></td><td id="LC1509" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> _getDefaultTemplateCh4 = getDefaultTemplateChildren(),
</code></td></tr><tr><td id="L1510" class="css-a4x74f"><span>1510</span></td><td id="LC1510" class="css-1dcdqdg"><code>            box = _getDefaultTemplateCh4.box,
</code></td></tr><tr><td id="L1511" class="css-a4x74f"><span>1511</span></td><td id="LC1511" class="css-1dcdqdg"><code>            content = _getDefaultTemplateCh4.content;
</code></td></tr><tr><td id="L1512" class="css-a4x74f"><span>1512</span></td><td id="LC1512" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1513" class="css-a4x74f"><span>1513</span></td><td id="LC1513" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (instance.props.animation) {
</code></td></tr><tr><td id="L1514" class="css-a4x74f"><span>1514</span></td><td id="LC1514" class="css-1dcdqdg"><code>          setTransitionDuration([box, content], duration);
</code></td></tr><tr><td id="L1515" class="css-a4x74f"><span>1515</span></td><td id="LC1515" class="css-1dcdqdg"><code>          setVisibilityState([box, content], <span class="code-string">'hidden'</span>);
</code></td></tr><tr><td id="L1516" class="css-a4x74f"><span>1516</span></td><td id="LC1516" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L1517" class="css-a4x74f"><span>1517</span></td><td id="LC1517" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1518" class="css-a4x74f"><span>1518</span></td><td id="LC1518" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1519" class="css-a4x74f"><span>1519</span></td><td id="LC1519" class="css-1dcdqdg"><code>      handleAriaContentAttribute();
</code></td></tr><tr><td id="L1520" class="css-a4x74f"><span>1520</span></td><td id="LC1520" class="css-1dcdqdg"><code>      handleAriaExpandedAttribute();
</code></td></tr><tr><td id="L1521" class="css-a4x74f"><span>1521</span></td><td id="LC1521" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1522" class="css-a4x74f"><span>1522</span></td><td id="LC1522" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (instance.props.animation) {
</code></td></tr><tr><td id="L1523" class="css-a4x74f"><span>1523</span></td><td id="LC1523" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (getIsDefaultRenderFn()) {
</code></td></tr><tr><td id="L1524" class="css-a4x74f"><span>1524</span></td><td id="LC1524" class="css-1dcdqdg"><code>          onTransitionedOut(duration, instance.unmount);
</code></td></tr><tr><td id="L1525" class="css-a4x74f"><span>1525</span></td><td id="LC1525" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L1526" class="css-a4x74f"><span>1526</span></td><td id="LC1526" class="css-1dcdqdg"><code>      } <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L1527" class="css-a4x74f"><span>1527</span></td><td id="LC1527" class="css-1dcdqdg"><code>        instance.unmount();
</code></td></tr><tr><td id="L1528" class="css-a4x74f"><span>1528</span></td><td id="LC1528" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1529" class="css-a4x74f"><span>1529</span></td><td id="LC1529" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1530" class="css-a4x74f"><span>1530</span></td><td id="LC1530" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1531" class="css-a4x74f"><span>1531</span></td><td id="LC1531" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">hideWithInteractivity</span>(<span class="code-params">event</span>) </span>{
</code></td></tr><tr><td id="L1532" class="css-a4x74f"><span>1532</span></td><td id="LC1532" class="css-1dcdqdg"><code>      <span class="code-comment">/* istanbul ignore else */</span>
</code></td></tr><tr><td id="L1533" class="css-a4x74f"><span>1533</span></td><td id="LC1533" class="css-1dcdqdg"><code>      {
</code></td></tr><tr><td id="L1534" class="css-a4x74f"><span>1534</span></td><td id="LC1534" class="css-1dcdqdg"><code>        warnWhen(instance.state.isDestroyed, createMemoryLeakWarning(<span class="code-string">'hideWithInteractivity'</span>));
</code></td></tr><tr><td id="L1535" class="css-a4x74f"><span>1535</span></td><td id="LC1535" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1536" class="css-a4x74f"><span>1536</span></td><td id="LC1536" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1537" class="css-a4x74f"><span>1537</span></td><td id="LC1537" class="css-1dcdqdg"><code>      getDocument().addEventListener(<span class="code-string">'mousemove'</span>, debouncedOnMouseMove);
</code></td></tr><tr><td id="L1538" class="css-a4x74f"><span>1538</span></td><td id="LC1538" class="css-1dcdqdg"><code>      pushIfUnique(mouseMoveListeners, debouncedOnMouseMove);
</code></td></tr><tr><td id="L1539" class="css-a4x74f"><span>1539</span></td><td id="LC1539" class="css-1dcdqdg"><code>      debouncedOnMouseMove(event);
</code></td></tr><tr><td id="L1540" class="css-a4x74f"><span>1540</span></td><td id="LC1540" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1541" class="css-a4x74f"><span>1541</span></td><td id="LC1541" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1542" class="css-a4x74f"><span>1542</span></td><td id="LC1542" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">unmount</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1543" class="css-a4x74f"><span>1543</span></td><td id="LC1543" class="css-1dcdqdg"><code>      <span class="code-comment">/* istanbul ignore else */</span>
</code></td></tr><tr><td id="L1544" class="css-a4x74f"><span>1544</span></td><td id="LC1544" class="css-1dcdqdg"><code>      {
</code></td></tr><tr><td id="L1545" class="css-a4x74f"><span>1545</span></td><td id="LC1545" class="css-1dcdqdg"><code>        warnWhen(instance.state.isDestroyed, createMemoryLeakWarning(<span class="code-string">'unmount'</span>));
</code></td></tr><tr><td id="L1546" class="css-a4x74f"><span>1546</span></td><td id="LC1546" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1547" class="css-a4x74f"><span>1547</span></td><td id="LC1547" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1548" class="css-a4x74f"><span>1548</span></td><td id="LC1548" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (instance.state.isVisible) {
</code></td></tr><tr><td id="L1549" class="css-a4x74f"><span>1549</span></td><td id="LC1549" class="css-1dcdqdg"><code>        instance.hide();
</code></td></tr><tr><td id="L1550" class="css-a4x74f"><span>1550</span></td><td id="LC1550" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1551" class="css-a4x74f"><span>1551</span></td><td id="LC1551" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1552" class="css-a4x74f"><span>1552</span></td><td id="LC1552" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (!instance.state.isMounted) {
</code></td></tr><tr><td id="L1553" class="css-a4x74f"><span>1553</span></td><td id="LC1553" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1554" class="css-a4x74f"><span>1554</span></td><td id="LC1554" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1555" class="css-a4x74f"><span>1555</span></td><td id="LC1555" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1556" class="css-a4x74f"><span>1556</span></td><td id="LC1556" class="css-1dcdqdg"><code>      destroyPopperInstance(); <span class="code-comment">// If a popper is not interactive, it will be appended outside the popper</span>
</code></td></tr><tr><td id="L1557" class="css-a4x74f"><span>1557</span></td><td id="LC1557" class="css-1dcdqdg"><code>      <span class="code-comment">// tree by default. This seems mainly for interactive tippies, but we should</span>
</code></td></tr><tr><td id="L1558" class="css-a4x74f"><span>1558</span></td><td id="LC1558" class="css-1dcdqdg"><code>      <span class="code-comment">// find a workaround if possible</span>
</code></td></tr><tr><td id="L1559" class="css-a4x74f"><span>1559</span></td><td id="LC1559" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1560" class="css-a4x74f"><span>1560</span></td><td id="LC1560" class="css-1dcdqdg"><code>      getNestedPopperTree().forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">nestedPopper</span>) </span>{
</code></td></tr><tr><td id="L1561" class="css-a4x74f"><span>1561</span></td><td id="LC1561" class="css-1dcdqdg"><code>        nestedPopper._tippy.unmount();
</code></td></tr><tr><td id="L1562" class="css-a4x74f"><span>1562</span></td><td id="LC1562" class="css-1dcdqdg"><code>      });
</code></td></tr><tr><td id="L1563" class="css-a4x74f"><span>1563</span></td><td id="LC1563" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1564" class="css-a4x74f"><span>1564</span></td><td id="LC1564" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (popper.parentNode) {
</code></td></tr><tr><td id="L1565" class="css-a4x74f"><span>1565</span></td><td id="LC1565" class="css-1dcdqdg"><code>        popper.parentNode.removeChild(popper);
</code></td></tr><tr><td id="L1566" class="css-a4x74f"><span>1566</span></td><td id="LC1566" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1567" class="css-a4x74f"><span>1567</span></td><td id="LC1567" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1568" class="css-a4x74f"><span>1568</span></td><td id="LC1568" class="css-1dcdqdg"><code>      mountedInstances = mountedInstances.filter(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">i</span>) </span>{
</code></td></tr><tr><td id="L1569" class="css-a4x74f"><span>1569</span></td><td id="LC1569" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> i !== instance;
</code></td></tr><tr><td id="L1570" class="css-a4x74f"><span>1570</span></td><td id="LC1570" class="css-1dcdqdg"><code>      });
</code></td></tr><tr><td id="L1571" class="css-a4x74f"><span>1571</span></td><td id="LC1571" class="css-1dcdqdg"><code>      instance.state.isMounted = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L1572" class="css-a4x74f"><span>1572</span></td><td id="LC1572" class="css-1dcdqdg"><code>      invokeHook(<span class="code-string">'onHidden'</span>, [instance]);
</code></td></tr><tr><td id="L1573" class="css-a4x74f"><span>1573</span></td><td id="LC1573" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1574" class="css-a4x74f"><span>1574</span></td><td id="LC1574" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1575" class="css-a4x74f"><span>1575</span></td><td id="LC1575" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">destroy</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1576" class="css-a4x74f"><span>1576</span></td><td id="LC1576" class="css-1dcdqdg"><code>      <span class="code-comment">/* istanbul ignore else */</span>
</code></td></tr><tr><td id="L1577" class="css-a4x74f"><span>1577</span></td><td id="LC1577" class="css-1dcdqdg"><code>      {
</code></td></tr><tr><td id="L1578" class="css-a4x74f"><span>1578</span></td><td id="LC1578" class="css-1dcdqdg"><code>        warnWhen(instance.state.isDestroyed, createMemoryLeakWarning(<span class="code-string">'destroy'</span>));
</code></td></tr><tr><td id="L1579" class="css-a4x74f"><span>1579</span></td><td id="LC1579" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1580" class="css-a4x74f"><span>1580</span></td><td id="LC1580" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1581" class="css-a4x74f"><span>1581</span></td><td id="LC1581" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (instance.state.isDestroyed) {
</code></td></tr><tr><td id="L1582" class="css-a4x74f"><span>1582</span></td><td id="LC1582" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1583" class="css-a4x74f"><span>1583</span></td><td id="LC1583" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1584" class="css-a4x74f"><span>1584</span></td><td id="LC1584" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1585" class="css-a4x74f"><span>1585</span></td><td id="LC1585" class="css-1dcdqdg"><code>      instance.clearDelayTimeouts();
</code></td></tr><tr><td id="L1586" class="css-a4x74f"><span>1586</span></td><td id="LC1586" class="css-1dcdqdg"><code>      instance.unmount();
</code></td></tr><tr><td id="L1587" class="css-a4x74f"><span>1587</span></td><td id="LC1587" class="css-1dcdqdg"><code>      removeListeners();
</code></td></tr><tr><td id="L1588" class="css-a4x74f"><span>1588</span></td><td id="LC1588" class="css-1dcdqdg"><code>      <span class="code-keyword">delete</span> reference._tippy;
</code></td></tr><tr><td id="L1589" class="css-a4x74f"><span>1589</span></td><td id="LC1589" class="css-1dcdqdg"><code>      instance.state.isDestroyed = <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L1590" class="css-a4x74f"><span>1590</span></td><td id="LC1590" class="css-1dcdqdg"><code>      invokeHook(<span class="code-string">'onDestroy'</span>, [instance]);
</code></td></tr><tr><td id="L1591" class="css-a4x74f"><span>1591</span></td><td id="LC1591" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1592" class="css-a4x74f"><span>1592</span></td><td id="LC1592" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L1593" class="css-a4x74f"><span>1593</span></td><td id="LC1593" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1594" class="css-a4x74f"><span>1594</span></td><td id="LC1594" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">tippy</span>(<span class="code-params">targets, optionalProps</span>) </span>{
</code></td></tr><tr><td id="L1595" class="css-a4x74f"><span>1595</span></td><td id="LC1595" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (optionalProps === <span class="code-keyword">void</span> <span class="code-number">0</span>) {
</code></td></tr><tr><td id="L1596" class="css-a4x74f"><span>1596</span></td><td id="LC1596" class="css-1dcdqdg"><code>      optionalProps = {};
</code></td></tr><tr><td id="L1597" class="css-a4x74f"><span>1597</span></td><td id="LC1597" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1598" class="css-a4x74f"><span>1598</span></td><td id="LC1598" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1599" class="css-a4x74f"><span>1599</span></td><td id="LC1599" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> plugins = defaultProps.plugins.concat(optionalProps.plugins || []);
</code></td></tr><tr><td id="L1600" class="css-a4x74f"><span>1600</span></td><td id="LC1600" class="css-1dcdqdg"><code>    <span class="code-comment">/* istanbul ignore else */</span>
</code></td></tr><tr><td id="L1601" class="css-a4x74f"><span>1601</span></td><td id="LC1601" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1602" class="css-a4x74f"><span>1602</span></td><td id="LC1602" class="css-1dcdqdg"><code>    {
</code></td></tr><tr><td id="L1603" class="css-a4x74f"><span>1603</span></td><td id="LC1603" class="css-1dcdqdg"><code>      validateTargets(targets);
</code></td></tr><tr><td id="L1604" class="css-a4x74f"><span>1604</span></td><td id="LC1604" class="css-1dcdqdg"><code>      validateProps(optionalProps, plugins);
</code></td></tr><tr><td id="L1605" class="css-a4x74f"><span>1605</span></td><td id="LC1605" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1606" class="css-a4x74f"><span>1606</span></td><td id="LC1606" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1607" class="css-a4x74f"><span>1607</span></td><td id="LC1607" class="css-1dcdqdg"><code>    bindGlobalEventListeners();
</code></td></tr><tr><td id="L1608" class="css-a4x74f"><span>1608</span></td><td id="LC1608" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> passedProps = <span class="code-built_in">Object</span>.assign({}, optionalProps, {
</code></td></tr><tr><td id="L1609" class="css-a4x74f"><span>1609</span></td><td id="LC1609" class="css-1dcdqdg"><code>      plugins: plugins
</code></td></tr><tr><td id="L1610" class="css-a4x74f"><span>1610</span></td><td id="LC1610" class="css-1dcdqdg"><code>    });
</code></td></tr><tr><td id="L1611" class="css-a4x74f"><span>1611</span></td><td id="LC1611" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> elements = getArrayOfElements(targets);
</code></td></tr><tr><td id="L1612" class="css-a4x74f"><span>1612</span></td><td id="LC1612" class="css-1dcdqdg"><code>    <span class="code-comment">/* istanbul ignore else */</span>
</code></td></tr><tr><td id="L1613" class="css-a4x74f"><span>1613</span></td><td id="LC1613" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1614" class="css-a4x74f"><span>1614</span></td><td id="LC1614" class="css-1dcdqdg"><code>    {
</code></td></tr><tr><td id="L1615" class="css-a4x74f"><span>1615</span></td><td id="LC1615" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> isSingleContentElement = isElement(passedProps.content);
</code></td></tr><tr><td id="L1616" class="css-a4x74f"><span>1616</span></td><td id="LC1616" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> isMoreThanOneReferenceElement = elements.length &gt; <span class="code-number">1</span>;
</code></td></tr><tr><td id="L1617" class="css-a4x74f"><span>1617</span></td><td id="LC1617" class="css-1dcdqdg"><code>      warnWhen(isSingleContentElement &amp;&amp; isMoreThanOneReferenceElement, [<span class="code-string">'tippy() was passed an Element as the `content` prop, but more than'</span>, <span class="code-string">'one tippy instance was created by this invocation. This means the'</span>, <span class="code-string">'content element will only be appended to the last tippy instance.'</span>, <span class="code-string">'\n\n'</span>, <span class="code-string">'Instead, pass the .innerHTML of the element, or use a function that'</span>, <span class="code-string">'returns a cloned version of the element instead.'</span>, <span class="code-string">'\n\n'</span>, <span class="code-string">'1) content: element.innerHTML\n'</span>, <span class="code-string">'2) content: () =&gt; element.cloneNode(true)'</span>].join(<span class="code-string">' '</span>));
</code></td></tr><tr><td id="L1618" class="css-a4x74f"><span>1618</span></td><td id="LC1618" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1619" class="css-a4x74f"><span>1619</span></td><td id="LC1619" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1620" class="css-a4x74f"><span>1620</span></td><td id="LC1620" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> instances = elements.reduce(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">acc, reference</span>) </span>{
</code></td></tr><tr><td id="L1621" class="css-a4x74f"><span>1621</span></td><td id="LC1621" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> instance = reference &amp;&amp; createTippy(reference, passedProps);
</code></td></tr><tr><td id="L1622" class="css-a4x74f"><span>1622</span></td><td id="LC1622" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1623" class="css-a4x74f"><span>1623</span></td><td id="LC1623" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (instance) {
</code></td></tr><tr><td id="L1624" class="css-a4x74f"><span>1624</span></td><td id="LC1624" class="css-1dcdqdg"><code>        acc.push(instance);
</code></td></tr><tr><td id="L1625" class="css-a4x74f"><span>1625</span></td><td id="LC1625" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1626" class="css-a4x74f"><span>1626</span></td><td id="LC1626" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1627" class="css-a4x74f"><span>1627</span></td><td id="LC1627" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> acc;
</code></td></tr><tr><td id="L1628" class="css-a4x74f"><span>1628</span></td><td id="LC1628" class="css-1dcdqdg"><code>    }, []);
</code></td></tr><tr><td id="L1629" class="css-a4x74f"><span>1629</span></td><td id="LC1629" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> isElement(targets) ? instances[<span class="code-number">0</span>] : instances;
</code></td></tr><tr><td id="L1630" class="css-a4x74f"><span>1630</span></td><td id="LC1630" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L1631" class="css-a4x74f"><span>1631</span></td><td id="LC1631" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1632" class="css-a4x74f"><span>1632</span></td><td id="LC1632" class="css-1dcdqdg"><code>  tippy.defaultProps = defaultProps;
</code></td></tr><tr><td id="L1633" class="css-a4x74f"><span>1633</span></td><td id="LC1633" class="css-1dcdqdg"><code>  tippy.setDefaultProps = setDefaultProps;
</code></td></tr><tr><td id="L1634" class="css-a4x74f"><span>1634</span></td><td id="LC1634" class="css-1dcdqdg"><code>  tippy.currentInput = currentInput;
</code></td></tr><tr><td id="L1635" class="css-a4x74f"><span>1635</span></td><td id="LC1635" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> hideAll = <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">hideAll</span>(<span class="code-params">_temp</span>) </span>{
</code></td></tr><tr><td id="L1636" class="css-a4x74f"><span>1636</span></td><td id="LC1636" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> _ref = _temp === <span class="code-keyword">void</span> <span class="code-number">0</span> ? {} : _temp,
</code></td></tr><tr><td id="L1637" class="css-a4x74f"><span>1637</span></td><td id="LC1637" class="css-1dcdqdg"><code>        excludedReferenceOrInstance = _ref.exclude,
</code></td></tr><tr><td id="L1638" class="css-a4x74f"><span>1638</span></td><td id="LC1638" class="css-1dcdqdg"><code>        duration = _ref.duration;
</code></td></tr><tr><td id="L1639" class="css-a4x74f"><span>1639</span></td><td id="LC1639" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1640" class="css-a4x74f"><span>1640</span></td><td id="LC1640" class="css-1dcdqdg"><code>    mountedInstances.forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">instance</span>) </span>{
</code></td></tr><tr><td id="L1641" class="css-a4x74f"><span>1641</span></td><td id="LC1641" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> isExcluded = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L1642" class="css-a4x74f"><span>1642</span></td><td id="LC1642" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1643" class="css-a4x74f"><span>1643</span></td><td id="LC1643" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (excludedReferenceOrInstance) {
</code></td></tr><tr><td id="L1644" class="css-a4x74f"><span>1644</span></td><td id="LC1644" class="css-1dcdqdg"><code>        isExcluded = isReferenceElement(excludedReferenceOrInstance) ? instance.reference === excludedReferenceOrInstance : instance.popper === excludedReferenceOrInstance.popper;
</code></td></tr><tr><td id="L1645" class="css-a4x74f"><span>1645</span></td><td id="LC1645" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1646" class="css-a4x74f"><span>1646</span></td><td id="LC1646" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1647" class="css-a4x74f"><span>1647</span></td><td id="LC1647" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (!isExcluded) {
</code></td></tr><tr><td id="L1648" class="css-a4x74f"><span>1648</span></td><td id="LC1648" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> originalDuration = instance.props.duration;
</code></td></tr><tr><td id="L1649" class="css-a4x74f"><span>1649</span></td><td id="LC1649" class="css-1dcdqdg"><code>        instance.setProps({
</code></td></tr><tr><td id="L1650" class="css-a4x74f"><span>1650</span></td><td id="LC1650" class="css-1dcdqdg"><code>          duration: duration
</code></td></tr><tr><td id="L1651" class="css-a4x74f"><span>1651</span></td><td id="LC1651" class="css-1dcdqdg"><code>        });
</code></td></tr><tr><td id="L1652" class="css-a4x74f"><span>1652</span></td><td id="LC1652" class="css-1dcdqdg"><code>        instance.hide();
</code></td></tr><tr><td id="L1653" class="css-a4x74f"><span>1653</span></td><td id="LC1653" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1654" class="css-a4x74f"><span>1654</span></td><td id="LC1654" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (!instance.state.isDestroyed) {
</code></td></tr><tr><td id="L1655" class="css-a4x74f"><span>1655</span></td><td id="LC1655" class="css-1dcdqdg"><code>          instance.setProps({
</code></td></tr><tr><td id="L1656" class="css-a4x74f"><span>1656</span></td><td id="LC1656" class="css-1dcdqdg"><code>            duration: originalDuration
</code></td></tr><tr><td id="L1657" class="css-a4x74f"><span>1657</span></td><td id="LC1657" class="css-1dcdqdg"><code>          });
</code></td></tr><tr><td id="L1658" class="css-a4x74f"><span>1658</span></td><td id="LC1658" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L1659" class="css-a4x74f"><span>1659</span></td><td id="LC1659" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1660" class="css-a4x74f"><span>1660</span></td><td id="LC1660" class="css-1dcdqdg"><code>    });
</code></td></tr><tr><td id="L1661" class="css-a4x74f"><span>1661</span></td><td id="LC1661" class="css-1dcdqdg"><code>  };
</code></td></tr><tr><td id="L1662" class="css-a4x74f"><span>1662</span></td><td id="LC1662" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1663" class="css-a4x74f"><span>1663</span></td><td id="LC1663" class="css-1dcdqdg"><code>  <span class="code-comment">// every time the popper is destroyed (i.e. a new target), removing the styles</span>
</code></td></tr><tr><td id="L1664" class="css-a4x74f"><span>1664</span></td><td id="LC1664" class="css-1dcdqdg"><code>  <span class="code-comment">// and causing transitions to break for singletons when the console is open, but</span>
</code></td></tr><tr><td id="L1665" class="css-a4x74f"><span>1665</span></td><td id="LC1665" class="css-1dcdqdg"><code>  <span class="code-comment">// most notably for non-transform styles being used, `gpuAcceleration: false`.</span>
</code></td></tr><tr><td id="L1666" class="css-a4x74f"><span>1666</span></td><td id="LC1666" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1667" class="css-a4x74f"><span>1667</span></td><td id="LC1667" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> applyStylesModifier = <span class="code-built_in">Object</span>.assign({}, core.applyStyles, {
</code></td></tr><tr><td id="L1668" class="css-a4x74f"><span>1668</span></td><td id="LC1668" class="css-1dcdqdg"><code>    effect: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">effect</span>(<span class="code-params">_ref</span>) </span>{
</code></td></tr><tr><td id="L1669" class="css-a4x74f"><span>1669</span></td><td id="LC1669" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> state = _ref.state;
</code></td></tr><tr><td id="L1670" class="css-a4x74f"><span>1670</span></td><td id="LC1670" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> initialStyles = {
</code></td></tr><tr><td id="L1671" class="css-a4x74f"><span>1671</span></td><td id="LC1671" class="css-1dcdqdg"><code>        popper: {
</code></td></tr><tr><td id="L1672" class="css-a4x74f"><span>1672</span></td><td id="LC1672" class="css-1dcdqdg"><code>          position: state.options.strategy,
</code></td></tr><tr><td id="L1673" class="css-a4x74f"><span>1673</span></td><td id="LC1673" class="css-1dcdqdg"><code>          left: <span class="code-string">'0'</span>,
</code></td></tr><tr><td id="L1674" class="css-a4x74f"><span>1674</span></td><td id="LC1674" class="css-1dcdqdg"><code>          top: <span class="code-string">'0'</span>,
</code></td></tr><tr><td id="L1675" class="css-a4x74f"><span>1675</span></td><td id="LC1675" class="css-1dcdqdg"><code>          margin: <span class="code-string">'0'</span>
</code></td></tr><tr><td id="L1676" class="css-a4x74f"><span>1676</span></td><td id="LC1676" class="css-1dcdqdg"><code>        },
</code></td></tr><tr><td id="L1677" class="css-a4x74f"><span>1677</span></td><td id="LC1677" class="css-1dcdqdg"><code>        arrow: {
</code></td></tr><tr><td id="L1678" class="css-a4x74f"><span>1678</span></td><td id="LC1678" class="css-1dcdqdg"><code>          position: <span class="code-string">'absolute'</span>
</code></td></tr><tr><td id="L1679" class="css-a4x74f"><span>1679</span></td><td id="LC1679" class="css-1dcdqdg"><code>        },
</code></td></tr><tr><td id="L1680" class="css-a4x74f"><span>1680</span></td><td id="LC1680" class="css-1dcdqdg"><code>        reference: {}
</code></td></tr><tr><td id="L1681" class="css-a4x74f"><span>1681</span></td><td id="LC1681" class="css-1dcdqdg"><code>      };
</code></td></tr><tr><td id="L1682" class="css-a4x74f"><span>1682</span></td><td id="LC1682" class="css-1dcdqdg"><code>      <span class="code-built_in">Object</span>.assign(state.elements.popper.style, initialStyles.popper);
</code></td></tr><tr><td id="L1683" class="css-a4x74f"><span>1683</span></td><td id="LC1683" class="css-1dcdqdg"><code>      state.styles = initialStyles;
</code></td></tr><tr><td id="L1684" class="css-a4x74f"><span>1684</span></td><td id="LC1684" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1685" class="css-a4x74f"><span>1685</span></td><td id="LC1685" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (state.elements.arrow) {
</code></td></tr><tr><td id="L1686" class="css-a4x74f"><span>1686</span></td><td id="LC1686" class="css-1dcdqdg"><code>        <span class="code-built_in">Object</span>.assign(state.elements.arrow.style, initialStyles.arrow);
</code></td></tr><tr><td id="L1687" class="css-a4x74f"><span>1687</span></td><td id="LC1687" class="css-1dcdqdg"><code>      } <span class="code-comment">// intentionally return no cleanup function</span>
</code></td></tr><tr><td id="L1688" class="css-a4x74f"><span>1688</span></td><td id="LC1688" class="css-1dcdqdg"><code>      <span class="code-comment">// return () =&gt; { ... }</span>
</code></td></tr><tr><td id="L1689" class="css-a4x74f"><span>1689</span></td><td id="LC1689" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1690" class="css-a4x74f"><span>1690</span></td><td id="LC1690" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1691" class="css-a4x74f"><span>1691</span></td><td id="LC1691" class="css-1dcdqdg"><code>  });
</code></td></tr><tr><td id="L1692" class="css-a4x74f"><span>1692</span></td><td id="LC1692" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1693" class="css-a4x74f"><span>1693</span></td><td id="LC1693" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> createSingleton = <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">createSingleton</span>(<span class="code-params">tippyInstances, optionalProps</span>) </span>{
</code></td></tr><tr><td id="L1694" class="css-a4x74f"><span>1694</span></td><td id="LC1694" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> _optionalProps$popper;
</code></td></tr><tr><td id="L1695" class="css-a4x74f"><span>1695</span></td><td id="LC1695" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1696" class="css-a4x74f"><span>1696</span></td><td id="LC1696" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (optionalProps === <span class="code-keyword">void</span> <span class="code-number">0</span>) {
</code></td></tr><tr><td id="L1697" class="css-a4x74f"><span>1697</span></td><td id="LC1697" class="css-1dcdqdg"><code>      optionalProps = {};
</code></td></tr><tr><td id="L1698" class="css-a4x74f"><span>1698</span></td><td id="LC1698" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1699" class="css-a4x74f"><span>1699</span></td><td id="LC1699" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1700" class="css-a4x74f"><span>1700</span></td><td id="LC1700" class="css-1dcdqdg"><code>    <span class="code-comment">/* istanbul ignore else */</span>
</code></td></tr><tr><td id="L1701" class="css-a4x74f"><span>1701</span></td><td id="LC1701" class="css-1dcdqdg"><code>    {
</code></td></tr><tr><td id="L1702" class="css-a4x74f"><span>1702</span></td><td id="LC1702" class="css-1dcdqdg"><code>      errorWhen(!<span class="code-built_in">Array</span>.isArray(tippyInstances), [<span class="code-string">'The first argument passed to createSingleton() must be an array of'</span>, <span class="code-string">'tippy instances. The passed value was'</span>, <span class="code-built_in">String</span>(tippyInstances)].join(<span class="code-string">' '</span>));
</code></td></tr><tr><td id="L1703" class="css-a4x74f"><span>1703</span></td><td id="LC1703" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1704" class="css-a4x74f"><span>1704</span></td><td id="LC1704" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1705" class="css-a4x74f"><span>1705</span></td><td id="LC1705" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> individualInstances = tippyInstances;
</code></td></tr><tr><td id="L1706" class="css-a4x74f"><span>1706</span></td><td id="LC1706" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> references = [];
</code></td></tr><tr><td id="L1707" class="css-a4x74f"><span>1707</span></td><td id="LC1707" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> triggerTargets = [];
</code></td></tr><tr><td id="L1708" class="css-a4x74f"><span>1708</span></td><td id="LC1708" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> currentTarget;
</code></td></tr><tr><td id="L1709" class="css-a4x74f"><span>1709</span></td><td id="LC1709" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> overrides = optionalProps.overrides;
</code></td></tr><tr><td id="L1710" class="css-a4x74f"><span>1710</span></td><td id="LC1710" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> interceptSetPropsCleanups = [];
</code></td></tr><tr><td id="L1711" class="css-a4x74f"><span>1711</span></td><td id="LC1711" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> shownOnCreate = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L1712" class="css-a4x74f"><span>1712</span></td><td id="LC1712" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1713" class="css-a4x74f"><span>1713</span></td><td id="LC1713" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">setTriggerTargets</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1714" class="css-a4x74f"><span>1714</span></td><td id="LC1714" class="css-1dcdqdg"><code>      triggerTargets = individualInstances.map(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">instance</span>) </span>{
</code></td></tr><tr><td id="L1715" class="css-a4x74f"><span>1715</span></td><td id="LC1715" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> normalizeToArray(instance.props.triggerTarget || instance.reference);
</code></td></tr><tr><td id="L1716" class="css-a4x74f"><span>1716</span></td><td id="LC1716" class="css-1dcdqdg"><code>      }).reduce(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">acc, item</span>) </span>{
</code></td></tr><tr><td id="L1717" class="css-a4x74f"><span>1717</span></td><td id="LC1717" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> acc.concat(item);
</code></td></tr><tr><td id="L1718" class="css-a4x74f"><span>1718</span></td><td id="LC1718" class="css-1dcdqdg"><code>      }, []);
</code></td></tr><tr><td id="L1719" class="css-a4x74f"><span>1719</span></td><td id="LC1719" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1720" class="css-a4x74f"><span>1720</span></td><td id="LC1720" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1721" class="css-a4x74f"><span>1721</span></td><td id="LC1721" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">setReferences</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1722" class="css-a4x74f"><span>1722</span></td><td id="LC1722" class="css-1dcdqdg"><code>      references = individualInstances.map(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">instance</span>) </span>{
</code></td></tr><tr><td id="L1723" class="css-a4x74f"><span>1723</span></td><td id="LC1723" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> instance.reference;
</code></td></tr><tr><td id="L1724" class="css-a4x74f"><span>1724</span></td><td id="LC1724" class="css-1dcdqdg"><code>      });
</code></td></tr><tr><td id="L1725" class="css-a4x74f"><span>1725</span></td><td id="LC1725" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1726" class="css-a4x74f"><span>1726</span></td><td id="LC1726" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1727" class="css-a4x74f"><span>1727</span></td><td id="LC1727" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">enableInstances</span>(<span class="code-params">isEnabled</span>) </span>{
</code></td></tr><tr><td id="L1728" class="css-a4x74f"><span>1728</span></td><td id="LC1728" class="css-1dcdqdg"><code>      individualInstances.forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">instance</span>) </span>{
</code></td></tr><tr><td id="L1729" class="css-a4x74f"><span>1729</span></td><td id="LC1729" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (isEnabled) {
</code></td></tr><tr><td id="L1730" class="css-a4x74f"><span>1730</span></td><td id="LC1730" class="css-1dcdqdg"><code>          instance.enable();
</code></td></tr><tr><td id="L1731" class="css-a4x74f"><span>1731</span></td><td id="LC1731" class="css-1dcdqdg"><code>        } <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L1732" class="css-a4x74f"><span>1732</span></td><td id="LC1732" class="css-1dcdqdg"><code>          instance.disable();
</code></td></tr><tr><td id="L1733" class="css-a4x74f"><span>1733</span></td><td id="LC1733" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L1734" class="css-a4x74f"><span>1734</span></td><td id="LC1734" class="css-1dcdqdg"><code>      });
</code></td></tr><tr><td id="L1735" class="css-a4x74f"><span>1735</span></td><td id="LC1735" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1736" class="css-a4x74f"><span>1736</span></td><td id="LC1736" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1737" class="css-a4x74f"><span>1737</span></td><td id="LC1737" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">interceptSetProps</span>(<span class="code-params">singleton</span>) </span>{
</code></td></tr><tr><td id="L1738" class="css-a4x74f"><span>1738</span></td><td id="LC1738" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> individualInstances.map(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">instance</span>) </span>{
</code></td></tr><tr><td id="L1739" class="css-a4x74f"><span>1739</span></td><td id="LC1739" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> originalSetProps = instance.setProps;
</code></td></tr><tr><td id="L1740" class="css-a4x74f"><span>1740</span></td><td id="LC1740" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1741" class="css-a4x74f"><span>1741</span></td><td id="LC1741" class="css-1dcdqdg"><code>        instance.setProps = <span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">props</span>) </span>{
</code></td></tr><tr><td id="L1742" class="css-a4x74f"><span>1742</span></td><td id="LC1742" class="css-1dcdqdg"><code>          originalSetProps(props);
</code></td></tr><tr><td id="L1743" class="css-a4x74f"><span>1743</span></td><td id="LC1743" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1744" class="css-a4x74f"><span>1744</span></td><td id="LC1744" class="css-1dcdqdg"><code>          <span class="code-keyword">if</span> (instance.reference === currentTarget) {
</code></td></tr><tr><td id="L1745" class="css-a4x74f"><span>1745</span></td><td id="LC1745" class="css-1dcdqdg"><code>            singleton.setProps(props);
</code></td></tr><tr><td id="L1746" class="css-a4x74f"><span>1746</span></td><td id="LC1746" class="css-1dcdqdg"><code>          }
</code></td></tr><tr><td id="L1747" class="css-a4x74f"><span>1747</span></td><td id="LC1747" class="css-1dcdqdg"><code>        };
</code></td></tr><tr><td id="L1748" class="css-a4x74f"><span>1748</span></td><td id="LC1748" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1749" class="css-a4x74f"><span>1749</span></td><td id="LC1749" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> <span class="code-function"><span class="code-keyword">function</span> (<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1750" class="css-a4x74f"><span>1750</span></td><td id="LC1750" class="css-1dcdqdg"><code>          instance.setProps = originalSetProps;
</code></td></tr><tr><td id="L1751" class="css-a4x74f"><span>1751</span></td><td id="LC1751" class="css-1dcdqdg"><code>        };
</code></td></tr><tr><td id="L1752" class="css-a4x74f"><span>1752</span></td><td id="LC1752" class="css-1dcdqdg"><code>      });
</code></td></tr><tr><td id="L1753" class="css-a4x74f"><span>1753</span></td><td id="LC1753" class="css-1dcdqdg"><code>    } <span class="code-comment">// have to pass singleton, as it maybe undefined on first call</span>
</code></td></tr><tr><td id="L1754" class="css-a4x74f"><span>1754</span></td><td id="LC1754" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1755" class="css-a4x74f"><span>1755</span></td><td id="LC1755" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1756" class="css-a4x74f"><span>1756</span></td><td id="LC1756" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">prepareInstance</span>(<span class="code-params">singleton, target</span>) </span>{
</code></td></tr><tr><td id="L1757" class="css-a4x74f"><span>1757</span></td><td id="LC1757" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> index = triggerTargets.indexOf(target); <span class="code-comment">// bail-out</span>
</code></td></tr><tr><td id="L1758" class="css-a4x74f"><span>1758</span></td><td id="LC1758" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1759" class="css-a4x74f"><span>1759</span></td><td id="LC1759" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (target === currentTarget) {
</code></td></tr><tr><td id="L1760" class="css-a4x74f"><span>1760</span></td><td id="LC1760" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1761" class="css-a4x74f"><span>1761</span></td><td id="LC1761" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1762" class="css-a4x74f"><span>1762</span></td><td id="LC1762" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1763" class="css-a4x74f"><span>1763</span></td><td id="LC1763" class="css-1dcdqdg"><code>      currentTarget = target;
</code></td></tr><tr><td id="L1764" class="css-a4x74f"><span>1764</span></td><td id="LC1764" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> overrideProps = (overrides || []).concat(<span class="code-string">'content'</span>).reduce(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">acc, prop</span>) </span>{
</code></td></tr><tr><td id="L1765" class="css-a4x74f"><span>1765</span></td><td id="LC1765" class="css-1dcdqdg"><code>        acc[prop] = individualInstances[index].props[prop];
</code></td></tr><tr><td id="L1766" class="css-a4x74f"><span>1766</span></td><td id="LC1766" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> acc;
</code></td></tr><tr><td id="L1767" class="css-a4x74f"><span>1767</span></td><td id="LC1767" class="css-1dcdqdg"><code>      }, {});
</code></td></tr><tr><td id="L1768" class="css-a4x74f"><span>1768</span></td><td id="LC1768" class="css-1dcdqdg"><code>      singleton.setProps(<span class="code-built_in">Object</span>.assign({}, overrideProps, {
</code></td></tr><tr><td id="L1769" class="css-a4x74f"><span>1769</span></td><td id="LC1769" class="css-1dcdqdg"><code>        getReferenceClientRect: <span class="code-keyword">typeof</span> overrideProps.getReferenceClientRect === <span class="code-string">'function'</span> ? overrideProps.getReferenceClientRect : <span class="code-function"><span class="code-keyword">function</span> (<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1770" class="css-a4x74f"><span>1770</span></td><td id="LC1770" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> _references$index;
</code></td></tr><tr><td id="L1771" class="css-a4x74f"><span>1771</span></td><td id="LC1771" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1772" class="css-a4x74f"><span>1772</span></td><td id="LC1772" class="css-1dcdqdg"><code>          <span class="code-keyword">return</span> (_references$index = references[index]) == <span class="code-literal">null</span> ? <span class="code-keyword">void</span> <span class="code-number">0</span> : _references$index.getBoundingClientRect();
</code></td></tr><tr><td id="L1773" class="css-a4x74f"><span>1773</span></td><td id="LC1773" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L1774" class="css-a4x74f"><span>1774</span></td><td id="LC1774" class="css-1dcdqdg"><code>      }));
</code></td></tr><tr><td id="L1775" class="css-a4x74f"><span>1775</span></td><td id="LC1775" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1776" class="css-a4x74f"><span>1776</span></td><td id="LC1776" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1777" class="css-a4x74f"><span>1777</span></td><td id="LC1777" class="css-1dcdqdg"><code>    enableInstances(<span class="code-literal">false</span>);
</code></td></tr><tr><td id="L1778" class="css-a4x74f"><span>1778</span></td><td id="LC1778" class="css-1dcdqdg"><code>    setReferences();
</code></td></tr><tr><td id="L1779" class="css-a4x74f"><span>1779</span></td><td id="LC1779" class="css-1dcdqdg"><code>    setTriggerTargets();
</code></td></tr><tr><td id="L1780" class="css-a4x74f"><span>1780</span></td><td id="LC1780" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> plugin = {
</code></td></tr><tr><td id="L1781" class="css-a4x74f"><span>1781</span></td><td id="LC1781" class="css-1dcdqdg"><code>      fn: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">fn</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1782" class="css-a4x74f"><span>1782</span></td><td id="LC1782" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> {
</code></td></tr><tr><td id="L1783" class="css-a4x74f"><span>1783</span></td><td id="LC1783" class="css-1dcdqdg"><code>          onDestroy: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onDestroy</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1784" class="css-a4x74f"><span>1784</span></td><td id="LC1784" class="css-1dcdqdg"><code>            enableInstances(<span class="code-literal">true</span>);
</code></td></tr><tr><td id="L1785" class="css-a4x74f"><span>1785</span></td><td id="LC1785" class="css-1dcdqdg"><code>          },
</code></td></tr><tr><td id="L1786" class="css-a4x74f"><span>1786</span></td><td id="LC1786" class="css-1dcdqdg"><code>          onHidden: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onHidden</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1787" class="css-a4x74f"><span>1787</span></td><td id="LC1787" class="css-1dcdqdg"><code>            currentTarget = <span class="code-literal">null</span>;
</code></td></tr><tr><td id="L1788" class="css-a4x74f"><span>1788</span></td><td id="LC1788" class="css-1dcdqdg"><code>          },
</code></td></tr><tr><td id="L1789" class="css-a4x74f"><span>1789</span></td><td id="LC1789" class="css-1dcdqdg"><code>          onClickOutside: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onClickOutside</span>(<span class="code-params">instance</span>) </span>{
</code></td></tr><tr><td id="L1790" class="css-a4x74f"><span>1790</span></td><td id="LC1790" class="css-1dcdqdg"><code>            <span class="code-keyword">if</span> (instance.props.showOnCreate &amp;&amp; !shownOnCreate) {
</code></td></tr><tr><td id="L1791" class="css-a4x74f"><span>1791</span></td><td id="LC1791" class="css-1dcdqdg"><code>              shownOnCreate = <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L1792" class="css-a4x74f"><span>1792</span></td><td id="LC1792" class="css-1dcdqdg"><code>              currentTarget = <span class="code-literal">null</span>;
</code></td></tr><tr><td id="L1793" class="css-a4x74f"><span>1793</span></td><td id="LC1793" class="css-1dcdqdg"><code>            }
</code></td></tr><tr><td id="L1794" class="css-a4x74f"><span>1794</span></td><td id="LC1794" class="css-1dcdqdg"><code>          },
</code></td></tr><tr><td id="L1795" class="css-a4x74f"><span>1795</span></td><td id="LC1795" class="css-1dcdqdg"><code>          onShow: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onShow</span>(<span class="code-params">instance</span>) </span>{
</code></td></tr><tr><td id="L1796" class="css-a4x74f"><span>1796</span></td><td id="LC1796" class="css-1dcdqdg"><code>            <span class="code-keyword">if</span> (instance.props.showOnCreate &amp;&amp; !shownOnCreate) {
</code></td></tr><tr><td id="L1797" class="css-a4x74f"><span>1797</span></td><td id="LC1797" class="css-1dcdqdg"><code>              shownOnCreate = <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L1798" class="css-a4x74f"><span>1798</span></td><td id="LC1798" class="css-1dcdqdg"><code>              prepareInstance(instance, references[<span class="code-number">0</span>]);
</code></td></tr><tr><td id="L1799" class="css-a4x74f"><span>1799</span></td><td id="LC1799" class="css-1dcdqdg"><code>            }
</code></td></tr><tr><td id="L1800" class="css-a4x74f"><span>1800</span></td><td id="LC1800" class="css-1dcdqdg"><code>          },
</code></td></tr><tr><td id="L1801" class="css-a4x74f"><span>1801</span></td><td id="LC1801" class="css-1dcdqdg"><code>          onTrigger: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onTrigger</span>(<span class="code-params">instance, event</span>) </span>{
</code></td></tr><tr><td id="L1802" class="css-a4x74f"><span>1802</span></td><td id="LC1802" class="css-1dcdqdg"><code>            prepareInstance(instance, event.currentTarget);
</code></td></tr><tr><td id="L1803" class="css-a4x74f"><span>1803</span></td><td id="LC1803" class="css-1dcdqdg"><code>          }
</code></td></tr><tr><td id="L1804" class="css-a4x74f"><span>1804</span></td><td id="LC1804" class="css-1dcdqdg"><code>        };
</code></td></tr><tr><td id="L1805" class="css-a4x74f"><span>1805</span></td><td id="LC1805" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1806" class="css-a4x74f"><span>1806</span></td><td id="LC1806" class="css-1dcdqdg"><code>    };
</code></td></tr><tr><td id="L1807" class="css-a4x74f"><span>1807</span></td><td id="LC1807" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> singleton = tippy(div(), <span class="code-built_in">Object</span>.assign({}, removeProperties(optionalProps, [<span class="code-string">'overrides'</span>]), {
</code></td></tr><tr><td id="L1808" class="css-a4x74f"><span>1808</span></td><td id="LC1808" class="css-1dcdqdg"><code>      plugins: [plugin].concat(optionalProps.plugins || []),
</code></td></tr><tr><td id="L1809" class="css-a4x74f"><span>1809</span></td><td id="LC1809" class="css-1dcdqdg"><code>      triggerTarget: triggerTargets,
</code></td></tr><tr><td id="L1810" class="css-a4x74f"><span>1810</span></td><td id="LC1810" class="css-1dcdqdg"><code>      popperOptions: <span class="code-built_in">Object</span>.assign({}, optionalProps.popperOptions, {
</code></td></tr><tr><td id="L1811" class="css-a4x74f"><span>1811</span></td><td id="LC1811" class="css-1dcdqdg"><code>        modifiers: [].concat(((_optionalProps$popper = optionalProps.popperOptions) == <span class="code-literal">null</span> ? <span class="code-keyword">void</span> <span class="code-number">0</span> : _optionalProps$popper.modifiers) || [], [applyStylesModifier])
</code></td></tr><tr><td id="L1812" class="css-a4x74f"><span>1812</span></td><td id="LC1812" class="css-1dcdqdg"><code>      })
</code></td></tr><tr><td id="L1813" class="css-a4x74f"><span>1813</span></td><td id="LC1813" class="css-1dcdqdg"><code>    }));
</code></td></tr><tr><td id="L1814" class="css-a4x74f"><span>1814</span></td><td id="LC1814" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> originalShow = singleton.show;
</code></td></tr><tr><td id="L1815" class="css-a4x74f"><span>1815</span></td><td id="LC1815" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1816" class="css-a4x74f"><span>1816</span></td><td id="LC1816" class="css-1dcdqdg"><code>    singleton.show = <span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">target</span>) </span>{
</code></td></tr><tr><td id="L1817" class="css-a4x74f"><span>1817</span></td><td id="LC1817" class="css-1dcdqdg"><code>      originalShow(); <span class="code-comment">// first time, showOnCreate or programmatic call with no params</span>
</code></td></tr><tr><td id="L1818" class="css-a4x74f"><span>1818</span></td><td id="LC1818" class="css-1dcdqdg"><code>      <span class="code-comment">// default to showing first instance</span>
</code></td></tr><tr><td id="L1819" class="css-a4x74f"><span>1819</span></td><td id="LC1819" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1820" class="css-a4x74f"><span>1820</span></td><td id="LC1820" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (!currentTarget &amp;&amp; target == <span class="code-literal">null</span>) {
</code></td></tr><tr><td id="L1821" class="css-a4x74f"><span>1821</span></td><td id="LC1821" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> prepareInstance(singleton, references[<span class="code-number">0</span>]);
</code></td></tr><tr><td id="L1822" class="css-a4x74f"><span>1822</span></td><td id="LC1822" class="css-1dcdqdg"><code>      } <span class="code-comment">// triggered from event (do nothing as prepareInstance already called by onTrigger)</span>
</code></td></tr><tr><td id="L1823" class="css-a4x74f"><span>1823</span></td><td id="LC1823" class="css-1dcdqdg"><code>      <span class="code-comment">// programmatic call with no params when already visible (do nothing again)</span>
</code></td></tr><tr><td id="L1824" class="css-a4x74f"><span>1824</span></td><td id="LC1824" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1825" class="css-a4x74f"><span>1825</span></td><td id="LC1825" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1826" class="css-a4x74f"><span>1826</span></td><td id="LC1826" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (currentTarget &amp;&amp; target == <span class="code-literal">null</span>) {
</code></td></tr><tr><td id="L1827" class="css-a4x74f"><span>1827</span></td><td id="LC1827" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1828" class="css-a4x74f"><span>1828</span></td><td id="LC1828" class="css-1dcdqdg"><code>      } <span class="code-comment">// target is index of instance</span>
</code></td></tr><tr><td id="L1829" class="css-a4x74f"><span>1829</span></td><td id="LC1829" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1830" class="css-a4x74f"><span>1830</span></td><td id="LC1830" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1831" class="css-a4x74f"><span>1831</span></td><td id="LC1831" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (<span class="code-keyword">typeof</span> target === <span class="code-string">'number'</span>) {
</code></td></tr><tr><td id="L1832" class="css-a4x74f"><span>1832</span></td><td id="LC1832" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> references[target] &amp;&amp; prepareInstance(singleton, references[target]);
</code></td></tr><tr><td id="L1833" class="css-a4x74f"><span>1833</span></td><td id="LC1833" class="css-1dcdqdg"><code>      } <span class="code-comment">// target is a child tippy instance</span>
</code></td></tr><tr><td id="L1834" class="css-a4x74f"><span>1834</span></td><td id="LC1834" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1835" class="css-a4x74f"><span>1835</span></td><td id="LC1835" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1836" class="css-a4x74f"><span>1836</span></td><td id="LC1836" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (individualInstances.indexOf(target) &gt;= <span class="code-number">0</span>) {
</code></td></tr><tr><td id="L1837" class="css-a4x74f"><span>1837</span></td><td id="LC1837" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> ref = target.reference;
</code></td></tr><tr><td id="L1838" class="css-a4x74f"><span>1838</span></td><td id="LC1838" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> prepareInstance(singleton, ref);
</code></td></tr><tr><td id="L1839" class="css-a4x74f"><span>1839</span></td><td id="LC1839" class="css-1dcdqdg"><code>      } <span class="code-comment">// target is a ReferenceElement</span>
</code></td></tr><tr><td id="L1840" class="css-a4x74f"><span>1840</span></td><td id="LC1840" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1841" class="css-a4x74f"><span>1841</span></td><td id="LC1841" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1842" class="css-a4x74f"><span>1842</span></td><td id="LC1842" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (references.indexOf(target) &gt;= <span class="code-number">0</span>) {
</code></td></tr><tr><td id="L1843" class="css-a4x74f"><span>1843</span></td><td id="LC1843" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> prepareInstance(singleton, target);
</code></td></tr><tr><td id="L1844" class="css-a4x74f"><span>1844</span></td><td id="LC1844" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1845" class="css-a4x74f"><span>1845</span></td><td id="LC1845" class="css-1dcdqdg"><code>    };
</code></td></tr><tr><td id="L1846" class="css-a4x74f"><span>1846</span></td><td id="LC1846" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1847" class="css-a4x74f"><span>1847</span></td><td id="LC1847" class="css-1dcdqdg"><code>    singleton.showNext = <span class="code-function"><span class="code-keyword">function</span> (<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1848" class="css-a4x74f"><span>1848</span></td><td id="LC1848" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> first = references[<span class="code-number">0</span>];
</code></td></tr><tr><td id="L1849" class="css-a4x74f"><span>1849</span></td><td id="LC1849" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1850" class="css-a4x74f"><span>1850</span></td><td id="LC1850" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (!currentTarget) {
</code></td></tr><tr><td id="L1851" class="css-a4x74f"><span>1851</span></td><td id="LC1851" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> singleton.show(<span class="code-number">0</span>);
</code></td></tr><tr><td id="L1852" class="css-a4x74f"><span>1852</span></td><td id="LC1852" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1853" class="css-a4x74f"><span>1853</span></td><td id="LC1853" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1854" class="css-a4x74f"><span>1854</span></td><td id="LC1854" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> index = references.indexOf(currentTarget);
</code></td></tr><tr><td id="L1855" class="css-a4x74f"><span>1855</span></td><td id="LC1855" class="css-1dcdqdg"><code>      singleton.show(references[index + <span class="code-number">1</span>] || first);
</code></td></tr><tr><td id="L1856" class="css-a4x74f"><span>1856</span></td><td id="LC1856" class="css-1dcdqdg"><code>    };
</code></td></tr><tr><td id="L1857" class="css-a4x74f"><span>1857</span></td><td id="LC1857" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1858" class="css-a4x74f"><span>1858</span></td><td id="LC1858" class="css-1dcdqdg"><code>    singleton.showPrevious = <span class="code-function"><span class="code-keyword">function</span> (<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1859" class="css-a4x74f"><span>1859</span></td><td id="LC1859" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> last = references[references.length - <span class="code-number">1</span>];
</code></td></tr><tr><td id="L1860" class="css-a4x74f"><span>1860</span></td><td id="LC1860" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1861" class="css-a4x74f"><span>1861</span></td><td id="LC1861" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (!currentTarget) {
</code></td></tr><tr><td id="L1862" class="css-a4x74f"><span>1862</span></td><td id="LC1862" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> singleton.show(last);
</code></td></tr><tr><td id="L1863" class="css-a4x74f"><span>1863</span></td><td id="LC1863" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1864" class="css-a4x74f"><span>1864</span></td><td id="LC1864" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1865" class="css-a4x74f"><span>1865</span></td><td id="LC1865" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> index = references.indexOf(currentTarget);
</code></td></tr><tr><td id="L1866" class="css-a4x74f"><span>1866</span></td><td id="LC1866" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> target = references[index - <span class="code-number">1</span>] || last;
</code></td></tr><tr><td id="L1867" class="css-a4x74f"><span>1867</span></td><td id="LC1867" class="css-1dcdqdg"><code>      singleton.show(target);
</code></td></tr><tr><td id="L1868" class="css-a4x74f"><span>1868</span></td><td id="LC1868" class="css-1dcdqdg"><code>    };
</code></td></tr><tr><td id="L1869" class="css-a4x74f"><span>1869</span></td><td id="LC1869" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1870" class="css-a4x74f"><span>1870</span></td><td id="LC1870" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> originalSetProps = singleton.setProps;
</code></td></tr><tr><td id="L1871" class="css-a4x74f"><span>1871</span></td><td id="LC1871" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1872" class="css-a4x74f"><span>1872</span></td><td id="LC1872" class="css-1dcdqdg"><code>    singleton.setProps = <span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">props</span>) </span>{
</code></td></tr><tr><td id="L1873" class="css-a4x74f"><span>1873</span></td><td id="LC1873" class="css-1dcdqdg"><code>      overrides = props.overrides || overrides;
</code></td></tr><tr><td id="L1874" class="css-a4x74f"><span>1874</span></td><td id="LC1874" class="css-1dcdqdg"><code>      originalSetProps(props);
</code></td></tr><tr><td id="L1875" class="css-a4x74f"><span>1875</span></td><td id="LC1875" class="css-1dcdqdg"><code>    };
</code></td></tr><tr><td id="L1876" class="css-a4x74f"><span>1876</span></td><td id="LC1876" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1877" class="css-a4x74f"><span>1877</span></td><td id="LC1877" class="css-1dcdqdg"><code>    singleton.setInstances = <span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">nextInstances</span>) </span>{
</code></td></tr><tr><td id="L1878" class="css-a4x74f"><span>1878</span></td><td id="LC1878" class="css-1dcdqdg"><code>      enableInstances(<span class="code-literal">true</span>);
</code></td></tr><tr><td id="L1879" class="css-a4x74f"><span>1879</span></td><td id="LC1879" class="css-1dcdqdg"><code>      interceptSetPropsCleanups.forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">fn</span>) </span>{
</code></td></tr><tr><td id="L1880" class="css-a4x74f"><span>1880</span></td><td id="LC1880" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> fn();
</code></td></tr><tr><td id="L1881" class="css-a4x74f"><span>1881</span></td><td id="LC1881" class="css-1dcdqdg"><code>      });
</code></td></tr><tr><td id="L1882" class="css-a4x74f"><span>1882</span></td><td id="LC1882" class="css-1dcdqdg"><code>      individualInstances = nextInstances;
</code></td></tr><tr><td id="L1883" class="css-a4x74f"><span>1883</span></td><td id="LC1883" class="css-1dcdqdg"><code>      enableInstances(<span class="code-literal">false</span>);
</code></td></tr><tr><td id="L1884" class="css-a4x74f"><span>1884</span></td><td id="LC1884" class="css-1dcdqdg"><code>      setReferences();
</code></td></tr><tr><td id="L1885" class="css-a4x74f"><span>1885</span></td><td id="LC1885" class="css-1dcdqdg"><code>      setTriggerTargets();
</code></td></tr><tr><td id="L1886" class="css-a4x74f"><span>1886</span></td><td id="LC1886" class="css-1dcdqdg"><code>      interceptSetPropsCleanups = interceptSetProps(singleton);
</code></td></tr><tr><td id="L1887" class="css-a4x74f"><span>1887</span></td><td id="LC1887" class="css-1dcdqdg"><code>      singleton.setProps({
</code></td></tr><tr><td id="L1888" class="css-a4x74f"><span>1888</span></td><td id="LC1888" class="css-1dcdqdg"><code>        triggerTarget: triggerTargets
</code></td></tr><tr><td id="L1889" class="css-a4x74f"><span>1889</span></td><td id="LC1889" class="css-1dcdqdg"><code>      });
</code></td></tr><tr><td id="L1890" class="css-a4x74f"><span>1890</span></td><td id="LC1890" class="css-1dcdqdg"><code>    };
</code></td></tr><tr><td id="L1891" class="css-a4x74f"><span>1891</span></td><td id="LC1891" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1892" class="css-a4x74f"><span>1892</span></td><td id="LC1892" class="css-1dcdqdg"><code>    interceptSetPropsCleanups = interceptSetProps(singleton);
</code></td></tr><tr><td id="L1893" class="css-a4x74f"><span>1893</span></td><td id="LC1893" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> singleton;
</code></td></tr><tr><td id="L1894" class="css-a4x74f"><span>1894</span></td><td id="LC1894" class="css-1dcdqdg"><code>  };
</code></td></tr><tr><td id="L1895" class="css-a4x74f"><span>1895</span></td><td id="LC1895" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1896" class="css-a4x74f"><span>1896</span></td><td id="LC1896" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> BUBBLING_EVENTS_MAP = {
</code></td></tr><tr><td id="L1897" class="css-a4x74f"><span>1897</span></td><td id="LC1897" class="css-1dcdqdg"><code>    mouseover: <span class="code-string">'mouseenter'</span>,
</code></td></tr><tr><td id="L1898" class="css-a4x74f"><span>1898</span></td><td id="LC1898" class="css-1dcdqdg"><code>    focusin: <span class="code-string">'focus'</span>,
</code></td></tr><tr><td id="L1899" class="css-a4x74f"><span>1899</span></td><td id="LC1899" class="css-1dcdqdg"><code>    click: <span class="code-string">'click'</span>
</code></td></tr><tr><td id="L1900" class="css-a4x74f"><span>1900</span></td><td id="LC1900" class="css-1dcdqdg"><code>  };
</code></td></tr><tr><td id="L1901" class="css-a4x74f"><span>1901</span></td><td id="LC1901" class="css-1dcdqdg"><code>  <span class="code-comment">/**
</span></code></td></tr><tr><td id="L1902" class="css-a4x74f"><span>1902</span></td><td id="LC1902" class="css-1dcdqdg"><code><span class="code-comment">   * Creates a delegate instance that controls the creation of tippy instances
</span></code></td></tr><tr><td id="L1903" class="css-a4x74f"><span>1903</span></td><td id="LC1903" class="css-1dcdqdg"><code><span class="code-comment">   * for child elements (`target` CSS selector).
</span></code></td></tr><tr><td id="L1904" class="css-a4x74f"><span>1904</span></td><td id="LC1904" class="css-1dcdqdg"><code><span class="code-comment">   */</span>
</code></td></tr><tr><td id="L1905" class="css-a4x74f"><span>1905</span></td><td id="LC1905" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1906" class="css-a4x74f"><span>1906</span></td><td id="LC1906" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">delegate</span>(<span class="code-params">targets, props</span>) </span>{
</code></td></tr><tr><td id="L1907" class="css-a4x74f"><span>1907</span></td><td id="LC1907" class="css-1dcdqdg"><code>    <span class="code-comment">/* istanbul ignore else */</span>
</code></td></tr><tr><td id="L1908" class="css-a4x74f"><span>1908</span></td><td id="LC1908" class="css-1dcdqdg"><code>    {
</code></td></tr><tr><td id="L1909" class="css-a4x74f"><span>1909</span></td><td id="LC1909" class="css-1dcdqdg"><code>      errorWhen(!(props &amp;&amp; props.target), [<span class="code-string">'You must specity a `target` prop indicating a CSS selector string matching'</span>, <span class="code-string">'the target elements that should receive a tippy.'</span>].join(<span class="code-string">' '</span>));
</code></td></tr><tr><td id="L1910" class="css-a4x74f"><span>1910</span></td><td id="LC1910" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1911" class="css-a4x74f"><span>1911</span></td><td id="LC1911" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1912" class="css-a4x74f"><span>1912</span></td><td id="LC1912" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> listeners = [];
</code></td></tr><tr><td id="L1913" class="css-a4x74f"><span>1913</span></td><td id="LC1913" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> childTippyInstances = [];
</code></td></tr><tr><td id="L1914" class="css-a4x74f"><span>1914</span></td><td id="LC1914" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> disabled = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L1915" class="css-a4x74f"><span>1915</span></td><td id="LC1915" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> target = props.target;
</code></td></tr><tr><td id="L1916" class="css-a4x74f"><span>1916</span></td><td id="LC1916" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> nativeProps = removeProperties(props, [<span class="code-string">'target'</span>]);
</code></td></tr><tr><td id="L1917" class="css-a4x74f"><span>1917</span></td><td id="LC1917" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> parentProps = <span class="code-built_in">Object</span>.assign({}, nativeProps, {
</code></td></tr><tr><td id="L1918" class="css-a4x74f"><span>1918</span></td><td id="LC1918" class="css-1dcdqdg"><code>      trigger: <span class="code-string">'manual'</span>,
</code></td></tr><tr><td id="L1919" class="css-a4x74f"><span>1919</span></td><td id="LC1919" class="css-1dcdqdg"><code>      touch: <span class="code-literal">false</span>
</code></td></tr><tr><td id="L1920" class="css-a4x74f"><span>1920</span></td><td id="LC1920" class="css-1dcdqdg"><code>    });
</code></td></tr><tr><td id="L1921" class="css-a4x74f"><span>1921</span></td><td id="LC1921" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> childProps = <span class="code-built_in">Object</span>.assign({
</code></td></tr><tr><td id="L1922" class="css-a4x74f"><span>1922</span></td><td id="LC1922" class="css-1dcdqdg"><code>      touch: defaultProps.touch
</code></td></tr><tr><td id="L1923" class="css-a4x74f"><span>1923</span></td><td id="LC1923" class="css-1dcdqdg"><code>    }, nativeProps, {
</code></td></tr><tr><td id="L1924" class="css-a4x74f"><span>1924</span></td><td id="LC1924" class="css-1dcdqdg"><code>      showOnCreate: <span class="code-literal">true</span>
</code></td></tr><tr><td id="L1925" class="css-a4x74f"><span>1925</span></td><td id="LC1925" class="css-1dcdqdg"><code>    });
</code></td></tr><tr><td id="L1926" class="css-a4x74f"><span>1926</span></td><td id="LC1926" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> returnValue = tippy(targets, parentProps);
</code></td></tr><tr><td id="L1927" class="css-a4x74f"><span>1927</span></td><td id="LC1927" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> normalizedReturnValue = normalizeToArray(returnValue);
</code></td></tr><tr><td id="L1928" class="css-a4x74f"><span>1928</span></td><td id="LC1928" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1929" class="css-a4x74f"><span>1929</span></td><td id="LC1929" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onTrigger</span>(<span class="code-params">event</span>) </span>{
</code></td></tr><tr><td id="L1930" class="css-a4x74f"><span>1930</span></td><td id="LC1930" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (!event.target || disabled) {
</code></td></tr><tr><td id="L1931" class="css-a4x74f"><span>1931</span></td><td id="LC1931" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1932" class="css-a4x74f"><span>1932</span></td><td id="LC1932" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1933" class="css-a4x74f"><span>1933</span></td><td id="LC1933" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1934" class="css-a4x74f"><span>1934</span></td><td id="LC1934" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> targetNode = event.target.closest(target);
</code></td></tr><tr><td id="L1935" class="css-a4x74f"><span>1935</span></td><td id="LC1935" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1936" class="css-a4x74f"><span>1936</span></td><td id="LC1936" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (!targetNode) {
</code></td></tr><tr><td id="L1937" class="css-a4x74f"><span>1937</span></td><td id="LC1937" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1938" class="css-a4x74f"><span>1938</span></td><td id="LC1938" class="css-1dcdqdg"><code>      } <span class="code-comment">// Get relevant trigger with fallbacks:</span>
</code></td></tr><tr><td id="L1939" class="css-a4x74f"><span>1939</span></td><td id="LC1939" class="css-1dcdqdg"><code>      <span class="code-comment">// 1. Check `data-tippy-trigger` attribute on target node</span>
</code></td></tr><tr><td id="L1940" class="css-a4x74f"><span>1940</span></td><td id="LC1940" class="css-1dcdqdg"><code>      <span class="code-comment">// 2. Fallback to `trigger` passed to `delegate()`</span>
</code></td></tr><tr><td id="L1941" class="css-a4x74f"><span>1941</span></td><td id="LC1941" class="css-1dcdqdg"><code>      <span class="code-comment">// 3. Fallback to `defaultProps.trigger`</span>
</code></td></tr><tr><td id="L1942" class="css-a4x74f"><span>1942</span></td><td id="LC1942" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1943" class="css-a4x74f"><span>1943</span></td><td id="LC1943" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1944" class="css-a4x74f"><span>1944</span></td><td id="LC1944" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> trigger = targetNode.getAttribute(<span class="code-string">'data-tippy-trigger'</span>) || props.trigger || defaultProps.trigger; <span class="code-comment">// @ts-ignore</span>
</code></td></tr><tr><td id="L1945" class="css-a4x74f"><span>1945</span></td><td id="LC1945" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1946" class="css-a4x74f"><span>1946</span></td><td id="LC1946" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (targetNode._tippy) {
</code></td></tr><tr><td id="L1947" class="css-a4x74f"><span>1947</span></td><td id="LC1947" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1948" class="css-a4x74f"><span>1948</span></td><td id="LC1948" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1949" class="css-a4x74f"><span>1949</span></td><td id="LC1949" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1950" class="css-a4x74f"><span>1950</span></td><td id="LC1950" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (event.type === <span class="code-string">'touchstart'</span> &amp;&amp; <span class="code-keyword">typeof</span> childProps.touch === <span class="code-string">'boolean'</span>) {
</code></td></tr><tr><td id="L1951" class="css-a4x74f"><span>1951</span></td><td id="LC1951" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1952" class="css-a4x74f"><span>1952</span></td><td id="LC1952" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1953" class="css-a4x74f"><span>1953</span></td><td id="LC1953" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1954" class="css-a4x74f"><span>1954</span></td><td id="LC1954" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (event.type !== <span class="code-string">'touchstart'</span> &amp;&amp; trigger.indexOf(BUBBLING_EVENTS_MAP[event.type]) &lt; <span class="code-number">0</span>) {
</code></td></tr><tr><td id="L1955" class="css-a4x74f"><span>1955</span></td><td id="LC1955" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L1956" class="css-a4x74f"><span>1956</span></td><td id="LC1956" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1957" class="css-a4x74f"><span>1957</span></td><td id="LC1957" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1958" class="css-a4x74f"><span>1958</span></td><td id="LC1958" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> instance = tippy(targetNode, childProps);
</code></td></tr><tr><td id="L1959" class="css-a4x74f"><span>1959</span></td><td id="LC1959" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1960" class="css-a4x74f"><span>1960</span></td><td id="LC1960" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (instance) {
</code></td></tr><tr><td id="L1961" class="css-a4x74f"><span>1961</span></td><td id="LC1961" class="css-1dcdqdg"><code>        childTippyInstances = childTippyInstances.concat(instance);
</code></td></tr><tr><td id="L1962" class="css-a4x74f"><span>1962</span></td><td id="LC1962" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1963" class="css-a4x74f"><span>1963</span></td><td id="LC1963" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1964" class="css-a4x74f"><span>1964</span></td><td id="LC1964" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1965" class="css-a4x74f"><span>1965</span></td><td id="LC1965" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">on</span>(<span class="code-params">node, eventType, handler, options</span>) </span>{
</code></td></tr><tr><td id="L1966" class="css-a4x74f"><span>1966</span></td><td id="LC1966" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (options === <span class="code-keyword">void</span> <span class="code-number">0</span>) {
</code></td></tr><tr><td id="L1967" class="css-a4x74f"><span>1967</span></td><td id="LC1967" class="css-1dcdqdg"><code>        options = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L1968" class="css-a4x74f"><span>1968</span></td><td id="LC1968" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L1969" class="css-a4x74f"><span>1969</span></td><td id="LC1969" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1970" class="css-a4x74f"><span>1970</span></td><td id="LC1970" class="css-1dcdqdg"><code>      node.addEventListener(eventType, handler, options);
</code></td></tr><tr><td id="L1971" class="css-a4x74f"><span>1971</span></td><td id="LC1971" class="css-1dcdqdg"><code>      listeners.push({
</code></td></tr><tr><td id="L1972" class="css-a4x74f"><span>1972</span></td><td id="LC1972" class="css-1dcdqdg"><code>        node: node,
</code></td></tr><tr><td id="L1973" class="css-a4x74f"><span>1973</span></td><td id="LC1973" class="css-1dcdqdg"><code>        eventType: eventType,
</code></td></tr><tr><td id="L1974" class="css-a4x74f"><span>1974</span></td><td id="LC1974" class="css-1dcdqdg"><code>        handler: handler,
</code></td></tr><tr><td id="L1975" class="css-a4x74f"><span>1975</span></td><td id="LC1975" class="css-1dcdqdg"><code>        options: options
</code></td></tr><tr><td id="L1976" class="css-a4x74f"><span>1976</span></td><td id="LC1976" class="css-1dcdqdg"><code>      });
</code></td></tr><tr><td id="L1977" class="css-a4x74f"><span>1977</span></td><td id="LC1977" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1978" class="css-a4x74f"><span>1978</span></td><td id="LC1978" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1979" class="css-a4x74f"><span>1979</span></td><td id="LC1979" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">addEventListeners</span>(<span class="code-params">instance</span>) </span>{
</code></td></tr><tr><td id="L1980" class="css-a4x74f"><span>1980</span></td><td id="LC1980" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> reference = instance.reference;
</code></td></tr><tr><td id="L1981" class="css-a4x74f"><span>1981</span></td><td id="LC1981" class="css-1dcdqdg"><code>      on(reference, <span class="code-string">'touchstart'</span>, onTrigger, TOUCH_OPTIONS);
</code></td></tr><tr><td id="L1982" class="css-a4x74f"><span>1982</span></td><td id="LC1982" class="css-1dcdqdg"><code>      on(reference, <span class="code-string">'mouseover'</span>, onTrigger);
</code></td></tr><tr><td id="L1983" class="css-a4x74f"><span>1983</span></td><td id="LC1983" class="css-1dcdqdg"><code>      on(reference, <span class="code-string">'focusin'</span>, onTrigger);
</code></td></tr><tr><td id="L1984" class="css-a4x74f"><span>1984</span></td><td id="LC1984" class="css-1dcdqdg"><code>      on(reference, <span class="code-string">'click'</span>, onTrigger);
</code></td></tr><tr><td id="L1985" class="css-a4x74f"><span>1985</span></td><td id="LC1985" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1986" class="css-a4x74f"><span>1986</span></td><td id="LC1986" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1987" class="css-a4x74f"><span>1987</span></td><td id="LC1987" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">removeEventListeners</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L1988" class="css-a4x74f"><span>1988</span></td><td id="LC1988" class="css-1dcdqdg"><code>      listeners.forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">_ref</span>) </span>{
</code></td></tr><tr><td id="L1989" class="css-a4x74f"><span>1989</span></td><td id="LC1989" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> node = _ref.node,
</code></td></tr><tr><td id="L1990" class="css-a4x74f"><span>1990</span></td><td id="LC1990" class="css-1dcdqdg"><code>            eventType = _ref.eventType,
</code></td></tr><tr><td id="L1991" class="css-a4x74f"><span>1991</span></td><td id="LC1991" class="css-1dcdqdg"><code>            handler = _ref.handler,
</code></td></tr><tr><td id="L1992" class="css-a4x74f"><span>1992</span></td><td id="LC1992" class="css-1dcdqdg"><code>            options = _ref.options;
</code></td></tr><tr><td id="L1993" class="css-a4x74f"><span>1993</span></td><td id="LC1993" class="css-1dcdqdg"><code>        node.removeEventListener(eventType, handler, options);
</code></td></tr><tr><td id="L1994" class="css-a4x74f"><span>1994</span></td><td id="LC1994" class="css-1dcdqdg"><code>      });
</code></td></tr><tr><td id="L1995" class="css-a4x74f"><span>1995</span></td><td id="LC1995" class="css-1dcdqdg"><code>      listeners = [];
</code></td></tr><tr><td id="L1996" class="css-a4x74f"><span>1996</span></td><td id="LC1996" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L1997" class="css-a4x74f"><span>1997</span></td><td id="LC1997" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L1998" class="css-a4x74f"><span>1998</span></td><td id="LC1998" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">applyMutations</span>(<span class="code-params">instance</span>) </span>{
</code></td></tr><tr><td id="L1999" class="css-a4x74f"><span>1999</span></td><td id="LC1999" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> originalDestroy = instance.destroy;
</code></td></tr><tr><td id="L2000" class="css-a4x74f"><span>2000</span></td><td id="LC2000" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> originalEnable = instance.enable;
</code></td></tr><tr><td id="L2001" class="css-a4x74f"><span>2001</span></td><td id="LC2001" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> originalDisable = instance.disable;
</code></td></tr><tr><td id="L2002" class="css-a4x74f"><span>2002</span></td><td id="LC2002" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2003" class="css-a4x74f"><span>2003</span></td><td id="LC2003" class="css-1dcdqdg"><code>      instance.destroy = <span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">shouldDestroyChildInstances</span>) </span>{
</code></td></tr><tr><td id="L2004" class="css-a4x74f"><span>2004</span></td><td id="LC2004" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (shouldDestroyChildInstances === <span class="code-keyword">void</span> <span class="code-number">0</span>) {
</code></td></tr><tr><td id="L2005" class="css-a4x74f"><span>2005</span></td><td id="LC2005" class="css-1dcdqdg"><code>          shouldDestroyChildInstances = <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L2006" class="css-a4x74f"><span>2006</span></td><td id="LC2006" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L2007" class="css-a4x74f"><span>2007</span></td><td id="LC2007" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2008" class="css-a4x74f"><span>2008</span></td><td id="LC2008" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (shouldDestroyChildInstances) {
</code></td></tr><tr><td id="L2009" class="css-a4x74f"><span>2009</span></td><td id="LC2009" class="css-1dcdqdg"><code>          childTippyInstances.forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">instance</span>) </span>{
</code></td></tr><tr><td id="L2010" class="css-a4x74f"><span>2010</span></td><td id="LC2010" class="css-1dcdqdg"><code>            instance.destroy();
</code></td></tr><tr><td id="L2011" class="css-a4x74f"><span>2011</span></td><td id="LC2011" class="css-1dcdqdg"><code>          });
</code></td></tr><tr><td id="L2012" class="css-a4x74f"><span>2012</span></td><td id="LC2012" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L2013" class="css-a4x74f"><span>2013</span></td><td id="LC2013" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2014" class="css-a4x74f"><span>2014</span></td><td id="LC2014" class="css-1dcdqdg"><code>        childTippyInstances = [];
</code></td></tr><tr><td id="L2015" class="css-a4x74f"><span>2015</span></td><td id="LC2015" class="css-1dcdqdg"><code>        removeEventListeners();
</code></td></tr><tr><td id="L2016" class="css-a4x74f"><span>2016</span></td><td id="LC2016" class="css-1dcdqdg"><code>        originalDestroy();
</code></td></tr><tr><td id="L2017" class="css-a4x74f"><span>2017</span></td><td id="LC2017" class="css-1dcdqdg"><code>      };
</code></td></tr><tr><td id="L2018" class="css-a4x74f"><span>2018</span></td><td id="LC2018" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2019" class="css-a4x74f"><span>2019</span></td><td id="LC2019" class="css-1dcdqdg"><code>      instance.enable = <span class="code-function"><span class="code-keyword">function</span> (<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2020" class="css-a4x74f"><span>2020</span></td><td id="LC2020" class="css-1dcdqdg"><code>        originalEnable();
</code></td></tr><tr><td id="L2021" class="css-a4x74f"><span>2021</span></td><td id="LC2021" class="css-1dcdqdg"><code>        childTippyInstances.forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">instance</span>) </span>{
</code></td></tr><tr><td id="L2022" class="css-a4x74f"><span>2022</span></td><td id="LC2022" class="css-1dcdqdg"><code>          <span class="code-keyword">return</span> instance.enable();
</code></td></tr><tr><td id="L2023" class="css-a4x74f"><span>2023</span></td><td id="LC2023" class="css-1dcdqdg"><code>        });
</code></td></tr><tr><td id="L2024" class="css-a4x74f"><span>2024</span></td><td id="LC2024" class="css-1dcdqdg"><code>        disabled = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L2025" class="css-a4x74f"><span>2025</span></td><td id="LC2025" class="css-1dcdqdg"><code>      };
</code></td></tr><tr><td id="L2026" class="css-a4x74f"><span>2026</span></td><td id="LC2026" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2027" class="css-a4x74f"><span>2027</span></td><td id="LC2027" class="css-1dcdqdg"><code>      instance.disable = <span class="code-function"><span class="code-keyword">function</span> (<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2028" class="css-a4x74f"><span>2028</span></td><td id="LC2028" class="css-1dcdqdg"><code>        originalDisable();
</code></td></tr><tr><td id="L2029" class="css-a4x74f"><span>2029</span></td><td id="LC2029" class="css-1dcdqdg"><code>        childTippyInstances.forEach(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">instance</span>) </span>{
</code></td></tr><tr><td id="L2030" class="css-a4x74f"><span>2030</span></td><td id="LC2030" class="css-1dcdqdg"><code>          <span class="code-keyword">return</span> instance.disable();
</code></td></tr><tr><td id="L2031" class="css-a4x74f"><span>2031</span></td><td id="LC2031" class="css-1dcdqdg"><code>        });
</code></td></tr><tr><td id="L2032" class="css-a4x74f"><span>2032</span></td><td id="LC2032" class="css-1dcdqdg"><code>        disabled = <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L2033" class="css-a4x74f"><span>2033</span></td><td id="LC2033" class="css-1dcdqdg"><code>      };
</code></td></tr><tr><td id="L2034" class="css-a4x74f"><span>2034</span></td><td id="LC2034" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2035" class="css-a4x74f"><span>2035</span></td><td id="LC2035" class="css-1dcdqdg"><code>      addEventListeners(instance);
</code></td></tr><tr><td id="L2036" class="css-a4x74f"><span>2036</span></td><td id="LC2036" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L2037" class="css-a4x74f"><span>2037</span></td><td id="LC2037" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2038" class="css-a4x74f"><span>2038</span></td><td id="LC2038" class="css-1dcdqdg"><code>    normalizedReturnValue.forEach(applyMutations);
</code></td></tr><tr><td id="L2039" class="css-a4x74f"><span>2039</span></td><td id="LC2039" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> returnValue;
</code></td></tr><tr><td id="L2040" class="css-a4x74f"><span>2040</span></td><td id="LC2040" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L2041" class="css-a4x74f"><span>2041</span></td><td id="LC2041" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2042" class="css-a4x74f"><span>2042</span></td><td id="LC2042" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> animateFill = {
</code></td></tr><tr><td id="L2043" class="css-a4x74f"><span>2043</span></td><td id="LC2043" class="css-1dcdqdg"><code>    name: <span class="code-string">'animateFill'</span>,
</code></td></tr><tr><td id="L2044" class="css-a4x74f"><span>2044</span></td><td id="LC2044" class="css-1dcdqdg"><code>    defaultValue: <span class="code-literal">false</span>,
</code></td></tr><tr><td id="L2045" class="css-a4x74f"><span>2045</span></td><td id="LC2045" class="css-1dcdqdg"><code>    fn: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">fn</span>(<span class="code-params">instance</span>) </span>{
</code></td></tr><tr><td id="L2046" class="css-a4x74f"><span>2046</span></td><td id="LC2046" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> _instance$props$rende;
</code></td></tr><tr><td id="L2047" class="css-a4x74f"><span>2047</span></td><td id="LC2047" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2048" class="css-a4x74f"><span>2048</span></td><td id="LC2048" class="css-1dcdqdg"><code>      <span class="code-comment">// @ts-ignore</span>
</code></td></tr><tr><td id="L2049" class="css-a4x74f"><span>2049</span></td><td id="LC2049" class="css-1dcdqdg"><code>      <span class="code-keyword">if</span> (!((_instance$props$rende = instance.props.render) != <span class="code-literal">null</span> &amp;&amp; _instance$props$rende.$$tippy)) {
</code></td></tr><tr><td id="L2050" class="css-a4x74f"><span>2050</span></td><td id="LC2050" class="css-1dcdqdg"><code>        {
</code></td></tr><tr><td id="L2051" class="css-a4x74f"><span>2051</span></td><td id="LC2051" class="css-1dcdqdg"><code>          errorWhen(instance.props.animateFill, <span class="code-string">'The `animateFill` plugin requires the default render function.'</span>);
</code></td></tr><tr><td id="L2052" class="css-a4x74f"><span>2052</span></td><td id="LC2052" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L2053" class="css-a4x74f"><span>2053</span></td><td id="LC2053" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2054" class="css-a4x74f"><span>2054</span></td><td id="LC2054" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> {};
</code></td></tr><tr><td id="L2055" class="css-a4x74f"><span>2055</span></td><td id="LC2055" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L2056" class="css-a4x74f"><span>2056</span></td><td id="LC2056" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2057" class="css-a4x74f"><span>2057</span></td><td id="LC2057" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> _getChildren = getChildren(instance.popper),
</code></td></tr><tr><td id="L2058" class="css-a4x74f"><span>2058</span></td><td id="LC2058" class="css-1dcdqdg"><code>          box = _getChildren.box,
</code></td></tr><tr><td id="L2059" class="css-a4x74f"><span>2059</span></td><td id="LC2059" class="css-1dcdqdg"><code>          content = _getChildren.content;
</code></td></tr><tr><td id="L2060" class="css-a4x74f"><span>2060</span></td><td id="LC2060" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2061" class="css-a4x74f"><span>2061</span></td><td id="LC2061" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> backdrop = instance.props.animateFill ? createBackdropElement() : <span class="code-literal">null</span>;
</code></td></tr><tr><td id="L2062" class="css-a4x74f"><span>2062</span></td><td id="LC2062" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> {
</code></td></tr><tr><td id="L2063" class="css-a4x74f"><span>2063</span></td><td id="LC2063" class="css-1dcdqdg"><code>        onCreate: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onCreate</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2064" class="css-a4x74f"><span>2064</span></td><td id="LC2064" class="css-1dcdqdg"><code>          <span class="code-keyword">if</span> (backdrop) {
</code></td></tr><tr><td id="L2065" class="css-a4x74f"><span>2065</span></td><td id="LC2065" class="css-1dcdqdg"><code>            box.insertBefore(backdrop, box.firstElementChild);
</code></td></tr><tr><td id="L2066" class="css-a4x74f"><span>2066</span></td><td id="LC2066" class="css-1dcdqdg"><code>            box.setAttribute(<span class="code-string">'data-animatefill'</span>, <span class="code-string">''</span>);
</code></td></tr><tr><td id="L2067" class="css-a4x74f"><span>2067</span></td><td id="LC2067" class="css-1dcdqdg"><code>            box.style.overflow = <span class="code-string">'hidden'</span>;
</code></td></tr><tr><td id="L2068" class="css-a4x74f"><span>2068</span></td><td id="LC2068" class="css-1dcdqdg"><code>            instance.setProps({
</code></td></tr><tr><td id="L2069" class="css-a4x74f"><span>2069</span></td><td id="LC2069" class="css-1dcdqdg"><code>              arrow: <span class="code-literal">false</span>,
</code></td></tr><tr><td id="L2070" class="css-a4x74f"><span>2070</span></td><td id="LC2070" class="css-1dcdqdg"><code>              animation: <span class="code-string">'shift-away'</span>
</code></td></tr><tr><td id="L2071" class="css-a4x74f"><span>2071</span></td><td id="LC2071" class="css-1dcdqdg"><code>            });
</code></td></tr><tr><td id="L2072" class="css-a4x74f"><span>2072</span></td><td id="LC2072" class="css-1dcdqdg"><code>          }
</code></td></tr><tr><td id="L2073" class="css-a4x74f"><span>2073</span></td><td id="LC2073" class="css-1dcdqdg"><code>        },
</code></td></tr><tr><td id="L2074" class="css-a4x74f"><span>2074</span></td><td id="LC2074" class="css-1dcdqdg"><code>        onMount: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onMount</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2075" class="css-a4x74f"><span>2075</span></td><td id="LC2075" class="css-1dcdqdg"><code>          <span class="code-keyword">if</span> (backdrop) {
</code></td></tr><tr><td id="L2076" class="css-a4x74f"><span>2076</span></td><td id="LC2076" class="css-1dcdqdg"><code>            <span class="code-keyword">var</span> transitionDuration = box.style.transitionDuration;
</code></td></tr><tr><td id="L2077" class="css-a4x74f"><span>2077</span></td><td id="LC2077" class="css-1dcdqdg"><code>            <span class="code-keyword">var</span> duration = <span class="code-built_in">Number</span>(transitionDuration.replace(<span class="code-string">'ms'</span>, <span class="code-string">''</span>)); <span class="code-comment">// The content should fade in after the backdrop has mostly filled the</span>
</code></td></tr><tr><td id="L2078" class="css-a4x74f"><span>2078</span></td><td id="LC2078" class="css-1dcdqdg"><code>            <span class="code-comment">// tooltip element. `clip-path` is the other alternative but is not</span>
</code></td></tr><tr><td id="L2079" class="css-a4x74f"><span>2079</span></td><td id="LC2079" class="css-1dcdqdg"><code>            <span class="code-comment">// well-supported and is buggy on some devices.</span>
</code></td></tr><tr><td id="L2080" class="css-a4x74f"><span>2080</span></td><td id="LC2080" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2081" class="css-a4x74f"><span>2081</span></td><td id="LC2081" class="css-1dcdqdg"><code>            content.style.transitionDelay = <span class="code-built_in">Math</span>.round(duration / <span class="code-number">10</span>) + <span class="code-string">"ms"</span>;
</code></td></tr><tr><td id="L2082" class="css-a4x74f"><span>2082</span></td><td id="LC2082" class="css-1dcdqdg"><code>            backdrop.style.transitionDuration = transitionDuration;
</code></td></tr><tr><td id="L2083" class="css-a4x74f"><span>2083</span></td><td id="LC2083" class="css-1dcdqdg"><code>            setVisibilityState([backdrop], <span class="code-string">'visible'</span>);
</code></td></tr><tr><td id="L2084" class="css-a4x74f"><span>2084</span></td><td id="LC2084" class="css-1dcdqdg"><code>          }
</code></td></tr><tr><td id="L2085" class="css-a4x74f"><span>2085</span></td><td id="LC2085" class="css-1dcdqdg"><code>        },
</code></td></tr><tr><td id="L2086" class="css-a4x74f"><span>2086</span></td><td id="LC2086" class="css-1dcdqdg"><code>        onShow: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onShow</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2087" class="css-a4x74f"><span>2087</span></td><td id="LC2087" class="css-1dcdqdg"><code>          <span class="code-keyword">if</span> (backdrop) {
</code></td></tr><tr><td id="L2088" class="css-a4x74f"><span>2088</span></td><td id="LC2088" class="css-1dcdqdg"><code>            backdrop.style.transitionDuration = <span class="code-string">'0ms'</span>;
</code></td></tr><tr><td id="L2089" class="css-a4x74f"><span>2089</span></td><td id="LC2089" class="css-1dcdqdg"><code>          }
</code></td></tr><tr><td id="L2090" class="css-a4x74f"><span>2090</span></td><td id="LC2090" class="css-1dcdqdg"><code>        },
</code></td></tr><tr><td id="L2091" class="css-a4x74f"><span>2091</span></td><td id="LC2091" class="css-1dcdqdg"><code>        onHide: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onHide</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2092" class="css-a4x74f"><span>2092</span></td><td id="LC2092" class="css-1dcdqdg"><code>          <span class="code-keyword">if</span> (backdrop) {
</code></td></tr><tr><td id="L2093" class="css-a4x74f"><span>2093</span></td><td id="LC2093" class="css-1dcdqdg"><code>            setVisibilityState([backdrop], <span class="code-string">'hidden'</span>);
</code></td></tr><tr><td id="L2094" class="css-a4x74f"><span>2094</span></td><td id="LC2094" class="css-1dcdqdg"><code>          }
</code></td></tr><tr><td id="L2095" class="css-a4x74f"><span>2095</span></td><td id="LC2095" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L2096" class="css-a4x74f"><span>2096</span></td><td id="LC2096" class="css-1dcdqdg"><code>      };
</code></td></tr><tr><td id="L2097" class="css-a4x74f"><span>2097</span></td><td id="LC2097" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L2098" class="css-a4x74f"><span>2098</span></td><td id="LC2098" class="css-1dcdqdg"><code>  };
</code></td></tr><tr><td id="L2099" class="css-a4x74f"><span>2099</span></td><td id="LC2099" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2100" class="css-a4x74f"><span>2100</span></td><td id="LC2100" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">createBackdropElement</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2101" class="css-a4x74f"><span>2101</span></td><td id="LC2101" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> backdrop = div();
</code></td></tr><tr><td id="L2102" class="css-a4x74f"><span>2102</span></td><td id="LC2102" class="css-1dcdqdg"><code>    backdrop.className = BACKDROP_CLASS;
</code></td></tr><tr><td id="L2103" class="css-a4x74f"><span>2103</span></td><td id="LC2103" class="css-1dcdqdg"><code>    setVisibilityState([backdrop], <span class="code-string">'hidden'</span>);
</code></td></tr><tr><td id="L2104" class="css-a4x74f"><span>2104</span></td><td id="LC2104" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> backdrop;
</code></td></tr><tr><td id="L2105" class="css-a4x74f"><span>2105</span></td><td id="LC2105" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L2106" class="css-a4x74f"><span>2106</span></td><td id="LC2106" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2107" class="css-a4x74f"><span>2107</span></td><td id="LC2107" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> mouseCoords = {
</code></td></tr><tr><td id="L2108" class="css-a4x74f"><span>2108</span></td><td id="LC2108" class="css-1dcdqdg"><code>    clientX: <span class="code-number">0</span>,
</code></td></tr><tr><td id="L2109" class="css-a4x74f"><span>2109</span></td><td id="LC2109" class="css-1dcdqdg"><code>    clientY: <span class="code-number">0</span>
</code></td></tr><tr><td id="L2110" class="css-a4x74f"><span>2110</span></td><td id="LC2110" class="css-1dcdqdg"><code>  };
</code></td></tr><tr><td id="L2111" class="css-a4x74f"><span>2111</span></td><td id="LC2111" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> activeInstances = [];
</code></td></tr><tr><td id="L2112" class="css-a4x74f"><span>2112</span></td><td id="LC2112" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2113" class="css-a4x74f"><span>2113</span></td><td id="LC2113" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">storeMouseCoords</span>(<span class="code-params">_ref</span>) </span>{
</code></td></tr><tr><td id="L2114" class="css-a4x74f"><span>2114</span></td><td id="LC2114" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> clientX = _ref.clientX,
</code></td></tr><tr><td id="L2115" class="css-a4x74f"><span>2115</span></td><td id="LC2115" class="css-1dcdqdg"><code>        clientY = _ref.clientY;
</code></td></tr><tr><td id="L2116" class="css-a4x74f"><span>2116</span></td><td id="LC2116" class="css-1dcdqdg"><code>    mouseCoords = {
</code></td></tr><tr><td id="L2117" class="css-a4x74f"><span>2117</span></td><td id="LC2117" class="css-1dcdqdg"><code>      clientX: clientX,
</code></td></tr><tr><td id="L2118" class="css-a4x74f"><span>2118</span></td><td id="LC2118" class="css-1dcdqdg"><code>      clientY: clientY
</code></td></tr><tr><td id="L2119" class="css-a4x74f"><span>2119</span></td><td id="LC2119" class="css-1dcdqdg"><code>    };
</code></td></tr><tr><td id="L2120" class="css-a4x74f"><span>2120</span></td><td id="LC2120" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L2121" class="css-a4x74f"><span>2121</span></td><td id="LC2121" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2122" class="css-a4x74f"><span>2122</span></td><td id="LC2122" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">addMouseCoordsListener</span>(<span class="code-params">doc</span>) </span>{
</code></td></tr><tr><td id="L2123" class="css-a4x74f"><span>2123</span></td><td id="LC2123" class="css-1dcdqdg"><code>    doc.addEventListener(<span class="code-string">'mousemove'</span>, storeMouseCoords);
</code></td></tr><tr><td id="L2124" class="css-a4x74f"><span>2124</span></td><td id="LC2124" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L2125" class="css-a4x74f"><span>2125</span></td><td id="LC2125" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2126" class="css-a4x74f"><span>2126</span></td><td id="LC2126" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">removeMouseCoordsListener</span>(<span class="code-params">doc</span>) </span>{
</code></td></tr><tr><td id="L2127" class="css-a4x74f"><span>2127</span></td><td id="LC2127" class="css-1dcdqdg"><code>    doc.removeEventListener(<span class="code-string">'mousemove'</span>, storeMouseCoords);
</code></td></tr><tr><td id="L2128" class="css-a4x74f"><span>2128</span></td><td id="LC2128" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L2129" class="css-a4x74f"><span>2129</span></td><td id="LC2129" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2130" class="css-a4x74f"><span>2130</span></td><td id="LC2130" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> followCursor = {
</code></td></tr><tr><td id="L2131" class="css-a4x74f"><span>2131</span></td><td id="LC2131" class="css-1dcdqdg"><code>    name: <span class="code-string">'followCursor'</span>,
</code></td></tr><tr><td id="L2132" class="css-a4x74f"><span>2132</span></td><td id="LC2132" class="css-1dcdqdg"><code>    defaultValue: <span class="code-literal">false</span>,
</code></td></tr><tr><td id="L2133" class="css-a4x74f"><span>2133</span></td><td id="LC2133" class="css-1dcdqdg"><code>    fn: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">fn</span>(<span class="code-params">instance</span>) </span>{
</code></td></tr><tr><td id="L2134" class="css-a4x74f"><span>2134</span></td><td id="LC2134" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> reference = instance.reference;
</code></td></tr><tr><td id="L2135" class="css-a4x74f"><span>2135</span></td><td id="LC2135" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> doc = getOwnerDocument(instance.props.triggerTarget || reference);
</code></td></tr><tr><td id="L2136" class="css-a4x74f"><span>2136</span></td><td id="LC2136" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> isInternalUpdate = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L2137" class="css-a4x74f"><span>2137</span></td><td id="LC2137" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> wasFocusEvent = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L2138" class="css-a4x74f"><span>2138</span></td><td id="LC2138" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> isUnmounted = <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L2139" class="css-a4x74f"><span>2139</span></td><td id="LC2139" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> prevProps = instance.props;
</code></td></tr><tr><td id="L2140" class="css-a4x74f"><span>2140</span></td><td id="LC2140" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2141" class="css-a4x74f"><span>2141</span></td><td id="LC2141" class="css-1dcdqdg"><code>      <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getIsInitialBehavior</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2142" class="css-a4x74f"><span>2142</span></td><td id="LC2142" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> instance.props.followCursor === <span class="code-string">'initial'</span> &amp;&amp; instance.state.isVisible;
</code></td></tr><tr><td id="L2143" class="css-a4x74f"><span>2143</span></td><td id="LC2143" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L2144" class="css-a4x74f"><span>2144</span></td><td id="LC2144" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2145" class="css-a4x74f"><span>2145</span></td><td id="LC2145" class="css-1dcdqdg"><code>      <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">addListener</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2146" class="css-a4x74f"><span>2146</span></td><td id="LC2146" class="css-1dcdqdg"><code>        doc.addEventListener(<span class="code-string">'mousemove'</span>, onMouseMove);
</code></td></tr><tr><td id="L2147" class="css-a4x74f"><span>2147</span></td><td id="LC2147" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L2148" class="css-a4x74f"><span>2148</span></td><td id="LC2148" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2149" class="css-a4x74f"><span>2149</span></td><td id="LC2149" class="css-1dcdqdg"><code>      <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">removeListener</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2150" class="css-a4x74f"><span>2150</span></td><td id="LC2150" class="css-1dcdqdg"><code>        doc.removeEventListener(<span class="code-string">'mousemove'</span>, onMouseMove);
</code></td></tr><tr><td id="L2151" class="css-a4x74f"><span>2151</span></td><td id="LC2151" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L2152" class="css-a4x74f"><span>2152</span></td><td id="LC2152" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2153" class="css-a4x74f"><span>2153</span></td><td id="LC2153" class="css-1dcdqdg"><code>      <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">unsetGetReferenceClientRect</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2154" class="css-a4x74f"><span>2154</span></td><td id="LC2154" class="css-1dcdqdg"><code>        isInternalUpdate = <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L2155" class="css-a4x74f"><span>2155</span></td><td id="LC2155" class="css-1dcdqdg"><code>        instance.setProps({
</code></td></tr><tr><td id="L2156" class="css-a4x74f"><span>2156</span></td><td id="LC2156" class="css-1dcdqdg"><code>          getReferenceClientRect: <span class="code-literal">null</span>
</code></td></tr><tr><td id="L2157" class="css-a4x74f"><span>2157</span></td><td id="LC2157" class="css-1dcdqdg"><code>        });
</code></td></tr><tr><td id="L2158" class="css-a4x74f"><span>2158</span></td><td id="LC2158" class="css-1dcdqdg"><code>        isInternalUpdate = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L2159" class="css-a4x74f"><span>2159</span></td><td id="LC2159" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L2160" class="css-a4x74f"><span>2160</span></td><td id="LC2160" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2161" class="css-a4x74f"><span>2161</span></td><td id="LC2161" class="css-1dcdqdg"><code>      <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onMouseMove</span>(<span class="code-params">event</span>) </span>{
</code></td></tr><tr><td id="L2162" class="css-a4x74f"><span>2162</span></td><td id="LC2162" class="css-1dcdqdg"><code>        <span class="code-comment">// If the instance is interactive, avoid updating the position unless it's</span>
</code></td></tr><tr><td id="L2163" class="css-a4x74f"><span>2163</span></td><td id="LC2163" class="css-1dcdqdg"><code>        <span class="code-comment">// over the reference element</span>
</code></td></tr><tr><td id="L2164" class="css-a4x74f"><span>2164</span></td><td id="LC2164" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> isCursorOverReference = event.target ? reference.contains(event.target) : <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L2165" class="css-a4x74f"><span>2165</span></td><td id="LC2165" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> followCursor = instance.props.followCursor;
</code></td></tr><tr><td id="L2166" class="css-a4x74f"><span>2166</span></td><td id="LC2166" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> clientX = event.clientX,
</code></td></tr><tr><td id="L2167" class="css-a4x74f"><span>2167</span></td><td id="LC2167" class="css-1dcdqdg"><code>            clientY = event.clientY;
</code></td></tr><tr><td id="L2168" class="css-a4x74f"><span>2168</span></td><td id="LC2168" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> rect = reference.getBoundingClientRect();
</code></td></tr><tr><td id="L2169" class="css-a4x74f"><span>2169</span></td><td id="LC2169" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> relativeX = clientX - rect.left;
</code></td></tr><tr><td id="L2170" class="css-a4x74f"><span>2170</span></td><td id="LC2170" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> relativeY = clientY - rect.top;
</code></td></tr><tr><td id="L2171" class="css-a4x74f"><span>2171</span></td><td id="LC2171" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2172" class="css-a4x74f"><span>2172</span></td><td id="LC2172" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (isCursorOverReference || !instance.props.interactive) {
</code></td></tr><tr><td id="L2173" class="css-a4x74f"><span>2173</span></td><td id="LC2173" class="css-1dcdqdg"><code>          instance.setProps({
</code></td></tr><tr><td id="L2174" class="css-a4x74f"><span>2174</span></td><td id="LC2174" class="css-1dcdqdg"><code>            <span class="code-comment">// @ts-ignore - unneeded DOMRect properties</span>
</code></td></tr><tr><td id="L2175" class="css-a4x74f"><span>2175</span></td><td id="LC2175" class="css-1dcdqdg"><code>            getReferenceClientRect: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getReferenceClientRect</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2176" class="css-a4x74f"><span>2176</span></td><td id="LC2176" class="css-1dcdqdg"><code>              <span class="code-keyword">var</span> rect = reference.getBoundingClientRect();
</code></td></tr><tr><td id="L2177" class="css-a4x74f"><span>2177</span></td><td id="LC2177" class="css-1dcdqdg"><code>              <span class="code-keyword">var</span> x = clientX;
</code></td></tr><tr><td id="L2178" class="css-a4x74f"><span>2178</span></td><td id="LC2178" class="css-1dcdqdg"><code>              <span class="code-keyword">var</span> y = clientY;
</code></td></tr><tr><td id="L2179" class="css-a4x74f"><span>2179</span></td><td id="LC2179" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2180" class="css-a4x74f"><span>2180</span></td><td id="LC2180" class="css-1dcdqdg"><code>              <span class="code-keyword">if</span> (followCursor === <span class="code-string">'initial'</span>) {
</code></td></tr><tr><td id="L2181" class="css-a4x74f"><span>2181</span></td><td id="LC2181" class="css-1dcdqdg"><code>                x = rect.left + relativeX;
</code></td></tr><tr><td id="L2182" class="css-a4x74f"><span>2182</span></td><td id="LC2182" class="css-1dcdqdg"><code>                y = rect.top + relativeY;
</code></td></tr><tr><td id="L2183" class="css-a4x74f"><span>2183</span></td><td id="LC2183" class="css-1dcdqdg"><code>              }
</code></td></tr><tr><td id="L2184" class="css-a4x74f"><span>2184</span></td><td id="LC2184" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2185" class="css-a4x74f"><span>2185</span></td><td id="LC2185" class="css-1dcdqdg"><code>              <span class="code-keyword">var</span> top = followCursor === <span class="code-string">'horizontal'</span> ? rect.top : y;
</code></td></tr><tr><td id="L2186" class="css-a4x74f"><span>2186</span></td><td id="LC2186" class="css-1dcdqdg"><code>              <span class="code-keyword">var</span> right = followCursor === <span class="code-string">'vertical'</span> ? rect.right : x;
</code></td></tr><tr><td id="L2187" class="css-a4x74f"><span>2187</span></td><td id="LC2187" class="css-1dcdqdg"><code>              <span class="code-keyword">var</span> bottom = followCursor === <span class="code-string">'horizontal'</span> ? rect.bottom : y;
</code></td></tr><tr><td id="L2188" class="css-a4x74f"><span>2188</span></td><td id="LC2188" class="css-1dcdqdg"><code>              <span class="code-keyword">var</span> left = followCursor === <span class="code-string">'vertical'</span> ? rect.left : x;
</code></td></tr><tr><td id="L2189" class="css-a4x74f"><span>2189</span></td><td id="LC2189" class="css-1dcdqdg"><code>              <span class="code-keyword">return</span> {
</code></td></tr><tr><td id="L2190" class="css-a4x74f"><span>2190</span></td><td id="LC2190" class="css-1dcdqdg"><code>                width: right - left,
</code></td></tr><tr><td id="L2191" class="css-a4x74f"><span>2191</span></td><td id="LC2191" class="css-1dcdqdg"><code>                height: bottom - top,
</code></td></tr><tr><td id="L2192" class="css-a4x74f"><span>2192</span></td><td id="LC2192" class="css-1dcdqdg"><code>                top: top,
</code></td></tr><tr><td id="L2193" class="css-a4x74f"><span>2193</span></td><td id="LC2193" class="css-1dcdqdg"><code>                right: right,
</code></td></tr><tr><td id="L2194" class="css-a4x74f"><span>2194</span></td><td id="LC2194" class="css-1dcdqdg"><code>                bottom: bottom,
</code></td></tr><tr><td id="L2195" class="css-a4x74f"><span>2195</span></td><td id="LC2195" class="css-1dcdqdg"><code>                left: left
</code></td></tr><tr><td id="L2196" class="css-a4x74f"><span>2196</span></td><td id="LC2196" class="css-1dcdqdg"><code>              };
</code></td></tr><tr><td id="L2197" class="css-a4x74f"><span>2197</span></td><td id="LC2197" class="css-1dcdqdg"><code>            }
</code></td></tr><tr><td id="L2198" class="css-a4x74f"><span>2198</span></td><td id="LC2198" class="css-1dcdqdg"><code>          });
</code></td></tr><tr><td id="L2199" class="css-a4x74f"><span>2199</span></td><td id="LC2199" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L2200" class="css-a4x74f"><span>2200</span></td><td id="LC2200" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L2201" class="css-a4x74f"><span>2201</span></td><td id="LC2201" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2202" class="css-a4x74f"><span>2202</span></td><td id="LC2202" class="css-1dcdqdg"><code>      <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">create</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2203" class="css-a4x74f"><span>2203</span></td><td id="LC2203" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (instance.props.followCursor) {
</code></td></tr><tr><td id="L2204" class="css-a4x74f"><span>2204</span></td><td id="LC2204" class="css-1dcdqdg"><code>          activeInstances.push({
</code></td></tr><tr><td id="L2205" class="css-a4x74f"><span>2205</span></td><td id="LC2205" class="css-1dcdqdg"><code>            instance: instance,
</code></td></tr><tr><td id="L2206" class="css-a4x74f"><span>2206</span></td><td id="LC2206" class="css-1dcdqdg"><code>            doc: doc
</code></td></tr><tr><td id="L2207" class="css-a4x74f"><span>2207</span></td><td id="LC2207" class="css-1dcdqdg"><code>          });
</code></td></tr><tr><td id="L2208" class="css-a4x74f"><span>2208</span></td><td id="LC2208" class="css-1dcdqdg"><code>          addMouseCoordsListener(doc);
</code></td></tr><tr><td id="L2209" class="css-a4x74f"><span>2209</span></td><td id="LC2209" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L2210" class="css-a4x74f"><span>2210</span></td><td id="LC2210" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L2211" class="css-a4x74f"><span>2211</span></td><td id="LC2211" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2212" class="css-a4x74f"><span>2212</span></td><td id="LC2212" class="css-1dcdqdg"><code>      <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">destroy</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2213" class="css-a4x74f"><span>2213</span></td><td id="LC2213" class="css-1dcdqdg"><code>        activeInstances = activeInstances.filter(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">data</span>) </span>{
</code></td></tr><tr><td id="L2214" class="css-a4x74f"><span>2214</span></td><td id="LC2214" class="css-1dcdqdg"><code>          <span class="code-keyword">return</span> data.instance !== instance;
</code></td></tr><tr><td id="L2215" class="css-a4x74f"><span>2215</span></td><td id="LC2215" class="css-1dcdqdg"><code>        });
</code></td></tr><tr><td id="L2216" class="css-a4x74f"><span>2216</span></td><td id="LC2216" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2217" class="css-a4x74f"><span>2217</span></td><td id="LC2217" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (activeInstances.filter(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">data</span>) </span>{
</code></td></tr><tr><td id="L2218" class="css-a4x74f"><span>2218</span></td><td id="LC2218" class="css-1dcdqdg"><code>          <span class="code-keyword">return</span> data.doc === doc;
</code></td></tr><tr><td id="L2219" class="css-a4x74f"><span>2219</span></td><td id="LC2219" class="css-1dcdqdg"><code>        }).length === <span class="code-number">0</span>) {
</code></td></tr><tr><td id="L2220" class="css-a4x74f"><span>2220</span></td><td id="LC2220" class="css-1dcdqdg"><code>          removeMouseCoordsListener(doc);
</code></td></tr><tr><td id="L2221" class="css-a4x74f"><span>2221</span></td><td id="LC2221" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L2222" class="css-a4x74f"><span>2222</span></td><td id="LC2222" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L2223" class="css-a4x74f"><span>2223</span></td><td id="LC2223" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2224" class="css-a4x74f"><span>2224</span></td><td id="LC2224" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> {
</code></td></tr><tr><td id="L2225" class="css-a4x74f"><span>2225</span></td><td id="LC2225" class="css-1dcdqdg"><code>        onCreate: create,
</code></td></tr><tr><td id="L2226" class="css-a4x74f"><span>2226</span></td><td id="LC2226" class="css-1dcdqdg"><code>        onDestroy: destroy,
</code></td></tr><tr><td id="L2227" class="css-a4x74f"><span>2227</span></td><td id="LC2227" class="css-1dcdqdg"><code>        onBeforeUpdate: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onBeforeUpdate</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2228" class="css-a4x74f"><span>2228</span></td><td id="LC2228" class="css-1dcdqdg"><code>          prevProps = instance.props;
</code></td></tr><tr><td id="L2229" class="css-a4x74f"><span>2229</span></td><td id="LC2229" class="css-1dcdqdg"><code>        },
</code></td></tr><tr><td id="L2230" class="css-a4x74f"><span>2230</span></td><td id="LC2230" class="css-1dcdqdg"><code>        onAfterUpdate: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onAfterUpdate</span>(<span class="code-params">_, _ref2</span>) </span>{
</code></td></tr><tr><td id="L2231" class="css-a4x74f"><span>2231</span></td><td id="LC2231" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> followCursor = _ref2.followCursor;
</code></td></tr><tr><td id="L2232" class="css-a4x74f"><span>2232</span></td><td id="LC2232" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2233" class="css-a4x74f"><span>2233</span></td><td id="LC2233" class="css-1dcdqdg"><code>          <span class="code-keyword">if</span> (isInternalUpdate) {
</code></td></tr><tr><td id="L2234" class="css-a4x74f"><span>2234</span></td><td id="LC2234" class="css-1dcdqdg"><code>            <span class="code-keyword">return</span>;
</code></td></tr><tr><td id="L2235" class="css-a4x74f"><span>2235</span></td><td id="LC2235" class="css-1dcdqdg"><code>          }
</code></td></tr><tr><td id="L2236" class="css-a4x74f"><span>2236</span></td><td id="LC2236" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2237" class="css-a4x74f"><span>2237</span></td><td id="LC2237" class="css-1dcdqdg"><code>          <span class="code-keyword">if</span> (followCursor !== <span class="code-literal">undefined</span> &amp;&amp; prevProps.followCursor !== followCursor) {
</code></td></tr><tr><td id="L2238" class="css-a4x74f"><span>2238</span></td><td id="LC2238" class="css-1dcdqdg"><code>            destroy();
</code></td></tr><tr><td id="L2239" class="css-a4x74f"><span>2239</span></td><td id="LC2239" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2240" class="css-a4x74f"><span>2240</span></td><td id="LC2240" class="css-1dcdqdg"><code>            <span class="code-keyword">if</span> (followCursor) {
</code></td></tr><tr><td id="L2241" class="css-a4x74f"><span>2241</span></td><td id="LC2241" class="css-1dcdqdg"><code>              create();
</code></td></tr><tr><td id="L2242" class="css-a4x74f"><span>2242</span></td><td id="LC2242" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2243" class="css-a4x74f"><span>2243</span></td><td id="LC2243" class="css-1dcdqdg"><code>              <span class="code-keyword">if</span> (instance.state.isMounted &amp;&amp; !wasFocusEvent &amp;&amp; !getIsInitialBehavior()) {
</code></td></tr><tr><td id="L2244" class="css-a4x74f"><span>2244</span></td><td id="LC2244" class="css-1dcdqdg"><code>                addListener();
</code></td></tr><tr><td id="L2245" class="css-a4x74f"><span>2245</span></td><td id="LC2245" class="css-1dcdqdg"><code>              }
</code></td></tr><tr><td id="L2246" class="css-a4x74f"><span>2246</span></td><td id="LC2246" class="css-1dcdqdg"><code>            } <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L2247" class="css-a4x74f"><span>2247</span></td><td id="LC2247" class="css-1dcdqdg"><code>              removeListener();
</code></td></tr><tr><td id="L2248" class="css-a4x74f"><span>2248</span></td><td id="LC2248" class="css-1dcdqdg"><code>              unsetGetReferenceClientRect();
</code></td></tr><tr><td id="L2249" class="css-a4x74f"><span>2249</span></td><td id="LC2249" class="css-1dcdqdg"><code>            }
</code></td></tr><tr><td id="L2250" class="css-a4x74f"><span>2250</span></td><td id="LC2250" class="css-1dcdqdg"><code>          }
</code></td></tr><tr><td id="L2251" class="css-a4x74f"><span>2251</span></td><td id="LC2251" class="css-1dcdqdg"><code>        },
</code></td></tr><tr><td id="L2252" class="css-a4x74f"><span>2252</span></td><td id="LC2252" class="css-1dcdqdg"><code>        onMount: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onMount</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2253" class="css-a4x74f"><span>2253</span></td><td id="LC2253" class="css-1dcdqdg"><code>          <span class="code-keyword">if</span> (instance.props.followCursor &amp;&amp; !wasFocusEvent) {
</code></td></tr><tr><td id="L2254" class="css-a4x74f"><span>2254</span></td><td id="LC2254" class="css-1dcdqdg"><code>            <span class="code-keyword">if</span> (isUnmounted) {
</code></td></tr><tr><td id="L2255" class="css-a4x74f"><span>2255</span></td><td id="LC2255" class="css-1dcdqdg"><code>              onMouseMove(mouseCoords);
</code></td></tr><tr><td id="L2256" class="css-a4x74f"><span>2256</span></td><td id="LC2256" class="css-1dcdqdg"><code>              isUnmounted = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L2257" class="css-a4x74f"><span>2257</span></td><td id="LC2257" class="css-1dcdqdg"><code>            }
</code></td></tr><tr><td id="L2258" class="css-a4x74f"><span>2258</span></td><td id="LC2258" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2259" class="css-a4x74f"><span>2259</span></td><td id="LC2259" class="css-1dcdqdg"><code>            <span class="code-keyword">if</span> (!getIsInitialBehavior()) {
</code></td></tr><tr><td id="L2260" class="css-a4x74f"><span>2260</span></td><td id="LC2260" class="css-1dcdqdg"><code>              addListener();
</code></td></tr><tr><td id="L2261" class="css-a4x74f"><span>2261</span></td><td id="LC2261" class="css-1dcdqdg"><code>            }
</code></td></tr><tr><td id="L2262" class="css-a4x74f"><span>2262</span></td><td id="LC2262" class="css-1dcdqdg"><code>          }
</code></td></tr><tr><td id="L2263" class="css-a4x74f"><span>2263</span></td><td id="LC2263" class="css-1dcdqdg"><code>        },
</code></td></tr><tr><td id="L2264" class="css-a4x74f"><span>2264</span></td><td id="LC2264" class="css-1dcdqdg"><code>        onTrigger: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onTrigger</span>(<span class="code-params">_, event</span>) </span>{
</code></td></tr><tr><td id="L2265" class="css-a4x74f"><span>2265</span></td><td id="LC2265" class="css-1dcdqdg"><code>          <span class="code-keyword">if</span> (isMouseEvent(event)) {
</code></td></tr><tr><td id="L2266" class="css-a4x74f"><span>2266</span></td><td id="LC2266" class="css-1dcdqdg"><code>            mouseCoords = {
</code></td></tr><tr><td id="L2267" class="css-a4x74f"><span>2267</span></td><td id="LC2267" class="css-1dcdqdg"><code>              clientX: event.clientX,
</code></td></tr><tr><td id="L2268" class="css-a4x74f"><span>2268</span></td><td id="LC2268" class="css-1dcdqdg"><code>              clientY: event.clientY
</code></td></tr><tr><td id="L2269" class="css-a4x74f"><span>2269</span></td><td id="LC2269" class="css-1dcdqdg"><code>            };
</code></td></tr><tr><td id="L2270" class="css-a4x74f"><span>2270</span></td><td id="LC2270" class="css-1dcdqdg"><code>          }
</code></td></tr><tr><td id="L2271" class="css-a4x74f"><span>2271</span></td><td id="LC2271" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2272" class="css-a4x74f"><span>2272</span></td><td id="LC2272" class="css-1dcdqdg"><code>          wasFocusEvent = event.type === <span class="code-string">'focus'</span>;
</code></td></tr><tr><td id="L2273" class="css-a4x74f"><span>2273</span></td><td id="LC2273" class="css-1dcdqdg"><code>        },
</code></td></tr><tr><td id="L2274" class="css-a4x74f"><span>2274</span></td><td id="LC2274" class="css-1dcdqdg"><code>        onHidden: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onHidden</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2275" class="css-a4x74f"><span>2275</span></td><td id="LC2275" class="css-1dcdqdg"><code>          <span class="code-keyword">if</span> (instance.props.followCursor) {
</code></td></tr><tr><td id="L2276" class="css-a4x74f"><span>2276</span></td><td id="LC2276" class="css-1dcdqdg"><code>            unsetGetReferenceClientRect();
</code></td></tr><tr><td id="L2277" class="css-a4x74f"><span>2277</span></td><td id="LC2277" class="css-1dcdqdg"><code>            removeListener();
</code></td></tr><tr><td id="L2278" class="css-a4x74f"><span>2278</span></td><td id="LC2278" class="css-1dcdqdg"><code>            isUnmounted = <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L2279" class="css-a4x74f"><span>2279</span></td><td id="LC2279" class="css-1dcdqdg"><code>          }
</code></td></tr><tr><td id="L2280" class="css-a4x74f"><span>2280</span></td><td id="LC2280" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L2281" class="css-a4x74f"><span>2281</span></td><td id="LC2281" class="css-1dcdqdg"><code>      };
</code></td></tr><tr><td id="L2282" class="css-a4x74f"><span>2282</span></td><td id="LC2282" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L2283" class="css-a4x74f"><span>2283</span></td><td id="LC2283" class="css-1dcdqdg"><code>  };
</code></td></tr><tr><td id="L2284" class="css-a4x74f"><span>2284</span></td><td id="LC2284" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2285" class="css-a4x74f"><span>2285</span></td><td id="LC2285" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getProps</span>(<span class="code-params">props, modifier</span>) </span>{
</code></td></tr><tr><td id="L2286" class="css-a4x74f"><span>2286</span></td><td id="LC2286" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> _props$popperOptions;
</code></td></tr><tr><td id="L2287" class="css-a4x74f"><span>2287</span></td><td id="LC2287" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2288" class="css-a4x74f"><span>2288</span></td><td id="LC2288" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> {
</code></td></tr><tr><td id="L2289" class="css-a4x74f"><span>2289</span></td><td id="LC2289" class="css-1dcdqdg"><code>      popperOptions: <span class="code-built_in">Object</span>.assign({}, props.popperOptions, {
</code></td></tr><tr><td id="L2290" class="css-a4x74f"><span>2290</span></td><td id="LC2290" class="css-1dcdqdg"><code>        modifiers: [].concat((((_props$popperOptions = props.popperOptions) == <span class="code-literal">null</span> ? <span class="code-keyword">void</span> <span class="code-number">0</span> : _props$popperOptions.modifiers) || []).filter(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">_ref</span>) </span>{
</code></td></tr><tr><td id="L2291" class="css-a4x74f"><span>2291</span></td><td id="LC2291" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> name = _ref.name;
</code></td></tr><tr><td id="L2292" class="css-a4x74f"><span>2292</span></td><td id="LC2292" class="css-1dcdqdg"><code>          <span class="code-keyword">return</span> name !== modifier.name;
</code></td></tr><tr><td id="L2293" class="css-a4x74f"><span>2293</span></td><td id="LC2293" class="css-1dcdqdg"><code>        }), [modifier])
</code></td></tr><tr><td id="L2294" class="css-a4x74f"><span>2294</span></td><td id="LC2294" class="css-1dcdqdg"><code>      })
</code></td></tr><tr><td id="L2295" class="css-a4x74f"><span>2295</span></td><td id="LC2295" class="css-1dcdqdg"><code>    };
</code></td></tr><tr><td id="L2296" class="css-a4x74f"><span>2296</span></td><td id="LC2296" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L2297" class="css-a4x74f"><span>2297</span></td><td id="LC2297" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2298" class="css-a4x74f"><span>2298</span></td><td id="LC2298" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> inlinePositioning = {
</code></td></tr><tr><td id="L2299" class="css-a4x74f"><span>2299</span></td><td id="LC2299" class="css-1dcdqdg"><code>    name: <span class="code-string">'inlinePositioning'</span>,
</code></td></tr><tr><td id="L2300" class="css-a4x74f"><span>2300</span></td><td id="LC2300" class="css-1dcdqdg"><code>    defaultValue: <span class="code-literal">false</span>,
</code></td></tr><tr><td id="L2301" class="css-a4x74f"><span>2301</span></td><td id="LC2301" class="css-1dcdqdg"><code>    fn: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">fn</span>(<span class="code-params">instance</span>) </span>{
</code></td></tr><tr><td id="L2302" class="css-a4x74f"><span>2302</span></td><td id="LC2302" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> reference = instance.reference;
</code></td></tr><tr><td id="L2303" class="css-a4x74f"><span>2303</span></td><td id="LC2303" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2304" class="css-a4x74f"><span>2304</span></td><td id="LC2304" class="css-1dcdqdg"><code>      <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">isEnabled</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2305" class="css-a4x74f"><span>2305</span></td><td id="LC2305" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> !!instance.props.inlinePositioning;
</code></td></tr><tr><td id="L2306" class="css-a4x74f"><span>2306</span></td><td id="LC2306" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L2307" class="css-a4x74f"><span>2307</span></td><td id="LC2307" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2308" class="css-a4x74f"><span>2308</span></td><td id="LC2308" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> placement;
</code></td></tr><tr><td id="L2309" class="css-a4x74f"><span>2309</span></td><td id="LC2309" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> cursorRectIndex = <span class="code-number">-1</span>;
</code></td></tr><tr><td id="L2310" class="css-a4x74f"><span>2310</span></td><td id="LC2310" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> isInternalUpdate = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L2311" class="css-a4x74f"><span>2311</span></td><td id="LC2311" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> triedPlacements = [];
</code></td></tr><tr><td id="L2312" class="css-a4x74f"><span>2312</span></td><td id="LC2312" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> modifier = {
</code></td></tr><tr><td id="L2313" class="css-a4x74f"><span>2313</span></td><td id="LC2313" class="css-1dcdqdg"><code>        name: <span class="code-string">'tippyInlinePositioning'</span>,
</code></td></tr><tr><td id="L2314" class="css-a4x74f"><span>2314</span></td><td id="LC2314" class="css-1dcdqdg"><code>        enabled: <span class="code-literal">true</span>,
</code></td></tr><tr><td id="L2315" class="css-a4x74f"><span>2315</span></td><td id="LC2315" class="css-1dcdqdg"><code>        phase: <span class="code-string">'afterWrite'</span>,
</code></td></tr><tr><td id="L2316" class="css-a4x74f"><span>2316</span></td><td id="LC2316" class="css-1dcdqdg"><code>        fn: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">fn</span>(<span class="code-params">_ref2</span>) </span>{
</code></td></tr><tr><td id="L2317" class="css-a4x74f"><span>2317</span></td><td id="LC2317" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> state = _ref2.state;
</code></td></tr><tr><td id="L2318" class="css-a4x74f"><span>2318</span></td><td id="LC2318" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2319" class="css-a4x74f"><span>2319</span></td><td id="LC2319" class="css-1dcdqdg"><code>          <span class="code-keyword">if</span> (isEnabled()) {
</code></td></tr><tr><td id="L2320" class="css-a4x74f"><span>2320</span></td><td id="LC2320" class="css-1dcdqdg"><code>            <span class="code-keyword">if</span> (triedPlacements.indexOf(state.placement) !== <span class="code-number">-1</span>) {
</code></td></tr><tr><td id="L2321" class="css-a4x74f"><span>2321</span></td><td id="LC2321" class="css-1dcdqdg"><code>              triedPlacements = [];
</code></td></tr><tr><td id="L2322" class="css-a4x74f"><span>2322</span></td><td id="LC2322" class="css-1dcdqdg"><code>            }
</code></td></tr><tr><td id="L2323" class="css-a4x74f"><span>2323</span></td><td id="LC2323" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2324" class="css-a4x74f"><span>2324</span></td><td id="LC2324" class="css-1dcdqdg"><code>            <span class="code-keyword">if</span> (placement !== state.placement &amp;&amp; triedPlacements.indexOf(state.placement) === <span class="code-number">-1</span>) {
</code></td></tr><tr><td id="L2325" class="css-a4x74f"><span>2325</span></td><td id="LC2325" class="css-1dcdqdg"><code>              triedPlacements.push(state.placement);
</code></td></tr><tr><td id="L2326" class="css-a4x74f"><span>2326</span></td><td id="LC2326" class="css-1dcdqdg"><code>              instance.setProps({
</code></td></tr><tr><td id="L2327" class="css-a4x74f"><span>2327</span></td><td id="LC2327" class="css-1dcdqdg"><code>                <span class="code-comment">// @ts-ignore - unneeded DOMRect properties</span>
</code></td></tr><tr><td id="L2328" class="css-a4x74f"><span>2328</span></td><td id="LC2328" class="css-1dcdqdg"><code>                getReferenceClientRect: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getReferenceClientRect</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2329" class="css-a4x74f"><span>2329</span></td><td id="LC2329" class="css-1dcdqdg"><code>                  <span class="code-keyword">return</span> _getReferenceClientRect(state.placement);
</code></td></tr><tr><td id="L2330" class="css-a4x74f"><span>2330</span></td><td id="LC2330" class="css-1dcdqdg"><code>                }
</code></td></tr><tr><td id="L2331" class="css-a4x74f"><span>2331</span></td><td id="LC2331" class="css-1dcdqdg"><code>              });
</code></td></tr><tr><td id="L2332" class="css-a4x74f"><span>2332</span></td><td id="LC2332" class="css-1dcdqdg"><code>            }
</code></td></tr><tr><td id="L2333" class="css-a4x74f"><span>2333</span></td><td id="LC2333" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2334" class="css-a4x74f"><span>2334</span></td><td id="LC2334" class="css-1dcdqdg"><code>            placement = state.placement;
</code></td></tr><tr><td id="L2335" class="css-a4x74f"><span>2335</span></td><td id="LC2335" class="css-1dcdqdg"><code>          }
</code></td></tr><tr><td id="L2336" class="css-a4x74f"><span>2336</span></td><td id="LC2336" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L2337" class="css-a4x74f"><span>2337</span></td><td id="LC2337" class="css-1dcdqdg"><code>      };
</code></td></tr><tr><td id="L2338" class="css-a4x74f"><span>2338</span></td><td id="LC2338" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2339" class="css-a4x74f"><span>2339</span></td><td id="LC2339" class="css-1dcdqdg"><code>      <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">_getReferenceClientRect</span>(<span class="code-params">placement</span>) </span>{
</code></td></tr><tr><td id="L2340" class="css-a4x74f"><span>2340</span></td><td id="LC2340" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> getInlineBoundingClientRect(getBasePlacement(placement), reference.getBoundingClientRect(), arrayFrom(reference.getClientRects()), cursorRectIndex);
</code></td></tr><tr><td id="L2341" class="css-a4x74f"><span>2341</span></td><td id="LC2341" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L2342" class="css-a4x74f"><span>2342</span></td><td id="LC2342" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2343" class="css-a4x74f"><span>2343</span></td><td id="LC2343" class="css-1dcdqdg"><code>      <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">setInternalProps</span>(<span class="code-params">partialProps</span>) </span>{
</code></td></tr><tr><td id="L2344" class="css-a4x74f"><span>2344</span></td><td id="LC2344" class="css-1dcdqdg"><code>        isInternalUpdate = <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L2345" class="css-a4x74f"><span>2345</span></td><td id="LC2345" class="css-1dcdqdg"><code>        instance.setProps(partialProps);
</code></td></tr><tr><td id="L2346" class="css-a4x74f"><span>2346</span></td><td id="LC2346" class="css-1dcdqdg"><code>        isInternalUpdate = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L2347" class="css-a4x74f"><span>2347</span></td><td id="LC2347" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L2348" class="css-a4x74f"><span>2348</span></td><td id="LC2348" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2349" class="css-a4x74f"><span>2349</span></td><td id="LC2349" class="css-1dcdqdg"><code>      <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">addModifier</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2350" class="css-a4x74f"><span>2350</span></td><td id="LC2350" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (!isInternalUpdate) {
</code></td></tr><tr><td id="L2351" class="css-a4x74f"><span>2351</span></td><td id="LC2351" class="css-1dcdqdg"><code>          setInternalProps(getProps(instance.props, modifier));
</code></td></tr><tr><td id="L2352" class="css-a4x74f"><span>2352</span></td><td id="LC2352" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L2353" class="css-a4x74f"><span>2353</span></td><td id="LC2353" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L2354" class="css-a4x74f"><span>2354</span></td><td id="LC2354" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2355" class="css-a4x74f"><span>2355</span></td><td id="LC2355" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> {
</code></td></tr><tr><td id="L2356" class="css-a4x74f"><span>2356</span></td><td id="LC2356" class="css-1dcdqdg"><code>        onCreate: addModifier,
</code></td></tr><tr><td id="L2357" class="css-a4x74f"><span>2357</span></td><td id="LC2357" class="css-1dcdqdg"><code>        onAfterUpdate: addModifier,
</code></td></tr><tr><td id="L2358" class="css-a4x74f"><span>2358</span></td><td id="LC2358" class="css-1dcdqdg"><code>        onTrigger: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onTrigger</span>(<span class="code-params">_, event</span>) </span>{
</code></td></tr><tr><td id="L2359" class="css-a4x74f"><span>2359</span></td><td id="LC2359" class="css-1dcdqdg"><code>          <span class="code-keyword">if</span> (isMouseEvent(event)) {
</code></td></tr><tr><td id="L2360" class="css-a4x74f"><span>2360</span></td><td id="LC2360" class="css-1dcdqdg"><code>            <span class="code-keyword">var</span> rects = arrayFrom(instance.reference.getClientRects());
</code></td></tr><tr><td id="L2361" class="css-a4x74f"><span>2361</span></td><td id="LC2361" class="css-1dcdqdg"><code>            <span class="code-keyword">var</span> cursorRect = rects.find(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">rect</span>) </span>{
</code></td></tr><tr><td id="L2362" class="css-a4x74f"><span>2362</span></td><td id="LC2362" class="css-1dcdqdg"><code>              <span class="code-keyword">return</span> rect.left - <span class="code-number">2</span> &lt;= event.clientX &amp;&amp; rect.right + <span class="code-number">2</span> &gt;= event.clientX &amp;&amp; rect.top - <span class="code-number">2</span> &lt;= event.clientY &amp;&amp; rect.bottom + <span class="code-number">2</span> &gt;= event.clientY;
</code></td></tr><tr><td id="L2363" class="css-a4x74f"><span>2363</span></td><td id="LC2363" class="css-1dcdqdg"><code>            });
</code></td></tr><tr><td id="L2364" class="css-a4x74f"><span>2364</span></td><td id="LC2364" class="css-1dcdqdg"><code>            <span class="code-keyword">var</span> index = rects.indexOf(cursorRect);
</code></td></tr><tr><td id="L2365" class="css-a4x74f"><span>2365</span></td><td id="LC2365" class="css-1dcdqdg"><code>            cursorRectIndex = index &gt; <span class="code-number">-1</span> ? index : cursorRectIndex;
</code></td></tr><tr><td id="L2366" class="css-a4x74f"><span>2366</span></td><td id="LC2366" class="css-1dcdqdg"><code>          }
</code></td></tr><tr><td id="L2367" class="css-a4x74f"><span>2367</span></td><td id="LC2367" class="css-1dcdqdg"><code>        },
</code></td></tr><tr><td id="L2368" class="css-a4x74f"><span>2368</span></td><td id="LC2368" class="css-1dcdqdg"><code>        onHidden: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onHidden</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2369" class="css-a4x74f"><span>2369</span></td><td id="LC2369" class="css-1dcdqdg"><code>          cursorRectIndex = <span class="code-number">-1</span>;
</code></td></tr><tr><td id="L2370" class="css-a4x74f"><span>2370</span></td><td id="LC2370" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L2371" class="css-a4x74f"><span>2371</span></td><td id="LC2371" class="css-1dcdqdg"><code>      };
</code></td></tr><tr><td id="L2372" class="css-a4x74f"><span>2372</span></td><td id="LC2372" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L2373" class="css-a4x74f"><span>2373</span></td><td id="LC2373" class="css-1dcdqdg"><code>  };
</code></td></tr><tr><td id="L2374" class="css-a4x74f"><span>2374</span></td><td id="LC2374" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getInlineBoundingClientRect</span>(<span class="code-params">currentBasePlacement, boundingRect, clientRects, cursorRectIndex</span>) </span>{
</code></td></tr><tr><td id="L2375" class="css-a4x74f"><span>2375</span></td><td id="LC2375" class="css-1dcdqdg"><code>    <span class="code-comment">// Not an inline element, or placement is not yet known</span>
</code></td></tr><tr><td id="L2376" class="css-a4x74f"><span>2376</span></td><td id="LC2376" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (clientRects.length &lt; <span class="code-number">2</span> || currentBasePlacement === <span class="code-literal">null</span>) {
</code></td></tr><tr><td id="L2377" class="css-a4x74f"><span>2377</span></td><td id="LC2377" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> boundingRect;
</code></td></tr><tr><td id="L2378" class="css-a4x74f"><span>2378</span></td><td id="LC2378" class="css-1dcdqdg"><code>    } <span class="code-comment">// There are two rects and they are disjoined</span>
</code></td></tr><tr><td id="L2379" class="css-a4x74f"><span>2379</span></td><td id="LC2379" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2380" class="css-a4x74f"><span>2380</span></td><td id="LC2380" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2381" class="css-a4x74f"><span>2381</span></td><td id="LC2381" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (clientRects.length === <span class="code-number">2</span> &amp;&amp; cursorRectIndex &gt;= <span class="code-number">0</span> &amp;&amp; clientRects[<span class="code-number">0</span>].left &gt; clientRects[<span class="code-number">1</span>].right) {
</code></td></tr><tr><td id="L2382" class="css-a4x74f"><span>2382</span></td><td id="LC2382" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> clientRects[cursorRectIndex] || boundingRect;
</code></td></tr><tr><td id="L2383" class="css-a4x74f"><span>2383</span></td><td id="LC2383" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L2384" class="css-a4x74f"><span>2384</span></td><td id="LC2384" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2385" class="css-a4x74f"><span>2385</span></td><td id="LC2385" class="css-1dcdqdg"><code>    <span class="code-keyword">switch</span> (currentBasePlacement) {
</code></td></tr><tr><td id="L2386" class="css-a4x74f"><span>2386</span></td><td id="LC2386" class="css-1dcdqdg"><code>      <span class="code-keyword">case</span> <span class="code-string">'top'</span>:
</code></td></tr><tr><td id="L2387" class="css-a4x74f"><span>2387</span></td><td id="LC2387" class="css-1dcdqdg"><code>      <span class="code-keyword">case</span> <span class="code-string">'bottom'</span>:
</code></td></tr><tr><td id="L2388" class="css-a4x74f"><span>2388</span></td><td id="LC2388" class="css-1dcdqdg"><code>        {
</code></td></tr><tr><td id="L2389" class="css-a4x74f"><span>2389</span></td><td id="LC2389" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> firstRect = clientRects[<span class="code-number">0</span>];
</code></td></tr><tr><td id="L2390" class="css-a4x74f"><span>2390</span></td><td id="LC2390" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> lastRect = clientRects[clientRects.length - <span class="code-number">1</span>];
</code></td></tr><tr><td id="L2391" class="css-a4x74f"><span>2391</span></td><td id="LC2391" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> isTop = currentBasePlacement === <span class="code-string">'top'</span>;
</code></td></tr><tr><td id="L2392" class="css-a4x74f"><span>2392</span></td><td id="LC2392" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> top = firstRect.top;
</code></td></tr><tr><td id="L2393" class="css-a4x74f"><span>2393</span></td><td id="LC2393" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> bottom = lastRect.bottom;
</code></td></tr><tr><td id="L2394" class="css-a4x74f"><span>2394</span></td><td id="LC2394" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> left = isTop ? firstRect.left : lastRect.left;
</code></td></tr><tr><td id="L2395" class="css-a4x74f"><span>2395</span></td><td id="LC2395" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> right = isTop ? firstRect.right : lastRect.right;
</code></td></tr><tr><td id="L2396" class="css-a4x74f"><span>2396</span></td><td id="LC2396" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> width = right - left;
</code></td></tr><tr><td id="L2397" class="css-a4x74f"><span>2397</span></td><td id="LC2397" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> height = bottom - top;
</code></td></tr><tr><td id="L2398" class="css-a4x74f"><span>2398</span></td><td id="LC2398" class="css-1dcdqdg"><code>          <span class="code-keyword">return</span> {
</code></td></tr><tr><td id="L2399" class="css-a4x74f"><span>2399</span></td><td id="LC2399" class="css-1dcdqdg"><code>            top: top,
</code></td></tr><tr><td id="L2400" class="css-a4x74f"><span>2400</span></td><td id="LC2400" class="css-1dcdqdg"><code>            bottom: bottom,
</code></td></tr><tr><td id="L2401" class="css-a4x74f"><span>2401</span></td><td id="LC2401" class="css-1dcdqdg"><code>            left: left,
</code></td></tr><tr><td id="L2402" class="css-a4x74f"><span>2402</span></td><td id="LC2402" class="css-1dcdqdg"><code>            right: right,
</code></td></tr><tr><td id="L2403" class="css-a4x74f"><span>2403</span></td><td id="LC2403" class="css-1dcdqdg"><code>            width: width,
</code></td></tr><tr><td id="L2404" class="css-a4x74f"><span>2404</span></td><td id="LC2404" class="css-1dcdqdg"><code>            height: height
</code></td></tr><tr><td id="L2405" class="css-a4x74f"><span>2405</span></td><td id="LC2405" class="css-1dcdqdg"><code>          };
</code></td></tr><tr><td id="L2406" class="css-a4x74f"><span>2406</span></td><td id="LC2406" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L2407" class="css-a4x74f"><span>2407</span></td><td id="LC2407" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2408" class="css-a4x74f"><span>2408</span></td><td id="LC2408" class="css-1dcdqdg"><code>      <span class="code-keyword">case</span> <span class="code-string">'left'</span>:
</code></td></tr><tr><td id="L2409" class="css-a4x74f"><span>2409</span></td><td id="LC2409" class="css-1dcdqdg"><code>      <span class="code-keyword">case</span> <span class="code-string">'right'</span>:
</code></td></tr><tr><td id="L2410" class="css-a4x74f"><span>2410</span></td><td id="LC2410" class="css-1dcdqdg"><code>        {
</code></td></tr><tr><td id="L2411" class="css-a4x74f"><span>2411</span></td><td id="LC2411" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> minLeft = <span class="code-built_in">Math</span>.min.apply(<span class="code-built_in">Math</span>, clientRects.map(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">rects</span>) </span>{
</code></td></tr><tr><td id="L2412" class="css-a4x74f"><span>2412</span></td><td id="LC2412" class="css-1dcdqdg"><code>            <span class="code-keyword">return</span> rects.left;
</code></td></tr><tr><td id="L2413" class="css-a4x74f"><span>2413</span></td><td id="LC2413" class="css-1dcdqdg"><code>          }));
</code></td></tr><tr><td id="L2414" class="css-a4x74f"><span>2414</span></td><td id="LC2414" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> maxRight = <span class="code-built_in">Math</span>.max.apply(<span class="code-built_in">Math</span>, clientRects.map(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">rects</span>) </span>{
</code></td></tr><tr><td id="L2415" class="css-a4x74f"><span>2415</span></td><td id="LC2415" class="css-1dcdqdg"><code>            <span class="code-keyword">return</span> rects.right;
</code></td></tr><tr><td id="L2416" class="css-a4x74f"><span>2416</span></td><td id="LC2416" class="css-1dcdqdg"><code>          }));
</code></td></tr><tr><td id="L2417" class="css-a4x74f"><span>2417</span></td><td id="LC2417" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> measureRects = clientRects.filter(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">rect</span>) </span>{
</code></td></tr><tr><td id="L2418" class="css-a4x74f"><span>2418</span></td><td id="LC2418" class="css-1dcdqdg"><code>            <span class="code-keyword">return</span> currentBasePlacement === <span class="code-string">'left'</span> ? rect.left === minLeft : rect.right === maxRight;
</code></td></tr><tr><td id="L2419" class="css-a4x74f"><span>2419</span></td><td id="LC2419" class="css-1dcdqdg"><code>          });
</code></td></tr><tr><td id="L2420" class="css-a4x74f"><span>2420</span></td><td id="LC2420" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> _top = measureRects[<span class="code-number">0</span>].top;
</code></td></tr><tr><td id="L2421" class="css-a4x74f"><span>2421</span></td><td id="LC2421" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> _bottom = measureRects[measureRects.length - <span class="code-number">1</span>].bottom;
</code></td></tr><tr><td id="L2422" class="css-a4x74f"><span>2422</span></td><td id="LC2422" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> _left = minLeft;
</code></td></tr><tr><td id="L2423" class="css-a4x74f"><span>2423</span></td><td id="LC2423" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> _right = maxRight;
</code></td></tr><tr><td id="L2424" class="css-a4x74f"><span>2424</span></td><td id="LC2424" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2425" class="css-a4x74f"><span>2425</span></td><td id="LC2425" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> _width = _right - _left;
</code></td></tr><tr><td id="L2426" class="css-a4x74f"><span>2426</span></td><td id="LC2426" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2427" class="css-a4x74f"><span>2427</span></td><td id="LC2427" class="css-1dcdqdg"><code>          <span class="code-keyword">var</span> _height = _bottom - _top;
</code></td></tr><tr><td id="L2428" class="css-a4x74f"><span>2428</span></td><td id="LC2428" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2429" class="css-a4x74f"><span>2429</span></td><td id="LC2429" class="css-1dcdqdg"><code>          <span class="code-keyword">return</span> {
</code></td></tr><tr><td id="L2430" class="css-a4x74f"><span>2430</span></td><td id="LC2430" class="css-1dcdqdg"><code>            top: _top,
</code></td></tr><tr><td id="L2431" class="css-a4x74f"><span>2431</span></td><td id="LC2431" class="css-1dcdqdg"><code>            bottom: _bottom,
</code></td></tr><tr><td id="L2432" class="css-a4x74f"><span>2432</span></td><td id="LC2432" class="css-1dcdqdg"><code>            left: _left,
</code></td></tr><tr><td id="L2433" class="css-a4x74f"><span>2433</span></td><td id="LC2433" class="css-1dcdqdg"><code>            right: _right,
</code></td></tr><tr><td id="L2434" class="css-a4x74f"><span>2434</span></td><td id="LC2434" class="css-1dcdqdg"><code>            width: _width,
</code></td></tr><tr><td id="L2435" class="css-a4x74f"><span>2435</span></td><td id="LC2435" class="css-1dcdqdg"><code>            height: _height
</code></td></tr><tr><td id="L2436" class="css-a4x74f"><span>2436</span></td><td id="LC2436" class="css-1dcdqdg"><code>          };
</code></td></tr><tr><td id="L2437" class="css-a4x74f"><span>2437</span></td><td id="LC2437" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L2438" class="css-a4x74f"><span>2438</span></td><td id="LC2438" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2439" class="css-a4x74f"><span>2439</span></td><td id="LC2439" class="css-1dcdqdg"><code>      <span class="code-keyword">default</span>:
</code></td></tr><tr><td id="L2440" class="css-a4x74f"><span>2440</span></td><td id="LC2440" class="css-1dcdqdg"><code>        {
</code></td></tr><tr><td id="L2441" class="css-a4x74f"><span>2441</span></td><td id="LC2441" class="css-1dcdqdg"><code>          <span class="code-keyword">return</span> boundingRect;
</code></td></tr><tr><td id="L2442" class="css-a4x74f"><span>2442</span></td><td id="LC2442" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L2443" class="css-a4x74f"><span>2443</span></td><td id="LC2443" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L2444" class="css-a4x74f"><span>2444</span></td><td id="LC2444" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L2445" class="css-a4x74f"><span>2445</span></td><td id="LC2445" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2446" class="css-a4x74f"><span>2446</span></td><td id="LC2446" class="css-1dcdqdg"><code>  <span class="code-keyword">var</span> sticky = {
</code></td></tr><tr><td id="L2447" class="css-a4x74f"><span>2447</span></td><td id="LC2447" class="css-1dcdqdg"><code>    name: <span class="code-string">'sticky'</span>,
</code></td></tr><tr><td id="L2448" class="css-a4x74f"><span>2448</span></td><td id="LC2448" class="css-1dcdqdg"><code>    defaultValue: <span class="code-literal">false</span>,
</code></td></tr><tr><td id="L2449" class="css-a4x74f"><span>2449</span></td><td id="LC2449" class="css-1dcdqdg"><code>    fn: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">fn</span>(<span class="code-params">instance</span>) </span>{
</code></td></tr><tr><td id="L2450" class="css-a4x74f"><span>2450</span></td><td id="LC2450" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> reference = instance.reference,
</code></td></tr><tr><td id="L2451" class="css-a4x74f"><span>2451</span></td><td id="LC2451" class="css-1dcdqdg"><code>          popper = instance.popper;
</code></td></tr><tr><td id="L2452" class="css-a4x74f"><span>2452</span></td><td id="LC2452" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2453" class="css-a4x74f"><span>2453</span></td><td id="LC2453" class="css-1dcdqdg"><code>      <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getReference</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2454" class="css-a4x74f"><span>2454</span></td><td id="LC2454" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> instance.popperInstance ? instance.popperInstance.state.elements.reference : reference;
</code></td></tr><tr><td id="L2455" class="css-a4x74f"><span>2455</span></td><td id="LC2455" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L2456" class="css-a4x74f"><span>2456</span></td><td id="LC2456" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2457" class="css-a4x74f"><span>2457</span></td><td id="LC2457" class="css-1dcdqdg"><code>      <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">shouldCheck</span>(<span class="code-params">value</span>) </span>{
</code></td></tr><tr><td id="L2458" class="css-a4x74f"><span>2458</span></td><td id="LC2458" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> instance.props.sticky === <span class="code-literal">true</span> || instance.props.sticky === value;
</code></td></tr><tr><td id="L2459" class="css-a4x74f"><span>2459</span></td><td id="LC2459" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L2460" class="css-a4x74f"><span>2460</span></td><td id="LC2460" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2461" class="css-a4x74f"><span>2461</span></td><td id="LC2461" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> prevRefRect = <span class="code-literal">null</span>;
</code></td></tr><tr><td id="L2462" class="css-a4x74f"><span>2462</span></td><td id="LC2462" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> prevPopRect = <span class="code-literal">null</span>;
</code></td></tr><tr><td id="L2463" class="css-a4x74f"><span>2463</span></td><td id="LC2463" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2464" class="css-a4x74f"><span>2464</span></td><td id="LC2464" class="css-1dcdqdg"><code>      <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">updatePosition</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2465" class="css-a4x74f"><span>2465</span></td><td id="LC2465" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> currentRefRect = shouldCheck(<span class="code-string">'reference'</span>) ? getReference().getBoundingClientRect() : <span class="code-literal">null</span>;
</code></td></tr><tr><td id="L2466" class="css-a4x74f"><span>2466</span></td><td id="LC2466" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> currentPopRect = shouldCheck(<span class="code-string">'popper'</span>) ? popper.getBoundingClientRect() : <span class="code-literal">null</span>;
</code></td></tr><tr><td id="L2467" class="css-a4x74f"><span>2467</span></td><td id="LC2467" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2468" class="css-a4x74f"><span>2468</span></td><td id="LC2468" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (currentRefRect &amp;&amp; areRectsDifferent(prevRefRect, currentRefRect) || currentPopRect &amp;&amp; areRectsDifferent(prevPopRect, currentPopRect)) {
</code></td></tr><tr><td id="L2469" class="css-a4x74f"><span>2469</span></td><td id="LC2469" class="css-1dcdqdg"><code>          <span class="code-keyword">if</span> (instance.popperInstance) {
</code></td></tr><tr><td id="L2470" class="css-a4x74f"><span>2470</span></td><td id="LC2470" class="css-1dcdqdg"><code>            instance.popperInstance.update();
</code></td></tr><tr><td id="L2471" class="css-a4x74f"><span>2471</span></td><td id="LC2471" class="css-1dcdqdg"><code>          }
</code></td></tr><tr><td id="L2472" class="css-a4x74f"><span>2472</span></td><td id="LC2472" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L2473" class="css-a4x74f"><span>2473</span></td><td id="LC2473" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2474" class="css-a4x74f"><span>2474</span></td><td id="LC2474" class="css-1dcdqdg"><code>        prevRefRect = currentRefRect;
</code></td></tr><tr><td id="L2475" class="css-a4x74f"><span>2475</span></td><td id="LC2475" class="css-1dcdqdg"><code>        prevPopRect = currentPopRect;
</code></td></tr><tr><td id="L2476" class="css-a4x74f"><span>2476</span></td><td id="LC2476" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2477" class="css-a4x74f"><span>2477</span></td><td id="LC2477" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (instance.state.isMounted) {
</code></td></tr><tr><td id="L2478" class="css-a4x74f"><span>2478</span></td><td id="LC2478" class="css-1dcdqdg"><code>          requestAnimationFrame(updatePosition);
</code></td></tr><tr><td id="L2479" class="css-a4x74f"><span>2479</span></td><td id="LC2479" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L2480" class="css-a4x74f"><span>2480</span></td><td id="LC2480" class="css-1dcdqdg"><code>      }
</code></td></tr><tr><td id="L2481" class="css-a4x74f"><span>2481</span></td><td id="LC2481" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2482" class="css-a4x74f"><span>2482</span></td><td id="LC2482" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> {
</code></td></tr><tr><td id="L2483" class="css-a4x74f"><span>2483</span></td><td id="LC2483" class="css-1dcdqdg"><code>        onMount: <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">onMount</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L2484" class="css-a4x74f"><span>2484</span></td><td id="LC2484" class="css-1dcdqdg"><code>          <span class="code-keyword">if</span> (instance.props.sticky) {
</code></td></tr><tr><td id="L2485" class="css-a4x74f"><span>2485</span></td><td id="LC2485" class="css-1dcdqdg"><code>            updatePosition();
</code></td></tr><tr><td id="L2486" class="css-a4x74f"><span>2486</span></td><td id="LC2486" class="css-1dcdqdg"><code>          }
</code></td></tr><tr><td id="L2487" class="css-a4x74f"><span>2487</span></td><td id="LC2487" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L2488" class="css-a4x74f"><span>2488</span></td><td id="LC2488" class="css-1dcdqdg"><code>      };
</code></td></tr><tr><td id="L2489" class="css-a4x74f"><span>2489</span></td><td id="LC2489" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L2490" class="css-a4x74f"><span>2490</span></td><td id="LC2490" class="css-1dcdqdg"><code>  };
</code></td></tr><tr><td id="L2491" class="css-a4x74f"><span>2491</span></td><td id="LC2491" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2492" class="css-a4x74f"><span>2492</span></td><td id="LC2492" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">areRectsDifferent</span>(<span class="code-params">rectA, rectB</span>) </span>{
</code></td></tr><tr><td id="L2493" class="css-a4x74f"><span>2493</span></td><td id="LC2493" class="css-1dcdqdg"><code>    <span class="code-keyword">if</span> (rectA &amp;&amp; rectB) {
</code></td></tr><tr><td id="L2494" class="css-a4x74f"><span>2494</span></td><td id="LC2494" class="css-1dcdqdg"><code>      <span class="code-keyword">return</span> rectA.top !== rectB.top || rectA.right !== rectB.right || rectA.bottom !== rectB.bottom || rectA.left !== rectB.left;
</code></td></tr><tr><td id="L2495" class="css-a4x74f"><span>2495</span></td><td id="LC2495" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L2496" class="css-a4x74f"><span>2496</span></td><td id="LC2496" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2497" class="css-a4x74f"><span>2497</span></td><td id="LC2497" class="css-1dcdqdg"><code>    <span class="code-keyword">return</span> <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L2498" class="css-a4x74f"><span>2498</span></td><td id="LC2498" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L2499" class="css-a4x74f"><span>2499</span></td><td id="LC2499" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2500" class="css-a4x74f"><span>2500</span></td><td id="LC2500" class="css-1dcdqdg"><code>  <span class="code-keyword">if</span> (isBrowser) {
</code></td></tr><tr><td id="L2501" class="css-a4x74f"><span>2501</span></td><td id="LC2501" class="css-1dcdqdg"><code>    injectCSS(css);
</code></td></tr><tr><td id="L2502" class="css-a4x74f"><span>2502</span></td><td id="LC2502" class="css-1dcdqdg"><code>  }
</code></td></tr><tr><td id="L2503" class="css-a4x74f"><span>2503</span></td><td id="LC2503" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2504" class="css-a4x74f"><span>2504</span></td><td id="LC2504" class="css-1dcdqdg"><code>  tippy.setDefaultProps({
</code></td></tr><tr><td id="L2505" class="css-a4x74f"><span>2505</span></td><td id="LC2505" class="css-1dcdqdg"><code>    plugins: [animateFill, followCursor, inlinePositioning, sticky],
</code></td></tr><tr><td id="L2506" class="css-a4x74f"><span>2506</span></td><td id="LC2506" class="css-1dcdqdg"><code>    render: render
</code></td></tr><tr><td id="L2507" class="css-a4x74f"><span>2507</span></td><td id="LC2507" class="css-1dcdqdg"><code>  });
</code></td></tr><tr><td id="L2508" class="css-a4x74f"><span>2508</span></td><td id="LC2508" class="css-1dcdqdg"><code>  tippy.createSingleton = createSingleton;
</code></td></tr><tr><td id="L2509" class="css-a4x74f"><span>2509</span></td><td id="LC2509" class="css-1dcdqdg"><code>  tippy.delegate = delegate;
</code></td></tr><tr><td id="L2510" class="css-a4x74f"><span>2510</span></td><td id="LC2510" class="css-1dcdqdg"><code>  tippy.hideAll = hideAll;
</code></td></tr><tr><td id="L2511" class="css-a4x74f"><span>2511</span></td><td id="LC2511" class="css-1dcdqdg"><code>  tippy.roundArrow = ROUND_ARROW;
</code></td></tr><tr><td id="L2512" class="css-a4x74f"><span>2512</span></td><td id="LC2512" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2513" class="css-a4x74f"><span>2513</span></td><td id="LC2513" class="css-1dcdqdg"><code>  <span class="code-keyword">return</span> tippy;
</code></td></tr><tr><td id="L2514" class="css-a4x74f"><span>2514</span></td><td id="LC2514" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L2515" class="css-a4x74f"><span>2515</span></td><td id="LC2515" class="css-1dcdqdg"><code>})));
</code></td></tr><tr><td id="L2516" class="css-a4x74f"><span>2516</span></td><td id="LC2516" class="css-1dcdqdg"><code><span class="code-comment">//# sourceMappingURL=tippy-bundle.umd.js.map</span>
</code></td></tr></tbody></table></div></div></div></div><style data-emotion-css="1teho9j">.css-1teho9j{margin-top:5rem;background:black;color:#aaa;}</style><footer class="css-1teho9j"><style data-emotion-css="1ui8put">.css-1ui8put{max-width:940px;padding:10px 20px;margin:0 auto;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-direction:row;-ms-flex-direction:row;flex-direction:row;-webkit-align-items:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-pack:justify;-webkit-justify-content:space-between;-ms-flex-pack:justify;justify-content:space-between;}</style><div class="css-1ui8put"><p><span>Build: <!-- -->a7ebffa</span></p><p><span>© <!-- -->2023<!-- --> UNPKG</span></p><style data-emotion-css="la3nd4">.css-la3nd4{font-size:1.5rem;}</style><p class="css-la3nd4"><style data-emotion-css="bogekj">.css-bogekj{color:#aaa;display:inline-block;}.css-bogekj:hover{color:white;}</style><a href="https://twitter.com/unpkg" class="css-bogekj"><style data-emotion-css="i6dzq1">.css-i6dzq1{vertical-align:text-bottom;}</style><svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512" class="css-i6dzq1" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"></path></svg></a><style data-emotion-css="3czw03">.css-3czw03{color:#aaa;display:inline-block;margin-left:1rem;}.css-3czw03:hover{color:white;}</style><a href="https://github.com/mjackson/unpkg" class="css-3czw03"><svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 496 512" class="css-i6dzq1" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M165.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3.3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-4.5c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2s-1.3-4.3-4.3-5.2c-2.6-.7-5.5.3-6.2 2.3zm44.2-1.7c-2.9.7-4.9 2.6-4.6 4.9.3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.6-.3-1.9-3-3.2-5.9-2.9zM244.8 8C106.1 8 0 113.3 0 252c0 110.9 69.8 205.8 169.5 239.2 12.8 2.3 17.3-5.6 17.3-12.1 0-6.2-.3-40.4-.3-61.4 0 0-70 15-84.7-29.8 0 0-11.4-29.1-27.8-36.6 0 0-22.9-15.7 1.6-15.4 0 0 24.9 2 38.6 25.8 21.9 38.6 58.6 27.5 72.9 20.9 2.3-16 8.8-27.1 16-33.7-55.9-6.2-112.3-14.3-112.3-110.5 0-27.5 7.6-41.3 23.6-58.9-2.6-6.5-11.1-33.3 2.6-67.9 20.9-6.5 69 27 69 27 20-5.6 41.5-8.5 62.8-8.5s42.8 2.9 62.8 8.5c0 0 48.1-33.6 69-27 13.7 34.7 5.2 61.4 2.6 67.9 16 17.7 25.8 31.5 25.8 58.9 0 96.5-58.9 104.2-114.8 110.5 9.2 7.9 17 22.9 17 46.4 0 33.7-.3 75.4-.3 83.6 0 6.5 4.6 14.4 17.3 12.1C428.2 457.8 496 362.9 496 252 496 113.3 383.5 8 244.8 8zM97.2 352.9c-1.3 1-1 3.3.7 5.2 1.6 1.6 3.9 2.3 5.2 1 1.3-1 1-3.3-.7-5.2-1.6-1.6-3.9-2.3-5.2-1zm-10.8-8.1c-.7 1.3.3 2.9 2.3 3.9 1.6 1 3.6.7 4.3-.7.7-1.3-.3-2.9-2.3-3.9-2-.6-3.6-.3-4.3.7zm32.4 35.6c-1.6 1.3-1 4.3 1.3 6.2 2.3 2.3 5.2 2.6 6.5 1 1.3-1.3.7-4.3-1.3-6.2-2.2-2.3-5.2-2.6-6.5-1zm-11.4-14.7c-1.6 1-1.6 3.6 0 5.9 1.6 2.3 4.3 3.3 5.6 2.3 1.6-1.3 1.6-3.9 0-6.2-1.4-2.3-4-3.3-5.6-2z"></path></svg></a></p></div></footer></div><script src="/react@16.8.6/umd/react.production.min.js"></script><script src="/react-dom@16.8.6/umd/react-dom.production.min.js"></script><script src="/@emotion/core@10.0.6/dist/core.umd.min.js"></script><script>'use strict';(function(t,A,c){function w(){w=Object.assign||function(a){for(var b=1;b<arguments.length;b++){var e=arguments[b],c;for(c in e)Object.prototype.hasOwnProperty.call(e,c)&&(a[c]=e[c])}return a};return w.apply(this,arguments)}function P(a,b){if(null==a)return{};var e={},c=Object.keys(a),d;for(d=0;d<c.length;d++){var h=c[d];0<=b.indexOf(h)||(e[h]=a[h])}return e}function Q(a,b){b||(b=a.slice(0));a.raw=b;return a}function R(a){return a&&a.__esModule&&Object.prototype.hasOwnProperty.call(a,
"default")?a["default"]:a}function D(a,b){return b={exports:{}},a(b,b.exports),b.exports}function J(a,b,e,c,d){for(var g in a)if(ua(a,g)){try{if("function"!==typeof a[g]){var r=Error((c||"React class")+": "+e+" type `"+g+"` is invalid; it must be a function, usually from the `prop-types` package, but received `"+typeof a[g]+"`.");r.name="Invariant Violation";throw r;}var k=a[g](b,g,c,e,null,"SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED")}catch(q){k=q}!k||k instanceof Error||K((c||"React class")+": type specification of "+
e+" `"+g+"` is invalid; the type checker function must return `null` or an `Error` but returned a "+typeof k+". You may have forgotten to pass an argument to the type checker creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and shape all require an argument).");if(k instanceof Error&&!(k.message in L)){L[k.message]=!0;var B=d?d():"";K("Failed "+e+" type: "+k.message+(null!=B?B:""))}}}function G(){return null}function S(a){var b,e=a.children;a=a.css;return c.jsx("div",{css:w((b={border:"1px solid #dfe2e5",
borderRadius:3},b["@media (max-width: 700px)"]={borderRightWidth:0,borderLeftWidth:0},b),a)},e)}function T(a){var b,e=a.children;a=a.css;return c.jsx("div",{css:w((b={padding:10,background:"#f6f8fa",color:"#424242",border:"1px solid #d1d5da",borderTopLeftRadius:3,borderTopRightRadius:3,margin:"-1px -1px 0",display:"flex",flexDirection:"row",alignItems:"center",justifyContent:"space-between"},b["@media (max-width: 700px)"]={paddingRight:20,paddingLeft:20},b),a)},e)}function U(a){return a&&a.map(function(a,
c){return t.createElement(a.tag,z({key:c},a.attr),U(a.child))})}function E(a){return function(b){return t.createElement(va,z({attr:z({},a.attr)},b),U(a.child))}}function va(a){var b=function(b){var c=a.size||b.size||"1em";if(b.className)var e=b.className;a.className&&(e=(e?e+" ":"")+a.className);var h=a.attr,r=a.title,k=["attr","title"],B={},q;for(q in a)Object.prototype.hasOwnProperty.call(a,q)&&0>k.indexOf(q)&&(B[q]=a[q]);if(null!=a&&"function"===typeof Object.getOwnPropertySymbols){var p=0;for(q=
Object.getOwnPropertySymbols(a);p<q.length;p++)0>k.indexOf(q[p])&&(B[q[p]]=a[q[p]])}return t.createElement("svg",z({stroke:"currentColor",fill:"currentColor",strokeWidth:"0"},b.attr,h,B,{className:e,style:z({color:a.color||b.color},b.style,a.style),height:c,width:c,xmlns:"http://www.w3.org/2000/svg"}),r&&t.createElement("title",null,r),a.children)};return void 0!==V?t.createElement(V.Consumer,null,function(a){return b(a)}):b(W)}function F(a,b){var e=b.css;b=P(b,["css"]);return c.jsx(a,w({css:w({},
e,{verticalAlign:"text-bottom"})},b))}function wa(a){return F(X,a)}function xa(a){return F(Y,a)}function ya(a){return F(Z,a)}function za(a){return F(aa,a)}function Aa(a){return F(ba,a)}function ca(a){var b=a.path,e=a.details,g=Object.keys(e).reduce(function(a,b){var c=a.subdirs,g=a.files;b=e[b];"directory"===b.type?c.push(b):"file"===b.type&&g.push(b);return a},{subdirs:[],files:[]});a=g.subdirs;g=g.files;a.sort(da("path"));g.sort(da("path"));var d=[];"/"!==b&&d.push(c.jsx("tr",{key:".."},c.jsx("td",
{css:M}),c.jsx("td",{css:y},c.jsx("a",{title:"Parent directory",href:"../",css:N},"..")),c.jsx("td",{css:y}),c.jsx("td",{css:O})));a.forEach(function(a){a=a.path.substr(1<b.length?b.length+1:1);var e=a+"/";d.push(c.jsx("tr",{key:a},c.jsx("td",{css:M},c.jsx(ya,null)),c.jsx("td",{css:y},c.jsx("a",{title:a,href:e,css:N},a)),c.jsx("td",{css:y},"-"),c.jsx("td",{css:O},"-")))});g.forEach(function(a){var e=a.size,g=a.contentType;a=a.path.substr(1<b.length?b.length+1:1);d.push(c.jsx("tr",{key:a},c.jsx("td",
{css:M},"text/plain"===g||"text/markdown"===g?c.jsx(wa,null):c.jsx(xa,null)),c.jsx("td",{css:y},c.jsx("a",{title:a,href:a,css:N},a)),c.jsx("td",{css:y},ea(e)),c.jsx("td",{css:O},g)))});var h=[];0<g.length&&h.push(g.length+" file"+(1===g.length?"":"s"));0<a.length&&h.push(a.length+" folder"+(1===a.length?"":"s"));return c.jsx(S,null,c.jsx(T,null,c.jsx("span",null,h.join(", "))),c.jsx("table",{css:{width:"100%",borderCollapse:"collapse",borderRadius:2,background:"#fff","@media (max-width: 700px)":{"& th + th + th + th, & td + td + td + td":{display:"none"}},
"& tr:first-of-type td":{borderTop:0}}},c.jsx("thead",null,c.jsx("tr",null,c.jsx("th",null,c.jsx(H,null,"Icon")),c.jsx("th",null,c.jsx(H,null,"Name")),c.jsx("th",null,c.jsx(H,null,"Size")),c.jsx("th",null,c.jsx(H,null,"Content Type")))),c.jsx("tbody",null,d)))}function Ba(a){a=a.split("/");return a[a.length-1]}function Ca(a){var b=a.uri;return c.jsx("div",{css:{padding:20,textAlign:"center"}},c.jsx("img",{alt:Ba(a.path),src:b}))}function Da(a){a=a.highlights.slice(0);var b=a.length&&""===a[a.length-
1];b&&a.pop();return c.jsx("div",{className:"code-listing",css:{overflowX:"auto",overflowY:"hidden",paddingTop:5,paddingBottom:5}},c.jsx("table",{css:{border:"none",borderCollapse:"collapse",borderSpacing:0}},c.jsx("tbody",null,a.map(function(a,b){var e=b+1;return c.jsx("tr",{key:b},c.jsx("td",{id:"L"+e,css:{paddingLeft:10,paddingRight:10,color:"rgba(27,31,35,.3)",textAlign:"right",verticalAlign:"top",width:"1%",minWidth:50,userSelect:"none"}},c.jsx("span",null,e)),c.jsx("td",{id:"LC"+e,css:{paddingLeft:10,
paddingRight:10,color:"#24292e",whiteSpace:"pre"}},c.jsx("code",{dangerouslySetInnerHTML:{__html:a}})))}),!b&&c.jsx("tr",{key:"no-newline"},c.jsx("td",{css:{paddingLeft:10,paddingRight:10,color:"rgba(27,31,35,.3)",textAlign:"right",verticalAlign:"top",width:"1%",minWidth:50,userSelect:"none"}},"\\"),c.jsx("td",{css:{paddingLeft:10,color:"rgba(27,31,35,.3)",userSelect:"none"}},"No newline at end of file")))))}function Ea(){return c.jsx("div",{css:{padding:20}},c.jsx("p",{css:{textAlign:"center"}},
"No preview available."))}function fa(a){var b=a.packageName,e=a.packageVersion,g=a.path;a=a.details;var d=a.highlights,h=a.uri,r=a.language;return c.jsx(S,null,c.jsx(T,null,c.jsx("span",null,ea(a.size)),c.jsx("span",null,r),c.jsx("span",null,c.jsx("a",{href:"/"+b+"@"+e+g,css:{display:"inline-block",marginLeft:8,padding:"2px 8px",textDecoration:"none",fontWeight:600,fontSize:"0.9rem",color:"#24292e",backgroundColor:"#eff3f6",border:"1px solid rgba(27,31,35,.2)",borderRadius:3,":hover":{backgroundColor:"#e6ebf1",
borderColor:"rgba(27,31,35,.35)"},":active":{backgroundColor:"#e9ecef",borderColor:"rgba(27,31,35,.35)",boxShadow:"inset 0 0.15em 0.3em rgba(27,31,35,.15)"}}},"View Raw"))),d?c.jsx(Da,{highlights:d}):h?c.jsx(Ca,{path:g,uri:h}):c.jsx(Ea,null))}function ha(){var a=Q(["\n  .code-listing {\n    background: #fbfdff;\n    color: #383a42;\n  }\n  .code-comment,\n  .code-quote {\n    color: #a0a1a7;\n    font-style: italic;\n  }\n  .code-doctag,\n  .code-keyword,\n  .code-link,\n  .code-formula {\n    color: #a626a4;\n  }\n  .code-section,\n  .code-name,\n  .code-selector-tag,\n  .code-deletion,\n  .code-subst {\n    color: #e45649;\n  }\n  .code-literal {\n    color: #0184bb;\n  }\n  .code-string,\n  .code-regexp,\n  .code-addition,\n  .code-attribute,\n  .code-meta-string {\n    color: #50a14f;\n  }\n  .code-built_in,\n  .code-class .code-title {\n    color: #c18401;\n  }\n  .code-attr,\n  .code-variable,\n  .code-template-variable,\n  .code-type,\n  .code-selector-class,\n  .code-selector-attr,\n  .code-selector-pseudo,\n  .code-number {\n    color: #986801;\n  }\n  .code-symbol,\n  .code-bullet,\n  .code-meta,\n  .code-selector-id,\n  .code-title {\n    color: #4078f2;\n  }\n  .code-emphasis {\n    font-style: italic;\n  }\n  .code-strong {\n    font-weight: bold;\n  }\n"]);
ha=function(){return a};return a}function ia(){var a=Q(["\n  html {\n    box-sizing: border-box;\n  }\n  *,\n  *:before,\n  *:after {\n    box-sizing: inherit;\n  }\n\n  html,\n  body,\n  #root {\n    height: 100%;\n    margin: 0;\n  }\n\n  body {\n    ","\n    font-size: 16px;\n    line-height: 1.5;\n    overflow-wrap: break-word;\n    background: white;\n    color: black;\n  }\n\n  code {\n    ","\n  }\n\n  th,\n  td {\n    padding: 0;\n  }\n\n  select {\n    font-size: inherit;\n  }\n\n  #root {\n    display: flex;\n    flex-direction: column;\n  }\n"]);
ia=function(){return a};return a}function ja(a){var b=a.css;a=P(a,["css"]);return c.jsx("a",w({},a,{css:w({color:"#0076ff",textDecoration:"none",":hover":{textDecoration:"underline"}},b)}))}function Fa(){return c.jsx("header",{css:{marginTop:"2rem"}},c.jsx("h1",{css:{textAlign:"center",fontSize:"3rem",letterSpacing:"0.05em"}},c.jsx("a",{href:"/",css:{color:"#000",textDecoration:"none"}},"UNPKG")))}function Ga(a){var b=a.packageName,e=a.packageVersion,g=a.availableVersions;a=a.filename;var d=[];if("/"===
a)d.push(b);else{var h="/browse/"+b+"@"+e;d.push(c.jsx(ja,{href:h+"/"},b));b=a.replace(/^\/+/,"").replace(/\/+$/,"").split("/");a=b.pop();b.forEach(function(a){h+="/"+a;d.push(c.jsx(ja,{href:h+"/"},a))});d.push(a)}return c.jsx("header",{css:{display:"flex",flexDirection:"row",alignItems:"center","@media (max-width: 700px)":{flexDirection:"column-reverse",alignItems:"flex-start"}}},c.jsx("h1",{css:{fontSize:"1.5rem",fontWeight:"normal",flex:1,wordBreak:"break-all"}},c.jsx("nav",null,d.map(function(a,
b,e){return c.jsx(t.Fragment,{key:b},0!==b&&c.jsx("span",{css:{paddingLeft:5,paddingRight:5}},"/"),b===e.length-1?c.jsx("strong",null,a):a)}))),c.jsx(Ha,{packageVersion:e,availableVersions:g,onChange:function(a){window.location.href=window.location.href.replace("@"+e,"@"+a)}}))}function Ha(a){var b=a.onChange;return c.jsx("p",{css:{marginLeft:20,"@media (max-width: 700px)":{marginLeft:0,marginBottom:0}}},c.jsx("label",null,"Version:"," ",c.jsx("select",{name:"version",defaultValue:a.packageVersion,
onChange:function(a){b&&b(a.target.value)},css:{appearance:"none",cursor:"pointer",padding:"4px 24px 4px 8px",fontWeight:600,fontSize:"0.9em",color:"#24292e",border:"1px solid rgba(27,31,35,.2)",borderRadius:3,backgroundColor:"#eff3f6",backgroundImage:"url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAKCAYAAAC9vt6cAAAAAXNSR0IArs4c6QAAARFJREFUKBVjZAACNS39RhBNKrh17WI9o4quoT3Dn78HSNUMUs/CzOTI/O7Vi4dCYpJ3/jP+92BkYGAlyiBGhm8MjIxJt65e3MQM0vDu9YvLYmISILYZELOBxHABRkaGr0yMzF23r12YDFIDNgDEePv65SEhEXENBkYGFSAXuyGMjF8Z/jOsvX3tYiFIDwgwQSgIaaijnvj/P8M5IO8HsjiY/f//D4b//88A1SQhywG9jQr09PS4v/1mPAeUUPzP8B8cJowMjL+Bqu6xMQmaXL164AuyDgwDQJLa2qYSP//9vARkCoMVMzK8YeVkNbh+9uxzMB+JwGoASF5Vx0jz/98/18BqmZi171w9D2EjaaYKEwAEK00XQLdJuwAAAABJRU5ErkJggg==)",
backgroundPosition:"right 8px center",backgroundRepeat:"no-repeat",backgroundSize:"auto 25%",":hover":{backgroundColor:"#e6ebf1",borderColor:"rgba(27,31,35,.35)"},":active":{backgroundColor:"#e9ecef",borderColor:"rgba(27,31,35,.35)",boxShadow:"inset 0 0.15em 0.3em rgba(27,31,35,.15)"}}},a.availableVersions.map(function(a){return c.jsx("option",{key:a,value:a},a)}))))}function Ia(a){var b=a.packageName,e=a.packageVersion;a=a.target;return"directory"===a.type?c.jsx(ca,{path:a.path,details:a.details}):
"file"===a.type?c.jsx(fa,{packageName:b,packageVersion:e,path:a.path,details:a.details}):null}function ka(a){var b=a.packageName,e=a.packageVersion,g=a.availableVersions;g=void 0===g?[]:g;var d=a.filename;a=a.target;return c.jsx(t.Fragment,null,c.jsx(c.Global,{styles:Ja}),c.jsx(c.Global,{styles:Ka}),c.jsx("div",{css:{flex:"1 0 auto"}},c.jsx("div",{css:{maxWidth:940,padding:"0 20px",margin:"0 auto"}},c.jsx(Fa,null)),c.jsx("div",{css:{maxWidth:940,padding:"0 20px",margin:"0 auto"}},c.jsx(Ga,{packageName:b,
packageVersion:e,availableVersions:g,filename:d})),c.jsx("div",{css:{maxWidth:940,padding:"0 20px",margin:"0 auto","@media (max-width: 700px)":{padding:0,margin:0}}},c.jsx(Ia,{packageName:b,packageVersion:e,target:a}))),c.jsx("footer",{css:{marginTop:"5rem",background:"black",color:"#aaa"}},c.jsx("div",{css:{maxWidth:940,padding:"10px 20px",margin:"0 auto",display:"flex",flexDirection:"row",alignItems:"center",justifyContent:"space-between"}},c.jsx("p",null,c.jsx("span",null,"Build: ","a7ebffa")),
c.jsx("p",null,c.jsx("span",null,"\u00a9 ",(new Date).getFullYear()," UNPKG")),c.jsx("p",{css:{fontSize:"1.5rem"}},c.jsx("a",{href:"https://twitter.com/unpkg",css:{color:"#aaa",display:"inline-block",":hover":{color:"white"}}},c.jsx(za,null)),c.jsx("a",{href:"https://github.com/mjackson/unpkg",css:{color:"#aaa",display:"inline-block",":hover":{color:"white"},marginLeft:"1rem"}},c.jsx(Aa,null))))))}var la="default"in t?t["default"]:t;A=A&&A.hasOwnProperty("default")?A["default"]:A;var La="undefined"!==
typeof globalThis?globalThis:"undefined"!==typeof window?window:"undefined"!==typeof global?global:"undefined"!==typeof self?self:{},m=D(function(a,b){function c(a){if("object"===typeof a&&null!==a){var b=a.$$typeof;switch(b){case d:switch(a=a.type,a){case l:case f:case r:case m:case k:case v:return a;default:switch(a=a&&a.$$typeof,a){case p:case n:case q:return a;default:return b}}case x:case u:case h:return b}}}function g(a){return c(a)===f}Object.defineProperty(b,"__esModule",{value:!0});var d=
(a="function"===typeof Symbol&&Symbol.for)?Symbol.for("react.element"):60103,h=a?Symbol.for("react.portal"):60106,r=a?Symbol.for("react.fragment"):60107,k=a?Symbol.for("react.strict_mode"):60108,m=a?Symbol.for("react.profiler"):60114,q=a?Symbol.for("react.provider"):60109,p=a?Symbol.for("react.context"):60110,l=a?Symbol.for("react.async_mode"):60111,f=a?Symbol.for("react.concurrent_mode"):60111,n=a?Symbol.for("react.forward_ref"):60112,v=a?Symbol.for("react.suspense"):60113,u=a?Symbol.for("react.memo"):
60115,x=a?Symbol.for("react.lazy"):60116;b.typeOf=c;b.AsyncMode=l;b.ConcurrentMode=f;b.ContextConsumer=p;b.ContextProvider=q;b.Element=d;b.ForwardRef=n;b.Fragment=r;b.Lazy=x;b.Memo=u;b.Portal=h;b.Profiler=m;b.StrictMode=k;b.Suspense=v;b.isValidElementType=function(a){return"string"===typeof a||"function"===typeof a||a===r||a===f||a===m||a===k||a===v||"object"===typeof a&&null!==a&&(a.$$typeof===x||a.$$typeof===u||a.$$typeof===q||a.$$typeof===p||a.$$typeof===n)};b.isAsyncMode=function(a){return g(a)||
c(a)===l};b.isConcurrentMode=g;b.isContextConsumer=function(a){return c(a)===p};b.isContextProvider=function(a){return c(a)===q};b.isElement=function(a){return"object"===typeof a&&null!==a&&a.$$typeof===d};b.isForwardRef=function(a){return c(a)===n};b.isFragment=function(a){return c(a)===r};b.isLazy=function(a){return c(a)===x};b.isMemo=function(a){return c(a)===u};b.isPortal=function(a){return c(a)===h};b.isProfiler=function(a){return c(a)===m};b.isStrictMode=function(a){return c(a)===k};b.isSuspense=
function(a){return c(a)===v}});R(m);var na=D(function(a,b){(function(){function a(a){if("object"===typeof a&&null!==a){var b=a.$$typeof;switch(b){case h:switch(a=a.type,a){case f:case n:case k:case q:case m:case u:return a;default:switch(a=a&&a.$$typeof,a){case l:case v:case p:return a;default:return b}}case I:case x:case r:return b}}}function c(b){return a(b)===n}Object.defineProperty(b,"__esModule",{value:!0});var d="function"===typeof Symbol&&Symbol.for,h=d?Symbol.for("react.element"):60103,r=
d?Symbol.for("react.portal"):60106,k=d?Symbol.for("react.fragment"):60107,m=d?Symbol.for("react.strict_mode"):60108,q=d?Symbol.for("react.profiler"):60114,p=d?Symbol.for("react.provider"):60109,l=d?Symbol.for("react.context"):60110,f=d?Symbol.for("react.async_mode"):60111,n=d?Symbol.for("react.concurrent_mode"):60111,v=d?Symbol.for("react.forward_ref"):60112,u=d?Symbol.for("react.suspense"):60113,x=d?Symbol.for("react.memo"):60115,I=d?Symbol.for("react.lazy"):60116;d=function(){};var Ma=function(a){for(var b=
arguments.length,f=Array(1<b?b-1:0),c=1;c<b;c++)f[c-1]=arguments[c];var n=0;b="Warning: "+a.replace(/%s/g,function(){return f[n++]});"undefined"!==typeof console&&console.warn(b);try{throw Error(b);}catch(Xa){}},Na=d=function(a,b){if(void 0===b)throw Error("`lowPriorityWarning(condition, format, ...args)` requires a warning message argument");if(!a){for(var f=arguments.length,c=Array(2<f?f-2:0),n=2;n<f;n++)c[n-2]=arguments[n];Ma.apply(void 0,[b].concat(c))}},ma=!1;b.typeOf=a;b.AsyncMode=f;b.ConcurrentMode=
n;b.ContextConsumer=l;b.ContextProvider=p;b.Element=h;b.ForwardRef=v;b.Fragment=k;b.Lazy=I;b.Memo=x;b.Portal=r;b.Profiler=q;b.StrictMode=m;b.Suspense=u;b.isValidElementType=function(a){return"string"===typeof a||"function"===typeof a||a===k||a===n||a===q||a===m||a===u||"object"===typeof a&&null!==a&&(a.$$typeof===I||a.$$typeof===x||a.$$typeof===p||a.$$typeof===l||a.$$typeof===v)};b.isAsyncMode=function(b){ma||(ma=!0,Na(!1,"The ReactIs.isAsyncMode() alias has been deprecated, and will be removed in React 17+. Update your code to use ReactIs.isConcurrentMode() instead. It has the exact same API."));
return c(b)||a(b)===f};b.isConcurrentMode=c;b.isContextConsumer=function(b){return a(b)===l};b.isContextProvider=function(b){return a(b)===p};b.isElement=function(a){return"object"===typeof a&&null!==a&&a.$$typeof===h};b.isForwardRef=function(b){return a(b)===v};b.isFragment=function(b){return a(b)===k};b.isLazy=function(b){return a(b)===I};b.isMemo=function(b){return a(b)===x};b.isPortal=function(b){return a(b)===r};b.isProfiler=function(b){return a(b)===q};b.isStrictMode=function(b){return a(b)===
m};b.isSuspense=function(b){return a(b)===u}})()});R(na);var oa=D(function(a){a.exports=na}),pa=Object.getOwnPropertySymbols,Oa=Object.prototype.hasOwnProperty,Pa=Object.prototype.propertyIsEnumerable,Qa=function(){try{if(!Object.assign)return!1;var a=new String("abc");a[5]="de";if("5"===Object.getOwnPropertyNames(a)[0])return!1;var b={};for(a=0;10>a;a++)b["_"+String.fromCharCode(a)]=a;if("0123456789"!==Object.getOwnPropertyNames(b).map(function(a){return b[a]}).join(""))return!1;var c={};"abcdefghijklmnopqrst".split("").forEach(function(a){c[a]=
a});return"abcdefghijklmnopqrst"!==Object.keys(Object.assign({},c)).join("")?!1:!0}catch(g){return!1}}()?Object.assign:function(a,b){if(null===a||void 0===a)throw new TypeError("Object.assign cannot be called with null or undefined");var c=Object(a);for(var g,d=1;d<arguments.length;d++){var h=Object(arguments[d]);for(var r in h)Oa.call(h,r)&&(c[r]=h[r]);if(pa){g=pa(h);for(var k=0;k<g.length;k++)Pa.call(h,g[k])&&(c[g[k]]=h[g[k]])}}return c},K=function(){},L={},ua=Function.call.bind(Object.prototype.hasOwnProperty);
K=function(a){a="Warning: "+a;"undefined"!==typeof console&&console.error(a);try{throw Error(a);}catch(b){}};J.resetWarningCache=function(){L={}};var Ra=Function.call.bind(Object.prototype.hasOwnProperty),C=function(){};C=function(a){a="Warning: "+a;"undefined"!==typeof console&&console.error(a);try{throw Error(a);}catch(b){}};var Sa=function(a,b){function c(a,b){return a===b?0!==a||1/a===1/b:a!==a&&b!==b}function g(a){this.message=a;this.stack=""}function d(a){function c(c,n,v,d,e,u,h){d=d||"<<anonymous>>";
u=u||v;if("SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED"!==h){if(b)throw c=Error("Calling PropTypes validators directly is not supported by the `prop-types` package. Use `PropTypes.checkPropTypes()` to call them. Read more at http://fb.me/use-check-prop-types"),c.name="Invariant Violation",c;"undefined"!==typeof console&&(h=d+":"+v,!f[h]&&3>l&&(C("You are manually calling a React.PropTypes validation function for the `"+u+"` prop on `"+d+"`. This is deprecated and will throw in the standalone `prop-types` package. You may be seeing this warning due to a third-party PropTypes library. See https://fb.me/react-warning-dont-call-proptypes for details."),
f[h]=!0,l++))}return null==n[v]?c?null===n[v]?new g("The "+e+" `"+u+"` is marked as required "+("in `"+d+"`, but its value is `null`.")):new g("The "+e+" `"+u+"` is marked as required in "+("`"+d+"`, but its value is `undefined`.")):null:a(n,v,d,e,u)}var f={},l=0,d=c.bind(null,!1);d.isRequired=c.bind(null,!0);return d}function h(a){return d(function(b,c,f,d,l,e){b=b[c];return k(b)!==a?(b=m(b),new g("Invalid "+d+" `"+l+"` of type "+("`"+b+"` supplied to `"+f+"`, expected ")+("`"+a+"`."))):null})}function r(b){switch(typeof b){case "number":case "string":case "undefined":return!0;
case "boolean":return!b;case "object":if(Array.isArray(b))return b.every(r);if(null===b||a(b))return!0;var c=b&&(p&&b[p]||b["@@iterator"]);var f="function"===typeof c?c:void 0;if(f)if(c=f.call(b),f!==b.entries)for(;!(b=c.next()).done;){if(!r(b.value))return!1}else for(;!(b=c.next()).done;){if((b=b.value)&&!r(b[1]))return!1}else return!1;return!0;default:return!1}}function k(a){var b=typeof a;return Array.isArray(a)?"array":a instanceof RegExp?"object":"symbol"===b||a&&("Symbol"===a["@@toStringTag"]||
"function"===typeof Symbol&&a instanceof Symbol)?"symbol":b}function m(a){if("undefined"===typeof a||null===a)return""+a;var b=k(a);if("object"===b){if(a instanceof Date)return"date";if(a instanceof RegExp)return"regexp"}return b}function q(a){a=m(a);switch(a){case "array":case "object":return"an "+a;case "boolean":case "date":case "regexp":return"a "+a;default:return a}}var p="function"===typeof Symbol&&Symbol.iterator,l={array:h("array"),bool:h("boolean"),func:h("function"),number:h("number"),object:h("object"),
string:h("string"),symbol:h("symbol"),any:d(G),arrayOf:function(a){return d(function(b,c,f,d,l){if("function"!==typeof a)return new g("Property `"+l+"` of component `"+f+"` has invalid PropType notation inside arrayOf.");b=b[c];if(!Array.isArray(b))return b=k(b),new g("Invalid "+d+" `"+l+"` of type "+("`"+b+"` supplied to `"+f+"`, expected an array."));for(c=0;c<b.length;c++){var n=a(b,c,f,d,l+"["+c+"]","SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED");if(n instanceof Error)return n}return null})},
element:function(){return d(function(b,c,d,l,e){b=b[c];return a(b)?null:(b=k(b),new g("Invalid "+l+" `"+e+"` of type "+("`"+b+"` supplied to `"+d+"`, expected a single ReactElement.")))})}(),elementType:function(){return d(function(a,b,c,d,l){a=a[b];return oa.isValidElementType(a)?null:(a=k(a),new g("Invalid "+d+" `"+l+"` of type "+("`"+a+"` supplied to `"+c+"`, expected a single ReactElement type.")))})}(),instanceOf:function(a){return d(function(b,c,f,d,l){if(!(b[c]instanceof a)){var n=a.name||
"<<anonymous>>";b=b[c];b=b.constructor&&b.constructor.name?b.constructor.name:"<<anonymous>>";return new g("Invalid "+d+" `"+l+"` of type "+("`"+b+"` supplied to `"+f+"`, expected ")+("instance of `"+n+"`."))}return null})},node:function(){return d(function(a,b,c,d,l){return r(a[b])?null:new g("Invalid "+d+" `"+l+"` supplied to "+("`"+c+"`, expected a ReactNode."))})}(),objectOf:function(a){return d(function(b,c,f,d,l){if("function"!==typeof a)return new g("Property `"+l+"` of component `"+f+"` has invalid PropType notation inside objectOf.");
b=b[c];c=k(b);if("object"!==c)return new g("Invalid "+d+" `"+l+"` of type "+("`"+c+"` supplied to `"+f+"`, expected an object."));for(var n in b)if(Ra(b,n)&&(c=a(b,n,f,d,l+"."+n,"SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED"),c instanceof Error))return c;return null})},oneOf:function(a){return Array.isArray(a)?d(function(b,f,d,l,e){b=b[f];for(f=0;f<a.length;f++)if(c(b,a[f]))return null;f=JSON.stringify(a,function(a,b){return"symbol"===m(b)?String(b):b});return new g("Invalid "+l+" `"+e+"` of value `"+
String(b)+"` "+("supplied to `"+d+"`, expected one of "+f+"."))}):(1<arguments.length?C("Invalid arguments supplied to oneOf, expected an array, got "+arguments.length+" arguments. A common mistake is to write oneOf(x, y, z) instead of oneOf([x, y, z])."):C("Invalid argument supplied to oneOf, expected an array."),G)},oneOfType:function(a){if(!Array.isArray(a))return C("Invalid argument supplied to oneOfType, expected an instance of array."),G;for(var b=0;b<a.length;b++){var c=a[b];if("function"!==
typeof c)return C("Invalid argument supplied to oneOfType. Expected an array of check functions, but received "+q(c)+" at index "+b+"."),G}return d(function(b,c,f,d,l){for(var e=0;e<a.length;e++)if(null==(0,a[e])(b,c,f,d,l,"SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED"))return null;return new g("Invalid "+d+" `"+l+"` supplied to "+("`"+f+"`."))})},shape:function(a){return d(function(b,c,d,l,f){b=b[c];c=k(b);if("object"!==c)return new g("Invalid "+l+" `"+f+"` of type `"+c+"` "+("supplied to `"+d+"`, expected `object`."));
for(var e in a)if(c=a[e])if(c=c(b,e,d,l,f+"."+e,"SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED"))return c;return null})},exact:function(a){return d(function(b,c,d,l,f){var e=b[c],n=k(e);if("object"!==n)return new g("Invalid "+l+" `"+f+"` of type `"+n+"` "+("supplied to `"+d+"`, expected `object`."));n=Qa({},b[c],a);for(var h in n){n=a[h];if(!n)return new g("Invalid "+l+" `"+f+"` key `"+h+"` supplied to `"+d+"`.\nBad object: "+JSON.stringify(b[c],null,"  ")+"\nValid keys: "+JSON.stringify(Object.keys(a),
null,"  "));if(n=n(e,h,d,l,f+"."+h,"SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED"))return n}return null})}};g.prototype=Error.prototype;l.checkPropTypes=J;l.resetWarningCache=J.resetWarningCache;return l.PropTypes=l};m=D(function(a){a.exports=Sa(oa.isElement,!0)});var Ta=Object.assign||function(a){for(var b=1;b<arguments.length;b++){var c=arguments[b],g;for(g in c)Object.prototype.hasOwnProperty.call(c,g)&&(a[g]=c[g])}return a},Ua={border:0,clip:"rect(0 0 0 0)",height:"1px",width:"1px",margin:"-1px",
padding:0,overflow:"hidden",position:"absolute"},H=function(a){return la.createElement("div",Ta({style:Ua},a))},qa=D(function(a){(function(b,c){a.exports=c()})(La,function(){function a(a){if(!a)return!0;if(!d(a)||0!==a.length)for(var b in a)if(q.call(a,b))return!1;return!0}function c(a){return"number"===typeof a||"[object Number]"===t.call(a)}function g(a){return"string"===typeof a||"[object String]"===t.call(a)}function d(a){return"object"===typeof a&&"number"===typeof a.length&&"[object Array]"===
t.call(a)}function h(a){var b=parseInt(a);return b.toString()===a?b:a}function m(b,d,e,k){c(d)&&(d=[d]);if(a(d))return b;if(g(d))return m(b,d.split("."),e,k);var f=h(d[0]);if(1===d.length)return d=b[f],void 0!==d&&k||(b[f]=e),d;void 0===b[f]&&(c(f)?b[f]=[]:b[f]={});return m(b[f],d.slice(1),e,k)}function k(b,f){c(f)&&(f=[f]);if(!a(b)){if(a(f))return b;if(g(f))return k(b,f.split("."));var e=h(f[0]),l=b[e];if(1===f.length)void 0!==l&&(d(b)?b.splice(e,1):delete b[e]);else if(void 0!==b[e])return k(b[e],
f.slice(1));return b}}var t=Object.prototype.toString,q=Object.prototype.hasOwnProperty,p={ensureExists:function(a,b,c){return m(a,b,c,!0)},set:function(a,b,c,d){return m(a,b,c,d)},insert:function(a,b,c,e){var f=p.get(a,b);e=~~e;d(f)||(f=[],p.set(a,b,f));f.splice(e,0,c)},empty:function(b,f){if(a(f))return b;if(!a(b)){var e,h;if(!(e=p.get(b,f)))return b;if(g(e))return p.set(b,f,"");if("boolean"===typeof e||"[object Boolean]"===t.call(e))return p.set(b,f,!1);if(c(e))return p.set(b,f,0);if(d(e))e.length=
0;else if("object"===typeof e&&"[object Object]"===t.call(e))for(h in e)q.call(e,h)&&delete e[h];else return p.set(b,f,null)}},push:function(a,b){var c=p.get(a,b);d(c)||(c=[],p.set(a,b,c));c.push.apply(c,Array.prototype.slice.call(arguments,2))},coalesce:function(a,b,c){for(var d,e=0,f=b.length;e<f;e++)if(void 0!==(d=p.get(a,b[e])))return d;return c},get:function(b,d,e){c(d)&&(d=[d]);if(a(d))return b;if(a(b))return e;if(g(d))return p.get(b,d.split("."),e);var f=h(d[0]);return 1===d.length?void 0===
b[f]?e:b[f]:p.get(b[f],d.slice(1),e)},del:function(a,b){return k(a,b)}};return p})});var ra=function(a){return function(b){return typeof b===a}};var Va=function(a,b){var c=1,g=b||function(a,b){return b};"-"===a[0]&&(c=-1,a=a.substr(1));return function(b,e){var d;b=g(a,qa.get(b,a));e=g(a,qa.get(e,a));b<e&&(d=-1);b>e&&(d=1);b===e&&(d=0);return d*c}};var da=function(){var a=Array.prototype.slice.call(arguments),b=a.filter(ra("string")),c=a.filter(ra("function"))[0];return function(a,d){for(var e=b.length,
g=0,k=0;0===g&&k<e;)g=Va(b[k],c)(a,d),k++;return g}};let sa="B kB MB GB TB PB EB ZB YB".split(" "),ta=(a,b)=>{let c=a;"string"===typeof b?c=a.toLocaleString(b):!0===b&&(c=a.toLocaleString());return c};var ea=(a,b)=>{if(!Number.isFinite(a))throw new TypeError(`Expected a finite number, got ${typeof a}: ${a}`);b=Object.assign({},b);if(b.signed&&0===a)return" 0 B";var c=0>a;let g=c?"-":b.signed?"+":"";c&&(a=-a);if(1>a)return a=ta(a,b.locale),g+a+" B";c=Math.min(Math.floor(Math.log10(a)/3),sa.length-
1);a=Number((a/Math.pow(1E3,c)).toPrecision(3));a=ta(a,b.locale);return g+a+" "+sa[c]},W={color:void 0,size:void 0,className:void 0,style:void 0,attr:void 0},V=t.createContext&&t.createContext(W),z=function(){z=Object.assign||function(a){for(var b,c=1,g=arguments.length;c<g;c++){b=arguments[c];for(var d in b)Object.prototype.hasOwnProperty.call(b,d)&&(a[d]=b[d])}return a};return z.apply(this,arguments)},Y=function(a){return E({tag:"svg",attr:{viewBox:"0 0 12 16"},child:[{tag:"path",attr:{fillRule:"evenodd",
d:"M8.5 1H1c-.55 0-1 .45-1 1v12c0 .55.45 1 1 1h10c.55 0 1-.45 1-1V4.5L8.5 1zM11 14H1V2h7l3 3v9zM5 6.98L3.5 8.5 5 10l-.5 1L2 8.5 4.5 6l.5.98zM7.5 6L10 8.5 7.5 11l-.5-.98L8.5 8.5 7 7l.5-1z"}}]})(a)};Y.displayName="GoFileCode";var Z=function(a){return E({tag:"svg",attr:{viewBox:"0 0 14 16"},child:[{tag:"path",attr:{fillRule:"evenodd",d:"M13 4H7V3c0-.66-.31-1-1-1H1c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h12c.55 0 1-.45 1-1V5c0-.55-.45-1-1-1zM6 4H1V3h5v1z"}}]})(a)};Z.displayName="GoFileDirectory";var X=function(a){return E({tag:"svg",
attr:{viewBox:"0 0 12 16"},child:[{tag:"path",attr:{fillRule:"evenodd",d:"M6 5H2V4h4v1zM2 8h7V7H2v1zm0 2h7V9H2v1zm0 2h7v-1H2v1zm10-7.5V14c0 .55-.45 1-1 1H1c-.55 0-1-.45-1-1V2c0-.55.45-1 1-1h7.5L12 4.5zM11 5L8 2H1v12h10V5z"}}]})(a)};X.displayName="GoFile";var ba=function(a){return E({tag:"svg",attr:{viewBox:"0 0 496 512"},child:[{tag:"path",attr:{d:"M165.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3.3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-4.5c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2s-1.3-4.3-4.3-5.2c-2.6-.7-5.5.3-6.2 2.3zm44.2-1.7c-2.9.7-4.9 2.6-4.6 4.9.3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.6-.3-1.9-3-3.2-5.9-2.9zM244.8 8C106.1 8 0 113.3 0 252c0 110.9 69.8 205.8 169.5 239.2 12.8 2.3 17.3-5.6 17.3-12.1 0-6.2-.3-40.4-.3-61.4 0 0-70 15-84.7-29.8 0 0-11.4-29.1-27.8-36.6 0 0-22.9-15.7 1.6-15.4 0 0 24.9 2 38.6 25.8 21.9 38.6 58.6 27.5 72.9 20.9 2.3-16 8.8-27.1 16-33.7-55.9-6.2-112.3-14.3-112.3-110.5 0-27.5 7.6-41.3 23.6-58.9-2.6-6.5-11.1-33.3 2.6-67.9 20.9-6.5 69 27 69 27 20-5.6 41.5-8.5 62.8-8.5s42.8 2.9 62.8 8.5c0 0 48.1-33.6 69-27 13.7 34.7 5.2 61.4 2.6 67.9 16 17.7 25.8 31.5 25.8 58.9 0 96.5-58.9 104.2-114.8 110.5 9.2 7.9 17 22.9 17 46.4 0 33.7-.3 75.4-.3 83.6 0 6.5 4.6 14.4 17.3 12.1C428.2 457.8 496 362.9 496 252 496 113.3 383.5 8 244.8 8zM97.2 352.9c-1.3 1-1 3.3.7 5.2 1.6 1.6 3.9 2.3 5.2 1 1.3-1 1-3.3-.7-5.2-1.6-1.6-3.9-2.3-5.2-1zm-10.8-8.1c-.7 1.3.3 2.9 2.3 3.9 1.6 1 3.6.7 4.3-.7.7-1.3-.3-2.9-2.3-3.9-2-.6-3.6-.3-4.3.7zm32.4 35.6c-1.6 1.3-1 4.3 1.3 6.2 2.3 2.3 5.2 2.6 6.5 1 1.3-1.3.7-4.3-1.3-6.2-2.2-2.3-5.2-2.6-6.5-1zm-11.4-14.7c-1.6 1-1.6 3.6 0 5.9 1.6 2.3 4.3 3.3 5.6 2.3 1.6-1.3 1.6-3.9 0-6.2-1.4-2.3-4-3.3-5.6-2z"}}]})(a)};
ba.displayName="FaGithub";var aa=function(a){return E({tag:"svg",attr:{viewBox:"0 0 512 512"},child:[{tag:"path",attr:{d:"M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"}}]})(a)};
aa.displayName="FaTwitter";var N={color:"#0076ff",textDecoration:"none",":hover":{textDecoration:"underline"}},y={paddingTop:6,paddingRight:3,paddingBottom:6,paddingLeft:3,borderTop:"1px solid #eaecef"},M=w({},y,{color:"#424242",width:17,paddingRight:2,paddingLeft:10,"@media (max-width: 700px)":{paddingLeft:20}}),O=w({},y,{textAlign:"right",paddingRight:10,"@media (max-width: 700px)":{paddingRight:20}});ca.propTypes={path:m.string.isRequired,details:m.objectOf(m.shape({path:m.string.isRequired,type:m.oneOf(["directory",
"file"]).isRequired,contentType:m.string,integrity:m.string,size:m.number})).isRequired};fa.propTypes={path:m.string.isRequired,details:m.shape({contentType:m.string.isRequired,highlights:m.arrayOf(m.string),uri:m.string,integrity:m.string.isRequired,language:m.string.isRequired,size:m.number.isRequired}).isRequired};var Ja=c.css(ia(),'\nfont-family: -apple-system,\n  BlinkMacSystemFont,\n  "Segoe UI",\n  "Roboto",\n  "Oxygen",\n  "Ubuntu",\n  "Cantarell",\n  "Fira Sans",\n  "Droid Sans",\n  "Helvetica Neue",\n  sans-serif;\n',
"\nfont-family: Menlo,\n  Monaco,\n  Lucida Console,\n  Liberation Mono,\n  DejaVu Sans Mono,\n  Bitstream Vera Sans Mono,\n  Courier New,\n  monospace;\n"),Ka=c.css(ha()),Wa=m.shape({path:m.string.isRequired,type:m.oneOf(["directory","file"]).isRequired,details:m.object.isRequired});ka.propTypes={packageName:m.string.isRequired,packageVersion:m.string.isRequired,availableVersions:m.arrayOf(m.string),filename:m.string.isRequired,target:Wa.isRequired};A.hydrate(la.createElement(ka,window.__DATA__||
{}),document.getElementById("root"))})(React,ReactDOM,emotionCore);
</script></body></html>