/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gnome-scan
 * Copyright (C) Étienne Bersac 2007 <bersace03@laposte.net>
 * 
 * gnome-scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#include "gnome-scan-range-widget.h"
#include "gnome-scan-param-specs.h"

#define	GET_PRIVATE(o)	(G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_TYPE_SCAN_RANGE_WIDGET, GnomeScanRangeWidgetPrivate))

typedef struct _GnomeScanRangeWidgetPrivate GnomeScanRangeWidgetPrivate;
struct _GnomeScanRangeWidgetPrivate
{
	GtkWidget	*scale;
	GtkWidget	*spin;
	GtkObject	*adj;
};

static void gsrw_range_value_changed (GtkAdjustment *adjustment,
									  GnomeScanRangeWidget *gsrw);

GS_DEFINE_PARAM_WIDGET (GnomeScanRangeWidget, gnome_scan_range_widget);

static void
gnome_scan_range_widget_init (GnomeScanRangeWidget *object)
{
	/* TODO: Add initialization code here */
}

static void
gnome_scan_range_widget_finalize (GObject *object)
{
	/* TODO: Add deinitalization code here */

	G_OBJECT_CLASS (gnome_scan_range_widget_parent_class)->finalize (object);
}

static void
gnome_scan_range_widget_build (GnomeScanParamWidget *gspw)
{
	GnomeScanRangeWidgetPrivate *priv = GET_PRIVATE (gspw);
	GValue *vdouble;
	GSParamSpecRange *spec;
	gdouble value, lower, upper, step;
	
	
	spec = GS_PARAM_SPEC_RANGE (gspw->pspec);
	vdouble = g_new0 (GValue, 1);
	g_value_init (vdouble, G_TYPE_DOUBLE);

#define	GET_DOUBLE(var,val)	g_value_transform ((val),vdouble); var = g_value_get_double (vdouble);
	GET_DOUBLE (value, spec->default_value);
	GET_DOUBLE (lower, spec->minimum);
	GET_DOUBLE (upper, spec->maximum);
	GET_DOUBLE (step, spec->step);
#undef	GET_DOUBLE
	
	priv->adj = gtk_adjustment_new (value, lower, upper,
									step, step, 0);
	priv->scale = gtk_hscale_new (GTK_ADJUSTMENT (priv->adj));
	gtk_scale_set_draw_value (GTK_SCALE (priv->scale), FALSE);
	gtk_box_pack_start (GTK_BOX (gspw), priv->scale, TRUE, TRUE, 0);
	
	priv->spin = gtk_spin_button_new (GTK_ADJUSTMENT (priv->adj), step,
									  G_VALUE_HOLDS_INT (spec->default_value) ? 0 : 2);
	gtk_box_pack_start (GTK_BOX (gspw), priv->spin, FALSE, TRUE, 0);
	
	g_signal_connect (GTK_ADJUSTMENT (priv->adj), "value-changed",
					  (GCallback) gsrw_range_value_changed,
					  GNOME_SCAN_RANGE_WIDGET (gspw));
	
}

static void
gnome_scan_range_widget_set (GnomeScanParamWidget *gspw, GValue *value)
{
	GValue *vdouble = g_new0 (GValue, 1);
	g_value_init (vdouble, G_TYPE_DOUBLE);
	g_value_transform (value, vdouble);
	gtk_adjustment_set_value (GTK_ADJUSTMENT (GET_PRIVATE (gspw)->adj),
							  g_value_get_double (vdouble));
	g_value_unset (vdouble);
	g_free (vdouble);
}

/* INTERNALS */

static void
gsrw_range_value_changed (GtkAdjustment *adjustment, GnomeScanRangeWidget *gsrw)
{
	GnomeScanParamWidget *gspw = GNOME_SCAN_PARAM_WIDGET (gsrw);
	GValue *vdouble = g_new0 (GValue, 1);
	g_value_init (vdouble, G_TYPE_DOUBLE);
	g_value_set_double (vdouble, gtk_adjustment_get_value (adjustment));
	g_value_transform (vdouble, gspw->value);
	g_value_unset (vdouble);
	g_free (vdouble);
	gnome_scan_param_widget_changed (gspw);
}
