#ifndef TRAVERSER_GROEBNERFAN_H_INCLUDED
#define TRAVERSER_GROEBNERFAN_H_INCLUDED

#include "symmetrictraversal.h"
#include "polynomial.h"

/**
 * This routine computes all reduced Groebner bases of the ideal generated by g whose Groebner cone intersects
 * the cone c in maximal dimension.
 */
PolynomialSet groebnerBasisWithFullDimensionalIntersection(PolynomialSet g, PolyhedralCone const &c);

class GroebnerFanTraverser: public ConeTraverser
{
	PolynomialSet groebnerBasis;
	PolyhedralCone theCone;
	PolyhedralCone theRestrictingCone;
	bool isHomogeneous;
	bool isKnownToBeComplete;
	int n,d;
	void updatePolyhedralCone();
public:
	GroebnerFanTraverser(PolynomialSet const &groebnerBasis_);
	GroebnerFanTraverser(PolynomialSet const &groebnerBasis_, PolyhedralCone const &restrictingCone);
	virtual void changeCone(IntegerVector const &ridgeVector, IntegerVector const &rayVector);
	virtual IntegerVectorList link(IntegerVector const &ridgeVector);
	PolyhedralCone & refToPolyhedralCone();
	PolynomialSet &refToGroebnerBasisRepresentation();
	PolynomialSet initialIdeal()const;
	/**
	 * Tells the traverser that the fan to be traversed is complete.
	 */
	void setIsKnownToBeComplete(bool complete);
};

#endif
