// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file keyTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#include "keyTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>
#include "key.hpp"


using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_KeyedShortStruct_type_identifier(
        TypeIdentifierPair& type_ids_KeyedShortStruct)
{

    ReturnCode_t return_code_KeyedShortStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_KeyedShortStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "KeyedShortStruct", type_ids_KeyedShortStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_KeyedShortStruct)
    {
        StructTypeFlag struct_flags_KeyedShortStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_KeyedShortStruct = "KeyedShortStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_KeyedShortStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_KeyedShortStruct;
        CompleteTypeDetail detail_KeyedShortStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_KeyedShortStruct, ann_custom_KeyedShortStruct, type_name_KeyedShortStruct.to_string());
        CompleteStructHeader header_KeyedShortStruct;
        header_KeyedShortStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_KeyedShortStruct);
        CompleteStructMemberSeq member_seq_KeyedShortStruct;
        {
            TypeIdentifierPair type_ids_key_short;
            ReturnCode_t return_code_key_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_key_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_short)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "key_short Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_key_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_short = 0x00000000;
            bool common_key_short_ec {false};
            CommonStructMember common_key_short {TypeObjectUtils::build_common_struct_member(member_id_key_short, member_flags_key_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_short, common_key_short_ec))};
            if (!common_key_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_short = "key_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_short;
            ann_custom_KeyedShortStruct.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_short;
            eprosima::fastcdr::optional<std::string> unit_key_short;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_short;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_short;
            eprosima::fastcdr::optional<std::string> hash_id_key_short;
            if (unit_key_short.has_value() || min_key_short.has_value() || max_key_short.has_value() || hash_id_key_short.has_value())
            {
                member_ann_builtin_key_short = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_short, min_key_short, max_key_short, hash_id_key_short);
            }
            if (!tmp_ann_custom_key_short.empty())
            {
                ann_custom_KeyedShortStruct = tmp_ann_custom_key_short;
            }
            CompleteMemberDetail detail_key_short = TypeObjectUtils::build_complete_member_detail(name_key_short, member_ann_builtin_key_short, ann_custom_KeyedShortStruct);
            CompleteStructMember member_key_short = TypeObjectUtils::build_complete_struct_member(common_key_short, detail_key_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedShortStruct, member_key_short);
        }
        {
            TypeIdentifierPair type_ids_var_short;
            ReturnCode_t return_code_var_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_var_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_short)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_short Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_short = 0x00000001;
            bool common_var_short_ec {false};
            CommonStructMember common_var_short {TypeObjectUtils::build_common_struct_member(member_id_var_short, member_flags_var_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_short, common_var_short_ec))};
            if (!common_var_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_short = "var_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_short;
            ann_custom_KeyedShortStruct.reset();
            CompleteMemberDetail detail_var_short = TypeObjectUtils::build_complete_member_detail(name_var_short, member_ann_builtin_var_short, ann_custom_KeyedShortStruct);
            CompleteStructMember member_var_short = TypeObjectUtils::build_complete_struct_member(common_var_short, detail_var_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedShortStruct, member_var_short);
        }
        CompleteStructType struct_type_KeyedShortStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_KeyedShortStruct, header_KeyedShortStruct, member_seq_KeyedShortStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_KeyedShortStruct, type_name_KeyedShortStruct.to_string(), type_ids_KeyedShortStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "KeyedShortStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_KeyedUShortStruct_type_identifier(
        TypeIdentifierPair& type_ids_KeyedUShortStruct)
{

    ReturnCode_t return_code_KeyedUShortStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_KeyedUShortStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "KeyedUShortStruct", type_ids_KeyedUShortStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_KeyedUShortStruct)
    {
        StructTypeFlag struct_flags_KeyedUShortStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_KeyedUShortStruct = "KeyedUShortStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_KeyedUShortStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_KeyedUShortStruct;
        CompleteTypeDetail detail_KeyedUShortStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_KeyedUShortStruct, ann_custom_KeyedUShortStruct, type_name_KeyedUShortStruct.to_string());
        CompleteStructHeader header_KeyedUShortStruct;
        header_KeyedUShortStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_KeyedUShortStruct);
        CompleteStructMemberSeq member_seq_KeyedUShortStruct;
        {
            TypeIdentifierPair type_ids_key_ushort;
            ReturnCode_t return_code_key_ushort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_ushort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_key_ushort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_ushort)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "key_ushort Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_key_ushort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_ushort = 0x00000000;
            bool common_key_ushort_ec {false};
            CommonStructMember common_key_ushort {TypeObjectUtils::build_common_struct_member(member_id_key_ushort, member_flags_key_ushort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_ushort, common_key_ushort_ec))};
            if (!common_key_ushort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_ushort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_ushort = "key_ushort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_ushort;
            ann_custom_KeyedUShortStruct.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_ushort;
            eprosima::fastcdr::optional<std::string> unit_key_ushort;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_ushort;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_ushort;
            eprosima::fastcdr::optional<std::string> hash_id_key_ushort;
            if (unit_key_ushort.has_value() || min_key_ushort.has_value() || max_key_ushort.has_value() || hash_id_key_ushort.has_value())
            {
                member_ann_builtin_key_ushort = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_ushort, min_key_ushort, max_key_ushort, hash_id_key_ushort);
            }
            if (!tmp_ann_custom_key_ushort.empty())
            {
                ann_custom_KeyedUShortStruct = tmp_ann_custom_key_ushort;
            }
            CompleteMemberDetail detail_key_ushort = TypeObjectUtils::build_complete_member_detail(name_key_ushort, member_ann_builtin_key_ushort, ann_custom_KeyedUShortStruct);
            CompleteStructMember member_key_ushort = TypeObjectUtils::build_complete_struct_member(common_key_ushort, detail_key_ushort);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedUShortStruct, member_key_ushort);
        }
        {
            TypeIdentifierPair type_ids_var_ushort;
            ReturnCode_t return_code_var_ushort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_ushort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_var_ushort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_ushort)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ushort Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_ushort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_ushort = 0x00000001;
            bool common_var_ushort_ec {false};
            CommonStructMember common_var_ushort {TypeObjectUtils::build_common_struct_member(member_id_var_ushort, member_flags_var_ushort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_ushort, common_var_ushort_ec))};
            if (!common_var_ushort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_ushort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_ushort = "var_ushort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_ushort;
            ann_custom_KeyedUShortStruct.reset();
            CompleteMemberDetail detail_var_ushort = TypeObjectUtils::build_complete_member_detail(name_var_ushort, member_ann_builtin_var_ushort, ann_custom_KeyedUShortStruct);
            CompleteStructMember member_var_ushort = TypeObjectUtils::build_complete_struct_member(common_var_ushort, detail_var_ushort);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedUShortStruct, member_var_ushort);
        }
        CompleteStructType struct_type_KeyedUShortStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_KeyedUShortStruct, header_KeyedUShortStruct, member_seq_KeyedUShortStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_KeyedUShortStruct, type_name_KeyedUShortStruct.to_string(), type_ids_KeyedUShortStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "KeyedUShortStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_KeyedLongStruct_type_identifier(
        TypeIdentifierPair& type_ids_KeyedLongStruct)
{

    ReturnCode_t return_code_KeyedLongStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_KeyedLongStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "KeyedLongStruct", type_ids_KeyedLongStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_KeyedLongStruct)
    {
        StructTypeFlag struct_flags_KeyedLongStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_KeyedLongStruct = "KeyedLongStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_KeyedLongStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_KeyedLongStruct;
        CompleteTypeDetail detail_KeyedLongStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_KeyedLongStruct, ann_custom_KeyedLongStruct, type_name_KeyedLongStruct.to_string());
        CompleteStructHeader header_KeyedLongStruct;
        header_KeyedLongStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_KeyedLongStruct);
        CompleteStructMemberSeq member_seq_KeyedLongStruct;
        {
            TypeIdentifierPair type_ids_key_long;
            ReturnCode_t return_code_key_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_key_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "key_long Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_key_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_long = 0x00000000;
            bool common_key_long_ec {false};
            CommonStructMember common_key_long {TypeObjectUtils::build_common_struct_member(member_id_key_long, member_flags_key_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_long, common_key_long_ec))};
            if (!common_key_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_long = "key_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_long;
            ann_custom_KeyedLongStruct.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_long;
            eprosima::fastcdr::optional<std::string> unit_key_long;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_long;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_long;
            eprosima::fastcdr::optional<std::string> hash_id_key_long;
            if (unit_key_long.has_value() || min_key_long.has_value() || max_key_long.has_value() || hash_id_key_long.has_value())
            {
                member_ann_builtin_key_long = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_long, min_key_long, max_key_long, hash_id_key_long);
            }
            if (!tmp_ann_custom_key_long.empty())
            {
                ann_custom_KeyedLongStruct = tmp_ann_custom_key_long;
            }
            CompleteMemberDetail detail_key_long = TypeObjectUtils::build_complete_member_detail(name_key_long, member_ann_builtin_key_long, ann_custom_KeyedLongStruct);
            CompleteStructMember member_key_long = TypeObjectUtils::build_complete_struct_member(common_key_long, detail_key_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedLongStruct, member_key_long);
        }
        {
            TypeIdentifierPair type_ids_var_long;
            ReturnCode_t return_code_var_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_var_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_long Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_long = 0x00000001;
            bool common_var_long_ec {false};
            CommonStructMember common_var_long {TypeObjectUtils::build_common_struct_member(member_id_var_long, member_flags_var_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_long, common_var_long_ec))};
            if (!common_var_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_long = "var_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_long;
            ann_custom_KeyedLongStruct.reset();
            CompleteMemberDetail detail_var_long = TypeObjectUtils::build_complete_member_detail(name_var_long, member_ann_builtin_var_long, ann_custom_KeyedLongStruct);
            CompleteStructMember member_var_long = TypeObjectUtils::build_complete_struct_member(common_var_long, detail_var_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedLongStruct, member_var_long);
        }
        CompleteStructType struct_type_KeyedLongStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_KeyedLongStruct, header_KeyedLongStruct, member_seq_KeyedLongStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_KeyedLongStruct, type_name_KeyedLongStruct.to_string(), type_ids_KeyedLongStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "KeyedLongStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_KeyedULongStruct_type_identifier(
        TypeIdentifierPair& type_ids_KeyedULongStruct)
{

    ReturnCode_t return_code_KeyedULongStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_KeyedULongStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "KeyedULongStruct", type_ids_KeyedULongStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_KeyedULongStruct)
    {
        StructTypeFlag struct_flags_KeyedULongStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_KeyedULongStruct = "KeyedULongStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_KeyedULongStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_KeyedULongStruct;
        CompleteTypeDetail detail_KeyedULongStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_KeyedULongStruct, ann_custom_KeyedULongStruct, type_name_KeyedULongStruct.to_string());
        CompleteStructHeader header_KeyedULongStruct;
        header_KeyedULongStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_KeyedULongStruct);
        CompleteStructMemberSeq member_seq_KeyedULongStruct;
        {
            TypeIdentifierPair type_ids_key_ulong;
            ReturnCode_t return_code_key_ulong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_ulong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_key_ulong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_ulong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "key_ulong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_key_ulong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_ulong = 0x00000000;
            bool common_key_ulong_ec {false};
            CommonStructMember common_key_ulong {TypeObjectUtils::build_common_struct_member(member_id_key_ulong, member_flags_key_ulong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_ulong, common_key_ulong_ec))};
            if (!common_key_ulong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_ulong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_ulong = "key_ulong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_ulong;
            ann_custom_KeyedULongStruct.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_ulong;
            eprosima::fastcdr::optional<std::string> unit_key_ulong;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_ulong;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_ulong;
            eprosima::fastcdr::optional<std::string> hash_id_key_ulong;
            if (unit_key_ulong.has_value() || min_key_ulong.has_value() || max_key_ulong.has_value() || hash_id_key_ulong.has_value())
            {
                member_ann_builtin_key_ulong = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_ulong, min_key_ulong, max_key_ulong, hash_id_key_ulong);
            }
            if (!tmp_ann_custom_key_ulong.empty())
            {
                ann_custom_KeyedULongStruct = tmp_ann_custom_key_ulong;
            }
            CompleteMemberDetail detail_key_ulong = TypeObjectUtils::build_complete_member_detail(name_key_ulong, member_ann_builtin_key_ulong, ann_custom_KeyedULongStruct);
            CompleteStructMember member_key_ulong = TypeObjectUtils::build_complete_struct_member(common_key_ulong, detail_key_ulong);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedULongStruct, member_key_ulong);
        }
        {
            TypeIdentifierPair type_ids_var_ulong;
            ReturnCode_t return_code_var_ulong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_ulong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_var_ulong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_ulong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ulong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_ulong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_ulong = 0x00000001;
            bool common_var_ulong_ec {false};
            CommonStructMember common_var_ulong {TypeObjectUtils::build_common_struct_member(member_id_var_ulong, member_flags_var_ulong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_ulong, common_var_ulong_ec))};
            if (!common_var_ulong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_ulong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_ulong = "var_ulong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_ulong;
            ann_custom_KeyedULongStruct.reset();
            CompleteMemberDetail detail_var_ulong = TypeObjectUtils::build_complete_member_detail(name_var_ulong, member_ann_builtin_var_ulong, ann_custom_KeyedULongStruct);
            CompleteStructMember member_var_ulong = TypeObjectUtils::build_complete_struct_member(common_var_ulong, detail_var_ulong);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedULongStruct, member_var_ulong);
        }
        CompleteStructType struct_type_KeyedULongStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_KeyedULongStruct, header_KeyedULongStruct, member_seq_KeyedULongStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_KeyedULongStruct, type_name_KeyedULongStruct.to_string(), type_ids_KeyedULongStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "KeyedULongStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_KeyedLongLongStruct_type_identifier(
        TypeIdentifierPair& type_ids_KeyedLongLongStruct)
{

    ReturnCode_t return_code_KeyedLongLongStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_KeyedLongLongStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "KeyedLongLongStruct", type_ids_KeyedLongLongStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_KeyedLongLongStruct)
    {
        StructTypeFlag struct_flags_KeyedLongLongStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_KeyedLongLongStruct = "KeyedLongLongStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_KeyedLongLongStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_KeyedLongLongStruct;
        CompleteTypeDetail detail_KeyedLongLongStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_KeyedLongLongStruct, ann_custom_KeyedLongLongStruct, type_name_KeyedLongLongStruct.to_string());
        CompleteStructHeader header_KeyedLongLongStruct;
        header_KeyedLongLongStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_KeyedLongLongStruct);
        CompleteStructMemberSeq member_seq_KeyedLongLongStruct;
        {
            TypeIdentifierPair type_ids_key_longlong;
            ReturnCode_t return_code_key_longlong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_longlong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_key_longlong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_longlong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "key_longlong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_key_longlong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_longlong = 0x00000000;
            bool common_key_longlong_ec {false};
            CommonStructMember common_key_longlong {TypeObjectUtils::build_common_struct_member(member_id_key_longlong, member_flags_key_longlong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_longlong, common_key_longlong_ec))};
            if (!common_key_longlong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_longlong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_longlong = "key_longlong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_longlong;
            ann_custom_KeyedLongLongStruct.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_longlong;
            eprosima::fastcdr::optional<std::string> unit_key_longlong;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_longlong;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_longlong;
            eprosima::fastcdr::optional<std::string> hash_id_key_longlong;
            if (unit_key_longlong.has_value() || min_key_longlong.has_value() || max_key_longlong.has_value() || hash_id_key_longlong.has_value())
            {
                member_ann_builtin_key_longlong = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_longlong, min_key_longlong, max_key_longlong, hash_id_key_longlong);
            }
            if (!tmp_ann_custom_key_longlong.empty())
            {
                ann_custom_KeyedLongLongStruct = tmp_ann_custom_key_longlong;
            }
            CompleteMemberDetail detail_key_longlong = TypeObjectUtils::build_complete_member_detail(name_key_longlong, member_ann_builtin_key_longlong, ann_custom_KeyedLongLongStruct);
            CompleteStructMember member_key_longlong = TypeObjectUtils::build_complete_struct_member(common_key_longlong, detail_key_longlong);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedLongLongStruct, member_key_longlong);
        }
        {
            TypeIdentifierPair type_ids_var_longlong;
            ReturnCode_t return_code_var_longlong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_longlong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_var_longlong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_longlong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_longlong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_longlong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_longlong = 0x00000001;
            bool common_var_longlong_ec {false};
            CommonStructMember common_var_longlong {TypeObjectUtils::build_common_struct_member(member_id_var_longlong, member_flags_var_longlong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_longlong, common_var_longlong_ec))};
            if (!common_var_longlong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_longlong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_longlong = "var_longlong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_longlong;
            ann_custom_KeyedLongLongStruct.reset();
            CompleteMemberDetail detail_var_longlong = TypeObjectUtils::build_complete_member_detail(name_var_longlong, member_ann_builtin_var_longlong, ann_custom_KeyedLongLongStruct);
            CompleteStructMember member_var_longlong = TypeObjectUtils::build_complete_struct_member(common_var_longlong, detail_var_longlong);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedLongLongStruct, member_var_longlong);
        }
        CompleteStructType struct_type_KeyedLongLongStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_KeyedLongLongStruct, header_KeyedLongLongStruct, member_seq_KeyedLongLongStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_KeyedLongLongStruct, type_name_KeyedLongLongStruct.to_string(), type_ids_KeyedLongLongStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "KeyedLongLongStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_KeyedULongLongStruct_type_identifier(
        TypeIdentifierPair& type_ids_KeyedULongLongStruct)
{

    ReturnCode_t return_code_KeyedULongLongStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_KeyedULongLongStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "KeyedULongLongStruct", type_ids_KeyedULongLongStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_KeyedULongLongStruct)
    {
        StructTypeFlag struct_flags_KeyedULongLongStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_KeyedULongLongStruct = "KeyedULongLongStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_KeyedULongLongStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_KeyedULongLongStruct;
        CompleteTypeDetail detail_KeyedULongLongStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_KeyedULongLongStruct, ann_custom_KeyedULongLongStruct, type_name_KeyedULongLongStruct.to_string());
        CompleteStructHeader header_KeyedULongLongStruct;
        header_KeyedULongLongStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_KeyedULongLongStruct);
        CompleteStructMemberSeq member_seq_KeyedULongLongStruct;
        {
            TypeIdentifierPair type_ids_key_ulonglong;
            ReturnCode_t return_code_key_ulonglong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_ulonglong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_key_ulonglong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_ulonglong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "key_ulonglong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_key_ulonglong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_ulonglong = 0x00000000;
            bool common_key_ulonglong_ec {false};
            CommonStructMember common_key_ulonglong {TypeObjectUtils::build_common_struct_member(member_id_key_ulonglong, member_flags_key_ulonglong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_ulonglong, common_key_ulonglong_ec))};
            if (!common_key_ulonglong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_ulonglong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_ulonglong = "key_ulonglong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_ulonglong;
            ann_custom_KeyedULongLongStruct.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_ulonglong;
            eprosima::fastcdr::optional<std::string> unit_key_ulonglong;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_ulonglong;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_ulonglong;
            eprosima::fastcdr::optional<std::string> hash_id_key_ulonglong;
            if (unit_key_ulonglong.has_value() || min_key_ulonglong.has_value() || max_key_ulonglong.has_value() || hash_id_key_ulonglong.has_value())
            {
                member_ann_builtin_key_ulonglong = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_ulonglong, min_key_ulonglong, max_key_ulonglong, hash_id_key_ulonglong);
            }
            if (!tmp_ann_custom_key_ulonglong.empty())
            {
                ann_custom_KeyedULongLongStruct = tmp_ann_custom_key_ulonglong;
            }
            CompleteMemberDetail detail_key_ulonglong = TypeObjectUtils::build_complete_member_detail(name_key_ulonglong, member_ann_builtin_key_ulonglong, ann_custom_KeyedULongLongStruct);
            CompleteStructMember member_key_ulonglong = TypeObjectUtils::build_complete_struct_member(common_key_ulonglong, detail_key_ulonglong);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedULongLongStruct, member_key_ulonglong);
        }
        {
            TypeIdentifierPair type_ids_var_ulonglong;
            ReturnCode_t return_code_var_ulonglong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_ulonglong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_var_ulonglong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_ulonglong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ulonglong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_ulonglong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_ulonglong = 0x00000001;
            bool common_var_ulonglong_ec {false};
            CommonStructMember common_var_ulonglong {TypeObjectUtils::build_common_struct_member(member_id_var_ulonglong, member_flags_var_ulonglong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_ulonglong, common_var_ulonglong_ec))};
            if (!common_var_ulonglong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_ulonglong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_ulonglong = "var_ulonglong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_ulonglong;
            ann_custom_KeyedULongLongStruct.reset();
            CompleteMemberDetail detail_var_ulonglong = TypeObjectUtils::build_complete_member_detail(name_var_ulonglong, member_ann_builtin_var_ulonglong, ann_custom_KeyedULongLongStruct);
            CompleteStructMember member_var_ulonglong = TypeObjectUtils::build_complete_struct_member(common_var_ulonglong, detail_var_ulonglong);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedULongLongStruct, member_var_ulonglong);
        }
        CompleteStructType struct_type_KeyedULongLongStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_KeyedULongLongStruct, header_KeyedULongLongStruct, member_seq_KeyedULongLongStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_KeyedULongLongStruct, type_name_KeyedULongLongStruct.to_string(), type_ids_KeyedULongLongStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "KeyedULongLongStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_KeyedFloatStruct_type_identifier(
        TypeIdentifierPair& type_ids_KeyedFloatStruct)
{

    ReturnCode_t return_code_KeyedFloatStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_KeyedFloatStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "KeyedFloatStruct", type_ids_KeyedFloatStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_KeyedFloatStruct)
    {
        StructTypeFlag struct_flags_KeyedFloatStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_KeyedFloatStruct = "KeyedFloatStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_KeyedFloatStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_KeyedFloatStruct;
        CompleteTypeDetail detail_KeyedFloatStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_KeyedFloatStruct, ann_custom_KeyedFloatStruct, type_name_KeyedFloatStruct.to_string());
        CompleteStructHeader header_KeyedFloatStruct;
        header_KeyedFloatStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_KeyedFloatStruct);
        CompleteStructMemberSeq member_seq_KeyedFloatStruct;
        {
            TypeIdentifierPair type_ids_key_float;
            ReturnCode_t return_code_key_float {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_float =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_float", type_ids_key_float);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_float)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "key_float Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_key_float = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_float = 0x00000000;
            bool common_key_float_ec {false};
            CommonStructMember common_key_float {TypeObjectUtils::build_common_struct_member(member_id_key_float, member_flags_key_float, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_float, common_key_float_ec))};
            if (!common_key_float_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_float member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_float = "key_float";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_float;
            ann_custom_KeyedFloatStruct.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_float;
            eprosima::fastcdr::optional<std::string> unit_key_float;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_float;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_float;
            eprosima::fastcdr::optional<std::string> hash_id_key_float;
            if (unit_key_float.has_value() || min_key_float.has_value() || max_key_float.has_value() || hash_id_key_float.has_value())
            {
                member_ann_builtin_key_float = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_float, min_key_float, max_key_float, hash_id_key_float);
            }
            if (!tmp_ann_custom_key_float.empty())
            {
                ann_custom_KeyedFloatStruct = tmp_ann_custom_key_float;
            }
            CompleteMemberDetail detail_key_float = TypeObjectUtils::build_complete_member_detail(name_key_float, member_ann_builtin_key_float, ann_custom_KeyedFloatStruct);
            CompleteStructMember member_key_float = TypeObjectUtils::build_complete_struct_member(common_key_float, detail_key_float);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedFloatStruct, member_key_float);
        }
        {
            TypeIdentifierPair type_ids_var_float;
            ReturnCode_t return_code_var_float {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_float =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_float", type_ids_var_float);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_float)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_float Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_float = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_float = 0x00000001;
            bool common_var_float_ec {false};
            CommonStructMember common_var_float {TypeObjectUtils::build_common_struct_member(member_id_var_float, member_flags_var_float, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_float, common_var_float_ec))};
            if (!common_var_float_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_float member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_float = "var_float";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_float;
            ann_custom_KeyedFloatStruct.reset();
            CompleteMemberDetail detail_var_float = TypeObjectUtils::build_complete_member_detail(name_var_float, member_ann_builtin_var_float, ann_custom_KeyedFloatStruct);
            CompleteStructMember member_var_float = TypeObjectUtils::build_complete_struct_member(common_var_float, detail_var_float);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedFloatStruct, member_var_float);
        }
        CompleteStructType struct_type_KeyedFloatStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_KeyedFloatStruct, header_KeyedFloatStruct, member_seq_KeyedFloatStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_KeyedFloatStruct, type_name_KeyedFloatStruct.to_string(), type_ids_KeyedFloatStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "KeyedFloatStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_KeyedDoubleStruct_type_identifier(
        TypeIdentifierPair& type_ids_KeyedDoubleStruct)
{

    ReturnCode_t return_code_KeyedDoubleStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_KeyedDoubleStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "KeyedDoubleStruct", type_ids_KeyedDoubleStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_KeyedDoubleStruct)
    {
        StructTypeFlag struct_flags_KeyedDoubleStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_KeyedDoubleStruct = "KeyedDoubleStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_KeyedDoubleStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_KeyedDoubleStruct;
        CompleteTypeDetail detail_KeyedDoubleStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_KeyedDoubleStruct, ann_custom_KeyedDoubleStruct, type_name_KeyedDoubleStruct.to_string());
        CompleteStructHeader header_KeyedDoubleStruct;
        header_KeyedDoubleStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_KeyedDoubleStruct);
        CompleteStructMemberSeq member_seq_KeyedDoubleStruct;
        {
            TypeIdentifierPair type_ids_key_double;
            ReturnCode_t return_code_key_double {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_double =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_double", type_ids_key_double);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_double)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "key_double Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_key_double = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_double = 0x00000000;
            bool common_key_double_ec {false};
            CommonStructMember common_key_double {TypeObjectUtils::build_common_struct_member(member_id_key_double, member_flags_key_double, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_double, common_key_double_ec))};
            if (!common_key_double_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_double member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_double = "key_double";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_double;
            ann_custom_KeyedDoubleStruct.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_double;
            eprosima::fastcdr::optional<std::string> unit_key_double;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_double;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_double;
            eprosima::fastcdr::optional<std::string> hash_id_key_double;
            if (unit_key_double.has_value() || min_key_double.has_value() || max_key_double.has_value() || hash_id_key_double.has_value())
            {
                member_ann_builtin_key_double = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_double, min_key_double, max_key_double, hash_id_key_double);
            }
            if (!tmp_ann_custom_key_double.empty())
            {
                ann_custom_KeyedDoubleStruct = tmp_ann_custom_key_double;
            }
            CompleteMemberDetail detail_key_double = TypeObjectUtils::build_complete_member_detail(name_key_double, member_ann_builtin_key_double, ann_custom_KeyedDoubleStruct);
            CompleteStructMember member_key_double = TypeObjectUtils::build_complete_struct_member(common_key_double, detail_key_double);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedDoubleStruct, member_key_double);
        }
        {
            TypeIdentifierPair type_ids_var_double;
            ReturnCode_t return_code_var_double {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_double =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_double", type_ids_var_double);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_double)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_double Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_double = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_double = 0x00000001;
            bool common_var_double_ec {false};
            CommonStructMember common_var_double {TypeObjectUtils::build_common_struct_member(member_id_var_double, member_flags_var_double, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_double, common_var_double_ec))};
            if (!common_var_double_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_double member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_double = "var_double";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_double;
            ann_custom_KeyedDoubleStruct.reset();
            CompleteMemberDetail detail_var_double = TypeObjectUtils::build_complete_member_detail(name_var_double, member_ann_builtin_var_double, ann_custom_KeyedDoubleStruct);
            CompleteStructMember member_var_double = TypeObjectUtils::build_complete_struct_member(common_var_double, detail_var_double);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedDoubleStruct, member_var_double);
        }
        CompleteStructType struct_type_KeyedDoubleStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_KeyedDoubleStruct, header_KeyedDoubleStruct, member_seq_KeyedDoubleStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_KeyedDoubleStruct, type_name_KeyedDoubleStruct.to_string(), type_ids_KeyedDoubleStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "KeyedDoubleStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_KeyedLongDoubleStruct_type_identifier(
        TypeIdentifierPair& type_ids_KeyedLongDoubleStruct)
{

    ReturnCode_t return_code_KeyedLongDoubleStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_KeyedLongDoubleStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "KeyedLongDoubleStruct", type_ids_KeyedLongDoubleStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_KeyedLongDoubleStruct)
    {
        StructTypeFlag struct_flags_KeyedLongDoubleStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_KeyedLongDoubleStruct = "KeyedLongDoubleStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_KeyedLongDoubleStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_KeyedLongDoubleStruct;
        CompleteTypeDetail detail_KeyedLongDoubleStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_KeyedLongDoubleStruct, ann_custom_KeyedLongDoubleStruct, type_name_KeyedLongDoubleStruct.to_string());
        CompleteStructHeader header_KeyedLongDoubleStruct;
        header_KeyedLongDoubleStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_KeyedLongDoubleStruct);
        CompleteStructMemberSeq member_seq_KeyedLongDoubleStruct;
        {
            TypeIdentifierPair type_ids_key_longdouble;
            ReturnCode_t return_code_key_longdouble {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_longdouble =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_longdouble", type_ids_key_longdouble);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_longdouble)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "key_longdouble Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_key_longdouble = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_longdouble = 0x00000000;
            bool common_key_longdouble_ec {false};
            CommonStructMember common_key_longdouble {TypeObjectUtils::build_common_struct_member(member_id_key_longdouble, member_flags_key_longdouble, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_longdouble, common_key_longdouble_ec))};
            if (!common_key_longdouble_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_longdouble member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_longdouble = "key_longdouble";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_longdouble;
            ann_custom_KeyedLongDoubleStruct.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_longdouble;
            eprosima::fastcdr::optional<std::string> unit_key_longdouble;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_longdouble;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_longdouble;
            eprosima::fastcdr::optional<std::string> hash_id_key_longdouble;
            if (unit_key_longdouble.has_value() || min_key_longdouble.has_value() || max_key_longdouble.has_value() || hash_id_key_longdouble.has_value())
            {
                member_ann_builtin_key_longdouble = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_longdouble, min_key_longdouble, max_key_longdouble, hash_id_key_longdouble);
            }
            if (!tmp_ann_custom_key_longdouble.empty())
            {
                ann_custom_KeyedLongDoubleStruct = tmp_ann_custom_key_longdouble;
            }
            CompleteMemberDetail detail_key_longdouble = TypeObjectUtils::build_complete_member_detail(name_key_longdouble, member_ann_builtin_key_longdouble, ann_custom_KeyedLongDoubleStruct);
            CompleteStructMember member_key_longdouble = TypeObjectUtils::build_complete_struct_member(common_key_longdouble, detail_key_longdouble);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedLongDoubleStruct, member_key_longdouble);
        }
        {
            TypeIdentifierPair type_ids_var_longdouble;
            ReturnCode_t return_code_var_longdouble {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_longdouble =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_longdouble", type_ids_var_longdouble);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_longdouble)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_longdouble Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_longdouble = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_longdouble = 0x00000001;
            bool common_var_longdouble_ec {false};
            CommonStructMember common_var_longdouble {TypeObjectUtils::build_common_struct_member(member_id_var_longdouble, member_flags_var_longdouble, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_longdouble, common_var_longdouble_ec))};
            if (!common_var_longdouble_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_longdouble member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_longdouble = "var_longdouble";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_longdouble;
            ann_custom_KeyedLongDoubleStruct.reset();
            CompleteMemberDetail detail_var_longdouble = TypeObjectUtils::build_complete_member_detail(name_var_longdouble, member_ann_builtin_var_longdouble, ann_custom_KeyedLongDoubleStruct);
            CompleteStructMember member_var_longdouble = TypeObjectUtils::build_complete_struct_member(common_var_longdouble, detail_var_longdouble);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedLongDoubleStruct, member_var_longdouble);
        }
        CompleteStructType struct_type_KeyedLongDoubleStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_KeyedLongDoubleStruct, header_KeyedLongDoubleStruct, member_seq_KeyedLongDoubleStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_KeyedLongDoubleStruct, type_name_KeyedLongDoubleStruct.to_string(), type_ids_KeyedLongDoubleStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "KeyedLongDoubleStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_KeyedBooleanStruct_type_identifier(
        TypeIdentifierPair& type_ids_KeyedBooleanStruct)
{

    ReturnCode_t return_code_KeyedBooleanStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_KeyedBooleanStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "KeyedBooleanStruct", type_ids_KeyedBooleanStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_KeyedBooleanStruct)
    {
        StructTypeFlag struct_flags_KeyedBooleanStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_KeyedBooleanStruct = "KeyedBooleanStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_KeyedBooleanStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_KeyedBooleanStruct;
        CompleteTypeDetail detail_KeyedBooleanStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_KeyedBooleanStruct, ann_custom_KeyedBooleanStruct, type_name_KeyedBooleanStruct.to_string());
        CompleteStructHeader header_KeyedBooleanStruct;
        header_KeyedBooleanStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_KeyedBooleanStruct);
        CompleteStructMemberSeq member_seq_KeyedBooleanStruct;
        {
            TypeIdentifierPair type_ids_key_boolean;
            ReturnCode_t return_code_key_boolean {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_key_boolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_boolean)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "key_boolean Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_key_boolean = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_boolean = 0x00000000;
            bool common_key_boolean_ec {false};
            CommonStructMember common_key_boolean {TypeObjectUtils::build_common_struct_member(member_id_key_boolean, member_flags_key_boolean, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_boolean, common_key_boolean_ec))};
            if (!common_key_boolean_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_boolean member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_boolean = "key_boolean";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_boolean;
            ann_custom_KeyedBooleanStruct.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_boolean;
            eprosima::fastcdr::optional<std::string> unit_key_boolean;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_boolean;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_boolean;
            eprosima::fastcdr::optional<std::string> hash_id_key_boolean;
            if (unit_key_boolean.has_value() || min_key_boolean.has_value() || max_key_boolean.has_value() || hash_id_key_boolean.has_value())
            {
                member_ann_builtin_key_boolean = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_boolean, min_key_boolean, max_key_boolean, hash_id_key_boolean);
            }
            if (!tmp_ann_custom_key_boolean.empty())
            {
                ann_custom_KeyedBooleanStruct = tmp_ann_custom_key_boolean;
            }
            CompleteMemberDetail detail_key_boolean = TypeObjectUtils::build_complete_member_detail(name_key_boolean, member_ann_builtin_key_boolean, ann_custom_KeyedBooleanStruct);
            CompleteStructMember member_key_boolean = TypeObjectUtils::build_complete_struct_member(common_key_boolean, detail_key_boolean);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedBooleanStruct, member_key_boolean);
        }
        {
            TypeIdentifierPair type_ids_var_boolean;
            ReturnCode_t return_code_var_boolean {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_var_boolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_boolean)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_boolean Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_boolean = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_boolean = 0x00000001;
            bool common_var_boolean_ec {false};
            CommonStructMember common_var_boolean {TypeObjectUtils::build_common_struct_member(member_id_var_boolean, member_flags_var_boolean, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_boolean, common_var_boolean_ec))};
            if (!common_var_boolean_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_boolean member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_boolean = "var_boolean";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_boolean;
            ann_custom_KeyedBooleanStruct.reset();
            CompleteMemberDetail detail_var_boolean = TypeObjectUtils::build_complete_member_detail(name_var_boolean, member_ann_builtin_var_boolean, ann_custom_KeyedBooleanStruct);
            CompleteStructMember member_var_boolean = TypeObjectUtils::build_complete_struct_member(common_var_boolean, detail_var_boolean);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedBooleanStruct, member_var_boolean);
        }
        CompleteStructType struct_type_KeyedBooleanStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_KeyedBooleanStruct, header_KeyedBooleanStruct, member_seq_KeyedBooleanStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_KeyedBooleanStruct, type_name_KeyedBooleanStruct.to_string(), type_ids_KeyedBooleanStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "KeyedBooleanStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_KeyedOctetStruct_type_identifier(
        TypeIdentifierPair& type_ids_KeyedOctetStruct)
{

    ReturnCode_t return_code_KeyedOctetStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_KeyedOctetStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "KeyedOctetStruct", type_ids_KeyedOctetStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_KeyedOctetStruct)
    {
        StructTypeFlag struct_flags_KeyedOctetStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_KeyedOctetStruct = "KeyedOctetStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_KeyedOctetStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_KeyedOctetStruct;
        CompleteTypeDetail detail_KeyedOctetStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_KeyedOctetStruct, ann_custom_KeyedOctetStruct, type_name_KeyedOctetStruct.to_string());
        CompleteStructHeader header_KeyedOctetStruct;
        header_KeyedOctetStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_KeyedOctetStruct);
        CompleteStructMemberSeq member_seq_KeyedOctetStruct;
        {
            TypeIdentifierPair type_ids_key_octet;
            ReturnCode_t return_code_key_octet {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_key_octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_octet)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "key_octet Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_key_octet = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_octet = 0x00000000;
            bool common_key_octet_ec {false};
            CommonStructMember common_key_octet {TypeObjectUtils::build_common_struct_member(member_id_key_octet, member_flags_key_octet, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_octet, common_key_octet_ec))};
            if (!common_key_octet_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_octet member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_octet = "key_octet";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_octet;
            ann_custom_KeyedOctetStruct.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_octet;
            eprosima::fastcdr::optional<std::string> unit_key_octet;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_octet;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_octet;
            eprosima::fastcdr::optional<std::string> hash_id_key_octet;
            if (unit_key_octet.has_value() || min_key_octet.has_value() || max_key_octet.has_value() || hash_id_key_octet.has_value())
            {
                member_ann_builtin_key_octet = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_octet, min_key_octet, max_key_octet, hash_id_key_octet);
            }
            if (!tmp_ann_custom_key_octet.empty())
            {
                ann_custom_KeyedOctetStruct = tmp_ann_custom_key_octet;
            }
            CompleteMemberDetail detail_key_octet = TypeObjectUtils::build_complete_member_detail(name_key_octet, member_ann_builtin_key_octet, ann_custom_KeyedOctetStruct);
            CompleteStructMember member_key_octet = TypeObjectUtils::build_complete_struct_member(common_key_octet, detail_key_octet);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedOctetStruct, member_key_octet);
        }
        {
            TypeIdentifierPair type_ids_var_octet;
            ReturnCode_t return_code_var_octet {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_var_octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_octet)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_octet Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_octet = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_octet = 0x00000001;
            bool common_var_octet_ec {false};
            CommonStructMember common_var_octet {TypeObjectUtils::build_common_struct_member(member_id_var_octet, member_flags_var_octet, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_octet, common_var_octet_ec))};
            if (!common_var_octet_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_octet member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_octet = "var_octet";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_octet;
            ann_custom_KeyedOctetStruct.reset();
            CompleteMemberDetail detail_var_octet = TypeObjectUtils::build_complete_member_detail(name_var_octet, member_ann_builtin_var_octet, ann_custom_KeyedOctetStruct);
            CompleteStructMember member_var_octet = TypeObjectUtils::build_complete_struct_member(common_var_octet, detail_var_octet);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedOctetStruct, member_var_octet);
        }
        CompleteStructType struct_type_KeyedOctetStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_KeyedOctetStruct, header_KeyedOctetStruct, member_seq_KeyedOctetStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_KeyedOctetStruct, type_name_KeyedOctetStruct.to_string(), type_ids_KeyedOctetStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "KeyedOctetStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_KeyedCharStruct_type_identifier(
        TypeIdentifierPair& type_ids_KeyedCharStruct)
{

    ReturnCode_t return_code_KeyedCharStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_KeyedCharStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "KeyedCharStruct", type_ids_KeyedCharStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_KeyedCharStruct)
    {
        StructTypeFlag struct_flags_KeyedCharStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_KeyedCharStruct = "KeyedCharStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_KeyedCharStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_KeyedCharStruct;
        CompleteTypeDetail detail_KeyedCharStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_KeyedCharStruct, ann_custom_KeyedCharStruct, type_name_KeyedCharStruct.to_string());
        CompleteStructHeader header_KeyedCharStruct;
        header_KeyedCharStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_KeyedCharStruct);
        CompleteStructMemberSeq member_seq_KeyedCharStruct;
        {
            TypeIdentifierPair type_ids_key_char8;
            ReturnCode_t return_code_key_char8 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_char8 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_key_char8);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_char8)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "key_char8 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_key_char8 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_char8 = 0x00000000;
            bool common_key_char8_ec {false};
            CommonStructMember common_key_char8 {TypeObjectUtils::build_common_struct_member(member_id_key_char8, member_flags_key_char8, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_char8, common_key_char8_ec))};
            if (!common_key_char8_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_char8 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_char8 = "key_char8";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_char8;
            ann_custom_KeyedCharStruct.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_char8;
            eprosima::fastcdr::optional<std::string> unit_key_char8;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_char8;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_char8;
            eprosima::fastcdr::optional<std::string> hash_id_key_char8;
            if (unit_key_char8.has_value() || min_key_char8.has_value() || max_key_char8.has_value() || hash_id_key_char8.has_value())
            {
                member_ann_builtin_key_char8 = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_char8, min_key_char8, max_key_char8, hash_id_key_char8);
            }
            if (!tmp_ann_custom_key_char8.empty())
            {
                ann_custom_KeyedCharStruct = tmp_ann_custom_key_char8;
            }
            CompleteMemberDetail detail_key_char8 = TypeObjectUtils::build_complete_member_detail(name_key_char8, member_ann_builtin_key_char8, ann_custom_KeyedCharStruct);
            CompleteStructMember member_key_char8 = TypeObjectUtils::build_complete_struct_member(common_key_char8, detail_key_char8);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedCharStruct, member_key_char8);
        }
        {
            TypeIdentifierPair type_ids_var_char8;
            ReturnCode_t return_code_var_char8 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_char8 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_var_char8);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_char8)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_char8 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_char8 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_char8 = 0x00000001;
            bool common_var_char8_ec {false};
            CommonStructMember common_var_char8 {TypeObjectUtils::build_common_struct_member(member_id_var_char8, member_flags_var_char8, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_char8, common_var_char8_ec))};
            if (!common_var_char8_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_char8 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_char8 = "var_char8";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_char8;
            ann_custom_KeyedCharStruct.reset();
            CompleteMemberDetail detail_var_char8 = TypeObjectUtils::build_complete_member_detail(name_var_char8, member_ann_builtin_var_char8, ann_custom_KeyedCharStruct);
            CompleteStructMember member_var_char8 = TypeObjectUtils::build_complete_struct_member(common_var_char8, detail_var_char8);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedCharStruct, member_var_char8);
        }
        CompleteStructType struct_type_KeyedCharStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_KeyedCharStruct, header_KeyedCharStruct, member_seq_KeyedCharStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_KeyedCharStruct, type_name_KeyedCharStruct.to_string(), type_ids_KeyedCharStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "KeyedCharStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_KeyedWCharStruct_type_identifier(
        TypeIdentifierPair& type_ids_KeyedWCharStruct)
{

    ReturnCode_t return_code_KeyedWCharStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_KeyedWCharStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "KeyedWCharStruct", type_ids_KeyedWCharStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_KeyedWCharStruct)
    {
        StructTypeFlag struct_flags_KeyedWCharStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_KeyedWCharStruct = "KeyedWCharStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_KeyedWCharStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_KeyedWCharStruct;
        CompleteTypeDetail detail_KeyedWCharStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_KeyedWCharStruct, ann_custom_KeyedWCharStruct, type_name_KeyedWCharStruct.to_string());
        CompleteStructHeader header_KeyedWCharStruct;
        header_KeyedWCharStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_KeyedWCharStruct);
        CompleteStructMemberSeq member_seq_KeyedWCharStruct;
        {
            TypeIdentifierPair type_ids_key_char16;
            ReturnCode_t return_code_key_char16 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_char16 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_wchar_t", type_ids_key_char16);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_char16)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "key_char16 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_key_char16 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_char16 = 0x00000000;
            bool common_key_char16_ec {false};
            CommonStructMember common_key_char16 {TypeObjectUtils::build_common_struct_member(member_id_key_char16, member_flags_key_char16, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_char16, common_key_char16_ec))};
            if (!common_key_char16_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_char16 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_char16 = "key_char16";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_char16;
            ann_custom_KeyedWCharStruct.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_char16;
            eprosima::fastcdr::optional<std::string> unit_key_char16;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_char16;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_char16;
            eprosima::fastcdr::optional<std::string> hash_id_key_char16;
            if (unit_key_char16.has_value() || min_key_char16.has_value() || max_key_char16.has_value() || hash_id_key_char16.has_value())
            {
                member_ann_builtin_key_char16 = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_char16, min_key_char16, max_key_char16, hash_id_key_char16);
            }
            if (!tmp_ann_custom_key_char16.empty())
            {
                ann_custom_KeyedWCharStruct = tmp_ann_custom_key_char16;
            }
            CompleteMemberDetail detail_key_char16 = TypeObjectUtils::build_complete_member_detail(name_key_char16, member_ann_builtin_key_char16, ann_custom_KeyedWCharStruct);
            CompleteStructMember member_key_char16 = TypeObjectUtils::build_complete_struct_member(common_key_char16, detail_key_char16);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedWCharStruct, member_key_char16);
        }
        {
            TypeIdentifierPair type_ids_var_char16;
            ReturnCode_t return_code_var_char16 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_char16 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_wchar_t", type_ids_var_char16);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_char16)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_char16 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_char16 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_char16 = 0x00000001;
            bool common_var_char16_ec {false};
            CommonStructMember common_var_char16 {TypeObjectUtils::build_common_struct_member(member_id_var_char16, member_flags_var_char16, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_char16, common_var_char16_ec))};
            if (!common_var_char16_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_char16 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_char16 = "var_char16";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_char16;
            ann_custom_KeyedWCharStruct.reset();
            CompleteMemberDetail detail_var_char16 = TypeObjectUtils::build_complete_member_detail(name_var_char16, member_ann_builtin_var_char16, ann_custom_KeyedWCharStruct);
            CompleteStructMember member_var_char16 = TypeObjectUtils::build_complete_struct_member(common_var_char16, detail_var_char16);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedWCharStruct, member_var_char16);
        }
        CompleteStructType struct_type_KeyedWCharStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_KeyedWCharStruct, header_KeyedWCharStruct, member_seq_KeyedWCharStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_KeyedWCharStruct, type_name_KeyedWCharStruct.to_string(), type_ids_KeyedWCharStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "KeyedWCharStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_KeyedEmptyStruct_type_identifier(
        TypeIdentifierPair& type_ids_KeyedEmptyStruct)
{

    ReturnCode_t return_code_KeyedEmptyStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_KeyedEmptyStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "KeyedEmptyStruct", type_ids_KeyedEmptyStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_KeyedEmptyStruct)
    {
        StructTypeFlag struct_flags_KeyedEmptyStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_KeyedEmptyStruct = "KeyedEmptyStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_KeyedEmptyStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_KeyedEmptyStruct;
        CompleteTypeDetail detail_KeyedEmptyStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_KeyedEmptyStruct, ann_custom_KeyedEmptyStruct, type_name_KeyedEmptyStruct.to_string());
        CompleteStructHeader header_KeyedEmptyStruct;
        header_KeyedEmptyStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_KeyedEmptyStruct);
        CompleteStructMemberSeq member_seq_KeyedEmptyStruct;
        {
            TypeIdentifierPair type_ids_key_short;
            ReturnCode_t return_code_key_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_key_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_short)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "key_short Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_key_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_short = 0x00000000;
            bool common_key_short_ec {false};
            CommonStructMember common_key_short {TypeObjectUtils::build_common_struct_member(member_id_key_short, member_flags_key_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_short, common_key_short_ec))};
            if (!common_key_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_short = "key_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_short;
            ann_custom_KeyedEmptyStruct.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_short;
            eprosima::fastcdr::optional<std::string> unit_key_short;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_short;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_short;
            eprosima::fastcdr::optional<std::string> hash_id_key_short;
            if (unit_key_short.has_value() || min_key_short.has_value() || max_key_short.has_value() || hash_id_key_short.has_value())
            {
                member_ann_builtin_key_short = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_short, min_key_short, max_key_short, hash_id_key_short);
            }
            if (!tmp_ann_custom_key_short.empty())
            {
                ann_custom_KeyedEmptyStruct = tmp_ann_custom_key_short;
            }
            CompleteMemberDetail detail_key_short = TypeObjectUtils::build_complete_member_detail(name_key_short, member_ann_builtin_key_short, ann_custom_KeyedEmptyStruct);
            CompleteStructMember member_key_short = TypeObjectUtils::build_complete_struct_member(common_key_short, detail_key_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedEmptyStruct, member_key_short);
        }
        CompleteStructType struct_type_KeyedEmptyStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_KeyedEmptyStruct, header_KeyedEmptyStruct, member_seq_KeyedEmptyStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_KeyedEmptyStruct, type_name_KeyedEmptyStruct.to_string(), type_ids_KeyedEmptyStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "KeyedEmptyStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_KeyedEmptyInheritanceStruct_type_identifier(
        TypeIdentifierPair& type_ids_KeyedEmptyInheritanceStruct)
{

    ReturnCode_t return_code_KeyedEmptyInheritanceStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_KeyedEmptyInheritanceStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "KeyedEmptyInheritanceStruct", type_ids_KeyedEmptyInheritanceStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_KeyedEmptyInheritanceStruct)
    {
        StructTypeFlag struct_flags_KeyedEmptyInheritanceStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        return_code_KeyedEmptyInheritanceStruct =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "KeyedEmptyStruct", type_ids_KeyedEmptyInheritanceStruct);

        if (return_code_KeyedEmptyInheritanceStruct != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_KeyedEmptyStruct_type_identifier(type_ids_KeyedEmptyInheritanceStruct);
        }
        QualifiedTypeName type_name_KeyedEmptyInheritanceStruct = "KeyedEmptyInheritanceStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_KeyedEmptyInheritanceStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_KeyedEmptyInheritanceStruct;
        CompleteTypeDetail detail_KeyedEmptyInheritanceStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_KeyedEmptyInheritanceStruct, ann_custom_KeyedEmptyInheritanceStruct, type_name_KeyedEmptyInheritanceStruct.to_string());
        CompleteStructHeader header_KeyedEmptyInheritanceStruct;
        if (EK_COMPLETE == type_ids_KeyedEmptyInheritanceStruct.type_identifier1()._d())
        {
            header_KeyedEmptyInheritanceStruct = TypeObjectUtils::build_complete_struct_header(type_ids_KeyedEmptyInheritanceStruct.type_identifier1(), detail_KeyedEmptyInheritanceStruct);
        }
        else if (EK_COMPLETE == type_ids_KeyedEmptyInheritanceStruct.type_identifier2()._d())
        {
            header_KeyedEmptyInheritanceStruct = TypeObjectUtils::build_complete_struct_header(type_ids_KeyedEmptyInheritanceStruct.type_identifier2(), detail_KeyedEmptyInheritanceStruct);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "KeyedEmptyInheritanceStruct Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_KeyedEmptyInheritanceStruct;
        {
            TypeIdentifierPair type_ids_key_str;
            ReturnCode_t return_code_key_str {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_str =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_key_str);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_str)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_key_str))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_key_str = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_key_str = 0x00000001;
            bool common_key_str_ec {false};
            CommonStructMember common_key_str {TypeObjectUtils::build_common_struct_member(member_id_key_str, member_flags_key_str, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_str, common_key_str_ec))};
            if (!common_key_str_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_str member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_str = "key_str";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_str;
            ann_custom_KeyedEmptyInheritanceStruct.reset();
            CompleteMemberDetail detail_key_str = TypeObjectUtils::build_complete_member_detail(name_key_str, member_ann_builtin_key_str, ann_custom_KeyedEmptyInheritanceStruct);
            CompleteStructMember member_key_str = TypeObjectUtils::build_complete_struct_member(common_key_str, detail_key_str);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedEmptyInheritanceStruct, member_key_str);
        }
        {
            TypeIdentifierPair type_ids_var_str;
            ReturnCode_t return_code_var_str {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_str =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_var_str);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_str)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_var_str))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_str = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_str = 0x00000002;
            bool common_var_str_ec {false};
            CommonStructMember common_var_str {TypeObjectUtils::build_common_struct_member(member_id_var_str, member_flags_var_str, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_str, common_var_str_ec))};
            if (!common_var_str_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_str member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_str = "var_str";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_str;
            ann_custom_KeyedEmptyInheritanceStruct.reset();
            CompleteMemberDetail detail_var_str = TypeObjectUtils::build_complete_member_detail(name_var_str, member_ann_builtin_var_str, ann_custom_KeyedEmptyInheritanceStruct);
            CompleteStructMember member_var_str = TypeObjectUtils::build_complete_struct_member(common_var_str, detail_var_str);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedEmptyInheritanceStruct, member_var_str);
        }
        CompleteStructType struct_type_KeyedEmptyInheritanceStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_KeyedEmptyInheritanceStruct, header_KeyedEmptyInheritanceStruct, member_seq_KeyedEmptyInheritanceStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_KeyedEmptyInheritanceStruct, type_name_KeyedEmptyInheritanceStruct.to_string(), type_ids_KeyedEmptyInheritanceStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "KeyedEmptyInheritanceStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_KeyedInheritanceStruct_type_identifier(
        TypeIdentifierPair& type_ids_KeyedInheritanceStruct)
{

    ReturnCode_t return_code_KeyedInheritanceStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_KeyedInheritanceStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "KeyedInheritanceStruct", type_ids_KeyedInheritanceStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_KeyedInheritanceStruct)
    {
        StructTypeFlag struct_flags_KeyedInheritanceStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        return_code_KeyedInheritanceStruct =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "KeyedShortStruct", type_ids_KeyedInheritanceStruct);

        if (return_code_KeyedInheritanceStruct != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_KeyedShortStruct_type_identifier(type_ids_KeyedInheritanceStruct);
        }
        QualifiedTypeName type_name_KeyedInheritanceStruct = "KeyedInheritanceStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_KeyedInheritanceStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_KeyedInheritanceStruct;
        CompleteTypeDetail detail_KeyedInheritanceStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_KeyedInheritanceStruct, ann_custom_KeyedInheritanceStruct, type_name_KeyedInheritanceStruct.to_string());
        CompleteStructHeader header_KeyedInheritanceStruct;
        if (EK_COMPLETE == type_ids_KeyedInheritanceStruct.type_identifier1()._d())
        {
            header_KeyedInheritanceStruct = TypeObjectUtils::build_complete_struct_header(type_ids_KeyedInheritanceStruct.type_identifier1(), detail_KeyedInheritanceStruct);
        }
        else if (EK_COMPLETE == type_ids_KeyedInheritanceStruct.type_identifier2()._d())
        {
            header_KeyedInheritanceStruct = TypeObjectUtils::build_complete_struct_header(type_ids_KeyedInheritanceStruct.type_identifier2(), detail_KeyedInheritanceStruct);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "KeyedInheritanceStruct Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_KeyedInheritanceStruct;
        {
            TypeIdentifierPair type_ids_key_str;
            ReturnCode_t return_code_key_str {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_str =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_key_str);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_str)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_key_str))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_key_str = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_key_str = 0x00000002;
            bool common_key_str_ec {false};
            CommonStructMember common_key_str {TypeObjectUtils::build_common_struct_member(member_id_key_str, member_flags_key_str, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_str, common_key_str_ec))};
            if (!common_key_str_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_str member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_str = "key_str";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_str;
            ann_custom_KeyedInheritanceStruct.reset();
            CompleteMemberDetail detail_key_str = TypeObjectUtils::build_complete_member_detail(name_key_str, member_ann_builtin_key_str, ann_custom_KeyedInheritanceStruct);
            CompleteStructMember member_key_str = TypeObjectUtils::build_complete_struct_member(common_key_str, detail_key_str);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedInheritanceStruct, member_key_str);
        }
        {
            TypeIdentifierPair type_ids_var_str;
            ReturnCode_t return_code_var_str {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_str =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_var_str);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_str)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_var_str))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_str = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_str = 0x00000003;
            bool common_var_str_ec {false};
            CommonStructMember common_var_str {TypeObjectUtils::build_common_struct_member(member_id_var_str, member_flags_var_str, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_str, common_var_str_ec))};
            if (!common_var_str_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_str member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_str = "var_str";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_str;
            ann_custom_KeyedInheritanceStruct.reset();
            CompleteMemberDetail detail_var_str = TypeObjectUtils::build_complete_member_detail(name_var_str, member_ann_builtin_var_str, ann_custom_KeyedInheritanceStruct);
            CompleteStructMember member_var_str = TypeObjectUtils::build_complete_struct_member(common_var_str, detail_var_str);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedInheritanceStruct, member_var_str);
        }
        CompleteStructType struct_type_KeyedInheritanceStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_KeyedInheritanceStruct, header_KeyedInheritanceStruct, member_seq_KeyedInheritanceStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_KeyedInheritanceStruct, type_name_KeyedInheritanceStruct.to_string(), type_ids_KeyedInheritanceStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "KeyedInheritanceStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_InheritanceKeyedEmptyStruct_type_identifier(
        TypeIdentifierPair& type_ids_InheritanceKeyedEmptyStruct)
{

    ReturnCode_t return_code_InheritanceKeyedEmptyStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_InheritanceKeyedEmptyStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "InheritanceKeyedEmptyStruct", type_ids_InheritanceKeyedEmptyStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_InheritanceKeyedEmptyStruct)
    {
        StructTypeFlag struct_flags_InheritanceKeyedEmptyStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        return_code_InheritanceKeyedEmptyStruct =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "KeyedShortStruct", type_ids_InheritanceKeyedEmptyStruct);

        if (return_code_InheritanceKeyedEmptyStruct != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_KeyedShortStruct_type_identifier(type_ids_InheritanceKeyedEmptyStruct);
        }
        QualifiedTypeName type_name_InheritanceKeyedEmptyStruct = "InheritanceKeyedEmptyStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_InheritanceKeyedEmptyStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_InheritanceKeyedEmptyStruct;
        CompleteTypeDetail detail_InheritanceKeyedEmptyStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_InheritanceKeyedEmptyStruct, ann_custom_InheritanceKeyedEmptyStruct, type_name_InheritanceKeyedEmptyStruct.to_string());
        CompleteStructHeader header_InheritanceKeyedEmptyStruct;
        if (EK_COMPLETE == type_ids_InheritanceKeyedEmptyStruct.type_identifier1()._d())
        {
            header_InheritanceKeyedEmptyStruct = TypeObjectUtils::build_complete_struct_header(type_ids_InheritanceKeyedEmptyStruct.type_identifier1(), detail_InheritanceKeyedEmptyStruct);
        }
        else if (EK_COMPLETE == type_ids_InheritanceKeyedEmptyStruct.type_identifier2()._d())
        {
            header_InheritanceKeyedEmptyStruct = TypeObjectUtils::build_complete_struct_header(type_ids_InheritanceKeyedEmptyStruct.type_identifier2(), detail_InheritanceKeyedEmptyStruct);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "InheritanceKeyedEmptyStruct Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_InheritanceKeyedEmptyStruct;
        CompleteStructType struct_type_InheritanceKeyedEmptyStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_InheritanceKeyedEmptyStruct, header_InheritanceKeyedEmptyStruct, member_seq_InheritanceKeyedEmptyStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_InheritanceKeyedEmptyStruct, type_name_InheritanceKeyedEmptyStruct.to_string(), type_ids_InheritanceKeyedEmptyStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "InheritanceKeyedEmptyStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_KeyedFinal_type_identifier(
        TypeIdentifierPair& type_ids_KeyedFinal)
{

    ReturnCode_t return_code_KeyedFinal {eprosima::fastdds::dds::RETCODE_OK};
    return_code_KeyedFinal =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "KeyedFinal", type_ids_KeyedFinal);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_KeyedFinal)
    {
        StructTypeFlag struct_flags_KeyedFinal = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_KeyedFinal = "KeyedFinal";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_KeyedFinal;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_KeyedFinal;
        AppliedAnnotationSeq tmp_ann_custom_KeyedFinal;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_KeyedFinal;
        if (!tmp_ann_custom_KeyedFinal.empty())
        {
            ann_custom_KeyedFinal = tmp_ann_custom_KeyedFinal;
        }

        CompleteTypeDetail detail_KeyedFinal = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_KeyedFinal, ann_custom_KeyedFinal, type_name_KeyedFinal.to_string());
        CompleteStructHeader header_KeyedFinal;
        header_KeyedFinal = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_KeyedFinal);
        CompleteStructMemberSeq member_seq_KeyedFinal;
        {
            TypeIdentifierPair type_ids_key_long;
            ReturnCode_t return_code_key_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_key_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "key_long Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_key_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_long = 0x00000002;
            bool common_key_long_ec {false};
            CommonStructMember common_key_long {TypeObjectUtils::build_common_struct_member(member_id_key_long, member_flags_key_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_long, common_key_long_ec))};
            if (!common_key_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_long = "key_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_long;
            ann_custom_KeyedFinal.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_long;
            eprosima::fastcdr::optional<std::string> unit_key_long;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_long;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_long;
            eprosima::fastcdr::optional<std::string> hash_id_key_long;
            if (unit_key_long.has_value() || min_key_long.has_value() || max_key_long.has_value() || hash_id_key_long.has_value())
            {
                member_ann_builtin_key_long = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_long, min_key_long, max_key_long, hash_id_key_long);
            }
            if (!tmp_ann_custom_key_long.empty())
            {
                ann_custom_KeyedFinal = tmp_ann_custom_key_long;
            }
            CompleteMemberDetail detail_key_long = TypeObjectUtils::build_complete_member_detail(name_key_long, member_ann_builtin_key_long, ann_custom_KeyedFinal);
            CompleteStructMember member_key_long = TypeObjectUtils::build_complete_struct_member(common_key_long, detail_key_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedFinal, member_key_long);
        }
        {
            TypeIdentifierPair type_ids_key_short;
            ReturnCode_t return_code_key_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_key_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_short)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "key_short Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_key_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_short = 0x00000001;
            bool common_key_short_ec {false};
            CommonStructMember common_key_short {TypeObjectUtils::build_common_struct_member(member_id_key_short, member_flags_key_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_short, common_key_short_ec))};
            if (!common_key_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_short = "key_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_short;
            ann_custom_KeyedFinal.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_short;
            eprosima::fastcdr::optional<std::string> unit_key_short;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_short;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_short;
            eprosima::fastcdr::optional<std::string> hash_id_key_short;
            if (unit_key_short.has_value() || min_key_short.has_value() || max_key_short.has_value() || hash_id_key_short.has_value())
            {
                member_ann_builtin_key_short = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_short, min_key_short, max_key_short, hash_id_key_short);
            }
            if (!tmp_ann_custom_key_short.empty())
            {
                ann_custom_KeyedFinal = tmp_ann_custom_key_short;
            }
            CompleteMemberDetail detail_key_short = TypeObjectUtils::build_complete_member_detail(name_key_short, member_ann_builtin_key_short, ann_custom_KeyedFinal);
            CompleteStructMember member_key_short = TypeObjectUtils::build_complete_struct_member(common_key_short, detail_key_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedFinal, member_key_short);
        }
        {
            TypeIdentifierPair type_ids_key_string;
            ReturnCode_t return_code_key_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_key_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_string)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_key_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_key_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_string = 0x00000000;
            bool common_key_string_ec {false};
            CommonStructMember common_key_string {TypeObjectUtils::build_common_struct_member(member_id_key_string, member_flags_key_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_string, common_key_string_ec))};
            if (!common_key_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_string = "key_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_string;
            ann_custom_KeyedFinal.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_string;
            eprosima::fastcdr::optional<std::string> unit_key_string;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_string;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_string;
            eprosima::fastcdr::optional<std::string> hash_id_key_string;
            if (unit_key_string.has_value() || min_key_string.has_value() || max_key_string.has_value() || hash_id_key_string.has_value())
            {
                member_ann_builtin_key_string = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_string, min_key_string, max_key_string, hash_id_key_string);
            }
            if (!tmp_ann_custom_key_string.empty())
            {
                ann_custom_KeyedFinal = tmp_ann_custom_key_string;
            }
            CompleteMemberDetail detail_key_string = TypeObjectUtils::build_complete_member_detail(name_key_string, member_ann_builtin_key_string, ann_custom_KeyedFinal);
            CompleteStructMember member_key_string = TypeObjectUtils::build_complete_struct_member(common_key_string, detail_key_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedFinal, member_key_string);
        }
        CompleteStructType struct_type_KeyedFinal = TypeObjectUtils::build_complete_struct_type(struct_flags_KeyedFinal, header_KeyedFinal, member_seq_KeyedFinal);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_KeyedFinal, type_name_KeyedFinal.to_string(), type_ids_KeyedFinal))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "KeyedFinal already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_KeyedAppendable_type_identifier(
        TypeIdentifierPair& type_ids_KeyedAppendable)
{

    ReturnCode_t return_code_KeyedAppendable {eprosima::fastdds::dds::RETCODE_OK};
    return_code_KeyedAppendable =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "KeyedAppendable", type_ids_KeyedAppendable);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_KeyedAppendable)
    {
        StructTypeFlag struct_flags_KeyedAppendable = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_KeyedAppendable = "KeyedAppendable";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_KeyedAppendable;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_KeyedAppendable;
        AppliedAnnotationSeq tmp_ann_custom_KeyedAppendable;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_KeyedAppendable;
        if (!tmp_ann_custom_KeyedAppendable.empty())
        {
            ann_custom_KeyedAppendable = tmp_ann_custom_KeyedAppendable;
        }

        CompleteTypeDetail detail_KeyedAppendable = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_KeyedAppendable, ann_custom_KeyedAppendable, type_name_KeyedAppendable.to_string());
        CompleteStructHeader header_KeyedAppendable;
        header_KeyedAppendable = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_KeyedAppendable);
        CompleteStructMemberSeq member_seq_KeyedAppendable;
        {
            TypeIdentifierPair type_ids_key_long;
            ReturnCode_t return_code_key_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_key_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "key_long Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_key_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_long = 0x00000002;
            bool common_key_long_ec {false};
            CommonStructMember common_key_long {TypeObjectUtils::build_common_struct_member(member_id_key_long, member_flags_key_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_long, common_key_long_ec))};
            if (!common_key_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_long = "key_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_long;
            ann_custom_KeyedAppendable.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_long;
            eprosima::fastcdr::optional<std::string> unit_key_long;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_long;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_long;
            eprosima::fastcdr::optional<std::string> hash_id_key_long;
            if (unit_key_long.has_value() || min_key_long.has_value() || max_key_long.has_value() || hash_id_key_long.has_value())
            {
                member_ann_builtin_key_long = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_long, min_key_long, max_key_long, hash_id_key_long);
            }
            if (!tmp_ann_custom_key_long.empty())
            {
                ann_custom_KeyedAppendable = tmp_ann_custom_key_long;
            }
            CompleteMemberDetail detail_key_long = TypeObjectUtils::build_complete_member_detail(name_key_long, member_ann_builtin_key_long, ann_custom_KeyedAppendable);
            CompleteStructMember member_key_long = TypeObjectUtils::build_complete_struct_member(common_key_long, detail_key_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedAppendable, member_key_long);
        }
        {
            TypeIdentifierPair type_ids_key_short;
            ReturnCode_t return_code_key_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_key_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_short)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "key_short Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_key_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_short = 0x00000001;
            bool common_key_short_ec {false};
            CommonStructMember common_key_short {TypeObjectUtils::build_common_struct_member(member_id_key_short, member_flags_key_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_short, common_key_short_ec))};
            if (!common_key_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_short = "key_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_short;
            ann_custom_KeyedAppendable.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_short;
            eprosima::fastcdr::optional<std::string> unit_key_short;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_short;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_short;
            eprosima::fastcdr::optional<std::string> hash_id_key_short;
            if (unit_key_short.has_value() || min_key_short.has_value() || max_key_short.has_value() || hash_id_key_short.has_value())
            {
                member_ann_builtin_key_short = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_short, min_key_short, max_key_short, hash_id_key_short);
            }
            if (!tmp_ann_custom_key_short.empty())
            {
                ann_custom_KeyedAppendable = tmp_ann_custom_key_short;
            }
            CompleteMemberDetail detail_key_short = TypeObjectUtils::build_complete_member_detail(name_key_short, member_ann_builtin_key_short, ann_custom_KeyedAppendable);
            CompleteStructMember member_key_short = TypeObjectUtils::build_complete_struct_member(common_key_short, detail_key_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedAppendable, member_key_short);
        }
        {
            TypeIdentifierPair type_ids_key_string;
            ReturnCode_t return_code_key_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_key_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_string)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_key_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_key_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_string = 0x00000000;
            bool common_key_string_ec {false};
            CommonStructMember common_key_string {TypeObjectUtils::build_common_struct_member(member_id_key_string, member_flags_key_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_string, common_key_string_ec))};
            if (!common_key_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_string = "key_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_string;
            ann_custom_KeyedAppendable.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_string;
            eprosima::fastcdr::optional<std::string> unit_key_string;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_string;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_string;
            eprosima::fastcdr::optional<std::string> hash_id_key_string;
            if (unit_key_string.has_value() || min_key_string.has_value() || max_key_string.has_value() || hash_id_key_string.has_value())
            {
                member_ann_builtin_key_string = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_string, min_key_string, max_key_string, hash_id_key_string);
            }
            if (!tmp_ann_custom_key_string.empty())
            {
                ann_custom_KeyedAppendable = tmp_ann_custom_key_string;
            }
            CompleteMemberDetail detail_key_string = TypeObjectUtils::build_complete_member_detail(name_key_string, member_ann_builtin_key_string, ann_custom_KeyedAppendable);
            CompleteStructMember member_key_string = TypeObjectUtils::build_complete_struct_member(common_key_string, detail_key_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedAppendable, member_key_string);
        }
        CompleteStructType struct_type_KeyedAppendable = TypeObjectUtils::build_complete_struct_type(struct_flags_KeyedAppendable, header_KeyedAppendable, member_seq_KeyedAppendable);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_KeyedAppendable, type_name_KeyedAppendable.to_string(), type_ids_KeyedAppendable))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "KeyedAppendable already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_KeyedMutable_type_identifier(
        TypeIdentifierPair& type_ids_KeyedMutable)
{

    ReturnCode_t return_code_KeyedMutable {eprosima::fastdds::dds::RETCODE_OK};
    return_code_KeyedMutable =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "KeyedMutable", type_ids_KeyedMutable);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_KeyedMutable)
    {
        StructTypeFlag struct_flags_KeyedMutable = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_KeyedMutable = "KeyedMutable";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_KeyedMutable;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_KeyedMutable;
        AppliedAnnotationSeq tmp_ann_custom_KeyedMutable;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_KeyedMutable;
        if (!tmp_ann_custom_KeyedMutable.empty())
        {
            ann_custom_KeyedMutable = tmp_ann_custom_KeyedMutable;
        }

        CompleteTypeDetail detail_KeyedMutable = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_KeyedMutable, ann_custom_KeyedMutable, type_name_KeyedMutable.to_string());
        CompleteStructHeader header_KeyedMutable;
        header_KeyedMutable = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_KeyedMutable);
        CompleteStructMemberSeq member_seq_KeyedMutable;
        {
            TypeIdentifierPair type_ids_key_long;
            ReturnCode_t return_code_key_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_key_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "key_long Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_key_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_long = 0x00000002;
            bool common_key_long_ec {false};
            CommonStructMember common_key_long {TypeObjectUtils::build_common_struct_member(member_id_key_long, member_flags_key_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_long, common_key_long_ec))};
            if (!common_key_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_long = "key_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_long;
            ann_custom_KeyedMutable.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_long;
            eprosima::fastcdr::optional<std::string> unit_key_long;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_long;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_long;
            eprosima::fastcdr::optional<std::string> hash_id_key_long;
            if (unit_key_long.has_value() || min_key_long.has_value() || max_key_long.has_value() || hash_id_key_long.has_value())
            {
                member_ann_builtin_key_long = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_long, min_key_long, max_key_long, hash_id_key_long);
            }
            if (!tmp_ann_custom_key_long.empty())
            {
                ann_custom_KeyedMutable = tmp_ann_custom_key_long;
            }
            CompleteMemberDetail detail_key_long = TypeObjectUtils::build_complete_member_detail(name_key_long, member_ann_builtin_key_long, ann_custom_KeyedMutable);
            CompleteStructMember member_key_long = TypeObjectUtils::build_complete_struct_member(common_key_long, detail_key_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedMutable, member_key_long);
        }
        {
            TypeIdentifierPair type_ids_key_short;
            ReturnCode_t return_code_key_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_key_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_short)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "key_short Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_key_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_short = 0x00000001;
            bool common_key_short_ec {false};
            CommonStructMember common_key_short {TypeObjectUtils::build_common_struct_member(member_id_key_short, member_flags_key_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_short, common_key_short_ec))};
            if (!common_key_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_short = "key_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_short;
            ann_custom_KeyedMutable.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_short;
            eprosima::fastcdr::optional<std::string> unit_key_short;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_short;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_short;
            eprosima::fastcdr::optional<std::string> hash_id_key_short;
            if (unit_key_short.has_value() || min_key_short.has_value() || max_key_short.has_value() || hash_id_key_short.has_value())
            {
                member_ann_builtin_key_short = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_short, min_key_short, max_key_short, hash_id_key_short);
            }
            if (!tmp_ann_custom_key_short.empty())
            {
                ann_custom_KeyedMutable = tmp_ann_custom_key_short;
            }
            CompleteMemberDetail detail_key_short = TypeObjectUtils::build_complete_member_detail(name_key_short, member_ann_builtin_key_short, ann_custom_KeyedMutable);
            CompleteStructMember member_key_short = TypeObjectUtils::build_complete_struct_member(common_key_short, detail_key_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedMutable, member_key_short);
        }
        {
            TypeIdentifierPair type_ids_key_string;
            ReturnCode_t return_code_key_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_key_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_key_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_key_string)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_key_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_key_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_key_string = 0x00000000;
            bool common_key_string_ec {false};
            CommonStructMember common_key_string {TypeObjectUtils::build_common_struct_member(member_id_key_string, member_flags_key_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_key_string, common_key_string_ec))};
            if (!common_key_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure key_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_key_string = "key_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_key_string;
            ann_custom_KeyedMutable.reset();
            AppliedAnnotationSeq tmp_ann_custom_key_string;
            eprosima::fastcdr::optional<std::string> unit_key_string;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_key_string;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_key_string;
            eprosima::fastcdr::optional<std::string> hash_id_key_string;
            if (unit_key_string.has_value() || min_key_string.has_value() || max_key_string.has_value() || hash_id_key_string.has_value())
            {
                member_ann_builtin_key_string = TypeObjectUtils::build_applied_builtin_member_annotations(unit_key_string, min_key_string, max_key_string, hash_id_key_string);
            }
            if (!tmp_ann_custom_key_string.empty())
            {
                ann_custom_KeyedMutable = tmp_ann_custom_key_string;
            }
            CompleteMemberDetail detail_key_string = TypeObjectUtils::build_complete_member_detail(name_key_string, member_ann_builtin_key_string, ann_custom_KeyedMutable);
            CompleteStructMember member_key_string = TypeObjectUtils::build_complete_struct_member(common_key_string, detail_key_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyedMutable, member_key_string);
        }
        CompleteStructType struct_type_KeyedMutable = TypeObjectUtils::build_complete_struct_type(struct_flags_KeyedMutable, header_KeyedMutable, member_seq_KeyedMutable);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_KeyedMutable, type_name_KeyedMutable.to_string(), type_ids_KeyedMutable))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "KeyedMutable already registered in TypeObjectRegistry for a different type.");
        }
    }
}
