<!--
Copyright (c) 2022 Dell Inc., or its subsidiaries. All Rights Reserved.

Licensed under the GPL, Version 3.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    https://www.gnu.org/licenses/gpl-3.0.txt
-->

# Committer Guidelines

These are the guidelines for people with commit privileges on the GitHub repository. Committers act as members of the Core Team and not necessarily employees of Dell.

These guidelines apply to everyone and as Committers you have been given access to commit changes because you exhibit good judgment and have demonstrated your commitment to the vision of the project. We trust that you will use these privileges wisely and not abuse it.

If these privileges are abused in any way and the quality of the project is compromised, our trust will be diminished and you may be asked to not commit or lose these privileges all together.

## General Rules

### Don't

* Break the build.
* Commit directly.
* Compromise backward compatibility.
* Disrespect your Community Team members. Help them grow.
* Think it is someone elses job to test your code. Write tests for all the code you produce.
* Forget to keep thing simple.
* Create technical debt. Fix-in-place and make it the highest priority above everything else.

### Do

* Always follow the defined coding guideline
* Keep the design of your software clean and maintainable.
* Squash your commits, avoid merges.
* Write tests for all your deliverables.
* Automate everything.
* Maintain a high code coverage, equal to or greater than 90%.
* Keep an open communication with other Committers.
* Ask questions.
* Document your contributions and remember to keep it simple.
