/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.mariadb.jdbc.AbstractMariaDbPrepareStatement;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbServerPreparedStatement;
import org.mariadb.jdbc.MariaDbStatement;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.queryresults.MultiIntExecutionResult;
import org.mariadb.jdbc.internal.queryresults.SingleExecutionResult;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class MariaDbClientPreparedStatement
extends AbstractMariaDbPrepareStatement
implements Cloneable {
    private String sqlQuery;
    private List<String> queryParts;
    private ParameterHolder[] parameters;
    private List<ParameterHolder[]> parameterList = new ArrayList<ParameterHolder[]>();
    private int paramCount;
    private ResultSetMetaData resultSetMetaData = null;
    private ParameterMetaData parameterMetaData = null;
    private boolean reWritablePrepare = true;

    public MariaDbClientPreparedStatement(MariaDbConnection connection, String sql, int resultSetScrollType) throws SQLException {
        super(connection, resultSetScrollType);
        this.sqlQuery = sql;
        this.useFractionalSeconds = connection.getProtocol().getOptions().useFractionalSeconds;
        this.queryParts = this.createRewritableParts(sql, connection.noBackslashEscapes);
        this.paramCount = this.queryParts.size() - 3;
        this.parameters = new ParameterHolder[this.paramCount];
    }

    @Override
    public MariaDbClientPreparedStatement clone() throws CloneNotSupportedException {
        MariaDbClientPreparedStatement clone = (MariaDbClientPreparedStatement)super.clone();
        clone.sqlQuery = this.sqlQuery;
        clone.queryParts = this.queryParts;
        clone.paramCount = this.paramCount;
        clone.parameters = new ParameterHolder[this.paramCount];
        clone.resultSetMetaData = this.resultSetMetaData;
        clone.parameterMetaData = this.parameterMetaData;
        return clone;
    }

    @Override
    protected boolean isNoBackslashEscapes() {
        return this.connection.noBackslashEscapes;
    }

    @Override
    protected boolean useFractionalSeconds() {
        return this.useFractionalSeconds;
    }

    @Override
    protected Calendar cal() {
        return this.protocol.getCalendar();
    }

    protected ParameterHolder getCurrentParameterHolder(int parameterIndex) {
        return this.parameters[parameterIndex];
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeInternal();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.executeInternal()) {
            return this.executionResult.getResult();
        }
        return MariaSelectResultSet.EMPTY;
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.executeInternal()) {
            return 0;
        }
        return this.getUpdateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeInternal() throws SQLException {
        this.executing = true;
        QueryException exception = null;
        this.lock.lock();
        try {
            this.executeQueryProlog();
            this.batchResultSet = null;
            SingleExecutionResult executionResultTmp = new SingleExecutionResult(this, this.getFetchSize(), true, false);
            this.protocol.executeQueries(executionResultTmp, this.queryParts, Collections.singletonList(this.parameters), this.resultSetScrollType, false);
            this.cacheMoreResults(executionResultTmp, this.getFetchSize(), false);
            this.executionResult = executionResultTmp;
            boolean bl = this.executionResult.getResult() != null;
            return bl;
        }
        catch (QueryException e2) {
            exception = e2;
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
            this.executeQueryEpilog(exception);
            this.executing = false;
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.parameterList.add(this.parameters);
        this.clearParameters();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("Cannot do addBatch(String) on preparedStatement");
    }

    @Override
    public void clearBatch() {
        this.parameterList.clear();
        this.parameters = new ParameterHolder[this.paramCount];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        int batchQueriesCount;
        this.checkClose();
        int size = this.parameterList.size();
        if (size == 0) {
            return new int[0];
        }
        int[] ret = new int[size];
        MultiIntExecutionResult internalExecutionResult = new MultiIntExecutionResult((Statement)this, size, 0, false);
        this.lock.lock();
        try {
            QueryException exception = null;
            this.executeQueryProlog();
            try {
                if (this.reWritablePrepare && (this.protocol.getOptions().allowMultiQueries || this.protocol.getOptions().rewriteBatchedStatements)) {
                    boolean rewrittenBatch = this.reWritablePrepare && this.protocol.getOptions().rewriteBatchedStatements;
                    this.protocol.executeQueries(internalExecutionResult, this.queryParts, this.parameterList, this.resultSetScrollType, rewrittenBatch);
                    this.cacheMoreResults(internalExecutionResult, this.getFetchSize(), false);
                    if (rewrittenBatch) {
                        internalExecutionResult.updateResultsForRewrite();
                    } else {
                        internalExecutionResult.updateResultsMultiple(this.cachedExecutionResults);
                    }
                } else {
                    for (batchQueriesCount = 0; batchQueriesCount < size; ++batchQueriesCount) {
                        this.protocol.executeQueries(internalExecutionResult, this.queryParts, Collections.singletonList(this.parameterList.get(batchQueriesCount)), this.resultSetScrollType, false);
                        this.cacheMoreResults(internalExecutionResult, 0, false);
                    }
                }
            }
            catch (QueryException e2) {
                exception = e2;
            }
            finally {
                this.executionResult = internalExecutionResult;
                this.executing = false;
                this.executeQueryEpilog(exception);
            }
        }
        catch (SQLException sqle) {
            throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), Arrays.copyOf(ret, batchQueriesCount), (Throwable)sqle);
        }
        finally {
            this.lock.unlock();
            this.clearBatch();
        }
        return internalExecutionResult.getAffectedRows();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClose();
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs.getMetaData();
        }
        if (this.resultSetMetaData == null) {
            this.setParametersData();
        }
        return this.resultSetMetaData;
    }

    @Override
    protected void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        if (parameterIndex < 1 || parameterIndex >= this.paramCount + 1) {
            throw ExceptionMapper.getSqlException("Could not set parameter at position " + parameterIndex + " (values vas " + holder.toString() + ")");
        }
        this.parameters[parameterIndex - 1] = holder;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClose();
        if (this.parameterMetaData == null) {
            this.setParametersData();
        }
        return this.parameterMetaData;
    }

    private void setParametersData() throws SQLException {
        MariaDbServerPreparedStatement ssps = new MariaDbServerPreparedStatement(this.connection, this.sqlQuery, 1004);
        ssps.close();
        this.resultSetMetaData = ssps.getMetaData();
        this.parameterMetaData = ssps.getParameterMetaData();
    }

    @Override
    public void clearParameters() {
        this.parameters = new ParameterHolder[this.paramCount];
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.statementEventListeners.isEmpty()) {
            return;
        }
    }

    protected int getParameterCount() {
        return this.paramCount;
    }

    public String toString() {
        return this.sqlQuery;
    }

    private List<String> createRewritableParts(String queryString, boolean noBackslashEscapes) {
        this.reWritablePrepare = true;
        ArrayList<String> partList = new ArrayList<String>();
        MariaDbStatement.LexState state = MariaDbStatement.LexState.Normal;
        char lastChar = '\u0000';
        StringBuilder sb = new StringBuilder();
        String preValuePart1 = null;
        String preValuePart2 = null;
        String postValuePart = null;
        boolean singleQuotes = false;
        int isInParenthesis = 0;
        boolean skipChar = false;
        boolean isFirstChar = true;
        boolean isInsert = false;
        boolean semicolon = false;
        boolean hasParam = false;
        char[] query = queryString.toCharArray();
        for (int i2 = 0; i2 < query.length; ++i2) {
            if (state == MariaDbStatement.LexState.Escape) {
                sb.append(query[i2]);
                state = MariaDbStatement.LexState.String;
                continue;
            }
            char car = query[i2];
            switch (car) {
                case '*': {
                    if (state != MariaDbStatement.LexState.Normal || lastChar != '/') break;
                    state = MariaDbStatement.LexState.SlashStarComment;
                    break;
                }
                case '/': {
                    if (state == MariaDbStatement.LexState.SlashStarComment && lastChar == '*') {
                        state = MariaDbStatement.LexState.Normal;
                        break;
                    }
                    if (state != MariaDbStatement.LexState.Normal || lastChar != '/') break;
                    state = MariaDbStatement.LexState.EOLComment;
                    break;
                }
                case '#': {
                    if (state != MariaDbStatement.LexState.Normal) break;
                    state = MariaDbStatement.LexState.EOLComment;
                    break;
                }
                case '-': {
                    if (state != MariaDbStatement.LexState.Normal || lastChar != '-') break;
                    state = MariaDbStatement.LexState.EOLComment;
                    break;
                }
                case '\n': {
                    if (state != MariaDbStatement.LexState.EOLComment) break;
                    state = MariaDbStatement.LexState.Normal;
                    break;
                }
                case '\"': {
                    if (state == MariaDbStatement.LexState.Normal) {
                        state = MariaDbStatement.LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state != MariaDbStatement.LexState.String || singleQuotes) break;
                    state = MariaDbStatement.LexState.Normal;
                    break;
                }
                case ';': {
                    if (state != MariaDbStatement.LexState.Normal) break;
                    semicolon = true;
                    break;
                }
                case '\'': {
                    if (state == MariaDbStatement.LexState.Normal) {
                        state = MariaDbStatement.LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state != MariaDbStatement.LexState.String || !singleQuotes) break;
                    state = MariaDbStatement.LexState.Normal;
                    break;
                }
                case '\\': {
                    if (noBackslashEscapes || state != MariaDbStatement.LexState.String) break;
                    state = MariaDbStatement.LexState.Escape;
                    break;
                }
                case '?': {
                    if (state != MariaDbStatement.LexState.Normal) break;
                    hasParam = true;
                    if (preValuePart1 == null) {
                        preValuePart1 = sb.toString();
                        sb.setLength(0);
                    }
                    if (preValuePart2 == null) {
                        preValuePart2 = sb.toString();
                        sb.setLength(0);
                    } else {
                        if (postValuePart != null) {
                            this.reWritablePrepare = false;
                            sb.insert(0, postValuePart);
                            postValuePart = null;
                        }
                        partList.add(sb.toString());
                        sb.setLength(0);
                    }
                    skipChar = true;
                    break;
                }
                case '`': {
                    if (state == MariaDbStatement.LexState.Backtick) {
                        state = MariaDbStatement.LexState.Normal;
                        break;
                    }
                    if (state != MariaDbStatement.LexState.Normal) break;
                    state = MariaDbStatement.LexState.Backtick;
                    break;
                }
                case 'S': 
                case 's': {
                    if (state != MariaDbStatement.LexState.Normal || postValuePart != null || query.length <= i2 + 6 || query[i2 + 1] != 'e' && query[i2 + 1] != 'E' || query[i2 + 2] != 'l' && query[i2 + 2] != 'L' || query[i2 + 3] != 'e' && query[i2 + 3] != 'E' || query[i2 + 4] != 'c' && query[i2 + 4] != 'C' || query[i2 + 5] != 't' && query[i2 + 5] != 'T') break;
                    this.reWritablePrepare = false;
                    break;
                }
                case 'V': 
                case 'v': {
                    if (state != MariaDbStatement.LexState.Normal || preValuePart1 != null || lastChar != ')' && (byte)lastChar > 40 || query.length <= i2 + 7 || query[i2 + 1] != 'a' && query[i2 + 1] != 'A' || query[i2 + 2] != 'l' && query[i2 + 2] != 'L' || query[i2 + 3] != 'u' && query[i2 + 3] != 'U' || query[i2 + 4] != 'e' && query[i2 + 4] != 'E' || query[i2 + 5] != 's' && query[i2 + 5] != 'S' || query[i2 + 6] != '(' && (byte)query[i2 + 6] > 40) break;
                    sb.append(car);
                    sb.append(query[i2 + 1]);
                    sb.append(query[i2 + 2]);
                    sb.append(query[i2 + 3]);
                    sb.append(query[i2 + 4]);
                    sb.append(query[i2 + 5]);
                    i2 += 5;
                    preValuePart1 = sb.toString();
                    sb.setLength(0);
                    skipChar = true;
                    break;
                }
                case '(': {
                    if (state != MariaDbStatement.LexState.Normal) break;
                    ++isInParenthesis;
                    break;
                }
                case ')': {
                    if (state != MariaDbStatement.LexState.Normal || --isInParenthesis != 0 || preValuePart2 == null || postValuePart != null) break;
                    sb.append(car);
                    postValuePart = sb.toString();
                    sb.setLength(0);
                    skipChar = true;
                    break;
                }
                default: {
                    if (state == MariaDbStatement.LexState.Normal && isFirstChar && (byte)car >= 40) {
                        if (car == 'I' || car == 'i') {
                            isInsert = true;
                        }
                        isFirstChar = false;
                    }
                    if (state != MariaDbStatement.LexState.Normal || !semicolon || (byte)car < 40) break;
                    this.reWritablePrepare = false;
                }
            }
            lastChar = car;
            if (skipChar) {
                skipChar = false;
                continue;
            }
            sb.append(car);
        }
        partList.add(0, preValuePart1 == null ? "" : preValuePart1);
        if (!hasParam) {
            partList.add(1, sb.toString());
            sb.setLength(0);
        } else {
            partList.add(1, preValuePart2 == null ? "" : preValuePart2);
        }
        if (!isInsert) {
            this.reWritablePrepare = false;
        }
        if (hasParam) {
            partList.add(postValuePart == null ? "" : postValuePart);
        }
        partList.add(sb.toString());
        return partList;
    }

    protected List<String> getQueryParts() {
        return this.queryParts;
    }

    protected int getParamCount() {
        return this.paramCount;
    }

    public boolean isReWritablePrepare() {
        return this.reWritablePrepare;
    }
}

