/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import java.util.Arrays;

@Immutable
public final class MongoNamespace {
    public static final String COMMAND_COLLECTION_NAME = "$cmd";
    private final String databaseName;
    private final String collectionName;
    private final String fullName;

    public static void checkDatabaseNameValidity(String databaseName) {
        Assertions.notNull("databaseName", databaseName);
        Assertions.isTrueArgument("databaseName is not empty", !databaseName.isEmpty());
        for (String cur : Arrays.asList(" ", ".")) {
            Assertions.isTrueArgument("databaseName does not contain '" + cur + "'", !databaseName.contains(cur));
        }
    }

    public static void checkCollectionNameValidity(String collectionName) {
        Assertions.notNull("collectionName", collectionName);
        Assertions.isTrueArgument("collectionName is not empty", !collectionName.isEmpty());
    }

    public MongoNamespace(String fullName) {
        Assertions.notNull("fullName", fullName);
        this.fullName = fullName;
        this.databaseName = MongoNamespace.getDatatabaseNameFromFullName(fullName);
        this.collectionName = MongoNamespace.getCollectionNameFullName(fullName);
        MongoNamespace.checkDatabaseNameValidity(this.databaseName);
        MongoNamespace.checkCollectionNameValidity(this.collectionName);
    }

    public MongoNamespace(String databaseName, String collectionName) {
        MongoNamespace.checkDatabaseNameValidity(databaseName);
        MongoNamespace.checkCollectionNameValidity(collectionName);
        this.databaseName = databaseName;
        this.collectionName = collectionName;
        this.fullName = databaseName + '.' + collectionName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoNamespace that = (MongoNamespace)o;
        if (!this.collectionName.equals(that.collectionName)) {
            return false;
        }
        return this.databaseName.equals(that.databaseName);
    }

    public String toString() {
        return this.fullName;
    }

    public int hashCode() {
        int result = this.databaseName.hashCode();
        result = 31 * result + this.collectionName.hashCode();
        return result;
    }

    private static String getCollectionNameFullName(String namespace) {
        if (namespace == null) {
            return null;
        }
        int firstDot = namespace.indexOf(46);
        if (firstDot == -1) {
            return namespace;
        }
        return namespace.substring(firstDot + 1);
    }

    private static String getDatatabaseNameFromFullName(String namespace) {
        if (namespace == null) {
            return null;
        }
        int firstDot = namespace.indexOf(46);
        if (firstDot == -1) {
            return "";
        }
        return namespace.substring(0, firstDot);
    }
}

