/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef BOOTUI_H
#define BOOTUI_H

#include <QWidget>
#include <QHBoxLayout>

#include "titlelabel.h"
#include "lightlabel.h"

#include <kysdk/applications/kswitchbutton.h>
using namespace kdk;

class BootUi : public QWidget
{
    Q_OBJECT
public:
    explicit BootUi(QWidget *parent = nullptr, Qt::WindowFlags f = Qt::WindowFlags());
    virtual ~BootUi();

public:
    inline KSwitchButton *grubSwitchButton()
    {
        return mGrubBtn;
    }

    inline QPushButton *resetButton()
    {
        return mResetPasswdBtn;
    }

private:
    QVBoxLayout *mVlayout = nullptr;

    TitleLabel *mBootTitleLabel;
    QFrame *mBootFrame;
    QLabel *mGrubLabel;
    KSwitchButton *mGrubBtn;
    QPushButton *mResetPasswdBtn;
    LightLabel *mNeedPasswdLabel;

private:
    void initUI();

};

#endif // BOOTUI_H
