## TFSA-2021-087: Division by zero in TFLite's implementation of `Split`

### CVE Number
CVE-2021-29599

### Impact
The implementation of the `Split` TFLite operator is [vulnerable to a
division by zero
error](https://github.com/tensorflow/tensorflow/blob/e2752089ef7ce9bcf3db0ec618ebd23ea119d0c7/tensorflow/lite/kernels/split.cc#L63-L65):

```cc
TF_LITE_ENSURE_MSG(context, input_size % num_splits == 0, "Not an even split");
const int slice_size = input_size / num_splits;
```

An attacker can craft a model such that `num_splits` would be 0.

### Patches
We have patched the issue in GitHub commit
[b22786e7e9b7bdb6a56936ff29cc7e9968d7bc1d](https://github.com/tensorflow/tensorflow/commit/b22786e7e9b7bdb6a56936ff29cc7e9968d7bc1d).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
